// Disable context menu + Ctrl+C/V/U/F6
document.addEventListener("contextmenu", e => e.preventDefault());
document.onkeydown = e => (e.ctrlKey && [67, 86, 85, 117].includes(e.keyCode)) ? false : true;
$(document).keypress("u", e => e.ctrlKey ? false : true);

// Small-Big Image Gallery
function initGallery(smallId, bigId) {
  $(`${smallId} .item`).click(function () {
    $(bigId + " img").attr("src", $(this).attr("src").replace("thumb", "large"));
    $(`${smallId} .item`).removeClass("active");
    $(this).addClass("active");
  });
}
["#small1","#small2","#small3","#small4","#small5","#small6"]
.forEach((id,i)=>initGallery(id,`#bigImage${i+1}`));

// Sticky Header
$(window).on("scroll", () => {
  $(".menubar").toggleClass("stricky-fixed", $(window).scrollTop() > 100);
});

// Navigation Menu
if ($(".navigation").length) {
  $(".navigation .navbar button").on("click", function () {
    $(".navigation .menu").slideToggle(); $(this).toggleClass("open"); return false;
  });
  $(".navigation .cs-submenu>a").append(
    '<button class="dropdown-expander" title="dropdown"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><path d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z"/></svg></button>'
  );
}
if ($(window).width() < 1023) {
  $(".navigation .menu .dropdown-expander").on("click", function () {
    $(this).parent().parent().children(".cs-dropdown").slideToggle();
    $(this).toggleClass("rotated");
    return false;
  });
  $(document).click(e => {
    if (!$(e.target).closest(".navigation .navbar button").length) {
      $(".navigation .menu").slideUp(); $(".navigation .navbar button").removeClass("open");
    }
  });
}
// Owl Carousel Common
const navIcons = [
  '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><path d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/></svg>',
  '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><path d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/></svg>'
];

function initCarousel(sel,opt){
  $(sel).owlCarousel($.extend({
    loop:true,margin:0,nav:true,navText:navIcons,navSpeed:500,
    autoplay:true,dots:false,responsiveClass:true
  },opt)).on("initialized.owl.carousel refreshed.owl.carousel translated.owl.carousel", e=>{
    const $c = $(e.target);
    setTimeout(()=>{
      $c.find(".owl-prev").attr("title","Previous");
      $c.find(".owl-next").attr("title","Next");
      $c.find(".owl-dot").each((i,el)=>$(el).attr("title","Go to Slide "+(i+1)));
    },30); // thoda delay so buttons/dots definitely exist
  });
}

// Carousels Init
initCarousel("#slider",{animateOut:"fadeOut",items:1,responsive:{0:{nav:false},600:{nav:false}}});
initCarousel("#popularCourse",{loop:false,margin:5,items:3,responsive:{0:{items:1},768:{items:2},1024:{items:3},1100:{items:4}}});
initCarousel("#popularCourse2",{margin:20,items:3,responsive:{0:{items:1},768:{items:2},1024:{items:3}}});
initCarousel("#testimonials",{nav:false,autoplay:false,dots:true,items:1});
initCarousel("#clients",{nav:false,items:1,responsive:{0:{items:2},768:{items:3},1024:{items:6}}});


// WOW + Scroll to Top
wow = new WOW({
    animateClass: 'animated',
    offset: 100,
    mobile: false
});
wow.init();


$(window).on("scroll", function () {
    if ($(this).scrollTop() > 100) {
        $("#web-pulse-scroll-up").fadeIn()
    } else {
        $("#web-pulse-scroll-up").fadeOut()
    }
});
$("#web-pulse-scroll-up").on("click", function () {
    $("html, body").animate({
        scrollTop: 0
    }, 600);
    return false
});

// Thumbnail to Large Image
$("#thumbs img").click(function(){
  $("#largeImage").attr("src",$(this).attr("src").replace("thumb","large"));
  $("#thumbs img").removeClass("active"); $(this).addClass("active");
});
