<?php
include_once("include/main.inc.php");
$hover = 'weight';
$page_metatitle = "Weight Calculator, Calculate Metal Weight Online| Numax Steels";
$page_metakey = "Metal Weight Calculator, Steel Weight Calculator, Stainless Steel Weight Calculation, Metal Weight Estimator, Online Weight Calculator, Numax Steels";
$page_metadesc = "Use the Weight Calculator by Numax Steels to easily calculate the weight of metals like stainless steel, aluminum, and more. Get accurate metal weight estimates online!";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include 'app_header.php'; ?>


    <section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/about-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Weight Calculator</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li class="active">Weight Calculator</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <section class="contact_page">
        <div class="container">
            <div class="contact_form_grid1">
                <div class="row">
                    <div class="col-lg-8 col-md-12 mx-auto">
                        <div class="form_grid float-start w-100 d-block">
                            <!-- <h2 class="d-none">Metal Weight Calculator</h2> -->
                        <h2 class="title_h2_2 text-center">Metal Weight Calculator</h2>
                        <!-- <h4 class="d-none">Metal Weight Calculator</h4> -->
                        <form class="calcutator-class" onsubmit="CalculateWeight(); return false;" method="post">
                            <table width="100%" class="table table-bordered table-responsive"
                                cellpadding="0" cellspacing="0" style="margin:0;">
                                <tbody>
                                    <tr>
                                        <td width="34%">
                                            <p>Alloy:</p>
                                        </td>
                                        <td width="66%" >
                                            <p>
                                                <select name="product" class="calcutator-class">
                                                    <option selected="selected">Steel
                                                        (default) </option>
                                                    <option>Aluminum 1100 </option>
                                                    <option>Aluminum
                                                        2011 </option>
                                                    <option>Aluminum 2014 </option>
                                                    <option>Aluminum
                                                        2017 </option>
                                                    <option>Aluminum 2024 </option>
                                                    <option>Aluminum
                                                        3003 </option>
                                                    <option>Aluminum 5005 </option>
                                                    <option>Aluminum
                                                        5052 </option>
                                                    <option>Aluminum 5056 </option>
                                                    <option>Aluminum
                                                        5083 </option>
                                                    <option>Aluminum 5086 </option>
                                                    <option>Aluminum
                                                        6061 </option>
                                                    <option>Aluminum 6063 </option>
                                                    <option>Aluminum
                                                        7050 </option>
                                                    <option>Aluminum 7075 </option>
                                                    <option>Aluminum
                                                        7178 </option>
                                                    <option>Stainless 300 Series </option>
                                                    <option>Stainless 400
                                                        Series </option>
                                                    <option>Nickel 200 </option>
                                                    <option>Nickel 400 </option>
                                                    <option>Nickel
                                                        R-405 </option>
                                                    <option>Nickel K-500 </option>
                                                    <option>Nickel 600 </option>
                                                    <option>Nickel
                                                        625 </option>
                                                    <option>Nickel 800H </option>
                                                    <option>Nickel 800AT </option>
                                                    <option>Nickel
                                                        825 </option>
                                                    <option>Nickel 330 </option>
                                                    <option>Nickel 20 </option>
                                                    <option>Nickel
                                                        C-276 </option>
                                                    <option>Nickel
                                                        2545MD </option>
                                                    <option>Magnesium </option>
                                                    <option>Beryllium </option>
                                                    <option>Titanium </option>
                                                    <option>Zirconium </option>
                                                    <option>Cast
                                                        Iron </option>
                                                    <option>Zinc </option>
                                                    <option>Brass </option>
                                                    <option>Columbium </option>
                                                    <option>Copper </option>
                                                    <option>Molybdenum </option>
                                                    <option>Silver </option>
                                                    <option>Lead </option>
                                                    <option>Tantalum </option>
                                                    <option>Tungsten </option>
                                                    <option>Gold</option>
                                                </select>
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p>Shape:</p>
                                        </td>
                                        <td >
                                            <p>
                                                <select onchange="ChangeLabel();ClearFields();" name="form"
                                                    class="calcutator-class">
                                                    <option selected="selected">Round </option>
                                                    <option>Square </option>
                                                    <option>Hexagonal </option>
                                                    <option>Octagonal </option>
                                                    <option>Sheet </option>
                                                    <option>Plate </option>
                                                    <option>Flat </option>
                                                    <option>Tubular </option>
                                                    <option>Circular </option>
                                                    <option>Ring</option>
                                                </select>
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p>Number of Pieces: </p>
                                        </td>
                                        <td >
                                            <p>
                                                <input size="10" name="param4" type="text" value="1" class="calcutator-class">
                                            </p>
                                        </td>
                                    </tr>
                                    <tr class="bodytext">
                                        <td>
                                            <input placeholder="Diameter:" onblur="ChangeLabel();"  onfocus="if(navigator.appName == 'Netscape'&amp;&amp; parseInt(navigator.appVersion) == 3); else document.forms[0].param1.focus(); " size="15" name="lbl1" type="text" class="calcutator-class">
                                        </td>
                                        <td >
                                            <div>
                                                <input size="10" name="param1" type="text" class="calcutator-class">
                                                <select name="units1" class="calcutator-class">
                                                    <option selected="selected">in </option>
                                                    <option>ft </option>
                                                    <option>yd </option>
                                                    <option>mm </option>
                                                    <option>cm </option>
                                                    <option>m</option>
                                                </select>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr class="bodytext">
                                        <td>
                                            <input
                                                onfocus="if(!(navigator.appName == 'Netscape' &amp;&amp; parseInt(navigator.appVersion) == 3)){	if(document.forms[0].lbl2.value=='')  document.forms[0].param3.focus(); else document.forms[0].param2.focus();}"
                                                size="15" name="lbl2" type="text" class="calcutator-class">
                                        </td>
                                        <td >
                                            <div>
                                                <input size="10" name="param2" type="text" class="calcutator-class">
                                                <select name="units2" class="calcutator-class">
                                                    <option selected="selected">in </option>
                                                    <option>ft </option>
                                                    <option>yd </option>
                                                    <option>mm </option>
                                                    <option>cm </option>
                                                    <option>m</option>
                                                </select>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr class="bodytext">
                                        <td>
                                            <input placeholder="Length:" onblur="ChangeLabel();"
                                                onfocus="if(navigator.appName == 'Netscape'&amp;&amp; parseInt(navigator.appVersion) == 3); else document.forms[0].param3.focus(); "
                                                size="15" name="lbl3" type="text" class="calcutator-class">
                                        </td>
                                        <td >
                                            <div>
                                                <input size="10" name="param3" type="text" class="calcutator-class">
                                                <select name="units3" class="calcutator-class">
                                                    <option selected="selected">in </option>
                                                    <option>ft </option>
                                                    <option>yd </option>
                                                    <option>mm </option>
                                                    <option>cm </option>
                                                    <option>m</option>
                                                </select>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p>Calculated Weight<br>
                                                (Kgs):</p>
                                        </td>
                                        <td>
                                            <input onblur="ChangeLabel();"
                                                onfocus="if(navigator.appName == 'Netscape'&amp;&amp; parseInt(navigator.appVersion) == 3); else document.forms[0].Submit.focus(); "
                                                maxlength="8" size="16" name="result" type="text" class="calcutator-class"
                                                style="padding-right:10px;">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="text-align:center">
                                            <input name="reset" type="reset" class="read_more mb-0" onclick="ChangeLabel();ClearFields();return false;" value="Reset">
                                            <input name="Submit" type="submit" class="read_more mb-0" value="Calculate">

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </form>
                        </div>
                    </div>
                    <!-- <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8 col-sm-12 col-12 mx-auto">
                        <div class=" form_grid">
                            <h3 class="title_h2_2">Metal Weight Calculator</h3>
                            <form name="contact-form" method="post" id="contact_form">
                                <div class="row">
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="form-group">
                                            <input class="form-control" type="text" name="name" placeholder="Full Name*"
                                                required>
                                        </div>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="form-group">
                                            <input class="form-control" type="email" name="email"
                                                placeholder="Email ID*" required>
                                        </div>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="form-group">
                                            <input type="hidden" id="countryName" class="countryName" name="countryName"
                                                value="">
                                            <input class="form-control telePhone" id="mobile" type="tel" name="mobile"
                                                value="+91" placeholder="Mobile Number*"
                                                onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')"
                                                minlength="10" maxlength="12" required="" autocomplete="off"
                                                style="padding-left: 84px;">


                                        </div>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

                                        <div class="form-group">
                                            <input class="form-control" type="text" name="location"
                                                placeholder="Location*" required>
                                        </div>
                                    </div>
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="form-group">
                                            <textarea class="form-control" rows="5" placeholder="Comments Here*"
                                                required name="message"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="form-group" style="margin-bottom: 0;">
                                            <div class="g-recaptcha"
                                                data-sitekey="6LeIanwUAAAAAFmGKxHc8HDyiVvsJdvRc01uSMVD"></div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <button type="submit" class="read_more"><span>Submit</span></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
    </section>
<script>
		var focusflag = false;
								var Factor = new Array(47);
								Factor[0] = .3462;
								Factor[1] = .3604;
								Factor[2] = .3568;
								Factor[3] = .3568;
								Factor[4] = .3533;
								Factor[5] = .3498;
								Factor[6] = .3462;
								Factor[7] = .3427;
								Factor[8] = .3356;
								Factor[9] = .3392;
								Factor[10] = .3392;
								Factor[11] = .3462;
								Factor[12] = .3462;
								Factor[13] = .3568;
								Factor[14] = .3568;
								Factor[15] = .3604;
								Factor[16] = 1.030;
								Factor[17] = 1.010;
								Factor[18] = 1.132;
								Factor[19] = 1.125;
								Factor[20] = 1.121;
								Factor[21] = 1.075;
								Factor[22] = 1.072;
								Factor[23] = 1.075;
								Factor[24] = 1.012;
								Factor[25] = 1.012;
								Factor[26] = 1.037;
								Factor[27] = 1.012;
								Factor[28] = 1.030;
								Factor[29] = 1.132;
								Factor[30] = 1.012;
								Factor[31] = .229;
								Factor[32] = .236;
								Factor[33] = .575;
								Factor[34] = .812;
								Factor[35] = .911;
								Factor[36] = .911;
								Factor[37] = 1.084;
								Factor[38] = 1.095;
								Factor[39] = 1.144;
								Factor[40] = 1.303;
								Factor[41] = 1.339;
								Factor[42] = 1.448;
								Factor[43] = 2.120;
								Factor[44] = 2.462;
								Factor[45] = 2.466;
								var RoundOff = 5;

						function UnitConvertI(value,type){


									if(type=="cm")
										value = value/2.54;
									if(type=="m")
										value = (value*100)/2.54;
									if(type== "mm")
										value = (value/10)/2.54;
									if(type=="ft")
										value = value*12;
									if(type=="yd")
										value = value*36;



							return value;
							}
						function UnitConvertF(value,type){

									if(type== "cm")
										value = (value/2.54)/12;
									if(type =="m")
										value = ((value*100)/2.54)/12;
									if(type=="mm")
										value = ((value/10)/2.54)/12;
									if(type=="in")
										value = value/12;
									if(type=="yd")
										value = value*3;


							return value;
							}
						function CheckNum(value,label){
								var String1 = new String(value);
								var String2 = new String("");
								var String3 = new String("");
								var String4 = new String("");
								var temp;
								var i=0;
								var count=0;
								for(i=0;i<String1.length;i++){
									String2 = new String(parseFloat(String1.charAt(i)));
									if(String1.charAt(i)==".")
										count++;

									if((String2.length!=1&&String1.charAt(i)!='.')||count>1){
										alert("You entered an illegal value for the " + label);
										return false;
									}
								}
								return true;
							}
						function CheckParam(Param1,Param2,Param3,Param4){
								var Form = document.forms[0].form.options[document.forms[0].form.selectedIndex].text;
								var valid1 = 0,valid2 = 0,valid3 = 0,valid4 = 0;
								var counter = 0;

									if(Form=="Round"||Form=="Square"||Form=="Hexagonal"||Form=="Octagonal"){
										if(Param1==""||Param3==""||Param4 == ""){
										alert("You must fill in values for the Diameter And the Length!");
										return false;
										}
										valid1 = CheckNum(Param1,"Diameter");
										valid3 = CheckNum(Param3,"Length");
										valid4 = CheckNum(Param4,"Number of Pieces");
										if(valid1!=true||valid3!=true||valid4!=true)
											return false;
									}
									if(Form=="Flat"||Form=="Sheet"||Form=="Plate"){
									if(Param1==""||Param3==""||Param4 == ""||Param2==""){
										alert("You must fill in values for the Thickness And the Width And the Length!");
										return false;
										}
										valid1 = CheckNum(Param1,"Thickness");
										valid2 = CheckNum(Param2,"Width");
										valid3 = CheckNum(Param3,"Length");
										valid4 = CheckNum(Param4,"Number of Pieces");
										if(valid1!=true||valid3!=true||valid4!=true||valid2!=true)
											return false;

									}
									if(Form=="Tubular"){
									if(Param1==""||Param3==""||Param4 == ""||Param2==""){
										alert("You must fill in values for the Outer Diameter And the Wall And the Length!");
										return false;
										}
										valid1 = CheckNum(Param1,"Outer Diameter");
										valid2 = CheckNum(Param2,"Wall");
										valid3 = CheckNum(Param3,"Length");
										valid4 = CheckNum(Param4,"Number of Pieces");
										if(valid1!=true||valid2!=true||valid3!=true||valid4!=true)
											return false;

									}
									if(Form=="Circular"){
									if(Param1==""||Param3==""||Param4 == ""){
										alert("You must fill in values for the Diameter And the Thickness!");
										return false;
										}
										valid1 = CheckNum(Param1,"Diameter");
										valid3 = CheckNum(Param3,"Thickness");
										valid4 = CheckNum(Param4,"Number of Pieces");
										if(valid1!=true||valid3!=true||valid4!=true)
											return false;

									}
									if(Form=="Ring"){
									if(Param1==""||Param2==""||Param3==""||Param4 == ""){
										alert("You must fill in values for the Outer Diameter And the Inner Diameter And the Thickness!");
										return false;
										}
										valid1 = CheckNum(Param1,"Outer Diameter");
										valid2 = CheckNum(Param2,"Inner Diameter");
										valid3 = CheckNum(Param3,"Thickness");
										valid4 = CheckNum(Param4,"Number of Pieces");
										if(valid1!=true||valid2!=true||valid3!=true||valid4!=true)
											return false;

									}



								return true;
							}
						function CalculateWeight(){

								var Param = new Array(5);
								var Units = new Array(4);
								var Convert;
								var FormType;
								var Result;
								var Good;
								Param[0] = document.forms[0].param1.value;
								Param[1] = document.forms[0].param2.value;
								Param[2] = document.forms[0].param3.value;
								Param[3] = document.forms[0].param4.value;
								Good = CheckParam(Param[0],Param[1],Param[2],Param[3]);
								if(!Good)
									return;


								Units[0] = document.forms[0].units1.options[document.forms[0].units1.selectedIndex].text;
								Units[1] = document.forms[0].units2.options[document.forms[0].units2.selectedIndex].text;;
								Units[2] = document.forms[0].units3.options[document.forms[0].units3.selectedIndex].text;;

								Param[0] = UnitConvertI(Param[0],Units[0]);
								Param[1] = UnitConvertI(Param[1],Units[1]);
								Param[2] = UnitConvertF(Param[2],Units[2]);

								FormType = document.forms[0].form.options[document.forms[0].form.selectedIndex].text;
								if(document.forms[0].product.selectedIndex>0)
								Convert = Factor[document.forms[0].product.selectedIndex-1];
								else
								Convert = 1;
								document.forms[0].result.rsize = "4";

									if(FormType=="Round"){
										Result = new String(2.6729/2.2046 * Param[0] * Param[0] * Convert * Param[2] * Param[3]);
										document.forms[0].result.value = Result.substring(0,Result.indexOf(".")+RoundOff);
									}
									if(FormType=="Square"){
										Result = new String(3.4032/2.2046 * Param[0] * Param[0] * Convert * Param[2] * Param[3]);
										document.forms[0].result.value = Result.substring(0,Result.indexOf(".")+RoundOff);
									}
									if(FormType=="Hexagonal"){
										Result= new String(2.9473/2.2046 * Param[0] * Param[0] * Convert * Param[2] * Param[3]);
										document.forms[0].result.value = Result.substring(0,Result.indexOf(".")+RoundOff);
									}
									if(FormType=="Octagonal"){
										Result = new String(2.8193/2.2046 * Param[0] * Param[0] * Convert * Param[2] * Param[3]);
										document.forms[0].result.value = Result.substring(0,Result.indexOf(".")+RoundOff);
									}
									if(FormType=="Flat"||FormType=="Sheet"||FormType=="Plate"){
										Result = new String(3.4032/2.2046 * Param[0] * Convert * Param[1] * Param[2] * Param[3]);					document.forms[0].result.value = Result.substring(0,Result.indexOf(".")+RoundOff);
									}
									if(FormType=="Tubular"){
										Result = 10.68/2.2046 * (Param[0] - Param[1]) * Convert * Param[1] * Param[2] * Param[3];
										if(Result<0)
											alert("The Width of the Tube Wall cannot exceed the Outer Diameter!");
										else{
										Result = new String(Result);
										document.forms[0].result.value = Result.substring(0,Result.indexOf(".")+RoundOff);
										}
									}
									if(FormType=="Circular"){
										Param[2] = UnitConvertI(Param[2],"ft");
										Result = new String(.22274/2.2046 * Param[0] * Convert * Param[0] * Param[2] * Param[3]);
										document.forms[0].result.value = Result.substring(0,Result.indexOf(".")+RoundOff);
									}
									if(FormType=="Ring"){
										Param[2] = UnitConvertI(Param[2],"ft");
										Result = (.22274/2.2046 * Param[2] * ((Param[0]*Param[0]) - (Param[1]*Param[1])) * Convert * Param[3]);
										if(Result<0)
											alert("The Inner Diameter cannot exceed the Outer Diameter!");
										else{
										Result = new String(Result);
										document.forms[0].result.value = Result.substring(0,Result.indexOf(".")+RoundOff);
										}
									}



						}
						function ClearFields(){
							document.forms[0].param1.value = "";
							document.forms[0].param2.value = "";
							document.forms[0].param3.value = "";
							document.forms[0].param4.value = "1";
							document.forms[0].result.value = "";

							}
						function ChangeLabel(){
							var formType;
							formType = document.forms[0].form.options[document.forms[0].form.selectedIndex].text;



							if(formType=="Round"){
								document.forms[0].lbl1.value = "Diameter:";
								document.forms[0].lbl2.value = "";
								document.forms[0].lbl3.value = "Length:";
								}
							if(formType=="Square"){
								document.forms[0].lbl1.value = "Diameter:";
								document.forms[0].lbl2.value = "";
								document.forms[0].lbl3.value = "Length:";
								}
							if(formType== "Hexagonal"){
								document.forms[0].lbl1.value = "Diameter:";
								document.forms[0].lbl2.value = "";
								document.forms[0].lbl3.value = "Length:";
								}
							if(formType=="Octagonal"){
								document.forms[0].lbl1.value = "Diameter:";
								document.forms[0].lbl2.value = "";
								document.forms[0].lbl3.value = "Length:";
								}
							if(formType=="Flat"||formType=="Sheet"||formType=="Plate"){
								document.forms[0].lbl1.value = "Thickness:";
								document.forms[0].lbl2.value = "Width:";
								document.forms[0].lbl3.value = "Length:";
								}
							if(formType=="Tubular"){
								document.forms[0].lbl1.value = "Outer Diameter:";
								document.forms[0].lbl2.value = "Wall:";
								document.forms[0].lbl3.value = "Length:";
								}
							if(formType=="Circular"){
								document.forms[0].lbl1.value = "Diameter:";
								document.forms[0].lbl2.value = "";
								document.forms[0].lbl3.value = "Thickness:";
								}
							if(formType=="Ring"){
								document.forms[0].lbl1.value = "Outer Diameter:";
								document.forms[0].lbl2.value = "Inner Diameter:";
								document.forms[0].lbl3.value = "Thickness:";
								}


						}
						ChangeLabel();
						ClearFields();
</script>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>