<?php
include_once("include/main.inc.php");
$hover = 'weight';
$page_metatitle = "Weight Calculator - " . COMPANY_NAME;
$page_metakey = "Weight Calculator - " . COMPANY_NAME;
$page_metadesc = "Weight Calculator - " . COMPANY_NAME;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>
    <section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/about-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Weight Calculator</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>
    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Weight Calculator</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <secton class="wei-sec">
        <div class="container">
            <h2 class="title_2">Weight Calculator</h2>
            <div class="clearfix"></div>
            <form class="cl_fr" name="weightForm" method="POST" onsubmit="CalculateWeight(); return false;">
                <table class="table table-bordered table-striped bg-white">
                    <tbody>
                        <tr>
                            <th class="ti-bx" colspan="4"><strong>Enter your values:</strong></th>
                        </tr>

                        <tr>
                            <td>Material: </td>

                            <td>
                                <select class="form-select form-control" name="product">
                                    <option>Steel (default)</option>
                                    <option>Aluminum 1100</option>
                                    <option>Aluminum 2011</option>
                                    <option>Aluminum 2014</option>
                                    <option>Aluminum 2017</option>
                                    <option>Aluminum 2024</option>
                                    <option>Aluminum 3003</option>
                                    <option>Aluminum 5005</option>
                                    <option>Aluminum 5052</option>
                                    <option>Aluminum 5056</option>
                                    <option>Aluminum 5083</option>
                                    <option>Aluminum 5086</option>
                                    <option>Aluminum 6061</option>
                                    <option>Aluminum 6063</option>
                                    <option>Aluminum 7050</option>
                                    <option>Aluminum 7075</option>
                                    <option>Aluminum 7178</option>
                                    <option>Stainless 300 Series</option>
                                    <option>Stainless 400 Series</option>
                                    <option>Nickel 200</option>
                                    <option>Nickel 400</option>
                                    <option>Nickel R-405</option>
                                    <option>Nickel K-500</option>
                                    <option>Nickel 600</option>
                                    <option>Nickel 625</option>
                                    <option>Nickel 800H</option>
                                    <option>Nickel 800AT</option>
                                    <option>Nickel 825</option>
                                    <option>Nickel 330</option>
                                    <option>Nickel 20</option>
                                    <option>Nickel C-276</option>
                                    <option>Nickel 2545MD</option>
                                    <option>Magnesium</option>
                                    <option>Beryllium</option>
                                    <option>Titanium</option>
                                    <option>Zirconium</option>
                                    <option>Cast Iron</option>
                                    <option>Zinc</option>
                                    <option>Brass</option>
                                    <option>Columbium</option>
                                    <option>Copper</option>
                                    <option>Molybdenum</option>
                                    <option>Silver</option>
                                    <option>Lead</option>
                                    <option>Tantalum</option>
                                    <option>Tungsten</option>
                                    <option>Gold</option>
                                </select>
                            </td>
                            <td>Shape:</td>
                            <td>
                                <select class="form-select form-control" name="form" onchange="ChangeLabel();ClearFields();showimage();">
                                    <option selected="" value="designer/images/round.jpg">Round</option>
                                    <option value="designer/images/sqr.jpg">Square</option>
                                    <option value="designer/images/rect.jpg">Rectangle</option>
                                    <option value="designer/images/hexagon.jpg">Hexagonal</option>
                                    <option value="designer/images/octagon.jpg">Octagonal</option>
                                    <option value="designer/images/sheet.jpg">Sheet</option>
                                    <option value="designer/images/plate.jpg">Plate</option>
                                    <option value="designer/images/tubular.jpg">Tubular</option>
                                    <option value="designer/images/ring.jpg">Ring</option>
                                    <option value="designer/images/tubular.jpg">Pipe</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td class="img-bx" colspan="4"><img src="designer/images/round.jpg" name="pictures"></td>
                        </tr>
                        <tr>
                            <td colspan="2">Quantity:</td>
                            <td colspan="2"><input class="form-control form-control-sm" type="text" name="param4" size="6" maxlength="10"></td>
                        </tr>

                        <tr>
                            <td colspan="2"><input class="form-control form-control-sm" type="text" name="lbl1" size="12" onfocus="if(navigator.appName == 'Netscape'&amp;&amp; parseInt(navigator.appVersion) == 3); else document.weightForm.param1.focus(); " onblur="ChangeLabel();"></td>
                            <td colspan="2">
                                <span class="d-flex gap-3 w-100%">
                                    <input class="form-control form-control-sm" type="text" name="param1" size="6" maxlength="10" />
                                    <select class="form-select form-control" name="units1">
                                        <option>in </option>
                                        <option>ft </option>
                                        <option>yd </option>
                                        <option>mm </option>
                                        <option>cm </option>
                                        <option>m</option>
                                    </select>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <input class="form-control form-control-sm" type="text" name="lbl2" size="12" onfocus="if(!(navigator.appName == 'Netscape' &amp;&amp; parseInt(navigator.appVersion) == 3)){	if(document.weightForm.lbl2.value=='(no value)')  document.weightForm.param3.focus(); else document.weightForm.param2.focus();}">
                            </td>
                            <td colspan="2">
                                <span class="d-flex gap-3 w-100%">
                                    <input class="form-control form-control-sm" type="text" name="param2" size="6" maxlength="10" />
                                    <select class="form-select form-control" name="units2">
                                        <option>in </option>
                                        <option>ft </option>
                                        <option>yd </option>
                                        <option>mm </option>
                                        <option>cm </option>
                                        <option>m </option>
                                    </select>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <input class="form-control form-control-sm" type="text" name="lbl3" size="12" onfocus="if(navigator.appName == 'Netscape'&amp;&amp; parseInt(navigator.appVersion) == 3); else document.weightForm.param3.focus(); " onblur="ChangeLabel();">
                            </td>
                            <td colspan="2">
                                <span class="d-flex gap-3 w-100%">
                                    <input class="form-control form-control-sm" type="text" name="param3" size="6" maxlength="10" />
                                    <select class="form-select form-control" name="units3">
                                        <option>in </option>
                                        <option>ft </option>
                                        <option>yd </option>
                                        <option>mm </option>
                                        <option>cm </option>
                                        <option>m </option>
                                    </select>
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td colspan="4">
                                <button class="read_more" type="submit" name="Submit" value="Calculate">Calculate</button>
                                <button class="read_more" type="reset" name="reset" value="Clear" onclick="ChangeLabel();ClearFields();return false;">Clear</button>
                            </td>
                        </tr>
                        <tr>
                            <th class="ti-bx" colspan="4">Results:</th>
                        </tr>
                        <tr>
                            <td colspan="2">Calculated Weight:</td>
                            <td colspan="2">
                                <span class="row align-items-center g-1">
                                    <span class="col-7">
                                        <input class="form-control form-control-sm" type="text" maxlength="8" name="result" size="10" onfocus="if(navigator.appName == 'Netscape'&amp;&amp; parseInt(navigator.appVersion) == 3); else document.weightForm.Submit.focus(); " onblur="ChangeLabel();" style="color:#333;" />
                                    </span>

                                <span class="col-5">Lbs</span>
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td colspan="2">Calculated Weight:</td>
                            <td colspan="2">
                                <span class="row align-items-center g-1">
                                    <span class="col-7">
                                        <input class="form-control form-control-sm" type="text" maxlength="8" name="result2" size="10" onfocus="if(navigator.appName == 'Netscape'&amp;&amp; parseInt(navigator.appVersion) == 3); else document.weightForm.Submit.focus(); " onblur="ChangeLabel();" />
                                    </span>
                                    <span class="col-5">Kgs</span>
                                </span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>
    </secton>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
    <script language="JavaScript">
        function showimage() {
            if (!document.images)
                return
            document.images.pictures.src =
                document.weightForm.form.options[document.weightForm.form.selectedIndex].value
        }

        var focusflag = false;
        var Factor = new Array(47);
        Factor[0] = .3462;
        Factor[1] = .3604;
        Factor[2] = .3568;
        Factor[3] = .3568;
        Factor[4] = .3533;
        Factor[5] = .3498;
        Factor[6] = .3462;
        Factor[7] = .3427;
        Factor[8] = .3356;
        Factor[9] = .3392;
        Factor[10] = .3392;
        Factor[11] = .3462;
        Factor[12] = .3462;
        Factor[13] = .3568;
        Factor[14] = .3568;
        Factor[15] = .3604;
        Factor[16] = 1.030;
        Factor[17] = 1.010;
        Factor[18] = 1.132;
        Factor[19] = 1.125;
        Factor[20] = 1.121;
        Factor[21] = 1.075;
        Factor[22] = 1.072;
        Factor[23] = 1.075;
        Factor[24] = 1.012;
        Factor[25] = 1.012;
        Factor[26] = 1.037;
        Factor[27] = 1.012;
        Factor[28] = 1.030;
        Factor[29] = 1.132;
        Factor[30] = 1.012;
        Factor[31] = .229;
        Factor[32] = .236;
        Factor[33] = .575;
        Factor[34] = .812;
        Factor[35] = .911;
        Factor[36] = .911;
        Factor[37] = 1.084;
        Factor[38] = 1.095;
        Factor[39] = 1.144;
        Factor[40] = 1.303;
        Factor[41] = 1.339;
        Factor[42] = 1.448;
        Factor[43] = 2.120;
        Factor[44] = 2.462;
        Factor[45] = 2.466;
        var RoundOff = 5;

        function UnitConvertI(value, type) {


            if (type == "cm")
                value = value / 2.54;
            if (type == "m")
                value = (value * 100) / 2.54;
            if (type == "mm")
                value = (value / 10) / 2.54;
            if (type == "ft")
                value = value * 12;
            if (type == "yd")
                value = value * 36;



            return value;
        }

        function UnitConvertF(value, type) {

            if (type == "cm")
                value = (value / 2.54) / 12;
            if (type == "m")
                value = ((value * 100) / 2.54) / 12;
            if (type == "mm")
                value = ((value / 10) / 2.54) / 12;
            if (type == "in")
                value = value / 12;
            if (type == "yd")
                value = value * 3;


            return value;
        }

        function CheckNum(value, label) {
            var String1 = new String(value);
            var String2 = new String("");
            var String3 = new String("");
            var String4 = new String("");
            var temp;
            var i = 0;
            var count = 0;
            for (i = 0; i < String1.length; i++) {
                String2 = new String(parseFloat(String1.charAt(i)));
                if (String1.charAt(i) == ".")
                    count++;

                if ((String2.length != 1 && String1.charAt(i) != '.') || count > 1) {
                    alert("You entered an illegal value for the " + label);
                    return false;
                }
            }
            return true;
        }

        function CheckParam(Param1, Param2, Param3, Param4) {
            var Form = document.weightForm.form.options[document.weightForm.form.selectedIndex].text;
            var valid1 = 0,
                valid2 = 0,
                valid3 = 0,
                valid4 = 0;
            var counter = 0;

            if (Form == "Round" || Form == "Hexagonal" || Form == "Octagonal") {
                if (Param1 == "" || Param3 == "" || Param4 == "") {
                    alert("You must fill in values for the Diameter And the Length!");
                    return false;
                }
                valid1 = CheckNum(Param1, "Diameter");
                valid3 = CheckNum(Param3, "Length");
                valid4 = CheckNum(Param4, "Number of Pieces");
                if (valid1 != true || valid3 != true || valid4 != true)
                    return false;
            }

            if (Form == "Square") {
                if (Param1 == "" || Param3 == "" || Param4 == "") {
                    alert("You must fill in values for the Width And the Length!");
                    return false;
                }
                valid1 = CheckNum(Param1, "Width");
                valid3 = CheckNum(Param3, "Length");
                valid4 = CheckNum(Param4, "Number of Pieces");
                if (valid1 != true || valid3 != true || valid4 != true)
                    return false;
            }

            if (Form == "Flat" || Form == "Sheet" || Form == "Plate" || Form == "Coil" || Form == "Rectangle") {
                if (Param1 == "" || Param3 == "" || Param4 == "" || Param2 == "") {
                    alert("You must fill in values for the Thickness And the Width And the Length!");
                    return false;
                }
                valid1 = CheckNum(Param1, "Thickness");
                valid2 = CheckNum(Param2, "Width");
                valid3 = CheckNum(Param3, "Length");
                valid4 = CheckNum(Param4, "Number of Pieces");
                if (valid1 != true || valid3 != true || valid4 != true || valid2 != true)
                    return false;

            }
            if (Form == "Tubular" || Form == "Pipe") {
                if (Param1 == "" || Param3 == "" || Param4 == "" || Param2 == "") {
                    alert("You must fill in values for the Outer Diameter And the Wall And the Length!");
                    return false;
                }
                valid1 = CheckNum(Param1, "Outer Diameter");
                valid2 = CheckNum(Param2, "Wall");
                valid3 = CheckNum(Param3, "Length");
                valid4 = CheckNum(Param4, "Number of Pieces");
                if (valid1 != true || valid2 != true || valid3 != true || valid4 != true)
                    return false;

            }
            if (Form == "Circular") {
                if (Param1 == "" || Param3 == "" || Param4 == "") {
                    alert("You must fill in values for the Diameter And the Thickness!");
                    return false;
                }
                valid1 = CheckNum(Param1, "Diameter");
                valid3 = CheckNum(Param3, "Thickness");
                valid4 = CheckNum(Param4, "Number of Pieces");
                if (valid1 != true || valid3 != true || valid4 != true)
                    return false;

            }
            if (Form == "Ring") {
                if (Param1 == "" || Param2 == "" || Param3 == "" || Param4 == "") {
                    alert("You must fill in values for the Outer Diameter And the Inner Diameter And the Thickness!");
                    return false;
                }
                valid1 = CheckNum(Param1, "Outer Diameter");
                valid2 = CheckNum(Param2, "Inner Diameter");
                valid3 = CheckNum(Param3, "Thickness");
                valid4 = CheckNum(Param4, "Number of Pieces");
                if (valid1 != true || valid2 != true || valid3 != true || valid4 != true)
                    return false;

            }



            return true;
        }

        function CalculateWeight() {

            var Param = new Array(5);
            var Units = new Array(4);
            var Convert;
            var FormType;
            var Result;

            var Good;
            Param[0] = document.weightForm.param1.value;
            Param[1] = document.weightForm.param2.value;
            Param[2] = document.weightForm.param3.value;
            Param[3] = document.weightForm.param4.value;
            Good = CheckParam(Param[0], Param[1], Param[2], Param[3]);
            if (!Good)
                return;


            Units[0] = document.weightForm.units1.options[document.weightForm.units1.selectedIndex].text;
            Units[1] = document.weightForm.units2.options[document.weightForm.units2.selectedIndex].text;;
            Units[2] = document.weightForm.units3.options[document.weightForm.units3.selectedIndex].text;;

            Param[0] = UnitConvertI(Param[0], Units[0]);
            Param[1] = UnitConvertI(Param[1], Units[1]);
            Param[2] = UnitConvertF(Param[2], Units[2]);

            FormType = document.weightForm.form.options[document.weightForm.form.selectedIndex].text;
            if (document.weightForm.product.selectedIndex > 0) {
                Convert = Factor[document.weightForm.product.selectedIndex - 1];
            } else {
                Convert = 1;
                document.weightForm.result.rsize = "4";
            }

            if (FormType == "Round") {
                Result = new String(2.6729 * Param[0] * Param[0] * Convert * Param[2] * Param[3]);
                document.weightForm.result.value = Result.substring(0, Result.indexOf(".") + RoundOff);
                document.weightForm.result2.value = Result.substring(0, Result.indexOf(".") + RoundOff) * 0.4535;

            }
            if (FormType == "Square") {
                Result = new String(3.4032 * Param[0] * Param[0] * Convert * Param[2] * Param[3]);
                document.weightForm.result.value = Result.substring(0, Result.indexOf(".") + RoundOff);
                document.weightForm.result2.value = Result.substring(0, Result.indexOf(".") + RoundOff) * 0.4535;
            }
            if (FormType == "Hexagonal") {
                Result = new String(2.9473 * Param[0] * Param[0] * Convert * Param[2] * Param[3]);
                document.weightForm.result.value = Result.substring(0, Result.indexOf(".") + RoundOff);
                document.weightForm.result2.value = Result.substring(0, Result.indexOf(".") + RoundOff) * 0.4535;
            }
            if (FormType == "Octagonal") {
                Result = new String(2.8193 * Param[0] * Param[0] * Convert * Param[2] * Param[3]);
                document.weightForm.result.value = Result.substring(0, Result.indexOf(".") + RoundOff);
                document.weightForm.result2.value = Result.substring(0, Result.indexOf(".") + RoundOff) * 0.4535;
            }
            if (FormType == "Flat" || FormType == "Sheet" || FormType == "Plate" || FormType == "Coil" || FormType ==
                "Rectangle") {
                Result = new String(3.4032 * Param[0] * Convert * Param[1] * Param[2] * Param[3]);
                document.weightForm.result.value = Result.substring(0, Result.indexOf(".") + RoundOff);
                document.weightForm.result2.value = Result.substring(0, Result.indexOf(".") + RoundOff) * 0.4535;
            }
            if (FormType == "Tubular" || FormType == "Pipe") {
                Result = 10.68 * (Param[0] - Param[1]) * Convert * Param[1] * Param[2] * Param[3];
                if (Result < 0)
                    alert("The Width of the Tube Wall cannot exceed the Outer Diameter!");
                else {
                    Result = new String(Result);
                    document.weightForm.result.value = Result.substring(0, Result.indexOf(".") + RoundOff);
                    document.weightForm.result2.value = Result.substring(0, Result.indexOf(".") + RoundOff) * 0.4535;
                }
            }
            if (FormType == "Circular") {
                Param[2] = UnitConvertI(Param[2], "ft");
                Result = new String(.22274 * Param[0] * Convert * Param[0] * Param[2] * Param[3]);
                document.weightForm.result.value = Result.substring(0, Result.indexOf(".") + RoundOff);
                document.weightForm.result2.value = Result.substring(0, Result.indexOf(".") + RoundOff) * 0.4535;
            }
            if (FormType == "Ring") {
                Param[2] = UnitConvertI(Param[2], "ft");
                Result = (.22274 * Param[2] * ((Param[0] * Param[0]) - (Param[1] * Param[1])) * Convert * Param[3]);
                if (Result < 0)
                    alert("The Inner Diameter cannot exceed the Outer Diameter!");
                else {
                    Result = new String(Result);
                    document.weightForm.result.value = Result.substring(0, Result.indexOf(".") + RoundOff);
                    document.weightForm.result2.value = Result.substring(0, Result.indexOf(".") + RoundOff) * 0.4535;
                }
            }



        }

        function ClearFields() {
            document.weightForm.param1.value = "";
            document.weightForm.param2.value = "";
            document.weightForm.param3.value = "";
            document.weightForm.param4.value = "1";
            document.weightForm.result.value = "";
            document.weightForm.result2.value = "";

        }

        function ChangeLabel() {
            var formType;
            formType = document.weightForm.form.options[document.weightForm.form.selectedIndex].text;



            if (formType == "Round") {
                document.weightForm.lbl1.value = "Diameter";
                document.weightForm.lbl2.value = "";
                document.weightForm.lbl3.value = "Length";
            }
            if (formType == "Square") {
                document.weightForm.lbl1.value = "Width";
                document.weightForm.lbl2.value = "";
                document.weightForm.lbl3.value = "Length";
            }
            if (formType == "Hexagonal") {
                document.weightForm.lbl1.value = "Diameter";
                document.weightForm.lbl2.value = "";
                document.weightForm.lbl3.value = "Length";
            }
            if (formType == "Octagonal") {
                document.weightForm.lbl1.value = "Diameter";
                document.weightForm.lbl2.value = "";
                document.weightForm.lbl3.value = "Length";
            }
            if (formType == "Flat" || formType == "Sheet" || formType == "Plate" || formType == "Coil" || formType ==
                "Rectangle") {
                document.weightForm.lbl1.value = "Thickness";
                document.weightForm.lbl2.value = "Width";
                document.weightForm.lbl3.value = "Length";
            }
            if (formType == "Tubular" || formType == "Pipe") {
                document.weightForm.lbl1.value = "Outer Diameter";
                document.weightForm.lbl2.value = "Wall";
                document.weightForm.lbl3.value = "Length";
            }
            if (formType == "Circular") {
                document.weightForm.lbl1.value = "Diameter";
                document.weightForm.lbl2.value = "";
                document.weightForm.lbl3.value = "Thickness";
            }
            if (formType == "Ring") {
                document.weightForm.lbl1.value = "Outer Diameter";
                document.weightForm.lbl2.value = "Inner Diameter";
                document.weightForm.lbl3.value = "Thickness";
            }


        }
        ChangeLabel();
        ClearFields();
    </script>
</body>

</html>