<?php

class Wishlist extends Public_Controller {

  public function __construct() {
    parent::__construct();
    if (!isset($this->ci)) {
      $this->ci = &get_instance();
    }

    $this->load->model(array('web_apis/api_model', 'users/users_model', 'wishlist/wishlist_model', 'products/product_model'));
    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer'));
    $this->load->helper(array('web_apis/api', 'cart/cart', 'products/product'));
  }

  public function addToWishlist() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      // $data['data']=array();
      if ($posteddata['userId'] != '' && $posteddata['productId']) {
        $productId = (int) $posteddata['productId'];
        // $size = (int) $posteddata['size'];
        $userId = (int) $posteddata['userId'];
        // $qty = (int) ($posteddata['quantity']) ? $posteddata['quantity'] : 1;
        //To check if product is already in the wishlist or not
        $isProductAdded = isProductAddedToWishlist($productId, $userId);
        if ($isProductAdded) {
          $data['success'] = false;
          $data['message'] = 'Product Already added in the wishlist';
          echo json_encode($data);
          die;
        }
        //to check if the produt is available             
        $product = array(
            'productId' => $productId,
            'userId' => $userId
        );
        $this->wishlist_model->add_to_wishlist($product);
        // $data['data']=$product;
        $data['success'] = true;
        $data['message'] = 'Product Added to the wishlist';
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function removeFromWishlist() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '' && $posteddata['productId'] != '') {
        $productId = (int) $posteddata['productId'];
        $userId = (int) $posteddata['userId'];
        // $sizeId = (int) $posteddata['sizeId'];
        $status = $this->wishlist_model->remove_from_wishlist($productId, $userId);
        if ($status == '0') {
          $data['success'] = false;
          $data['message'] = 'Product not in wishlist';
        } else {
          $data['success'] = true;
          $data['message'] = 'Product Removed from the wishlist';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function listItem() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $userId = $posteddata['userId'];
        $cartItems = $this->wishlist_model->get_wishlist_items($userId);
        if ($cartItems == '0') {
          $data['success'] = true;
          $data['data'] = [];
          $data['message'] = 'Wishlist Empty';
        } else {
          foreach ($cartItems as $item) {
            //trace($item);
            $completeProductDetail = get_product_by_id($item['products_Id']);
            $productDetail[] = [
                "productId" => $completeProductDetail['productId'],
                "name" => $completeProductDetail['name'],
                "originalPrice" => $completeProductDetail['originalPrice'],
                "price" => $completeProductDetail['price'],
                "description" => $completeProductDetail['description'],
                'colorId' => $completeProductDetail['color'][0]['colorId'],
                "image" => array_pop($completeProductDetail['image']),
                    // "quantity" => $item['quantity'],
                    // "size" => $this->product_model->get_size_by_id($item['size_id']),
                    // "deliveryCharges" => $item['delivery_charges']
            ];
          }
          $data['data'] = $productDetail;
          $data['success'] = true;
          $data['message'] = 'Success';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function emptyWishlist() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $userId = (int) $posteddata['userId'];
        $status = $this->wishlist_model->empty_wishlist($userId);
        $data['data'] = [];
        $data['success'] = true;
        $data['message'] = 'Wishlist has been emptied';
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }

    echo json_encode($data);
  }

}
