<?php

class Utility extends Public_Controller {

  public function __construct() {
    parent::__construct();
    if (!isset($this->ci)) {
      $this->ci = &get_instance();
    }

    $this->load->model(array('web_apis/api_model'));
    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer'));
    // $this->load->library(array('Mailer'));
  }

  //get App version and update window.

  public function initApi() {

    $appV = $this->db->query("SELECT app_version_ios, app_version_android from wps_admin where admin_id = '1'")->row_array();
    $data['FORCE_UPDATE'] = false;
    $data['FORCE_UPDATE_CONTENT'] = "We've released a new version of the app.\nTo continue using Unyqorn please upgrade to the latest version.";
    $data['APP_VERSION_IOS'] = $appV['app_version_ios'];
    $data['APP_VERSION_ANDROID'] = $appV['app_version_android'];
    echo json_encode($data);
  }

  //get App version and update window.

  public function checkUserStatus() {

    $posteddata = json_decode(file_get_contents('php://input'), true);
    $admin_id = $posteddata['adminId'];
    if ($admin_id > 0) {
      $status = get_db_field_value("tbl_admin", "status", "WHERE admin_id = '" . $admin_id . "'");
      if ($status == '1') {
        $data['message'] = 'Continue Login';
        $data['success'] = true;
      } else {
        $data['message'] = 'Logout Now';
        $data['success'] = true;
      }
    } else {
      $data['error'] = 'Parameter Missing, please try again later.';
      $data['success'] = false;
    }
    echo json_encode($data);

    exit;
  }

  /* App Version Control */

  public function checkAppUpdate() {
    $appData = get_db_single_row(" wps_version_control", "*", "id = '1'");
    $FORCE_UPDATE = false;
    if ($FORCE_UPDATE) {
      $data['FORCE_UPDATE'] = $FORCE_UPDATE;
      $data['FORCE_UPDATE_CONTENT'] = "We've released a new version of the APP.\nTo continue using APP please upgrade to the latest version.";
      $data['success'] = true;
    } else {
      if (is_array($appData) && !empty($appData)) {
        $data['success'] = true;
        $data['message'] = "";
      } else {
        $data['message'] = 'Somthing went wrong.';
        $data['success'] = false;
      }
    }
    $data['version_no'] = $appData['version_no'];
    $data['ios_version_no'] = $appData['ios_version_no'];
    echo json_encode($data);
    exit;
  }

  public function sendFCMMessage() {
    $url = "https://fcm.googleapis.com/fcm/send";
    $token = "eDXq0Vc3VEM:APA91bEsBAlsp7qQ1N3Ayp5_DYtltGmYcbjbFN8mKSJ90a-dS4shUfJxZxootla9m3mAbuQT-ShDfs3Fjsq0LIjSJw7Hg7fr0FdyXQxHpDVWfBFsTfIo7RA7ZxPr_mg8mJRVGHz-YUFY";
    $serverKey = 'AAAAuZ29sJU:APA91bEZtukhHen1kTQJnP5Cc6ykPYqE5--oe_us5egNwZHudNPB6Az9s5Zk300mlIQs2Pk6pOMtXg7rUKJ7-hXVm5da9lc1lZHcmCxozYmqtkoI6CwLjTHABeIleGo4NNbfcOb7OfYy';
    $title = "Title";
    $body = "Body of the message";
    $notification = array('title' => $title, 'text' => $body, 'sound' => 'default', 'badge' => '1');
    $dataArray = array("clientType" => "Leads", "clientName" => "Vicky Jha", "phoneNo" => "9910505554", "companyName" => "Webpulse Solution");
    $arrayToSend = array('to' => $token, 'notification' => $notification, 'data' => $dataArray, 'priority' => 'high');
    $json = json_encode($arrayToSend);
    $headers = array();
    $headers[] = 'Content-Type: application/json';
    $headers[] = 'Authorization: key=' . $serverKey;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //Send the request
    $response = curl_exec($ch);
    //Close request
    if ($response === false) {
      die('FCM Send Error: ' . curl_error($ch));
    }
    curl_close($ch);
  }

  public function getCity() {

    $cities = $this->db->query("SELECT city_name, latitude, longitude FROM wp_statelist WHERE 1")->result_array();
    $data['cities'] = $cities;
    $data['success'] = true;
    echo json_encode($data);
  }

}

/* End of file apis.php */