<?php

class Users extends Public_Controller {

  public function __construct() {
    parent::__construct();
    if (!isset($this->ci)) {
      $this->ci = &get_instance();
    }

    $this->load->model(array('web_apis/api_model', 'users/users_model'));
    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer'));
    $this->load->helper(array('web_apis/api'));
  }

  public function changePassword() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if (!empty(@$posteddata['userId']) && !empty(@$posteddata['oldPassword']) && !empty(@$posteddata['newPassword'])) {
        $userId = $posteddata['userId'];
        $oldPassword = $posteddata['oldPassword'];
        $newPassword = $posteddata['newPassword'];

        $this->form_validation->set_rules('oldPassword', 'Old Password', 'trim|required');
        $this->form_validation->set_rules('newPassword', 'New Password', 'trim|required|valid_password');
        $data = '';
        $password_old = $this->safe_encrypt->encode($oldPassword, TRUE);
        $mres = $this->users_model->get_member_row($userId, " AND password='$password_old' ");
        $oldPass = $this->users_model->get_member_row($userId, "");
        if ($oldPass['password'] == '' || (is_array($mres) && !empty($mres))) {
          $password = $this->safe_encrypt->encode($newPassword, TRUE);
          $data2 = array('password' => $password);
          $where = "customers_id=" . $userId . " ";
          $this->users_model->safe_update('wps_customers', $data2, $where, FALSE);
          $data['success'] = true;
          $data['message'] = 'Password Changed Successfully!';
        } else {
          $data['success'] = false;
          $data['message'] = 'Incorrect Old Password!';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function editProfile() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if (!empty(@$posteddata['mobileNo']) && !empty(@$posteddata['userId']) && !empty(@$posteddata['email'])) {
        $userId = $posteddata['userId'];
        $mobileNo = $posteddata['mobileNo'];
        $email = $posteddata['email'];
        $user = get_db_single_row('wps_customers', 'user_name, mobile_number', "`customers_id`=$userId");
        if ($user['mobile_number'] != $posteddata['mobileNo'] || $user['user_name'] != $posteddata['email']) {
          $data = array();
          $data['success'] = true;
          $data['message'] = 'Verfication in progress!';
        } else {
          $data['success'] = false;
          $data['message'] = 'Nothing Changed!';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function verifyOtpUpdate() {
    $resp = array('success' => false, 'message' => 'Invalid Token.', 'data' => (object) []);
    try {
      if (is_post()) {
        $post = post_json_data();
        if (!empty(@$post['otp']) && !empty(@$post['userId']) && !empty(@$post['mobileNo']) && !empty(@$post['email'])) {
          $user_id = escape_str($post['userId']);
          $otp = escape_str($post['otp']);
          $email = $post['email'];
          $mobileNo = $post['mobileNo'];
          $user = get_db_single_row('wps_customers', 'customers_id,mobile_number', "`customers_id`='$user_id'");
          if ($user) {
            if (verify_sms($post['mobileNo'], $otp)) {
              $update = array(
                  'user_name' => $email,
                  'mobile_number' => $mobileNo,
              );
              $this->users_model->safe_update('wps_customers', $update, "`customers_id`='$user_id'");
              $resp = array('success' => true, 'message' => 'Otp Verified Successfully.');
              $resp['data'] = (is_array(get_user_profile($user_id))) ? get_user_profile($user_id) : (object) [];
            } else {
              throw new Exception("Invalid Otp");
            }
          } else {
            throw new Exception("User Not Found");
          }
        } else {
          throw new Exception("Send All Required Field");
        }
      } else {
        throw new Exception("Method Not Allowed");
      }
    } catch (Exception $e) {
      $resp['message'] = $e->getMessage();
      $resp['success'] = false;
    }
    echo json_encode($resp);
  }

  public function register() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $identificationObject = $posteddata['identificationObject'];
    $identificationObject['last_login'] = $this->config->item('config.date.time');
    $name = $posteddata['name'];
    $email = $posteddata['email'];
    $password = $posteddata['password'];
    $mobile = $posteddata['mobileNo'];
    //$city = $posteddata['user_location'];
    // $lat = $posteddata['lat'];
    //$long = $posteddata['long'];
    //$type = $posteddata['type'];
    //$ip = $posteddata['ip_address'];
    if ($email != '' && $mobile != '') {
      $count = count_record("wps_customers", "user_name = '" . $email . "' OR mobile_number = '" . $mobile . "'");
      if ($count == 0) {
        $register_array = array(
            'user_name' => $email,
            //'ori_password' => $password,
            'password' => $this->safe_encrypt->encode($password),
            'mobile_number' => $mobile,
            'first_name' => $name,
            // 'user_location' => $city,
            // 'user_lat' => $lat,
            // 'user_long' => $long,
            'actkey' => md5($email),
            'account_created_date' => $this->config->item('config.date.time'),
            'current_login' => $this->config->item('config.date.time'),
            'status' => '1',
            'is_verified' => '0',
                //'login_type' => $type,
                //'ip_address' => $ip,
        );
        $insId = $this->users_model->safe_insert('wps_customers', $register_array, false);
        get_auth_token($insId, $identificationObject);
        $data['userId'] = $insId;
        $data['success'] = true;
        $data['message'] = 'Register Successfully!';
      } else {
        $data['success'] = false;
        $data['message'] = 'Email Id or Mobile Number already exists! Please login!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Something went wrong please try again!';
    }
    echo json_encode($data);
  }

  public function get_otp() {
    $resp = array('success' => true, 'message' => 'Otp Sent Successfully.');
    try {
      if (is_post()) {
        $post = post_json_data();
        $user_id = (int) @$post['userId'];
        $type = @$post['type'];
        if ($type == 'register') {
          $user = get_db_single_row('wps_customers', 'customers_id,mobile_number', "`customers_id`='$user_id'");
          if ($user) {
            $mobile = escape_str($user['mobile_number']);
            sendOtp($mobile);
          } else {
            throw new Exception("Otp Not Sent. User Not Exist");
          }
        } elseif ($type == 'update') {
          $mobile = escape_str(@$post['mobileNo']);
          sendOtp($mobile);
        }
      } else {
        throw new Exception("Method Not Allowed");
      }
    } catch (Exception $e) {
      $resp['message'] = $e->getMessage();
      $resp['success'] = false;
    }
    json_data($resp);
  }

  public function login() {
    $resp = array('success' => false, 'message' => 'Login Details Not Found.', 'data' => (object) []);
    try {
      if (is_post()) {
        $post = post_json_data();
        if (!empty(@$post['email']) && !empty(@$post['password'])) {
          $user = $this->users_model->login($post);
          if ($user) {
            $identificationObject = @$post['identificationObject'];
            $identificationObject['last_login'] = $this->config->item('config.date.time');
            $this->db->set('login_status', 1);
            $this->db->where('customers_id', $user->customers_id);
            $this->db->update('wps_customers');
            $user_dtl = get_user_profile($user->customers_id, $identificationObject);
            $resp['success'] = true;
            $resp['message'] = ($user_dtl['isVerified'] == 1) ? 'Verified' : 'Not Verified';
            $resp['data'] = $user_dtl;
            // print_r($identificationObject);
            $resp['data']['token'] = get_auth_token($user->customers_id, $identificationObject);
          }
        } else {
          throw new Exception("Send All Required Field");
        }
      } else {
        throw new Exception("Method Not Allowed");
      }
    } catch (Exception $e) {
      $resp['message'] = $e->getMessage();
      $resp['success'] = false;
    }
    json_data($resp);
  }

  public function verifyOtp() {
    $resp = array('success' => false, 'message' => 'Invalid Token.', 'data' => (object) []);
    try {
      if (is_post()) {
        $post = post_json_data();
        if (!empty(@$post['otp']) && !empty(@$post['userId'])) {
          // $identificationObject = @$post['identificationObject']; 
          $user_id = escape_str($post['userId']);
          $otp = escape_str($post['otp']);
          $user = get_db_single_row('wps_customers', 'customers_id,mobile_number', "`customers_id`='$user_id'");
          if ($user) {
            if (verify_sms($user['mobile_number'], $otp)) {
              $up_data['is_verified'] = '1';
              $this->users_model->safe_update('wps_customers', $up_data, "`customers_id`='$user_id'");
              $resp = array('success' => true, 'message' => 'Otp Verified Successfully.');
              $resp['data'] = get_user_profile($user_id);
            } else {
              throw new Exception("Invalid Otp");
            }
          } else {
            throw new Exception("User Not Found");
          }
        } else {
          throw new Exception("Send All Required Field");
        }
      } else {
        throw new Exception("Method Not Allowed");
      }
    } catch (Exception $e) {
      $resp['message'] = $e->getMessage();
      $resp['success'] = false;
    }
    json_data($resp);
  }

  public function add_address() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $userId = $posteddata['userId'];
    if (verifyToken($userId)) {
      $name = $posteddata['name'];
      $house = $posteddata['house'];
      $street = $posteddata['street'];
      $locality = $posteddata['locality'];
      $city = $posteddata['city'];
      $pincode = $posteddata['pincode'];

      if ($name != '' && $house != '' && $street != '' && $locality != '' && $city != '' && $pincode != '' && $userId != '') {
        $register_array = array(
            'userId' => $userId,
            'name' => $name,
            'house' => $house,
            'street' => $street,
            'locality' => $locality,
            'city' => $city,
            'pincode' => $pincode,
        );
        $insId = $this->users_model->safe_insert('addresses', $register_array, false);
        //$data['userId'] = $insId;
        $data['success'] = true;
        $data['message'] = 'Address Added Successfully!';
      } else {
        $data['success'] = false;
        $data['message'] = 'Please Enter All Fields!';
      }
      echo json_encode($data);
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
      echo json_encode($data);
    }
  }

  public function view_address() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $userId = $posteddata['userId'];
    if (verifyToken($userId)) {

      if ($userId != '') {
        $res = $this->db->query("SELECT id, userId, name, house, street, locality, city, pincode FROM addresses WHERE status=1 AND userId=" . $userId . "")->result_array();
        $data['data'] = $res;
        $data['success'] = true;
        $data['message'] = 'Success!';
      } else {
        $data['success'] = false;
        $data['message'] = 'User id missing!';
      }
      echo json_encode($data);
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
      echo json_encode($data);
    }
  }

  public function deleteAddress() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $userId = $posteddata['userId'];
    if (verifyToken($userId)) {
      if ($posteddata['addressId'] != '') {
        $addressId = $posteddata['addressId'];
        $res = $this->db->query("SELECT * FROM addresses WHERE id=" . $addressId . "")->result_array();
        if (count($res) > 0) {
          $res = $this->db->query("UPDATE addresses SET status=0 WHERE id='" . $addressId . "'");
          $data['success'] = true;
          $data['message'] = 'Address deleted successfully!';
        } else {
          $data['success'] = false;
          $data['message'] = 'Address not found!';
        }
        echo json_encode($data);
      } else {
        $data['success'] = false;
        $data['message'] = 'Required parameters missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
      echo json_encode($data);
    }
  }

  public function updateAddress() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $userId = $posteddata['userId'];
    if (verifyToken($userId)) {
      if ($posteddata['addressId'] != '') {
        $addressId = $posteddata['addressId'];
        $name = '';
        $house = '';
        $street = '';
        $locality = '';
        $city = '';
        $pincode = '';


        $res = $this->db->query("SELECT * FROM addresses WHERE status='1' AND id=" . $addressId . "")->result_array();
        if (count($res) > 0) {
          $name = (empty($posteddata['name'])) ? $res[0]['name'] : $posteddata['name'];
          $house = ($posteddata['house'] != '') ? $posteddata['house'] : $res[0]['house'];
          $street = ($posteddata['street'] != '') ? $posteddata['street'] : $res[0]['street'];
          $locality = ($posteddata['locality'] != '') ? $posteddata['locality'] : $res[0]['locality'];
          $city = ($posteddata['city'] != '') ? $posteddata['city'] : $res[0]['city'];
          $pincode = ($posteddata['pincode'] != '') ? $posteddata['pincode'] : $res[0]['pincode'];
          $resUpdate = $this->db->query("UPDATE addresses SET name='$name', house='$house', street='$street', locality='$locality', city='$city', pincode='$pincode' WHERE id='" . $addressId . "'");
          $data['success'] = true;
          $data['message'] = 'Address updated successfully!';
        } else {
          $data['success'] = false;
          $data['message'] = 'Address not found!';
        }
        // echo json_encode($data);
      } else {
        $data['success'] = false;
        $data['message'] = 'Required parameters missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function saveSocialUser() {

    $resp = array('success' => false, 'message' => 'Err', 'data' => (object) []);

    try {

      if (is_post()) {

        $post = post_json_data();

        if (!empty(@$post['email']) && !empty(@$post['name'])) {

          $identificationObject = @$post['identificationObject'];
          if (is_array($identificationObject)) {
            $identificationObject['last_login'] = $this->config->item('config.date.time');
          }
          $user['user_name'] = $post['email'];

          $user['first_name'] = $post['name'];

          //check user exist or not

          $insId = 0;

          $new_user = get_db_single_row('wps_customers', '*', "`user_name`='" . escape_str($post['email']) . "'");

          if (!$new_user) {

            $insId = $this->users_model->safe_insert('wps_customers', $user);

            $new_user = get_db_single_row('wps_customers', '*', "`customers_id`='" . $insId . "'");
          } else {

            $insId = $new_user['customers_id'];
          }

          $resp['data'] = get_user_profile($insId, $identificationObject);
          ;

          $resp['success'] = true;

          $resp['message'] = '';
        } else {

          throw new Exception("Send All Required Field");
        }
      } else {

        throw new Exception("Method Not Allowed");
      }
    } catch (Exception $e) {

      $resp['message'] = $e->getMessage();

      $resp['success'] = false;
    }

    json_data($resp);
  }

  public function updateProfile() {
    $resp = array('success' => false, 'message' => 'Err', 'data' => (object) []);
    try {
      if (is_post()) {
        $post = post_json_data();
        //update user
        $user_id = (int) escape_str($post['userId']);
        $new_param = array(
            'about_user' => $post['aboutUser'],
            'user_location' => $post['city'],
            'user_lat' => $post['latitude'],
            'user_long' => $post['longitude'],
        );
        $posted_data = $new_param;
        unset($post['user_id']);

        $this->users_model->safe_update('wps_customers', $posted_data, "`customers_id`='$user_id'");

        //response

        $resp['success'] = true;

        $resp['message'] = '';

        $resp['data'] = get_user_profile($user_id);
      }
    } catch (Exception $e) {

      $resp['message'] = $e->getMessage();

      $resp['success'] = false;
    }

    json_data($resp);
  }

  public function updateSocialProfile() {

    $resp = array('success' => false, 'message' => 'Err');

    try {

      if (is_post()) {

        $post = post_json_data();

        //update user

        $user_id = (int) escape_str($post['userId']);

        $user['mobile_number'] = $post['mobile'];

        // $user['user_location'] = $post['user_location'];
        // $user['user_lat'] = $post['lat'];
        // $user['user_long'] = $post['long'];

        $user['login_type'] = $post['type'];

        $user['ip_address'] = $post['ip_address'];

        $exst_user = $this->db->query("select count(`customers_id`) as total_user from wps_customers where `is_verified` = '1' AND `mobile_number`='" . $user['mobile_number'] . "'")->row();
        // print_r($exst_user);

        if ($exst_user->total_user > 0) {

          throw new Exception("This number is linked with other account");
        }

        $this->users_model->safe_update('wps_customers', $user, "`customers_id`='$user_id'");

        //response

        $resp['success'] = true;

        $resp['message'] = '';
      } else {

        throw new Exception("Method Not Allowed");
      }
    } catch (Exception $e) {

      $resp['message'] = $e->getMessage();

      $resp['success'] = false;
    }

    json_data($resp);
  }

  public function posts() {

    verifyToken();

    $resp = array('success' => false, 'message' => '', 'data' => (object) []);

    $post_results = (object) [];

    if (is_post()) {

      $post = post_json_data();

      $offset = (int) escape_str(@$post['offset']) * 15;

      $user_id = (int) escape_str($post['user_id']);

      $posts = $this->db->select('P.*')
                      ->from('user_post P')
                      ->where(['user_id' => $user_id, 'status' => '1'])
                      ->limit(15)
                      ->offset($offset)
                      ->order_by('P.id desc')
                      ->get()->result_array();

      foreach ($posts as $k => $r) {

        $post_user_dtl = $this->users_model->detail($r['user_id']);

        if (!$post_user_dtl) {

          continue;
        }

        $post_medias = $this->db->select('*')
                        ->from('post_media')->where(['post_id' => $r['id']])
                        ->get()->result_array();

        $medias = (object) [];

        $ind = 0;

        foreach ($post_medias as $k => $m_r) {

          $medias[$ind]['link'] = base_url('uploaded-files/user_post/' . $m_r['path']);

          $medias[$ind]['type'] = $m_r['media_type'];

          $ind++;
        }

        $post_row = [
            'id' => $r['id'],
            'total_shares' => $r['total_shares'],
            'total_comment' => $r['total_comment'],
            'total_like' => $r['total_like'],
            'category' => $r['category'],
            'description' => $r['description'],
            'created' => $r['created'],
            'user' => [
                'id' => $post_user_dtl->customers_id,
                'email' => $post_user_dtl->user_name,
                'first_name' => $post_user_dtl->first_name,
                'last_name' => $post_user_dtl->last_name,
            ],
            'medias' => $medias,
        ];

        $user_like = $this->db->select(['type'])->from('post_likes')->where(['post_id' => $r['id'], 'user_id' => $user_id])->limit(1)->get()->first_row('array');

        if ($user_like && @$user_like['type'] == 'like') {

          $post_row['like_status'] = 'like';
        } else {

          $post_row['like_status'] = 'dislike';
        }



        array_push($post_results, $post_row);
      }

      $resp['data'] = $post_results;

      $resp['success'] = true;
    }

    json_data($resp);
  }

  public function addProfilePic() {

    $resp = array('success' => false, 'message' => '', 'data' => (object) []);

    verifyToken();

    try {

      if (is_post()) {

        $post = $this->input->post(); /* post_json_data();  dd($post);  */

        $user_id = $post['userId'];

        $user = get_db_single_row('wps_customers', '*', "`customers_id`='$user_id'");

        if (isset($_FILES['profile_picture']) && $_FILES['profile_picture']['size']) {

          $this->load->library('upload'); //load upload library

          $uploaded_data = @$this->upload->my_upload('profile_picture', 'user')['upload_data'];

          if (@$uploaded_data['file_name']) {

            $new_data['profile_picture'] = $uploaded_data['file_name'];

            // delete old file 

            if ($user['profile_picture']) {

              del_file('user/' . $user['profile_picture']);
            }



            $this->users_model->safe_update('wps_customers', $new_data, "`customers_id`='$user_id'");



            $resp['data'] = get_user_profile($user_id);

            $resp['success'] = true;
          } else {

            throw new Exception('File Not Uploaded');
          }
        } else {

          throw new Exception("Profile Picture Not Sent");
        }
      }
    } catch (Exception $e) {

      $resp['success'] = false;

      $resp['message'] = $e->getMessage();
    }

    json_data($resp);
  }

  public function logout() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // $userId = $posteddata['userId'];
    // if(verifyToken($posteddata['userId'])){ 
    if (isset($posteddata['userId']) && $posteddata['userId'] != '') {
      $userId = $posteddata['userId'];
      $uuid = $posteddata['uuid'];
      $this->users_model->logoutUser($userId, $uuid);
      $data['success'] = true;
      $data['message'] = 'User Successfully logged out!';
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    // }else{
    //   $data['success'] = false;
    //   $data['message'] = 'Invalid Token!';
    // } 
    echo json_encode($data);
  }

  public function forgetPassword() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (isset($posteddata['email']) && $posteddata['email'] != '') {
      $email = $posteddata['email'];
      $user = get_db_single_row('wps_customers', '*', "`user_name`='$email'");
      if ($user) {
        $first_name = $user['first_name'];
        $password = $this->safe_encrypt->decode($user['password']);
        $subject = 'Forgot Password Request';
        $body = "<b>Greeting from Noor By Sakshi<br>Dear $first_name,<br><br> Please note your login detail.<br><br>Username = $email<br>Password = $password<br><br>Thanks.</b>";
        $mail_conf = array(
            'subject' => $subject,
            'to_email' => $email,
            'from_email' => $this->config->item('site_email'),
            'from_name' => $this->config->item('site_name'),
            'body_part' => $body,
        );
        $this->dmailer->mail_notify($mail_conf);
        $data['success'] = true;
        $data['message'] = 'Password has been sent to the registered email';
      } else {
        $data['success'] = false;
        $data['message'] = 'User Not registered!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    echo json_encode($data);
  }

  public function getDevices() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $userId = $posteddata['userId'];
    if (verifyToken($posteddata['userId'])) {
      if (isset($posteddata['userId']) && $posteddata['userId'] != '') {
        $userId = $posteddata['userId'];
        $devices = $this->users_model->get_all_devices($userId);
        $devicesArray = [];
        if (count($devices) > 0) {
          foreach ($devices as $device) {
            $devicesArray[] = [
                "uuid" => $device['uuid'],
                "device" => $device['device'],
                "manufacturer" => $device['manufacturer'],
                "lastLogin" => $device['last_login']
            ];
          }
          $data['success'] = true;
          $data['data'] = $devicesArray;
          $data['message'] = 'Success';
        } else {
          $data['success'] = false;
          $data['message'] = 'No device found for this user!';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function logoutSingle() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if(verifyToken($posteddata['userId'])){  
    if (isset($posteddata['uuid']) && $posteddata['uuid'] != '' && isset($posteddata['userId']) && $posteddata['userId'] != '') {
      $uuid = $posteddata['uuid'];
      $userId = $posteddata['userId'];
      $status = $this->users_model->logout_from_single_device($uuid, $userId);
      if ($status) {
        $data['success'] = true;
        $data['message'] = 'Successfully logged out';
      } else {
        $data['success'] = false;
        $data['message'] = 'No device found for this user!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    //       }else{
    //     $data['success'] = false;
    //     $data['message'] = 'Invalid Token';
    // }
    echo json_encode($data);
  }

  public function logoutAll() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $userId = $posteddata['userId'];
    // if(verifyToken($posteddata['userId'])){  
    if (isset($posteddata['userId']) && $posteddata['userId'] != '') {
      $userId = $posteddata['userId'];
      $status = $this->users_model->logout_from_all_devices($userId);
      if ($status) {
        $data['success'] = true;
        $data['message'] = 'Successfully logged out from all devices';
      } else {
        $data['success'] = false;
        $data['message'] = 'No device found for this user!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    //       }else{
    //     $data['success'] = false;
    //     $data['message'] = 'Invalid Token';
    // }
    echo json_encode($data);
  }

}

/* End of file apis.php */

