<?php

class Cart extends Public_Controller {

  public function __construct() {
    parent::__construct();
    if (!isset($this->ci)) {
      $this->ci = &get_instance();
    }
    $this->load->model(array('web_apis/api_model', 'users/users_model', 'cart/cart_model', 'products/product_model'));
    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer'));
    $this->load->helper(array('web_apis/api', 'cart/cart', 'products/product'));
  }

  public function addToCart() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $userId = $posteddata['userId'];
    if (verifyToken($posteddata['userId'])) {
      // $data['data']=array();
      if ($posteddata['colorId'] != '' && $posteddata['userId'] != '' && $posteddata['quantity'] != '' && $posteddata['quantity'] != 0 && $posteddata['productId'] != '' && $posteddata['sizeType'] != '') {
        $productId = (int) $posteddata['productId'];
        $sizeType = $posteddata['sizeType'];
        $size = (int) $posteddata['size'];
        $customSize = $posteddata['customSize'];
        $userId = (int) $posteddata['userId'];
        $colorId = (int) $posteddata['colorId'];
        $qty = (int) ($posteddata['quantity']) ? $posteddata['quantity'] : 1;
        $customSize = json_encode($customSize);
        //To check if product is already in the cart or not
        $isProductAdded = isProductAdded($productId, $userId, $size, $colorId, $sizeType, $customSize);
        if ($isProductAdded) {
          $data['success'] = false;
          $data['message'] = 'Product Already added in the cart';
          echo json_encode($data);
          die;
        }
        //to check if the produt is available             
        $productAvailable = isProductAttributeAvailable($productId, $qty, $size, $colorId);
        if ($productAvailable != false || $sizeType == 'custom') {
          $productDetail = get_product_by_id($productId);
          if ($sizeType == 'custom') {
            $product = array(
                'productId' => $productId,
                'qty' => $qty,
                'price' => (int)$productDetail['originalPrice'],
                'name' => $productDetail['name'],
                'productDiscountedPrice' => (int)$productDetail['price'],
                'discountPrice' => (int)($productDetail['originalPrice'] - $productDetail['price']),
                'sizeId' => 0,
                'colorId' => $colorId,
                'sizeType' => $sizeType,
                'customSize' => $customSize,
                'userId' => $userId,
                'deliveryCharges' => 0,
                    // 'completeProductDetail' => $productDetail 
            );
          } else {
            $product = array(
                'productId' => $productId,
                'qty' => $qty,
                'price' => (int)$productAvailable[0]['product_price'],
                'name' => $productDetail['name'],
                'productDiscountedPrice' => (int)$productAvailable[0]['product_discounted_price'],
                'discountPrice' => (int)($productAvailable[0]['product_price'] - $productAvailable[0]['product_discounted_price']),
                'sizeId' => $size,
                'colorId' => $colorId,
                'sizeType' => $sizeType,
                'customSize' => $customSize,
                'userId' => $userId,
                'deliveryCharges' => 0,
                    // 'completeProductDetail' => $productDetail 
            );
          }
          // print_r($productDetail); die;
          $this->cart_model->add_to_cart($product);
          $cartItems = $this->cart_model->get_cart_items($userId);
          $cartCount = ($cartItems == '0') ? 0 : count($cartItems);
          $data['cartCount'] = $cartCount;
          // $data['data']=$product;
          $data['success'] = true;
          $data['message'] = 'Product Added to the cart';
        } else {
          $data['success'] = false;
          $data['message'] = 'Product Not Available';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function removeFromCart() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $userId = $posteddata['userId'];
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '' && $posteddata['cartItemId'] != '') {
        $userId = (int) $posteddata['userId'];
        $cartItemId = (int) $posteddata['cartItemId'];
        $status = $this->cart_model->remove_from_cart($userId, $cartItemId);
        if ($status == '0') {
          $data['success'] = false;
          $data['message'] = 'Product not in cart';
        } else {
          $cartItems = $this->cart_model->get_cart_items($userId);
          $cartCount = ($cartItems == '0') ? 0 : count($cartItems);
          $data['cartCount'] = $cartCount;
          $data['data'] = [];
          $data['success'] = true;
          $data['message'] = 'Product Removed from the cart';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function updateCart() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $originalPrice = 0;
    $totalDiscountedPrice = 0;
    $userId = $posteddata['userId'];
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '' && $posteddata['quantity'] >= 0 && $posteddata['productId'] >= 0 && $posteddata['cartItemId'] != '' && $posteddata['sizeId'] != '' && $posteddata['sizeType'] != '' && $posteddata['colorId'] != '') {
        $couponCode = $posteddata['coupon'];
        $cartItemId = (int) $posteddata['cartItemId'];
        $userId = (int) $posteddata['userId'];
        $sizeId = (int) $posteddata['sizeId'];
        $productId = (int) $posteddata['productId'];
        $sizeType = $posteddata['sizeType'];
        $customSize = json_encode($posteddata['customSize']);
        $colorId = (int) $posteddata['colorId'];
        $quantity = (int) ($posteddata['quantity']);
        $userId = $posteddata['userId'];
        $productAttribute = isProductAttributeAvailable($productId, $quantity, $sizeId, $colorId);
        // print_r($productAttribute);
        $productAvailable = isProductAvailable($productId, $quantity, $sizeId, $colorId);
        if ($quantity == 0) {
          $status = $this->cart_model->remove_from_cart($userId, $cartItemId);
          if ($status == '0') {
            $data['success'] = true;
            $data['data'] = [];
            $data['message'] = 'Product not in cart';
          } else {
            $cartItems = $this->cart_model->get_cart_items($userId);
            $cartCount = ($cartItems == '0') ? 0 : count($cartItems);
            $data['cartCount'] = $cartCount;
            $data['success'] = true;
            $data['data'] = [];
            $data['message'] = 'Product Removed from the cart';
            $cartItems = $this->cart_model->get_cart_items($userId);
            if ($cartCount > 0) {
              foreach ($cartItems as $item) {
                $color = color_name($item['color_id']);
                $sizeType = $item['size_type'];
                $completeProductDetail = get_product_by_id($item['product_id']);
                $productAttribute = isProductAttributeAvailable($item['product_id'], $qty = 0, $item['size_id'], $item['color_id']);
                if ($sizeType == 'custom') {
                  $originalPrice += $item['product_price'] * $item['quantity'];
                  $totalDiscountedPrice += $item['product_discounted_price'] * $item['quantity'];
                  $productDetail[] = [
                      "cartItemId" => $item['id'],
                      "productId" => $completeProductDetail['productId'],
                      "name" => $completeProductDetail['name'],
                      "subcatId" => $completeProductDetail['subcatId'],
                      "originalPrice" => (int)$item['product_price'],
                      'colorName' => $color,
                      "price" => (int)$item['product_discounted_price'],
                      'colorId' => $item['color_id'],
                      'sizeType' => $item['size_type'],
                      "image" => array_pop($completeProductDetail['image']),
                      "quantity" => $item['quantity'],
                      "customSize" => $item['custom_size'],
                      "size" => (object) [],
                          //"deliveryCharges" => 0
                  ];
                } else {
                  $size = size_name($item['size_id']);
                  $originalPrice += $item['product_price'] * $item['quantity'];
                  $totalDiscountedPrice += $item['product_discounted_price'] * $item['quantity'];
                  $productDetail[] = [
                      "productId" => $completeProductDetail['productId'],
                      "cartItemId" => $item['id'],
                      "name" => $completeProductDetail['name'],
                      "subcatId" => $completeProductDetail['subcatId'],
                      "originalPrice" => (int)$item['product_price'],
                      "price" => (int)$item['product_discounted_price'],
                      // "description" => $completeProductDetail['description'],
                      'colorId' => $item['color_id'],
                      'colorName' => $color,
                      "image" => array_pop($completeProductDetail['image']),
                      "customSize" => '',
                      'sizeType' => $item['size_type'],
                      "quantity" => $item['quantity'],
                      "size" => [
                          'size_name' => $size,
                          'size_id' => $item['size_id'],
                          'size_quantity' => $productAttribute[0]['quantity']
                      ],
                          //"deliveryCharges" => 0
                  ];
                }
              }
              $data['originalPrice'] = (int)$originalPrice;
              $data['totalDiscountedPrice'] = (int)$totalDiscountedPrice;
              $data['data'] = $productDetail;
              $data['totalDiscount'] = (int)($originalPrice - $totalDiscountedPrice);

              // $data['data']=[];
            }
          }
        } else {
          if ($productAttribute != false || $sizeType == 'custom') {
            $status = $this->cart_model->update_cart($productId, $userId, $sizeId, $quantity, $colorId, $sizeType, $customSize, $cartItemId);
            if ($status == '0') {
              $data['success'] = false;
              $data['data'] = [];
              $data['message'] = 'Product not in cart';
              echo json_encode($data);
              die;
            } else {
              $cartItems = $this->cart_model->get_cart_items($userId);
              $cartCount = ($cartItems == '0') ? 0 : count($cartItems);
              $data['cartCount'] = $cartCount;
              $data['success'] = true;
              $data['data'] = [];
              $data['message'] = 'Cart updated successfully';
            }

            $cartItems = $this->cart_model->get_cart_items($userId);
            if ($cartItems == '0') {
              $data['success'] = true;
              $data['data'] = [];
              $data['message'] = 'Cart Empty';
            } else {
              foreach ($cartItems as $item) {
                $sizeType = $item['size_type'];
                $color = color_name($item['color_id']);
                $completeProductDetail = get_product_by_id($item['product_id']);
                $productAttribute = isProductAttributeAvailable($item['product_id'], $qty = 0, $item['size_id'], $item['color_id']);
                if ($sizeType == 'custom') {
                  $originalPrice += $item['product_price'] * $item['quantity'];
                  $totalDiscountedPrice += $item['product_discounted_price'] * $item['quantity'];
                  $productDetail[] = [
                      "productId" => $completeProductDetail['productId'],
                      "name" => $completeProductDetail['name'],
                      "cartItemId" => $item['id'],
                      "subcatId" => $completeProductDetail['subcatId'],
                      'sizeType' => $item['size_type'],
                      "originalPrice" => (int)$item['product_price'],
                      "price" => (int)$item['product_discounted_price'],
                      'colorId' => $item['color_id'],
                      'colorName' => $color,
                      "image" => array_pop($completeProductDetail['image']),
                      "quantity" => $item['quantity'],
                      "customSize" => $item['custom_size'],
                      "size" => (object) [],
                          //"deliveryCharges" => 0
                  ];
                } else {
                  $size = size_name($item['size_id']);
                  $originalPrice += $item['product_price'] * $item['quantity'];
                  $totalDiscountedPrice += $item['product_discounted_price'] * $item['quantity'];
                  $productDetail[] = [
                      "productId" => $completeProductDetail['productId'],
                      "name" => $completeProductDetail['name'],
                      "cartItemId" => $item['id'],
                      "subcatId" => $completeProductDetail['subcatId'],
                      'sizeType' => $item['size_type'],
                      'colorName' => $color,
                      "originalPrice" => (int)$item['product_price'],
                      "customSize" => '',
                      "price" => (int)$item['product_discounted_price'],
                      // "description" => $completeProductDetail['description'],
                      'colorId' => $item['color_id'],
                      "image" => array_pop($completeProductDetail['image']),
                      "quantity" => $item['quantity'],
                      "size" => [
                          'size_name' => $size,
                          'size_id' => $item['size_id'],
                          'size_quantity' => $productAttribute[0]['quantity']
                      ],
                          //"deliveryCharges" => 0
                  ];
                }
              }
              $data['originalPrice'] = (int)$originalPrice;
              $data['totalDiscountedPrice'] = (int)$totalDiscountedPrice;
              $data['totalDiscount'] = (int)($originalPrice - $totalDiscountedPrice);
              $data['data'] = $productDetail;
              $data['deliveryCharges'] = 0;
              $couponArr = $this->applycoupon($couponCode, $userId);
              $data['couponRes'] = $couponArr;
            }
          } else {
            $data['data'] = [];
            $data['success'] = true;
            $data['message'] = 'Product Not Available';
          }
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function listItem() {
    $originalPrice = 0;
    $totalDiscountedPrice = 0;
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $userId = $posteddata['userId'];
        $couponCode = $posteddata['coupon'];
        $cartItems = $this->cart_model->get_cart_items($userId);
        if ($cartItems == '0') {
          $data['success'] = false;
          $data['message'] = 'Cart Empty';
        } else {
          foreach ($cartItems as $item) {
            $sizeType = $item['size_type'];
            $color = color_name($item['color_id']);
            $completeProductDetail = get_product_by_id($item['product_id']);
            $productAttribute = isProductAttributeAvailable($item['product_id'], $qty = 0, $item['size_id'], $item['color_id']);
            if ($sizeType == 'custom') {
              $originalPrice += $item['product_price'] * $item['quantity'];
              $totalDiscountedPrice += $item['product_discounted_price'] * $item['quantity'];
              $productDetail[] = [
                  "productId" => $completeProductDetail['productId'],
                  "cartItemId" => $item['id'],
                  "name" => $completeProductDetail['name'],
                  "subcatId" => $completeProductDetail['subcatId'],
                  "originalPrice" => (int)$item['product_price'],
                  'sizeType' => $item['size_type'],
                  "price" => $item['product_discounted_price'],
                  'colorId' => $item['color_id'],
                  'colorName' => $color,
                  "image" => array_pop($completeProductDetail['image']),
                  "quantity" => $item['quantity'],
                  "customSize" => json_decode($item['custom_size']),
                  "size" => (object) [],
                      //"deliveryCharges" => $item['delivery_charges']
              ];
            } else {
              $size = size_name($item['size_id']);
              $originalPrice += $item['product_price'] * $item['quantity'];
              $totalDiscountedPrice += $item['product_discounted_price'] * $item['quantity'];
              $productDetail[] = [
                  "productId" => $completeProductDetail['productId'],
                  "name" => $completeProductDetail['name'],
                  "cartItemId" => $item['id'],
                  'sizeType' => $item['size_type'],
                  "subcatId" => $completeProductDetail['subcatId'],
                  "originalPrice" => (int)$item['product_price'],
                  "price" => (int)$item['product_discounted_price'],
                  // "description" => $completeProductDetail['description'],
                  'colorId' => $item['color_id'],
                  'colorName' => $color,
                  "image" => array_pop($completeProductDetail['image']),
                  "quantity" => $item['quantity'],
                  "size" => [
                      'size_name' => $size,
                      'size_id' => $item['size_id'],
                      'size_quantity' => $productAttribute[0]['quantity']
                  ],
                      //"deliveryCharges" => $item['delivery_charges']
              ];
            }
          }
          $cartItems = $this->cart_model->get_cart_items($userId);
          $cartCount = ($cartItems == '0') ? 0 : count($cartItems);
          $couponArr = $this->applycoupon($couponCode, $userId);
          $data['cartCount'] = $cartCount;
          $data['couponRes'] = $couponArr;
          $data['originalPrice'] = (int)$originalPrice;
          $data['totalDiscountedPrice'] = (int)$totalDiscountedPrice;
          $data['totalDiscount'] = (int)($originalPrice - $totalDiscountedPrice);
          $data["deliveryCharges"] = 0;
          $data['data'] = $productDetail;

          $data['success'] = true;
          $data['message'] = 'Success';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function emptyCart() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $userId = (int) $posteddata['userId'];
        $status = $this->cart_model->empty_cart($userId);
        $cartItems = $this->cart_model->get_cart_items($userId);
        $cartCount = ($cartItems == '0') ? 0 : count($cartItems);
        $data['cartCount'] = $cartCount;
        $data['data'] = [];
        $data['success'] = true;
        $data['message'] = 'Cart has been emptied';
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }

    echo json_encode($data);
  }

  public function getCartCount() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $userId = $posteddata['userId'];
        $cartItems = $this->cart_model->get_cart_items($userId);
        $cartCount = ($cartItems == '0') ? 0 : count($cartItems);
        $data['cartCount'] = $cartCount;
        $data['success'] = true;
        $data['message'] = 'Success';
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function applycoupon($coupon_code, $userId) {
    //$coupon_code = $this->input->get_post('couponcode');
    //$amt = $this->input->get_post('amt');
    //AND minimum_amount_for_coupan_apply <= '" . $amt . "'
    $cdets = get_db_single_row('wps_discount_coupans', "cpn_id, cpn_type, cpn_code, cpn_rate, cpn_start_date, cpn_end_date", "cpn_start_date <= '" . date('Y-m-d') . "' AND cpn_end_date >= '" . date('Y-m-d') . "' AND cpn_code = '" . $coupon_code . "'");
    //echo_sql();
    $couponArray = array();
    if (is_array($cdets) && !empty($cdets)) {
      if ($cdets['cpn_type'] == '0') {
        $discount = "";
        $discount = $cdets['cpn_rate'];
        $couponArray['success'] = true;
        $couponArray['couponId'] = $cdets['cpn_id'];
        $couponArray['couponCode'] = $coupon_code;
        $couponArray['couponAmount'] = (int)$discount;
      } else {
        //check content of cart 
        $discountAmt = 0;
        $cartItems = $this->cart_model->get_cart_items($userId);
        foreach ($cartItems as $items) {
          $pprice = ($items['product_discounted_price'] > 0) ? $items['product_discounted_price'] : $items['product_price'];
          $discount = (($pprice * $items['quantity']) * $cdets['cpn_rate'] / 100);
          $discountAmt += $discount;
        }
        $couponArray['success'] = true;
        $couponArray['couponId'] = $cdets['cpn_id'];
        $couponArray['couponCode'] = $coupon_code;
        $couponArray['couponAmount'] = (int)$discountAmt;
      }
    } else {
      $couponArray['success'] = false;
      $couponArray['couponId'] = '';
      $couponArray['couponCode'] = $coupon_code;
      $couponArray['couponAmount'] = '';
    }
    return $couponArray;
  }

  public function reApplycoupon($couponcode, $userId) {

    $cdets = get_db_single_row('wps_discount_coupans', "cpn_id, cpn_type, cpn_code, cpn_rate, cpn_start_date, cpn_end_date", "cpn_start_date <= '" . date('Y-m-d') . "' AND cpn_end_date >= '" . date('Y-m-d') . "' AND cpn_code = '" . $couponcode . "'");
    //echo_sql();
    $couponArray = array();
    if (is_array($cdets) && !empty($cdets)) {
      if ($cdets['cpn_type'] == '0') {
        $discount = "";
        $discount = $cdets['cpn_rate'];
        $couponArray['success'] = true;
        $couponArray['couponId'] = $cdets['cpn_id'];
        $couponArray['couponCode'] = $coupon_code;
        $couponArray['couponAmount'] = (int)$discount;
      } else {
        //check content of cart
        $discountAmt = 0;
        $cartItems = $this->cart_model->get_cart_items($userId);
        foreach ($cartItems as $items) {
          $pprice = ($items['product_discounted_price'] > 0) ? $items['product_discounted_price'] : $items['product_price'];
          $discount = (($pprice * $items['quantity']) * $cdets['cpn_rate'] / 100);
          $discountAmt += $discount;
        }
        $this->session->set_userdata('coupon_id', $couponcode);
        $this->session->set_userdata('discount_amount', round($discountAmt));
      }
      $couponArray['success'] = true;
      $couponArray['couponId'] = $cdets['cpn_id'];
      $couponArray['couponCode'] = $coupon_code;
      $couponArray['couponAmount'] = (int)$discountAmt;
    } else {
      $couponArray['success'] = false;
      $couponArray['couponId'] = '';
      $couponArray['couponCode'] = '';
      $couponArray['couponAmount'] = '';
    }
    return $couponArray;
  }

}
