<?php

class Special_offers extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('comments/comments_model', 'products/product_model'));
    $this->load->helper(array('products/product'));
    $this->config->set_item('menu_highlight', 'product management');
  }

  public function index($page = NULL) {
    if ($this->input->post('status_action') != '') {

      $this->update_status('wps_product_discount_special_offer', 'discount_id');
    }



    $keyword = trim($this->input->get_post('keyword2', TRUE));
    $keyword = $this->db->escape_str($keyword);

    $pagesize = (int) $this->input->get_post('pagesize');

    $ref_id = (int) $this->input->get_post('ref_id');

    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');

    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;

    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $condition = " AND c.status!='2' ";

    if ($ref_id > 0) {
      $condition .= " AND product_id ='" . $ref_id . "' ";
    }

    $status = $this->input->get_post('status');

    if ($status != '') {
      //$condition .= " AND .status = '" . $status . "'";
    }

    $qry_options = array(
        'limit' => $config['limit'],
        'offset' => $offset,
        'condition' => $condition,
        'exjoin' => " INNER JOIN wps_products as c ON c.products_id=a.product_id",
        'exselect' => " ,c.product_name"
    );


    //$res_array = $this->comments_model->get_comments($qry_options);
    $res_array = $this->db->query("select * from wps_product_discount_special_offer where discount_id = '" . $ref_id . "' ")->result_array();


    $config['total_rows'] = get_found_rows();

    $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['res'] = $res_array;
    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found ";
    $data['heading_title'] = "View Special Offer";
    $this->load->view('catalog/view_special_offer_list', $data);
  }

  /* Add Product Comments */

  public function add() {
    $Id = (int) $this->uri->segment(4);
    $condition = array(
        'fields' => "wlp.product_name,wlp.products_id",
        'where' => "wlp.products_id ='" . $Id . "'"
    );
    $pres = $this->product_model->get_products($condition);


    if (is_array($pres) && !empty($pres)) {
      $pres = $pres[0];

      $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");

      $this->form_validation->set_rules('discount_text', 'Discount Text', 'trim|required');
      $this->form_validation->set_rules('regular_price', 'Regular Price', 'trim|required|valid_amount');
      $this->form_validation->set_rules('discounted_price', 'Discounted Price', 'trim|required|valid_amount');
       $this->form_validation->set_rules('discount_percentage', 'Discount Percentage', 'trim|required|numeric');
      $this->form_validation->set_rules('no_of_products', 'No Of Products', 'trim|required|numeric');
      //$this->form_validation->set_rules('special_image', 'Special Image', "required|file_allowed_type[image]");

      if ($this->form_validation->run() == TRUE) {
      //    $uploaded_file = "";
      // if (!empty($_FILES) && $_FILES['special_image']['name'] != '') {
      //   $config['max_size'] = '2048';
      //   $this->load->library('upload');
      //   $uploaded_data = $this->upload->my_upload('special_image', 'products', round(microtime(true)));
      //   if (is_array($uploaded_data) && !empty($uploaded_data)) {
      //     $uploaded_file = $uploaded_data['upload_data']['file_name'];
      //   }
      // }
       
        $posted_data = array(
            'discount_id' => $Id,
            'discount_text' => $this->input->post('discount_text'),
            'regular_price' => $this->input->post('regular_price'),
            'discounted_price' => $this->input->post('discounted_price'),
            'discount_percentage' => $this->input->post('discount_percentage'),
            'no_of_products' => $this->input->post('no_of_products'),
            //'special_image' => $uploaded_file,
            'status' => '1'
        );
        // trace($posted_data);
        // exit();
        $this->comments_model->safe_insert('wps_product_discount_special_offer', $posted_data, FALSE);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('success'));
        redirect('sitepanel/special_offers?ref_id=' . $Id, '');
      }

      $data['pres'] = $pres;
      $data['heading_title'] = "Add Special Offer";
      $this->load->view('catalog/view_post_special_offer', $data);
    } else {
      $this->session->set_userdata(array('msg_type' => 'error'));
      $this->session->set_flashdata('success', 'Product not exists');
      redirect('sitepanel/special_offers/', '');
    }
  }

  /* Edit School Feedback */

  public function edit() {

    $id = (int) $this->uri->segment(4);

    $qry_options = array(
        'limit' => 1,
        'offset' => 0,
        'condition' => " AND discount_id ='$id'"
    );

    $res = $this->db->query("select * from wps_product_discount_special_offer where special_id = '" . $id . "' ")->result_array();
//print_r($res);

    if (is_array($res) && !empty($res)) {

      $res = $res[0];
       

     

       $this->form_validation->set_rules('discount_text', 'Discount Text', 'trim|required');
      $this->form_validation->set_rules('regular_price', 'Regular Price', 'trim|required|valid_amount');
      $this->form_validation->set_rules('discounted_price', 'Discounted Price', 'trim|required|valid_amount');
       $this->form_validation->set_rules('discount_percentage', 'Discount Percentage', 'trim|required|numeric');
      $this->form_validation->set_rules('no_of_products', 'No Of Products', 'trim|required|numeric');
      //$this->form_validation->set_rules('special_image', 'Special Image', "file_allowed_type[image]");

      if ($this->form_validation->run() == TRUE) {
        //  $uploaded_file = $res['special_image'];
        // $unlink_image = array('source_dir' => "products", 'source_file' => $res['special_image']);
        // if (!empty($_FILES) && $_FILES['special_image']['name'] != '') {
        //   $this->load->library('upload');
        //   $uploaded_data = $this->upload->my_upload('special_image', 'products', round(microtime(true)));
        //   if (is_array($uploaded_data) && !empty($uploaded_data)) {
        //     $uploaded_file = $uploaded_data['upload_data']['file_name'];
        //     removeImage($unlink_image);
        //   }
        // }

       $posted_data = array(
            //'discount_id' => $id,
            'discount_text' => $this->input->post('discount_text'),
            'regular_price' => $this->input->post('regular_price'),
            'discounted_price' => $this->input->post('discounted_price'),
            'discount_percentage' => $this->input->post('discount_percentage'),
            'no_of_products' => $this->input->post('no_of_products'),
            //'special_image' => $uploaded_file,
            'status' => '1'
        );
      

        $where = "special_id = '" . $id . "'";

        $this->comments_model->safe_update('wps_product_discount_special_offer', $posted_data, $where, FALSE);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect('sitepanel/special_offers?ref_id=' . $res['discount_id'], '');
      }

      $data['res'] = $res;
      
      $data['heading_title'] = "Edit Special Offer";
      $this->load->view('catalog/view_edit_special_offer', $data);
    } else {
      $this->session->set_userdata(array('msg_type' => 'error'));
      $this->session->set_flashdata('success', 'Special Offer not exists');
      redirect('sitepanel/special_offers' . query_string(), '');
    }
  }

}

// End of controller