<?php

class Products extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('products/product_model', 'color/color_model', 'size/size_model'));
    $this->load->helper('category/category');
    $this->config->set_item('menu_highlight', 'product management');
  }

  public function index($page = NULL) {
    $this->load->helper(array('products/product'));
    $condtion = array();
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $category_id = (int) $this->uri->segment(4, 0);
    $status = $this->input->get_post('status', TRUE);

     if ($this->input->post('update_order') != '') {
      $this->update_displayOrder('wps_products', 'sort_order', 'products_id');
    }
    
    $cat_name = '';
    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_name = 'in ';
      $cat_name .= get_db_field_value('wps_categories', 'category_name', "WHERE category_id='$category_id'");
    }
    if ($status != '') {
      $condtion['status'] = $status;
    }
    $condtion['orderby'] = 'wlp.products_id desc';
    $condtion['keyword'] = $this->input->post('keyword');
    $res_array = $this->product_model->get_products($config['limit'], $offset, $condtion);

    $config['total_rows'] = get_found_rows();
    $data['heading_title'] = 'Product Lists';
    $data['res'] = $res_array;
    $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    if ($this->input->post('status_action') != '') {
      if ($this->input->post('status_action') == 'Delete') {
        $prod_id = $this->input->post('arr_ids');
        foreach ($prod_id as $v) {
          $where = array('entity_type' => 'products/detail', 'entity_id' => $v);
          $this->product_model->safe_delete('wps_meta_tags', $where, TRUE);
        }
      }
      $this->session->set_flashdata('success', lang('deleted'));
      $this->update_status('wps_products', 'products_id');
    }
    /* Product set as a */
    if ($this->input->post('set_as') != '') {
      $set_as = $this->input->post('set_as', TRUE);
      $this->set_as('wps_products', 'products_id', array($set_as => '1'));
    }
    if ($this->input->post('unset_as') != '') {
      $unset_as = $this->input->post('unset_as', TRUE);
      $this->set_as('wps_products', 'products_id', array($unset_as => '0'));
    }
    /* End product set as a */

    /* upload Bulk Excel */
    if ($this->input->post('action') == 'submit_excel') {
      $this->form_validation->set_rules('excel_file', 'Upload Excel File', 'required|callback_check_upload_excel');
      if ($this->form_validation->run() == TRUE) {
        require_once FCPATH . 'apps/third_party/Excel/reader.php';
        $data = new Spreadsheet_Excel_Reader();
        $data->setOutputEncoding('CP1251');

        //$data->setUTFEncoder('');
        chmod($_FILES["excel_file"]["tmp_name"], 0777);
        $data->read($_FILES["excel_file"]["tmp_name"]);
        $worksheet = $data->sheets[0]['cells'];

        $process_add = $this->product_model->add_bulk_upload_product($worksheet);
        //echo "sss";
        if ($process_add === TRUE) {
          $this->session->set_userdata(array('msg_type' => 'success'));
          $this->session->set_flashdata('success', 'Excel file inserted successfully!!!');
          redirect('sitepanel/products', '');
        } else {
          $this->form_validation->_error_array['image'] = 'Uploading Failed. Please Try Again';
        }
      }
    }

    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found " . strtolower($cat_name) . " ";

    //Call of View
    $this->load->view('catalog/view_product_list', $data);
  }

  public function add() {
    $data['heading_title'] = 'Add Product';
    $categoryposted = $this->input->post('catid');
    $data['categoryposted'] = $categoryposted;
    $categoryposted = $this->input->post('catid');
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description')); //'type' => 'basic'
    $data['ckeditor2'] = set_ck_config(array('textarea_id' => 'disclaimer'));
    $data['ckeditor3'] = set_ck_config(array('textarea_id' => 'terms_of_sale'));
    $data['unit_measurement'] = $this->config->item('unit_measurement');

    $img_allow_size = $this->config->item('allow.file.size');
    $img_allow_dim = $this->config->item('allow.imgage.dimension');

    $seo_url_length = $this->config->item('seo_url_length');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");

    $this->form_validation->set_rules('product_name', 'Product Name', 'required');
    
    $this->form_validation->set_rules('product_code', 'Product Code', "trim|required|max_length[65]|unique[wps_products.product_code='" . $this->db->escape_str($this->input->post('product_code')) . "' AND status!='2']");
    $this->form_validation->set_rules('product_price', 'Price', 'trim|required|valid_amount');
    $this->form_validation->set_rules('discounted_price', 'Discounted Price', 'trim|valid_amount');
    $this->form_validation->set_rules('description', 'Product Description', 'trim|required');
    $this->form_validation->set_rules('category_id[]', 'Product Category', 'trim|required');
    $this->form_validation->set_rules('size', 'Size', "trim|required");
    $this->form_validation->set_rules('product_qty', 'Quantity', "trim|required|numeric");
    $this->form_validation->set_rules('browsed_image', 'Browsed Image', "trim|required");


    if ($this->form_validation->run() === TRUE) {
    
      //cat links
      $postCategory = $this->input->post('category_id');
      $category_links = "";
      $catlink = $ctl = "";
      foreach ($postCategory as $ctv) {
        $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
        $ctl = array_keys($catlink);
        $category_links .= implode(",", $ctl) . ',';
      }
      $category_links = substr($category_links, 0, -1);

    

      $posted_data = array(
          'customers_id' => '0',
          'category_id' => implode(',', $this->input->post('category_id')),
          'category_links' => $category_links,
          'friendly_url' => $this->cbk_friendly_url,
          'product_name' => $this->input->post('product_name', TRUE),
          'product_code' => $this->input->post('product_code', TRUE),
          'product_price' => $this->input->post('product_price', TRUE),
          'product_discounted_price' => $this->input->post('discounted_price', TRUE),
          'product_qty' => $this->input->post('product_qty', TRUE),
          'color_ids' => '',
          'size_ids' => '',
          
          'size' => $this->input->post('size', TRUE),
          'disclaimer' => $this->input->post('disclaimer', TRUE),
          'terms_of_sale' => $this->input->post('terms_of_sale', TRUE),
          'product_alt' => $this->input->post('product_name'),
          'products_description' => $this->input->post('description'),
          'youtube_id' => '',
          'product_added_date' => $this->config->item('config.date.time')
      );
      //trace($posted_data); exit;
      $productId = $this->product_model->safe_insert('wps_products', $posted_data, FALSE);
       $this->add_select_product_media($productId);
      if ($productId > 0) {
        $this->cbk_friendly_url = seo_url_title($this->input->post('product_name')).$productId;

        //update friendly_url
        $this->db->query("UPDATE wps_products SET friendly_url = '" . $this->cbk_friendly_url . "' WHERE products_id = '" . $productId . "'");

        //Create Meta
        $redirect_url = "products/detail";
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $productId,
            'page_url' => $this->cbk_friendly_url,
            'meta_title' => get_text($this->input->post('product_name'), 80),
            'meta_description' => get_text($this->input->post('description')),
            'meta_keyword' => get_keywords($this->input->post('description'))
        );
        create_meta($meta_array);
      }
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('sitepanel/products/index/' . $this->input->post('category_id'), '');
    }
   
    $this->load->view('catalog/view_product_add', $data);
  }

  public function edit($productId) {
    $data['heading_title'] = 'Edit Product';
    $productId = (int) $this->uri->segment(4);
    $option = array('productid' => $productId);
    $res = $this->product_model->get_products(1, 0, $option);
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description'));
    $data['ckeditor2'] = set_ck_config(array('textarea_id' => 'disclaimer'));
    $data['ckeditor3'] = set_ck_config(array('textarea_id' => 'terms_of_sale'));
    $data['unit_measurement'] = $this->config->item('unit_measurement');
    //image validation
    $img_allow_size = $this->config->item('allow.file.size');
    $img_allow_dim = $this->config->item('allow.imgage.dimension');

    $this->cbk_friendly_url = seo_url_title($this->input->post('product_name')).$productId;

    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $media = array();

    if (is_array($res) && !empty($res)) {
      $res = $res[0];
      $media = $this->product_model->get_product_media(4, 0, array('productid' => $res['products_id']));

      $this->form_validation->set_rules('product_name', 'Product Name', 'required');
      $this->form_validation->set_rules('product_code', 'Product Code', "trim|required|max_length[65]|unique[wps_products.product_code='" . $this->db->escape_str($this->input->post('product_code')) . "' AND status!='2' AND products_id != '" . $res['products_id'] . "']");
     
      $this->form_validation->set_rules('product_price', 'Price', 'trim|required|valid_amount');
      $this->form_validation->set_rules('discounted_price', 'Discounted Price', 'trim|valid_amount');
      $this->form_validation->set_rules('description', 'Product Description', 'trim|required');
      $this->form_validation->set_rules('category_id[]', 'Product Category', 'trim|required');
      $this->form_validation->set_rules('size[]', 'Size', "trim|required");
       $this->form_validation->set_rules('remarks[]', 'Remarks', "trim");
      $this->form_validation->set_rules('product_qty', 'Quantity', "trim|required|numeric");
      $this->form_validation->set_rules('browsed_image', 'Browsed Image', "trim");

      if ($this->form_validation->run() == TRUE) {

        //cat links
        $postCategory = $this->input->post('category_id');
        $category_links = "";
        $catlink = $ctl = "";
        foreach ($postCategory as $ctv) {
          $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
          $ctl = array_keys($catlink);
          $category_links .= implode(",", $ctl) . ',';
        }
        $category_links = substr($category_links, 0, -1);

      

        $posted_data = array(
            'category_id' => implode(',', $this->input->post('category_id')),
            'category_links' => $category_links,
            'friendly_url' => $this->cbk_friendly_url,
            'product_name' => $this->input->post('product_name', TRUE),
            'product_code' => $this->input->post('product_code', TRUE),
            'product_price' => $this->input->post('product_price', TRUE),
            'product_discounted_price' => $this->input->post('discounted_price', TRUE),
            'product_qty' => $this->input->post('product_qty', TRUE),
            'color_ids' => '',
            'size_ids' => '',
            
            'size' => $this->input->post('size', TRUE),
            'disclaimer' => $this->input->post('disclaimer', TRUE),
            'terms_of_sale' => $this->input->post('terms_of_sale', TRUE),
            'product_alt' => $this->input->post('product_name'),
            'products_description' => $this->input->post('description'),
            'youtube_id' => '',
            'product_updated_date' => $this->config->item('config.date.time')
        );
        //trace($posted_data); exit;
        $where = "products_id = '" . $res['products_id'] . "'";
        $this->product_model->safe_update('wps_products', $posted_data, $where, FALSE);
        $this->add_select_product_media($res['products_id']);
        update_meta_page_url('products/detail', $res['products_id'], $this->cbk_friendly_url);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));
        if ($this->input->post('category_id') > 0) {
          redirect('sitepanel/products/index/' . $this->input->post('category_id'), '');
        } else {
          redirect('sitepanel/products/' . query_string(), '');
        }
      }

      $data['res'] = $res;
      $media_option = array('productid' => $res['products_id']);
      $res_photo_media = $this->product_model->get_product_media(5, 0, $media_option);
      $data['res_photo_media'] = $res_photo_media;
      $this->load->view('catalog/view_product_edit', $data);
    } else {
      redirect('sitepanel/products', '');
    }
  }

   public function add_select_product_media($productId) {
    if (( $productId > 0)) {
      $defalut_image = 'Y';

      $browsed_image = $this->input->post('browsed_image');
      //trace($browsed_image); die;
      if ($browsed_image != '') {
        $this->db->query("DELETE FROM wps_products_media WHERE products_id = '" . $productId . "'");
        $browsed_arr = explode(",", $browsed_image);
        foreach ($browsed_arr as $val) {
          $src_path = UPLOAD_DIR . '/product_images/' . $val;
          $dest_path = UPLOAD_DIR . '/products/' . $val;
          if ($val != '' && @copy($src_path, $dest_path)) {
          $add_data = array(
              'products_id' => $productId,
              'media_type' => 'photo',
              'is_default' => $defalut_image,
              'media' => $val,
              'media_date_added' => $this->config->item('config.date.time')
          );
          //trace();
          $this->product_model->safe_insert('wps_products_media', $add_data, FALSE);
          $defalut_image = "N";
          }
        }
      }
    }
  }

  public function details() {
    $id = (int) $this->uri->segment(4);
    $condition = array(
        'fields' => "SQL_CALC_FOUND_ROWS wlp.*,wlc.first_name,wlc.company_name,wlcat.category_links",
        'offset' => 0,
        'limit' => 1,
        'where' => "wlp.products_id ='" . $id . "'"
    );
    $res_array = $this->product_model->get_products($condition);
    $data['heading_title'] = 'View Details';
    $data['page_title'] = 'View Details';
    $data['res'] = $res_array;
    $this->load->view('catalog/view_product_details', $data);
  }

  public function check_price() {
    $disc_price = $this->input->post('product_discounted_price');
    $price = $this->input->post('product_price');
    if ($disc_price != '' && $price != '') {
      $disc_price = floatval($disc_price);
      $price = floatval($price);
      if ($disc_price >= $price && $disc_price > 0 && $price > 0) {
        $this->form_validation->set_message('check_price', 'Discount price must be less than actual price.');
        return FALSE;
      } else {
        return TRUE;
      }
    } else {
      return TRUE;
    }
  }

  public function delete_media() {
    $id = (int) $this->input->post('id');

    if ($id > 0) {
      $res = $this->db->select('media,id')->get_where('wps_products_media', array('id' => $id))->row();
      if (is_object($res)) {
        $unlink_image = array('source_dir' => "products", 'source_file' => $res->media);
        removeImage($unlink_image);
        $this->db->query("DELETE FROM wps_products_media WHERE id='" . $res->id . "'");
        echo 'success';
      }
    }
  }

  public function get_html_category_ids() {
    $data['heading_title'] = 'Excel Category List Ids';

    set_time_limit(0);
    $file_path = $this->load->view('catalog/excel_category_ids', $data);
    ob_start();
    include_once($this->load->view('catalog/excel_category_ids', $data));

    $mess = ob_get_contents();
    $filename = "category.htm";
    ob_end_clean();

    header("Pragma: public");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("Cache-Control: public");
    header("Content-Description: File Transfer");

    //Use the switch-generated Content-Type
    header("Content-Type: application/force-download");

    //Force the download
    $header = "Content-Disposition: attachment; filename=" . $filename . ";";
    header($header);
    header("Content-Transfer-Encoding: binary");
    echo $mess;
    exit;
  }

  public function check_upload_excel() {
    $filearrext = array('xls');
    if ($_FILES['excel_file']['name'] == '') {
      $this->form_validation->set_message('check_upload_excel', 'Please upload excel file.');
      return FALSE;
    }
    if ($_FILES['excel_file']['name'] != '') {
      $extension = substr(strrchr($_FILES['excel_file']['name'], '.'), 1);
      if (!in_array($extension, $filearrext)) {
        $this->form_validation->set_message('check_upload_excel', 'Please upload (xls) file only.');
        return FALSE;
      } else {
        return TRUE;
      }
    }
  }

  public function view_discounts() {
    $productId = (int) $this->uri->segment(4);
    $option = array('productid' => $productId);
    $res = $this->product_model->get_products(1, 0, $option);
    if (is_array($res)) {
        $res = $res[0];
        if ($this->input->post('sub') != '') {
           
            if($this->input->post('discount_text1') != ''){
               $this->form_validation->set_rules('regular_price1', 'Regular Price 1', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('discounted_price1', 'Discounted Price 1', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('no_of_products1', 'No Of Products 1', 'trim|required|numeric');
            }
            if($this->input->post('discount_text2') != ''){
               $this->form_validation->set_rules('regular_price2', 'Regular Price 2', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('discounted_price2', 'Discounted Price 2', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('no_of_products2', 'No Of Products 2', 'trim|required|numeric');
            }
            if($this->input->post('discount_text3') != ''){
               $this->form_validation->set_rules('regular_price3', 'Regular Price 3', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('discounted_price3', 'Discounted Price 3', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('no_of_products3', 'No Of Products 3', 'trim|required|numeric');
            }
            if($this->input->post('discount_text4') != ''){
               $this->form_validation->set_rules('regular_price4', 'Regular Price 4', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('discounted_price4', 'Discounted Price 4', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('no_of_products4', 'No Of Products 4', 'trim|required|numeric');
            }
            if($this->input->post('discount_text5') != ''){
               $this->form_validation->set_rules('regular_price5', 'Regular Price 5', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('discounted_price5', 'Discounted Price 5', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('no_of_products5', 'No Of Products 5', 'trim|required|numeric');
            }
            if($this->input->post('discount_text6') != ''){
               $this->form_validation->set_rules('regular_price6', 'Regular Price 6', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('discounted_price6', 'Discounted Price 6', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('no_of_products6', 'No Of Products 6', 'trim|required|numeric');
            }
             if($this->input->post('discount_text7') != ''){
               $this->form_validation->set_rules('regular_price7', 'Regular Price 7', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('discounted_price7', 'Discounted Price 7', 'trim|required|valid_amount|greater_than[0]');
               $this->form_validation->set_rules('no_of_products7', 'No Of Products 7', 'trim|required|numeric');
            }
     
         if ($this->form_validation->run() == TRUE) {
          $uploaded_file = $res['discount_image1'];
          $unlink_image = array('source_dir' => "products", 'source_file' => $res['discount_image1']);
          if (!empty($_FILES) && $_FILES['discount_image1']['name'] != '') {
            $this->load->library('upload');
            $uploaded_data = $this->upload->my_upload('discount_image1', 'products', round(microtime(true)));
            if (is_array($uploaded_data) && !empty($uploaded_data)) {
              $uploaded_file = $uploaded_data['upload_data']['file_name'];
              removeImage($unlink_image);
            }
          }

           $uploaded_file2 = $res['discount_image2'];
          $unlink_image2 = array('source_dir' => "products", 'source_file' => $res['discount_image2']);
          if (!empty($_FILES) && $_FILES['discount_image2']['name'] != '') {
            $this->load->library('upload');
            $uploaded_data = $this->upload->my_upload('discount_image2', 'products', round(microtime(true)));
            if (is_array($uploaded_data) && !empty($uploaded_data)) {
              $uploaded_file2 = $uploaded_data['upload_data']['file_name'];
              removeImage($unlink_image2);
            }
          }

          $uploaded_file3 = $res['discount_image3'];
          $unlink_image3 = array('source_dir' => "products", 'source_file' => $res['discount_image3']);
          if (!empty($_FILES) && $_FILES['discount_image3']['name'] != '') {
            $this->load->library('upload');
            $uploaded_data = $this->upload->my_upload('discount_image3', 'products', round(microtime(true)));
            if (is_array($uploaded_data) && !empty($uploaded_data)) {
              $uploaded_file3 = $uploaded_data['upload_data']['file_name'];
              removeImage($unlink_image3);
            }
          }

          $uploaded_file4 = $res['discount_image4'];
          $unlink_image4 = array('source_dir' => "products", 'source_file' => $res['discount_image4']);
          if (!empty($_FILES) && $_FILES['discount_image4']['name'] != '') {
            $this->load->library('upload');
            $uploaded_data = $this->upload->my_upload('discount_image4', 'products', round(microtime(true)));
            if (is_array($uploaded_data) && !empty($uploaded_data)) {
              $uploaded_file4 = $uploaded_data['upload_data']['file_name'];
              removeImage($unlink_image4);
            }
          }

          $uploaded_file5 = $res['discount_image5'];
          $unlink_image5 = array('source_dir' => "products", 'source_file' => $res['discount_image5']);
          if (!empty($_FILES) && $_FILES['discount_image5']['name'] != '') {
            $this->load->library('upload');
            $uploaded_data = $this->upload->my_upload('discount_image5', 'products', round(microtime(true)));
            if (is_array($uploaded_data) && !empty($uploaded_data)) {
              $uploaded_file5 = $uploaded_data['upload_data']['file_name'];
              removeImage($unlink_image5);
            }
          }

          $uploaded_file6 = $res['discount_image6'];
          $unlink_image6 = array('source_dir' => "products", 'source_file' => $res['discount_image6']);
          if (!empty($_FILES) && $_FILES['discount_image6']['name'] != '') {
            $this->load->library('upload');
            $uploaded_data = $this->upload->my_upload('discount_image6', 'products', round(microtime(true)));
            if (is_array($uploaded_data) && !empty($uploaded_data)) {
              $uploaded_file6 = $uploaded_data['upload_data']['file_name'];
              removeImage($unlink_image6);
            }
          }

          $uploaded_file7 = $res['discount_image7'];
          $unlink_image7 = array('source_dir' => "products", 'source_file' => $res['discount_image7']);
          if (!empty($_FILES) && $_FILES['discount_image7']['name'] != '') {
            $this->load->library('upload');
            $uploaded_data = $this->upload->my_upload('discount_image7', 'products', round(microtime(true)));
            if (is_array($uploaded_data) && !empty($uploaded_data)) {
              $uploaded_file7 = $uploaded_data['upload_data']['file_name'];
              removeImage($unlink_image7);
            }
          }

            $posted_data = array(
                      'discount_text1' => $this->input->post('discount_text1', TRUE),
                      'regular_price1' => $this->input->post('regular_price1', TRUE),
                      'discounted_price1' => $this->input->post('discounted_price1', TRUE),
                      'no_of_products1' => $this->input->post('no_of_products1', TRUE),
                      'discount_image1' => $uploaded_file,
                      'discount_text2' => $this->input->post('discount_text2', TRUE),
                      'regular_price2' => $this->input->post('regular_price2', TRUE),
                      'discounted_price2' => $this->input->post('discounted_price2', TRUE),
                      'no_of_products2' => $this->input->post('no_of_products2', TRUE),
                      'discount_image2' => $uploaded_file2,
                      'discount_text3' => $this->input->post('discount_text3', TRUE),
                      'regular_price3' => $this->input->post('regular_price3', TRUE),
                      'discounted_price3' => $this->input->post('discounted_price3', TRUE),
                      'no_of_products3' => $this->input->post('no_of_products3', TRUE),
                      'discount_image3' => $uploaded_file3,
                      'discount_text4' => $this->input->post('discount_text4', TRUE),
                      'regular_price4' => $this->input->post('regular_price4', TRUE),
                      'discounted_price4' => $this->input->post('discounted_price4', TRUE),
                      'no_of_products4' => $this->input->post('no_of_products4', TRUE),
                      'discount_image4' => $uploaded_file4,
                      'discount_text5' => $this->input->post('discount_text5', TRUE),
                      'regular_price5' => $this->input->post('regular_price5', TRUE),
                      'discounted_price5' => $this->input->post('discounted_price5', TRUE),
                      'no_of_products5' => $this->input->post('no_of_products5', TRUE),
                      'discount_image5' => $uploaded_file5,
                      'discount_text6' => $this->input->post('discount_text6', TRUE),
                      'regular_price6' => $this->input->post('regular_price6', TRUE),
                      'discounted_price6' => $this->input->post('discounted_price6', TRUE),
                      'no_of_products6' => $this->input->post('no_of_products6', TRUE),
                      'discount_image6' => $uploaded_file6,
                      'discount_text7' => $this->input->post('discount_text7', TRUE),
                      'regular_price7' => $this->input->post('regular_price7', TRUE),
                      'discounted_price7' => $this->input->post('discounted_price7', TRUE),
                      'no_of_products7' => $this->input->post('no_of_products7', TRUE),
                      'discount_image7' => $uploaded_file7,
            );
            $where = "products_id = '" .$res['products_id']. "'";
            $this->product_model->safe_update('wps_products', $posted_data, $where, FALSE);
             $this->session->set_userdata(array('msg_type' => 'success'));
            $this->session->set_flashdata('success', lang('successupdate'));
            redirect('sitepanel/products/view_discounts/' . $res['products_id'], '');
          }
        }

        $data['res'] = $res;
        $data['heading_title'] = "Manage Discounts";
        $this->load->view('catalog/view_discounts_products', $data);
    }

  }


  public function view_stocks() {
    $productId = (int) $this->uri->segment(4);
    $option = array('productid' => $productId);
    $res = $this->product_model->get_products(1, 0, $option);
    if (is_array($res)) {
      $res = $res[0];
      $post_err = array(
          'quantity' => array(),
          'product_price' => array(),
          'product_discounted_price' => array()
      );
      $post_error = FALSE;
      if ($this->input->post('sub') != '') {
        $product_price = $this->input->post('product_price');
        $product_discounted_price = $this->input->post('product_discounted_price');
        $quantity = $this->input->post('quantity');
        $color_id = $this->input->post('color');
        $size_id = $this->input->post('size');
        $color_traced = TRUE;
        $size_traced = TRUE;
        if (!is_array($color_id)) {
          $color_traced = FALSE;
        }
        if (!is_array($size_id)) {
          $size_traced = FALSE;
        }
        $data_insert = array();
        foreach ($quantity as $key => $val) {
          $loop_verified = TRUE;
          $loop_price = $product_price[$key];
          $loop_discount_price = $product_discounted_price[$key];
          $loop_quantity = $val;
          $loop_color_id = $color_traced === TRUE ? $color_id[$key] : 0;
          $loop_size_id = $size_traced === TRUE ? $size_id[$key] : 0;
          if ($loop_price != '' || $loop_discount_price != '' || $loop_quantity != '') {
            if ($loop_price == '') {
              $post_err['product_price'][$key] = "Price is required";
              $loop_verified = FALSE;
            } elseif (!array_key_exists($key, $post_err['product_price'])) {
              if (!preg_match('/^[0-9]*(\.)?[0-9]+$/', $loop_price)) {
                $post_err['product_price'][$key] = "Price is invalid";
                $loop_verified = FALSE;
              }
              if ($loop_price >= 10000000) {
                $post_err['product_price'][$key] = "Price must be less than 10000000";
                $loop_verified = FALSE;
              }
              if ($loop_price <= 0) {
                $post_err['product_price'][$key] = "Price must be greater than 0";
                $loop_verified = FALSE;
              }
            }
            if ($loop_discount_price != '') {
              if (!preg_match('/^[0-9]*(\.)?[0-9]+$/', $loop_price)) {
                $post_err['product_discounted_price'][$key] = "Price is invalid";
                $loop_verified = FALSE;
              } elseif (!array_key_exists($key, $post_err['product_price'])) {
                if ($loop_discount_price >= $loop_price) {
                  $post_err['product_discounted_price'][$key] = "Price must be less than actual price";
                  $loop_verified = FALSE;
                }
              }
            }
            if ($loop_quantity == '') {
              $post_err['quantity'][$key] = "Quantity is required";
              $loop_verified = FALSE;
            } elseif (!array_key_exists($key, $post_err['quantity'])) {
              if (!preg_match('/^[0-9]+$/', $loop_quantity)) {
                $post_err['quantity'][$key] = "Quantity is invalid";
                $loop_verified = FALSE;
              }
            }
            if ($loop_verified === TRUE) {
              $data_insert[] = array(
                  'product_id' => $res['products_id'],
                  'color_id' => $loop_color_id,
                  'size_id' => $loop_size_id,
                  'product_price' => $loop_price,
                  'product_discounted_price' => $loop_discount_price == '' ? null : $loop_discount_price,
                  'quantity' => $loop_quantity
              );
            } else {
              $post_error = TRUE;
            }
          }
        }
        if ($post_error === FALSE) {
          $this->db->query("DELETE FROM wps_product_attributes WHERE product_id='" . $res['products_id'] . "'");
          if (!empty($data_insert)) {
            foreach ($data_insert as $val) {
              $this->product_model->safe_insert('wps_product_attributes', $val, FALSE);
            }
          }
          $this->session->set_userdata(array('msg_type' => 'success'));
          $this->session->set_flashdata('success', lang('successupdate'));
          redirect('sitepanel/products/view_stocks/' . $res['products_id'], '');
        }
      }
      $matrix_arr_filled = FALSE;
      $matrix_arr_db = array();
      $attr_cond = array(
          'where' => "product_id='" . $res['products_id'] . "'"
      );
      $res_attr = $this->product_model->product_attributes($attr_cond);
      if (is_array($res_attr) && !empty($res_attr)) {
        foreach ($res_attr as $val) {
          $color_id = $val['color_id'];
          $size_id = $val['size_id'];
          $matrix_arr_db[$color_id][$size_id] = $val;
          $matrix_arr_filled = TRUE;
        }
      }
      $color_ids = $res['color_ids'] != '' ? $res['color_ids'] : "-9999";
      $prod_color_cond = array(
          'where' => "wlc.color_id IN($color_ids)"
      );
      $res_colors = $this->product_model->related_colors($prod_color_cond);
      $size_ids = $res['size_ids'] != '' ? $res['size_ids'] : "-9999";
      $prod_size_cond = array(
          'where' => "wls.size_id IN($size_ids)"
      );
      $res_size = $this->product_model->related_sizes($prod_size_cond);
      $data['res_size'] = $res_size;
      $data['res_colors'] = $res_colors;
      $data['res_attr'] = $res_attr;
      $data['matrix_arr_filled'] = $matrix_arr_filled;
      $data['matrix_arr_db'] = $matrix_arr_db;
      $data['res'] = $res;
      $data['heading_title'] = "Manage Stocks";
      $data['post_err'] = $post_err;
      $this->load->view('catalog/view_stock_products', $data);
    }
  }

}

// End of controller