<?php
$this->load->view("app_top");
$countRows = count_record("wps_orders_products", "order_id = '" . $order_res['order_id'] . "' ");
$orderDets = $this->order_model->get_order_detail($order_res['order_id']);
?>

<div class="page_breadcrumbs">
  <div class="container">
    <ul class="dash-breadcrumb">
      <li><a href="<?php echo site_url(); ?>">Home</a></li>
      <li><a href="<?php echo site_url(); ?>members" title="My Account">My Account</a></li>
      <li class="active"><?php echo $order_res['invoice_number']; ?> <span>(<?php echo $countRows; ?> item(s))</li>
    </ul>
  </div>
</div>
<section class="track_page">
  <div class="container">
    <div class="row">
        <?php $this->load->view('members/partials/left-sidebar'); ?>
      
      <div class="col-md-9">
        <div class="wps_right track_info">
          <div class="row">
            <div class="col-lg-8 col-md-8">
              <div class="ordHeaderDetails">
                <h1>Delivery Address</h1>
                <h2><?php echo $order_res['billing_name']; ?></h2>
                <p><?php echo $order_res['billing_address']; ?>, <?php echo $order_res['billing_state']; ?>, <?php echo $order_res['billing_city']; ?> - <?php echo $order_res['billing_zipcode']; ?><br>
                  <strong>Phone</strong>: <?php echo $order_res['billing_phone']; ?></p>
                <p><strong>Dated</strong>: <?php echo getDateFormat($order_res['order_received_date'], 6); ?></p>
                <p><strong>Total Ordered Amount </strong>: <?php echo display_price($order_res['total_amount']); ?></p>
              </div>
            </div>
            <div class="col-lg-4 col-md-4">
              <div class="more_track">
                <h2>More actions</h2>
                <p><i class="fa fa-file-text"></i> Invoice <a class="request_invoice" href="<?php echo site_url(); ?>cart/print_invoice/<?php echo $order_res['order_id']; ?>" target="_blank">Download Invoice</a></p>
              </div>
            </div>
          </div>
        </div>
        <div class="table-wrapper">
            <div class="table-title">
                <div class="row">
                    <div class="col-sm-4">
            <h2>Order <b>Details</b></h2>
          </div>
                </div>
            </div>
            <div class="overflow-scroll">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th></th>
                        <th>Products</th>
            <th>Product Price</th>           
            <!--<th>Action</th>-->
                    </tr>
                </thead>
                <tbody>
                  <?php
          if (is_array($orderDets) && !empty($orderDets)) {
            foreach ($orderDets as $o => $pageVal) {

              $furl = get_db_field_value("wps_products", "friendly_url", "WHERE products_id = '" . $pageVal['products_id'] . "'");
              $img = get_db_field_value("wps_products_media", "media", "WHERE products_id = '" . $pageVal['products_id'] . "'");
              $productName = get_db_field_value("wps_products", "product_name", "WHERE products_id = '" . $pageVal['products_id'] . "'");
              $productDetail=get_db_single_row('wps_products', "discount_text1, discount_text2, discount_text3, discount_text4", "products_id='".$pageVal['products_id']."'");

              ?>
              <tr>
                        <td>1</td>
                        <td><img src="<?php echo get_image('product_images', $img, '80', '80', 'R'); ?>" alt = "<?php echo $productName; ?>"></td>
                        <td>
                          <a href="<?php echo site_url() . $furl; ?>"><?php echo $productName; ?></a><br/>
                          <span class=""><strong><?php if($pageVal['discount_type']=='discounted_price1'){ echo $productDetail['discount_text1']; }elseif($pageVal['discount_type']=='discounted_price2'){ echo $productDetail['discount_text2']; }elseif($pageVal['discount_type']=='discounted_price3'){ echo $productDetail['discount_text3']; }elseif($pageVal['discount_type']=='discounted_price4'){ echo $productDetail['discount_text4']; }else{ ''; } ?></strong>
                     </span>
                        </td>
                        <td><?php echo display_price($pageVal['product_price']); ?></td>                        
                    </tr>
                  <?php }} ?>
              
                   </tbody></table></div>
      
          <div class="row">
            <div class="col-lg-3 col-md-3"></div>
            <div class="col-lg-6 col-md-6">
              <div class="deliver_process">
                <ul class="progressbar">
                  
                  <?php
                  if ($order_res['order_status'] == '3') {
                    ?>
                    <li class="active">In Transit
                      <div class="process_dec">
                        <p><span><?php echo getDateFormat($order_res['order_in_transit_date'], 6); ?></span><br>Your item is out for delivery</p>
                      </div>
                    </li>
                    <?php
                  }
                  elseif ($order_res['order_status'] == '8') {
                    ?>
                    <li class="active">Delivered
                      <div class="process_dec">
                        <p><span><?php echo getDateFormat($order_res['order_delivery_date'], 6); ?></span><br>
                          Your item has been delivered</p>
                      </div>
                    </li>
                    <?php
                  }else{ ?>
                    <li class="active">Ordered
                    <div class="process_dec">           
                      <p><span><?php echo getDateFormat($order_res['order_received_date'], 6); ?></span><br> Payment approved</p>
                    </div>
                  </li>
                  <?php }
                  ?>
                </ul>
              </div>
            </div>
            <div class="col-lg-3 col-md-3">
              <div class="deliver_righ_info">
                <?php
                if ($order_res['order_status'] == '8') {
                  ?>
                  <h4>Delivered on <?php echo getDateFormat($order_res['order_delivery_date'], 6); ?></h4>
                  <?php
                }
                ?>
                <a href="<?php echo site_url(); ?>contact-us" title="Need Help"><i class="fa fa-question"></i> Need Help</a>
              </div>
            </div>
          </div>
        </div>
        <div class="track_footer">
          
        </div>
      </div>
    </div>
  </div>
</section>
<?php $this->load->view("app_bottom"); ?>