<?php
$this->load->view("top_application");
$QryStringArr = array();  // To store all Query Variables so to move to other view;
$QryStringArr = array_unique($QryStringArr);
?>
<div class="page_breadcrumbs">
  <div class="container">
    <ul>
      <li><a href="<?php echo site_url(); ?>">Home</a></li>
      <li>My Orders</li>
    </ul>
  </div>
</div>
<!----My Accounts---->
<section class="my_account_page">
  <form name="searchForm" id="searchForm" action="">
    <div class="container">
      <div class="row">
        <div class="col-md-9 col-md-push-3">
          <h1>My Orders</h1>          
          <div class="my_account my_order" id="prodListingContainer">
            <!--- Start Here-->
            <?php
            echo error_message();
            echo validation_message();
            //$orders = array();
            if (is_array($orders) && !empty($orders)) {
              foreach ($orders as $key => $val) {
                $orderDets = $this->order_model->get_order_detail($val['order_id']);
                //trace($orderDets);
                //trace($val);
                ?>
                <div class="order_item listpager">
                  <div class="order_top">
                    <div class="row">
                      <div class="col-lg-5">
                        <a class="orderID" rel="noopener noreferrer" href="<?php echo site_url(); ?>members/order_details/<?php echo $val['order_id']; ?>"><?php echo $val['invoice_number']; ?></a>
                      </div>
                      <div class="col-lg-3 pull-right text-right">
                        <a class="need_btn" href="<?php echo site_url(); ?>members/order_details/<?php echo $val['order_id']; ?>" title="Track"><i class="fa fa-map-marker"></i> Track</a>
                      </div>
                    </div>
                  </div>
                  <div class="order_body">
                    <?php
                    if (is_array($orderDets) && !empty($orderDets)) {
                      foreach ($orderDets as $o => $pageVal) {
                        $furl = get_db_field_value("wps_products", "friendly_url", "WHERE products_id = '" . $pageVal['products_id'] . "'");
                        $img = get_db_field_value("wps_products_media", "media", "WHERE products_id = '" . $pageVal['products_id'] . "'");
                        print_r($pageVal);
                        $productName = get_db_field_value("wps_products", "product_name", "WHERE products_id = '" . $pageVal['products_id'] . "'");
                        ?>
                        <div class="row">
                          <div class="col-lg-5 col-md-5 col-sm-5">
                            <div class="row">
                              <div class="col-lg-4 col-md-4 col-sm-4">
                                <a href="<?php echo site_url() . $furl; ?>"><img src="<?php echo get_image_with_name($productName, 'product_images', $img, '80', '80', 'R'); ?>" alt = "<?php echo $productName; ?>"></a>
                              </div>
                              <div class="col-lg-8 col-md-8 col-sm-8">
                                <div class="order_info">
                                  <a href="<?php echo site_url() . $furl; ?>"><?php echo $productName; ?></a>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="col-lg-7 col-md-7 col-sm-7">
                            <div class="row">
                              <div class="col-lg-3 col-md-3 col-sm-3">
                                <div class="order_price">
                                  <?php echo display_price($pageVal['product_price']); ?>
                                </div>
                              </div>
                              <?php
                              if ($val['order_status'] == '8') {
                                ?>
                                <div class="col-lg-5 col-md-5 col-sm-5">
                                  <div class="delivered">
                                    <p>Delivered on <?php echo getDateFormat($val['order_delivery_date'], 3); ?></p>
                                    <small>Your item has been delivered</small>
                                  </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-5">
                                  <a class="review_product" href="<?php echo site_url(); ?>members/post_review/<?php $pageVal['prosucts_id']; ?>" title="Rate & Review Product"><i class="fa fa-star"></i> Rate & Review</a>
                                </div>
                                <?php
                              } elseif ($val['order_status'] == 'Canceled') {
                                ?>
                                <div class="col-lg-5 col-md-5 col-sm-5">
                                  <div class="delivered">
                                    <?php echo ucwords(($this->session->userdata('lang') == 'p') ? $this->lang->line('order_canceled') : 'Order Canceled'); ?>

                                  </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-5">

                                </div>
                                <?php
                              }
                              ?>
                            </div>
                          </div>
                        </div>
                        <?php
                      }
                    }
                    ?>
                  </div>
                  <div class="order_foot">
                    <div class="row">
                      <div class="col-lg-6 col-md-6 col-sm-6">
                        <p>Ordered On <?php echo getDateFormat($val['order_received_date'], 3); ?></p>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6">
                        <p class="text-right">Order Total <strong><?php echo display_price($val['total_amount']); ?></strong></p>
                      </div>
                    </div>
                  </div>
                </div>
                <?php
              }
            } else {
              ?>
              <div class="text-center mt10">
                <h2 class="contact-title">Sorry, No Result Found!</h2>
                <img src="<?php echo theme_url(); ?>images/noresult.gif" width="350" title="No Result Found" alt="No Result Found" />
              </div>
              <?php
            }
            ?>
          </div>
        </div>
        <div class="col-md-3 col-md-pull-9">
          <div class="my_sidebar">
            <div class="profle_body text-center">
              <img src="<?php echo theme_url(); ?>images/user.svg" width="80" height="80" alt="User">
              <h5 class="bold mb-0"><?php echo $mres['first_name'] . ' ' . $mres['last_name']; ?></h5>
            </div>            
          </div>
          <div class="my_sidebar">
            <?php $this->load->view('members/left'); ?>
          </div>
        </div>
      </div>
    </div>
  </form>
</section>
<script type="text/javascript">
  var page = 1;
  var triggeredPaging = 0;
  $(window).scroll(function () {
    $('#loadingdiv').hide();
    var scrollTop = $(window).scrollTop();
    var scrollBottom = (scrollTop + $(window).height());
    var containerTop = $('#prodListingContainer').offset().top;
    var containerHeight = $('#prodListingContainer').height();
    var containerBottom = Math.floor(containerTop + containerHeight);
    var scrollBuffer = 0;
    if ((containerBottom - scrollBuffer) <= scrollBottom) {
      page = $('.listpager').length;
      var queryString = '?stOffSet=' + page;
<?php
if (count($QryStringArr)) {
  foreach ($QryStringArr as $qrykey => $qryval) {
    ?>
          queryString += "&<?php echo $qrykey; ?>=<?php echo $qryval; ?>";
    <?php
  }
}
?>
      var actual_count = <?php echo $total_list_rows; ?>;
      if (!triggeredPaging && page < actual_count) {
        triggeredPaging = 1;
        $.ajax({
          type: "POST",
          url: "<?php echo base_url(); ?>members/ajax_load_orders" + queryString,
          error: function (res) {
            triggeredPaging = 0;
            $('#loadingdiv').hide();
          },
          beforeSend: function (jqXHR, settings) {
            $('#loadingdiv').show();
          },
          success: function (res) {
            $('#loadingdiv').hide();
            $("#prodListingContainer").append(res);
            triggeredPaging = 0;
          }
        });
      }
    }
  });

</script>
<?php $this->load->view("bottom_application"); ?>