<?php

if (!defined('BASEPATH')) {
  exit('No direct script access allowed');
}

class api_model extends MY_Model {

  public function get_client($limit, $offset, $param = array()) {

    $userType = @$param['admin_type'];
    $status = @$param['status'];
    $stage = @$param['stage'];
    $assigned = @$param['assigned'];
    $unassigned = @$param['unassigned'];
    $userId = @$param['userId'];
    $assignedTo = @$param['assignedTo'];
    $myTeam = @$param['myTeam'];
    $upcoming_renewals = @$param['upcoming_renewals'];
    $expired_renewals = @$param['expired_renewals'];
    $follow_date = @$param['follow_date'];
    $customer_id = @$param['requirementsId'];
    $projectType = @$param['projectType'];
    $projectStatus = @$param['projectStatus'];
    $privileged = @$param['privileged'];

    $search_keyword = @$param['search_keyword'];
    $search_keyword = $this->db->escape_str($search_keyword);

    if ($customer_id != '') {
      $this->db->where("u.en_id", "$customer_id");
    }
    if ($status != '') {
      $this->db->where("u.status = '" . $status . "'");
    }
    // if($userId != ''){
    //   $this->db->where("u.assigned_to_ex = '" . $userId . "'");
    // }
    if ($userId != '') {
      if ($userType == '2' || $userType == '3') {
        $this->db->where("(FIND_IN_SET('" . $userId . "',u.admin_id) OR FIND_IN_SET('" . $userId . "',u.admin_id))");
      } else {
        $this->db->where("FIND_IN_SET('" . $userId . "',u.admin_id) != 0");
      }
    }
    if ($assigned != "" && $assignedTo == "") {
      $this->db->or_where("u.admin_id != ''");
    }
    if ($assignedTo != "") {
      $this->db->where("u.admin_id = '" . $assignedTo . "'");
    }
    if ($projectType != "") {
      $this->db->where("u.projectType = '" . $projectType . "'");
    }
    if ($privileged != "") {
      $this->db->where("u.privileged = '" . $privileged . "'");
    }
    if ($projectStatus != '') {
      $this->db->where("u.projectStatus = '" . $projectStatus . "'");
    }
    if ($myTeam) {
      $this->db->where("u.admin_id IN (" . $myTeam . ")");
    }
    if ($stage != '') {
      $this->db->where("u.stage", $stage);
    }
    if ($follow_date != '') {
      $this->db->where("u.follow_up_date <= '" . $follow_date . "'");
    }
    if ($upcoming_renewals > 0) {
      $this->db->where("(u.expiryDate <= NOW() + INTERVAL 90 DAY) AND u.expiryDate >= '" . date('Y-m-d') . "'");
      $this->db->order_by('u.expiryDate', 'asc');
    } elseif ($expired_renewals > 0) {
      $this->db->where("u.expiryDate < '" . date('Y-m-d') . "' AND u.expiryDate != '0000-00-00'");
      $this->db->order_by('u.expiryDate', 'asc');
    } else {
      $this->db->where("(u.expiryDate >= '" . date('Y-m-d') . "' OR u.expiryDate = '0000-00-00')");
      $this->db->order_by('u.supportID', 'desc');
    }
    if ($unassigned != "") {
      $this->db->where("u.admin_id = '0'");
    }

    if ($search_keyword != '') {
      $this->db->where("(u.memberName LIKE '%" . $search_keyword . "%' OR email LIKE '%" . $search_keyword . "%' OR u.companyName LIKE '%" . $search_keyword . "%' OR u.website LIKE '%" . $search_keyword . "%' OR u.phone LIKE '%" . $search_keyword . "%' OR u.mobileNo LIKE '%" . $search_keyword . "%')");
    }
    if ($limit > 0) {
      if (applyFilter('NUMERIC_WT_ZERO', $offset) == -1) {
        $offset = 0;
      }

      $this->db->limit($limit, $offset);
    }

    $this->db->select("u.*, ad.contact_person", false);

    //   $this->db->select("ad.admin_type,ad.admin_key, ad.reportingId,ad.targets,ad.admin_email,ad.litigation_days,ad.admin_last_login,ad.address,ad.city,ad.country,ad.phone,ad.contact_person,ad.contact_phone,ad.contact_email,ad.joining_date,ad.dob,ad.department,ad.sub_department,ad.admin_picture,ad.post_date,ad.status,ad.contact_person", FALSE);
    $this->db->from('tbl_support_clients as u');
    $this->db->join('tbl_admin AS ad', 'ad.admin_id=u.admin_id', 'left');
    $this->db->where("u.status != '2'");
    $q = $this->db->get();
    $result = $q->result_array();
    // echo_sql(); die;
    $result = ($limit == '1') ? $result[0] : $result;
    return $result;
  }

  public function member_exists($id) {
    $count = count_record("tbl_admin", "admin_id = '" . $id . "'");
    if ($count > 0) {
      return 1;
    } else {
      return 0;
    }
  }

  public function get_comment_list($limit, $offset, $supportId) {
    $result = $this->db->query("SELECT rc.*, DATE_FORMAT(rc.activity_date,'%d-%m-%Y') as add_date, a.contact_person FROM tbl_support_activity as rc LEFT JOIN tbl_admin as a ON a.admin_id = rc.admin_id WHERE rc.supportID = '" . $supportId . "' ORDER BY rc.activity_date DESC, activity_id DESC LIMIT $offset, $limit")->result_array();
    return $result;
  }

  public function get_leads($limit = '10', $offset = '0', $param = array()) {
    //print_r($param);die;
    $userType = @$param['admin_type'];
    $method = @$param['clientType'];

    // echo $method; die;
    $status = @$param['status'];
    $stage = @$param['stage'];
    $assigned = @$param['assigned'];
    $unassigned = @$param['unassigned'];
    $userId = @$param['userId'];
    $assignedTo = @$param['assignedTo'];
    $myTeam = @$param['myTeam'];
    $follow_date = @$param['follow_date'];
    $contactdate = @$param['contact_date'];
    $customer_id = @$param['leadsId'];
    $search_keyword = @$param['search_keyword'];
    $projectType = @$param['projectType'];

    $keyword = $this->db->escape_str($search_keyword);
    if ($customer_id != '') {
      $this->db->where("u.en_id", "$customer_id");
    }
    if ($status != '') {
      $this->db->where("u.status = '" . $status . "'");
    }

    if ($userId != '') {
      if ($userType == '2' || $userType == '3') {
        if ($method == '1') {
          $this->db->where("(FIND_IN_SET('" . $userId . "',u.assigned_to_tl) OR FIND_IN_SET('" . $userId . "',u.assigned_to_ex)) AND stage = '0'");
        } else {
          $this->db->where("(FIND_IN_SET('" . $userId . "',u.assigned_to_tl) OR FIND_IN_SET('" . $userId . "',u.assigned_to_ex))");
        }
      } else {
        if ($method == '1' || $method == '2') {
          $this->db->where("FIND_IN_SET('" . $userId . "',u.assigned_to_ex) != 0 AND stage = '0'");
          if ($method == '1') {
            $this->db->where("(u.follow_up_date > '" . date('Y-m-d') . "' OR u.follow_up_date = '0000-00-00')");
          }
        } else {
          $this->db->where("FIND_IN_SET('" . $userId . "',u.assigned_to_ex) != 0");
        }
      }
    }

    if ($assigned != "" && $assignedTo == "") {
      $this->db->or_where("(u.assigned_to_tl != '' OR u.assigned_to_ex != '')");
    }

    /*  if ($projectType != "") {
      $this->db->where("u.projectType = '" . $projectType . "'");
      } */
    if ($assignedTo != "") {
      $this->db->where("u.assigned_to_ex = '" . $assignedTo . "'");
    }
    if ($myTeam) {
      $this->db->where("u.assigned_to_ex IN (" . $myTeam . ")");
    }
    if ($stage != '') {
      $this->db->where("u.stage", $stage);
    }
    if ($follow_date != '') {
      $this->db->where("u.follow_up_date <= '" . $follow_date . "'");
    }
    if ($contactdate != '') {
      $this->db->where("u.follow_up_date <= '" . $contactdate . "'");
    }

    if ($unassigned != "") {
      $this->db->where("u.assigned_to_tl = '0'");
      $this->db->where("u.assigned_to_ex = '0'");
    }
    if ($keyword != '') {
      $this->db->where("(u.name LIKE '%" . $keyword . "%' OR company_name LIKE '%" . $keyword . "%' OR u.email LIKE '%" . $keyword . "%' OR u.alt_email LIKE '%" . $keyword . "%' OR u.mobile LIKE '%" . $keyword . "%' OR u.alt_mobile LIKE '%" . $keyword . "%')");
    }

    if ($limit > 0) {
      if (applyFilter('NUMERIC_WT_ZERO', $offset) == -1) {
        $offset = 0;
      }
      $this->db->limit($limit, $offset);
    }
    //$this->db->where("u.status != '2'");
    $this->db->order_by('u.follow_up_date', 'desc');
    $this->db->order_by('u.follow_up_time', 'asc');
    $this->db->group_by('u.en_id');
    $this->db->select("u.*, ad.contact_person, leComm.added_date", false);
    $this->db->from('wps_leads as u');
    $this->db->join('tbl_admin AS ad', 'ad.admin_id = u.assigned_to_ex', 'left');
    $this->db->join('wps_leads_comments as leComm', 'leComm.req_id = u.en_id', 'left');

    $this->db->where("u.status != '2'");
    $q = $this->db->get();
    $result = $q->result_array();
    // echo count($result); die;
    //echo_sql(); die;
    $result = ($limit == '1') ? $result[0] : $result;
    return $result;
  }

  /* Insert Data in Table */

  public function safe_insert($table, $data = array(), $debug = false) {
    if ($table != "" && is_array($data) && !empty($data)) {
      $qstr = $this->db->insert_string($table, $data);
      $this->db->query($qstr);
      if ($debug) {
        echo $this->db->last_query();
      }
      return $this->db->insert_id();
    }
  }

  /* Update Data in Table */

  public function safe_update($table, $data = array(), $where, $debug = false) {

    if ($table != "" && is_array($data) && !empty($data) && $where != "") {
      $qstr = $this->db->update_string($table, $data, $where);
      $this->db->query($qstr);
      if ($debug) {
        echo $this->db->last_query();
      }
    }
  }

  /* Get Lead Comment List */

  public function get_req_cvs($limit, $offset, $leadId) {
    // print_r($leadId); die;
    $result = $this->db->query("SELECT rc.*, DATE_FORMAT(rc.added_date,'%d-%m-%Y') as add_date, a.contact_person FROM wps_leads_comments as rc LEFT JOIN tbl_admin as a ON a.admin_id = rc.added_by WHERE rc.req_id = '" . $leadId . "' ORDER BY added_date DESC, req_cv_id DESC")->result_array();

    /*  $result1 = array();
      $i = 0;
      foreach ($result as $rkey => $rval):
      $res = $this->db->query("SELECT cv_stage, cv_comment, coversation_type, added_date FROM wps_leads_comments WHERE req_cv_id = '" . $rval['req_cv_id'] . "'")->row_array();
      if ($res['coversation_type'] == 1) {
      $text = 'Conversation';
      } elseif ($res['coversation_type'] == 2) {
      $text = 'Chat:';
      } else {
      $text = 'Others:';
      }
      $result1[$i] = $rval;
      $result1[$i]['cv_stage'] = $res['cv_stage'];
      $result1[$i]['cv_comment'] = $text .'    '.  $res['cv_comment'];
      $result1[$i]['added_date'] = date('d-m-Y', strtotime($res['added_date']));
      $i++;
      endforeach; */
    return $result;
  }

  /* get admin Record by admin Id */

  public function get_member_row($id, $condtion = '') {
    $id = (int) $id;
    if ($id != '' && is_numeric($id)) {
      $condtion = "status !='2' AND admin_id=$id $condtion ";

      $fetch_config = array(
          'condition' => $condtion,
          'debug' => false,
          'return_type' => "array",
      );

      $result = $this->find('tbl_admin', $fetch_config);
      return $result;
    }
  }

  /* update change Password */

  public function update_info($adminId, $oldPass, $newPass) {
    $cond = "admin_id = $adminId AND admin_password ='$oldPass' ";
    $num_row = $this->findCount('tbl_admin', $cond);
    if ($num_row > 0) {
      $data = array(
          'admin_password' => $newPass,
      );
      print_r($data);
      die;

      $where = "admin_id=" . $id . " ";
      $this->safe_update('tbl_admin', $data, $where, false);

      $this->session->set_userdata('msg_type', "success");
      $this->session->set_flashdata('success', lang('successupdate'));
    } else {
      $this->session->set_userdata(array('msg_type' => 'error'));
      $this->session->set_flashdata('error', lang('password_incorrect'));
    }
  }

  /* Total Count */

  public function getTotalCountList($limit = '10', $offset = '0', $param = array()) {
//print_r($param);die;
    $userType = @$param['admin_type'];
    $method = @$param['clientType'];

    // echo $method; die;
    $status = @$param['status'];
    $stage = @$param['stage'];
    $assigned = @$param['assigned'];
    $unassigned = @$param['unassigned'];
    $userId = @$param['userId'];
    $assignedTo = @$param['assignedTo'];
    $myTeam = @$param['myTeam'];
    $follow_date = @$param['follow_date'];
    $contactdate = @$param['contact_date'];
    $customer_id = @$param['leadsId'];
    $search_keyword = @$param['search_keyword'];
    $projectType = @$param['projectType'];

    $keyword = $this->db->escape_str($search_keyword);
    if ($customer_id != '') {
      $this->db->where("u.en_id", "$customer_id");
    }
    if ($status != '') {
      $this->db->where("u.status = '" . $status . "'");
    }

    if ($userId != '') {
      if ($userType == '2' || $userType == '3') {
        if ($method == '1') {
          $this->db->where("(FIND_IN_SET('" . $userId . "',u.assigned_to_tl) OR FIND_IN_SET('" . $userId . "',u.assigned_to_ex)) AND stage = '0'");
        } else {
          $this->db->where("(FIND_IN_SET('" . $userId . "',u.assigned_to_tl) OR FIND_IN_SET('" . $userId . "',u.assigned_to_ex))");
        }
      } else {
        if ($method == '1' || $method == '2') {
          $this->db->where("FIND_IN_SET('" . $userId . "',u.assigned_to_ex) != 0 AND stage = '0'");
          if ($method == '1') {
            $this->db->where("(follow_up_date > '" . date('Y-m-d') . "' OR follow_up_date = '0000-00-00')");
          }
        } else {
          $this->db->where("FIND_IN_SET('" . $userId . "',u.assigned_to_ex) != 0");
        }
      }
    }

    if ($assigned != "" && $assignedTo == "") {
      $this->db->or_where("(u.assigned_to_tl != '' OR u.assigned_to_ex != '')");
    }

    /*  if ($projectType != "") {
      $this->db->where("u.projectType = '" . $projectType . "'");
      } */
    if ($assignedTo != "") {
      $this->db->where("u.assigned_to_ex = '" . $assignedTo . "'");
    }
    if ($myTeam) {
      $this->db->where("u.assigned_to_ex IN (" . $myTeam . ")");
    }
    if ($stage != '') {
      $this->db->where("u.stage", $stage);
    }
    if ($follow_date != '') {
      $this->db->where("u.follow_up_date <= '" . $follow_date . "'");
    }
    if ($contactdate != '') {
      $this->db->where("u.follow_up_date <= '" . $contactdate . "'");
    }

    if ($unassigned != "") {
      $this->db->where("u.assigned_to_tl = '0'");
      $this->db->where("u.assigned_to_ex = '0'");
    }
    if ($keyword != '') {
      $this->db->where("(u.name LIKE '%" . $keyword . "%' OR company_name LIKE '%" . $keyword . "%' OR u.email LIKE '%" . $keyword . "%' OR u.alt_email LIKE '%" . $keyword . "%' OR u.mobile LIKE '%" . $keyword . "%' OR u.alt_mobile LIKE '%" . $keyword . "%')");
    }

    if ($limit > 0) {
      if (applyFilter('NUMERIC_WT_ZERO', $offset) == -1) {
        $offset = 0;
      }
      $this->db->limit($limit, $offset);
    }
    //$this->db->where("u.status != '2'");
    $this->db->order_by('u.follow_up_date', 'desc');
    $this->db->order_by('u.follow_up_time', 'asc');
    $this->db->group_by('u.en_id');
    $this->db->select("u.*, ad.contact_person, leComm.added_date", false);
    $this->db->from('wps_leads as u');
    $this->db->join('tbl_admin AS ad', 'ad.admin_id = u.assigned_to_ex', 'left');
    $this->db->join('wps_leads_comments as leComm', 'leComm.req_id = u.en_id', 'left');

    $this->db->where("u.status != '2'");
    $q = $this->db->get();
    $result = $q->result_array();
    // echo count($result); die;
    // echo_sql(); die;
    $result = ($limit == '1') ? $result[0] : $result;
    return $result;
  }

  public function get_static_pages($id) {
    return $this->db->query("SELECT * from wps_cms_pages where page_id = '$id'")->row_array();
  }

}
