<?php

class Products extends Public_Controller {

  public function __construct() {
    parent::__construct();
    if (!isset($this->ci)) {
      $this->ci = &get_instance();
    }
    $this->load->model(array('web_apis/api_model', 'users/users_model', 'products/product_model'));
    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer'));
    $this->load->helper(array('web_apis/api', 'category/category', 'products/product'));
  }

  public function getProductList() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $subcatId = $posteddata['subcatId'];
    $offset = $posteddata['offset'];
    // $userId=$posteddata['userId'];
    if ($subcatId != '' && !is_null($offset)) {
      $product = get_products_by_id($subcatId, $offset);
      $data['data'] = $product;
      $data['success'] = true;
      $data['message'] = 'Success';
    } else {
      $data['success'] = false;
      $data['message'] = 'Missing Required Parameters!';
    }
    echo json_encode($data);
  }

  public function getProduct() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if(verifyToken($posteddata['userId'])){  
    if ($posteddata['productId'] != '') {
      $productId = (int) $posteddata['productId'];
      $product = get_product_by_id($productId);
      if (count($product) == 0) {
        $data['success'] = false;
        $data['message'] = 'Product Not Available';
      } else {
        $product['image'] = get_products_media($productId);
        $data['data'] = $product;
        $data['success'] = true;
        $data['message'] = 'Success';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    // }else{
    //   $data['success'] = false;
    //       $data['message'] = 'Invalid Token!';
    //  }

    echo json_encode($data);
  }

  public function rating() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if(verifyToken($posteddata['userId'])){  
    if ($posteddata['productId'] != '' && $posteddata['rating'] != '' && $posteddata['userId'] != '') {
      $productId = (int) $posteddata['productId'];
      $rating = (int) $posteddata['rating'];
      $userId = (int) $posteddata['userId'];
      if ($rating > 5) {
        $data['success'] = false;
        $data['message'] = 'Rating can not be greater than 5';
      } else {
        $product = get_product_by_id($productId);
        if (count($product) == 0) {
          $data['success'] = false;
          $data['message'] = 'Product Not Available';
        } else {
          $this->product_model->rate($productId, $rating, $userId);
          $data['success'] = true;
          $data['message'] = 'Success';
        }
      }
      echo json_encode($data);
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    // }else{
    //   $data['success'] = false;
    //       $data['message'] = 'Invalid Token!';
    //  }
  }

  public function review() {
    $posteddata = json_decode(file_get_contents('php://input'), true);

    // print_r($_POST); die;
    // if(verifyToken($posteddata['userId'])){ 
    // $this->product_model->review($productId=0, $rating=0, $userId=0, $comment=0);

    if ($_POST['productId'] != '' && $_POST['rating'] != '' && $_POST['userId'] != '') {
      $productId = (int) $_POST['productId'];
      $rating = (int) $_POST['rating'];
      $userId = (int) $_POST['userId'];
      // echo($productId); die;
      $comment = $_POST['comment'];
      if ($rating > 5) {
        $data['success'] = false;
        $data['message'] = 'Rating can not be greater than 5';
      } else {
        $product = get_product_by_id($productId);
        if (count($product) == 0) {
          $data['success'] = false;
          $data['message'] = 'Product Not Available';
        } else {
          $status = $this->product_model->review($productId, $rating, $userId, $comment);
            $data['success'] = true;
            $data['message'] = 'Success';
        }
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    // }else{
    //   $data['success'] = false;
    //       $data['message'] = 'Invalid Token!';
    //  }
    echo json_encode($data);
  }

  public function getSize() {
    $sizesArray = getSizes();
    $sizes = [];
    foreach ($sizesArray as $size) {
      $sizes[] = [
          'sizeId' => $size['size_id'],
          'sizeName' => $size['size_name']
      ];
    }
    $data['success'] = true;
    $data['message'] = 'Success';
    $data['data'] = $sizes;
    echo json_encode($data);
  }

  public function getColor() {
    $colorsArray = getColors();
    $colors = [];
    foreach ($colorsArray as $color) {
      $colors[] = [
          'colorId' => $color['color_id'],
          'colorName' => $color['color_name'],
          'colorCode' => $color['color_code']
      ];
    }
    $data['success'] = true;
    $data['message'] = 'Success';
    $data['data'] = $colors;
    echo json_encode($data);
  }

  public function getCategories() {
    $categoriesArray = getCategories();
    $categories = [];
    foreach ($categoriesArray as $category) {
      $categories[] = [
          'categoryId' => $category['category_id'],
          'categoryName' => $category['category_name']
              // 'categoryImage' => site_url()."uploaded-files/category_image/".$category['category_image']
      ];
    }
    $data['success'] = true;
    $data['message'] = 'Success';
    $data['data'] = $categories;
    echo json_encode($data);
  }

  public function deleteReview() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // print_r($_POST); die;
    if (verifyToken($posteddata['userId'])) {
      // $this->product_model->review($productId=0, $rating=0, $userId=0, $comment=0);

      if ($posteddata['reviewId'] != '' && $posteddata['userId'] != '') {
        $userId = (int) $posteddata['userId'];
        $reviewId = (int) $posteddata['reviewId'];
        // echo($productId); die;
        $status = $this->product_model->deleteReview($reviewId, $userId);
        if ($status == '0') {
          $data['success'] = false;
          $data['message'] = 'Review Not Found';
        } else {
          $data['success'] = true;
          $data['message'] = 'Review successfully deleted';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function filterProducts() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if(verifyToken($posteddata['userId'])){ 
    if ($posteddata['subcatId'] != '') {
      $subcatId = $posteddata['subcatId'];
      $offset = $posteddata['offset'];
      $maxPrice = $posteddata['filter']['price']['max'];
      $minPrice = $posteddata['filter']['price']['min'];
      $sizeString = $posteddata['filter']['size'];
      $colorString = ($posteddata['filter']['color'] != '') ? $posteddata['filter']['color'] : '0';
      $discountOnly = $posteddata['filter']['discount'];
      $includeOutOfStock = $posteddata['filter']['availability'];
      $sizeArray = explode(',', $sizeString);
      $colorArray = explode(',', $colorString);
      $filterArray = [
          'catIds' => $subcatId,
          'price' => $minPrice . "-" . $maxPrice,
          'size' => $sizeString,
          'color' => $colorString,
          'discount' => $discountOnly,
          'includeOutOfStock' => $includeOutOfStock
      ];
      $limit = 10;
      $products = $this->product_model->get_products($limit, $offset, $filterArray);
      // print_r($products); die;
      if (count($products) > 0) {
        $productsArray = [];
        foreach ($products as $product) {
          $product = get_product_by_id($product['products_id']);
          $productsArray[] = [
              'productId' => $product['productId'],
              'name' => $product['name'],
              'subcatId' => $product['subcatId'],
              'originalPrice' => (int)$product['originalPrice'],
              'price' => (int)$product['price'],
              'description' => $product['description'],
              'image' => array_pop($product['image']),
              'colorId' => $product['color'][0]['colorId']
          ];
        }
        $data['data'] = $productsArray;
        $data['success'] = true;
        $data['message'] = 'Success';
      } else {
        $data['success'] = false;
        $data['message'] = 'No Product Found!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }

    // }else{
    //   $data['success'] = false;
    //       $data['message'] = 'Invalid Token!';
    //  }
    echo json_encode($data);
  }

  public function getPrice() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if(verifyToken($posteddata['userId'])){ 
    if ($posteddata['subcatId'] != '') {
      $subcatId = $posteddata['subcatId'];
      $price = $this->product_model->getPrice($subcatId);
      $data['maxPrice'] = (isset($price['maxPrice'])) ? $price['maxPrice'] : 5000.00;
      $data['minPrice'] = (isset($price['minPrice'])) ? $price['minPrice'] : 0.00;
      $data['success'] = true;
      $data['message'] = 'success';
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }

    // }else{
    //   $data['success'] = false;
    //       $data['message'] = 'Invalid Token!';
    //  }
    echo json_encode($data);
  }

  public function ratingReviewByProduct() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if(verifyToken($posteddata['userId'])){ 
    if ($posteddata['productId'] != '') {
      $productId = $posteddata['productId'];
      $reviews = $this->product_model->get_reviews_by_product($productId);
      $data['reviews'] = $reviews['reviews'];
      // $ratings = $this->product_model->get_ratings_by_product($productId);
      $rating_count = [
          'oneCount' => $reviews['reviews_count']['oneCount'],
          'twoCount' => $reviews['reviews_count']['twoCount'],
          'threeCount' => $reviews['reviews_count']['threeCount'],
          'fourCount' => $reviews['reviews_count']['fourCount'],
          'fiveCount' => $reviews['reviews_count']['fiveCount'],
          'totalRatingsCount' => $reviews['reviews_count']['totalRatingsCount'],
          'totalReviewsCount' => $reviews['reviews_count']['totalReviewsCount'],
          'averageProductRating' => number_format($reviews['reviews_count']['averageReviewsRatingCount'], 2)
      ];
      $data['ratingCount'] = $rating_count;
      $data['success'] = true;
      $data['message'] = 'success';
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }

    // }else{
    //   $data['success'] = false;
    //       $data['message'] = 'Invalid Token!';
    //  }
    echo json_encode($data);
  }

  public function getReviewByUser() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $userId = $posteddata['userId'];
        $reviews = $this->product_model->get_review_by_user($userId);
        if ($reviews == '0') {
          $data['success'] = true;
          $data['reviews'] = [];
          $data['message'] = 'No reviews submitted';
        } else {
          if (count($reviews) > 0) {
            $data['reviews'] = $reviews;
            $data['success'] = true;
            $data['message'] = 'Success';
          } else {
            $data['success'] = true;
            $data['reviews'] = [];
            $data['message'] = 'No reviews submitted';
          }
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function removeReviewImage() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['reviewImageId'] != '') {
        $reviewImageId = $posteddata['reviewImageId'];
        $this->product_model->remove_review_image($reviewImageId);
        $data['success'] = true;
        $data['message'] = 'Review image deleted successfully';
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function updateReview() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($_POST['reviewId'] != '') {
        $reviewId = $_POST['reviewId'];
        $rating = $_POST['rating'];
        $comment = $_POST['comment'];
        $this->product_model->update_review($reviewId, $rating, $comment);
        $data['success'] = true;
        $data['message'] = 'Review updated successfully';
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function getSizeDataByColor() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if(verifyToken($posteddata['userId'])){ 
    if ($posteddata['colorId'] != '' && $posteddata['productId'] != '') {
      $colorId = $posteddata['colorId'];
      $productId = $posteddata['productId'];
      // $comment = $_POST['comment'];
      //$images = get_products_media_by_color($productId, $colorId);
      $size_quantity = $this->product_model->get_size_quantity($colorId, $productId);
      $data['data'] = [
          //'images' => $images,
          'size' => $size_quantity
      ];
      $data['success'] = true;
      $data['message'] = 'Success';
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }

    // }else{
    //   $data['success'] = false;
    //       $data['message'] = 'Invalid Token!';
    //  }
    echo json_encode($data);
  }

  public function getProductSection() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if(verifyToken($posteddata['userId'])){ 
    if ($posteddata['type'] != '') {
      $type = $posteddata['type'];
      $output = [];
      switch ($type) {
        case '1' : {
            $output = get_products2('', "AND latest_product='1'");
            break;
          }
        case '2' : {
            $output = get_products2('', "AND bestseller_product='1'");
            break;
          }
        case '3' : {
            $output = get_products2('', "AND popular_product='1'");
            break;
          }
        case '4' : {
            $output = get_products2('', "AND newarrival_product='1'");
            break;
          }
        case '5' : {
            $output = get_products2('', "AND product_discounted_price<>0");
            break;
          }
      }
      $data['data'] = $output;
      $data['success'] = true;
      $data['message'] = 'Success';
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }

    // }else{
    //   $data['success'] = false;
    //       $data['message'] = 'Invalid Token!';
    //  }
    echo json_encode($data);
  }

  public function sendEnquiry() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if ($_POST['name']!='' && $_POST['email']!= '' && $_POST['mobile']!= '' && $_POST['size']!= '' && $_POST['comment']!= ''){
      $name = $_POST['name'];
      $email = $_POST['email'];
      $mobile = $_POST['mobile'];
      $size = $_POST['size'];
      $comment = $_POST['comment'];
      $status = $this->product_model->send_enquiry($name, $email, $mobile, $size, $comment);
        $data['success'] = true;
        $data['message'] = 'Success';
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    echo json_encode($data);
  }

}
