<?php

class Home extends Public_Controller {

  public function __construct() {
    parent::__construct();
    if (!isset($this->ci)) {
      $this->ci = &get_instance();
    }
    $this->load->model(array('web_apis/api_model', 'users/users_model'));
    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer'));
    $this->load->helper(array('web_apis/api', 'home/home', 'category/category'));
  }

  public function getHomeDetails() {
    $home = get_home_details();
    $data['data'] = $home;
    $data['success'] = true;
    $data['message'] = 'Success';
    echo json_encode($data);
  }

  public function search() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $data = array();
    $offset = $posteddata['offset'];
    $searchKeyword = $posteddata['searchKeyword'];
    if ($searchKeyword != '' && !is_null($offset)) {
      $user = get_search_result($searchKeyword, $offset);
      $data['data'] = $user;
      $data['success'] = true;
      $data['message'] = 'Success!';
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    echo json_encode($data);
  }

  public function getSupportDetails() {
    $admin = $this->db->query('SELECT * FROM wps_admin where admin_id = 1')->row_array();
    if (!empty($admin)) {
      $data['success'] = true;
      $data['message'] = 'Success!';
      $data['contactPhone'] = $admin['phone'];
      $data['contactEmail'] = $admin['admin_email'];
      $data['contactAltPhone'] = $admin['whatsapp'];
    } else {
      $data['success'] = false;
      $data['message'] = 'Something Went wrong!';
    }

    echo json_encode($data);
  }

  public function getStaticInfo() {
    $about = $this->api_model->get_static_pages('1');
    $privacy = $this->api_model->get_static_pages('3');
    $terms = $this->api_model->get_static_pages('2');
    if (!empty($about)) {
      $data['success'] = true;
      $data['message'] = 'Success!';
      $data['about'] = strip_tags($about['page_description']);
      $data['privacy'] = strip_tags($privacy['page_description']);
      $data['terms'] = strip_tags($terms['page_description']);
    } else {
      $data['success'] = false;
      $data['message'] = 'Something Went wrong!';
    }
    echo json_encode($data);
  }
}
