<?php

class Category extends Public_Controller {

  public function __construct() {

    parent::__construct();

    if (!isset($this->ci)) {
      $this->ci = &get_instance();
    }

    $this->load->model(array('web_apis/api_model', 'users/users_model'));

    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer'));

    $this->load->helper(array('web_apis/api', 'category/category'));
  }

  public function getCategories() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    // if($posteddata['parentId'] != ''){
    $parentId = $posteddata['parentId'];
    $data['data'] = (object) [];
    $cat = get_categories($parentId);
    if (count($cat) > 0) {
      $data['data'] = $cat;
    }
    $data['success'] = true;
    $data['message'] = 'Success';
    // }else{
    //     $data['success'] = false;
    //     $data['message'] = 'Required Parameter Missing';
    // }
    echo json_encode($data);
  }

}
