<?php

class Setting extends Admin_Controller {

  public function __construct() {


    parent::__construct();
    $this->load->helper('ckeditor');
    $this->load->model(array('sitepanel/setting_model'));
  }

  public function index($page = null) {

    $data['heading_title'] = 'Admin Setting';

    $data['admin_info'] = $this->setting_model->get_admin_info(1);
    $this->load->view('dashboard/setting_edit_view', $data);
  }

  public function edit() {

    $this->form_validation->set_rules('old_pass', 'Old Password', 'required|max_length[80]');
    $this->form_validation->set_rules('new_pass', 'New Password', 'required|valid_password|max_length[80]');
    $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[new_pass]|max_length[80]');
    if ($this->form_validation->run() == TRUE) {
      $this->setting_model->update_info($this->input->post('old_pass'), '1');
      redirect('sitepanel/setting/', '');
    }

    $data['heading_title'] = 'Update Admin Password';
    $data['admin_info'] = $this->setting_model->get_admin_info(1);
    $this->load->view('dashboard/setting_edit_view', $data);
  }

  public function edit_config() {

    $this->form_validation->set_rules('admin_email', 'Email ID', 'required|valid_email');
    $this->form_validation->set_rules('admin_phone', 'Phone Number', 'required|max_length[30]');
    $this->form_validation->set_rules('address', 'Address', 'required');

    $this->form_validation->set_rules('facebook', 'Facebook Link', 'trim|max_lenght[240]');
    $this->form_validation->set_rules('twitter', 'Twitter Link', 'trim|max_lenght[240]');
    $this->form_validation->set_rules('instagram', 'Instagram Link', 'trim|max_lenght[240]');
    $this->form_validation->set_rules('whatsapp', 'WhatsApp Number', 'trim|max_lenght[240]');



    if ($this->form_validation->run() == TRUE) {
      $this->setting_model->update_config('1');
      redirect('sitepanel/setting/edit_config', '');
    }
    $data['heading_title'] = 'Admin Configuration';
    $data['admin_info'] = $this->setting_model->get_admin_info(1);
    $this->load->view('dashboard/config_edit_view', $data);
  }

  public function update_ticker() {
    $this->form_validation->set_rules('ticker_text', 'Address', 'required|max_length[160]');
    if ($this->form_validation->run() == TRUE) {
      $this->db->query("UPDATE wps_admin SET ticker_text = '" . $this->input->get_post('ticker_text') . "' WHERE admin_id = '1'");
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', "Ticker Text has been updated successfully!");
      redirect('sitepanel/setting/update_ticker/', '');
    }
    $data['heading_title'] = 'Update Ticker';
    $data['admin_info'] = $this->setting_model->get_admin_info(1);
    $this->load->view('dashboard/ticker_edit_view', $data);
  }

}

// End of controller