<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Admin_Controller extends MY_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->library(array(
        'sitepanel/jquery_pagination', 'dmailer'
    ));
    $this->load->model(array(
        'utils_model'
    ));
    $this->admin_lib->is_admin_logged_in();
  }

  public function update_status($table, $auto_field = 'id') {
    $action = $this->input->post('status_action', TRUE);
    $arr_ids = $this->input->post('arr_ids', TRUE);
    $category_count = $this->input->post('category_count', TRUE);
    $product_count = $this->input->post('product_count', TRUE);
    $gallery_count = $this->input->post('gallery_count', TRUE);
    $controller = $this->router->fetch_class();
    $method = $this->router->fetch_method();

    if (is_array($arr_ids)) {
      $str_ids = implode(',', $arr_ids);
      if ($action == 'Activate') {
        foreach ($arr_ids as $k => $v) {
          $data = array(
              'status' => '1'
          );
          if ($controller == "members") {
            $data = array(
                'status' => '1',
                'is_verified' => '1'
            );
          } else {
            $data = array(
                'status' => '1'
            );
          }
          $where = "$auto_field ='$v'";
          $this->utils_model->safe_update($table, $data, $where, FALSE);
          $this->session->set_userdata(array(
              'msg_type' => 'success'
          ));
          $this->session->set_flashdata('success', lang('activate'));
        }
      }
      if ($action == 'Deactivate') {
        foreach ($arr_ids as $k => $v) {
          $countChild = 0;
          if ($controller == 'category') {
            $countChild = count_record('wps_products', "FIND_IN_SET (" . $v . ",category_links) AND status !='2'");
          }
          if ($countChild > 0) {
            $this->session->set_userdata(array(
                'msg_type' => 'error'
            ));
            $this->session->set_flashdata('error', lang('child_to_deactivate'));
          } else {
            $data = array(
                'status' => '0'
            );
            $where = "$auto_field ='$v'";
            $this->utils_model->safe_update($table, $data, $where, FALSE);
            $this->session->set_userdata(array(
                'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deactivate'));
          }
        }
      }

      if ($action == 'Delete') {
        foreach ($arr_ids as $k => $v) {
          $countChild = 0;
          if ($controller == 'category') {
            $countChild = count_record('wps_products', "FIND_IN_SET (" . $v . ",category_links) AND status !='2'");
          }

          if ($countChild > 0) {
            $this->session->set_userdata(array(
                'msg_type' => 'error'
            ));
            $this->session->set_flashdata('error', lang('child_to_delete'));
          } else {

            $where = array(
                $auto_field => $v
            );
            $this->utils_model->safe_delete($table, $where, TRUE);
            $this->session->set_userdata(array(
                'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
          }
        }
      }
      

      if ($action == 'Block') {
        $data = array(
            'is_blocked' => '1'
        );
        $where = "$auto_field IN ($str_ids)";
        $this->utils_model->safe_update($table, $data, $where, FALSE);
        $this->session->set_userdata(array(
            'msg_type' => 'success'
        ));
        $this->session->set_flashdata('success', 'Members have been set as blocked!');
      }
      if ($action == 'Unblock') {
        $data = array(
            'is_blocked' => '0'
        );
        $where = "$auto_field IN ($str_ids)";
        $this->utils_model->safe_update($table, $data, $where, FALSE);
        $this->session->set_userdata(array(
            'msg_type' => 'success'
        ));
        $this->session->set_flashdata('success', 'Members have been set as unblocked!');
      }

      if ($action == 'Tempdelete') {
        $data = array(
            'status' => '2'
        );
        $where = "$auto_field IN ($str_ids)";
        $this->utils_model->safe_update($table, $data, $where, FALSE);
        $this->session->set_userdata(array(
            'msg_type' => 'success'
        ));
        $this->session->set_flashdata('success', lang('deleted'));
      }
    }
    redirect($_SERVER['HTTP_REFERER'], '');
  }

  public function set_as($table, $auto_field = 'id', $data = array()) {
    $arr_ids = $this->input->post('arr_ids', TRUE);
    if (is_array($arr_ids)) {
      $str_ids = implode(',', $arr_ids);
      if (is_array($data) && !empty($data)) {
        $data = $data;
        $where = "$auto_field IN ($str_ids)";
        $this->utils_model->safe_update($table, $data, $where, FALSE);
        $current_controller = $this->router->fetch_class();
        if ($current_controller == "orders" && $this->input->post("ord_status") != "" && ($this->input->post("ord_status") != "Pending" && $this->input->post("ord_status") != "Closed")) {

          $this->load->library("dmailer");
          $curr_symbol = display_symbol();
          $mail_subject = $this->config->item('site_name') . " Order overview";
          $from_email = $this->admin_info->admin_email;
          $from_name = $this->config->item('site_name');
          foreach ($arr_ids as $key => $val) {
            $order = get_db_single_row("wps_order", '*', " order_id = " . $val);
            $courier_details = "";

            if ($this->input->post("ord_status") == '8') {
              $data = array(
                  'payment_status' => 'Paid',
                  'order_delivery_date' => $this->config->item('config.date.time')
              );
              $where = "order_id = '" . $val . "'";
              $this->utils_model->safe_update('wps_order', $data, $where, FALSE);

              $mail_to = $order["email"];
              $from_email = $this->admin_info->admin_email;
              $content = '<table width="1024" border="0" cellpadding="0" cellspacing="0" style="padding:10px;">
                <tr>
                <td style="">
                Dear ' . $order['first_name'] . ',<br /><br />
                  Your order no ' . $order['invoice_number'] . ', is delivered at your address,. Thank you for using Mercadomoz.com. We are waiting for your next order. Give us chance to serve you.
                  <br /><br />
                  
                  Thank you for trust.<br />
                  Team - Bone Chokers
                  </td>
                  </tr>
                  <tr><td style="">&nbsp;</td></tr>
              </table>';

              $mail_conf = array(
                  'subject' => $this->config->item('site_name') . " Order " . $this->input->post("ord_status"),
                  'to_email' => $mail_to,
                  'from_email' => $from_email,
                  'from_name' => $this->config->item('site_name'),
                  'body_part' => $content
              );
              // trace($mail_conf);
              // exit;
              $this->dmailer->mail_notify($mail_conf);
            }

            if ($this->input->post("ord_status") == 'Canceled') {
              // update stock
              $orders = $this->db->query("SELECT store, products_id, quantity FROM wps_orders_products WHERE " . $where)->result_array();
              foreach ($orders as $ord) {
                $qty = $ord['quantity'];
                $this->db->query("UPDATE wps_product_attributes SET quantity=quantity+$qty WHERE store_id = '" . $ord['store'] . "' AND product_id = '" . $ord['products_id'] . "'");
              }
              // End here
            }

            if ($this->input->post("ord_status") == '2') {

              $new_time = date("Y-m-d H:i:s", strtotime('+24 hours'));
              $dt = explode(' ', $new_time);
              $mail_to = $order["email"];
              $from_email = $this->admin_info->admin_email;
              $content = '<table width="1024" border="0" cellpadding="0" cellspacing="0" style="padding:10px;">
                <tr>
                <td style="">
                Dear ' . $order['first_name'] . ',<br /><br />
                  Your order no ' . $order['invoice_number'] . ', is dispatched for delivery, your billed amount is ' .$curr_symbol. display_price($order['total_amount']) . '. Estimated delivery time is ' . getDateFormat($dt[0], 3) . ', by ' . $dt[1] . '.
                  <br /><br />
                  </td>
                </tr>
              </table>';

              $mail_conf = array(
                  'subject' => $this->config->item('site_name') . " Order Dispatched",
                  'to_email' => $mail_to,
                  'from_email' => $from_email,
                  'from_name' => $this->config->item('site_name'),
                  'body_part' => $content
              );
              // trace($mail_conf);
              // exit;
              $this->dmailer->mail_notify($mail_conf);
            }
          }
        }
        $this->session->set_userdata(array(
            'msg_type' => 'success'
        ));
        $this->session->set_flashdata('success', "Record has been updated/deleted successfully.");
      }
      redirect($_SERVER['HTTP_REFERER'], '');
    }
  }

  public function update_displayOrder($tblname, $fldname, $fld_id) {
    $posted_order_data = $this->input->post('ord');
    while (list ($key, $val) = each($posted_order_data)) {
      if ($val != '') {
        $val = (int) $val;
        $data = array(
            $fldname => $val
        );
        $where = "$fld_id=$key";
        $this->utils_model->safe_update($tblname, $data, $where, TRUE);
      }
    }
    $this->session->set_userdata(array(
        'msg_type' => 'success'
    ));
    $this->session->set_flashdata('success', lang('order_updated'));
    redirect($_SERVER['HTTP_REFERER'], '');
  }

}
