<?php

class Order extends Public_Controller {

  public function __construct() {
    parent::__construct();
    if (!isset($this->ci)) {
      $this->ci = &get_instance();
    }
    //'wishlist/wishlist_model',
    $this->load->model(array('web_apis/api_model', 'users/users_model', 'products/product_model', 'order/order_model', 'cart/cart_model','payment/payment_model'));
    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer'));
    $this->load->helper(array('web_apis/api', 'cart/cart', 'products/product','payment/encdec_paytm'));

    $this->statusArray = array("0" => "Order Placed", "1" => "Order Confirmed", "2" => "Dispatched", "3" => "In Transit", "4" => "Out For Delivery", "5" => "Cancelled", "6" => "Returned", "7" => "Requested for Return", "8" => "Delivered");

    $this->statusDateArray = array("0" => "order_received_date", "1" => "order_confirmed_date", "2" => "order_dispatched_date", "3" => "order_in_transit_date", "4" => "order_out_for_delivery_date");
  }

  public function listOrders() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $status = [];
        $statusCode = '';
        $statusTitle = '';
        $statusDate = '';
        $statusTime = '';
        $dateTitle = '';
        $orderDate = '';
        $userId = $posteddata['userId'];
        $orders = $this->order_model->get_orders("0", "100", "AND customers_id = '" . $userId . "'");
        //trace($orders);
        //echo_sql();
        if (count($orders) > 0) {
          $orderProducts = (object) [];
          $res = $this->db->query("SELECT * FROM addresses WHERE userId=" . $userId . "")->result_array();
          $data['data'] = $res;
          $completeProductDetail = array();
          // $data = array();
          foreach ($orders as $order) {
            // echo json_encode($orders); die;
            $status = [];
            $orderProducts = $this->order_model->get_order_detail($order['order_id']);
            $orderProducts2 = $this->order_model->get_order_detail($order['order_id']);
            if (isset($orderProducts)) {
              foreach ($orderProducts as $orderProduct) {
                $otherProducts = [];

                $completeProductDetail = get_product_by_id($orderProduct['products_id'], $userId);
                //$size = $this->product_model->get_size_by_id($orderProduct['size_id']);
                $rating = $this->product_model->get_rating_by_product_user($orderProduct['products_id'], $userId);
                $productRating = (!empty($rating)) ? number_format($rating['rating'], 2) : 0.00;
                $billing_address = $this->users_model->getAddressById($order['billing_address']);
                $shipping_address = $this->users_model->getAddressById($order['shipping_address']);

                $orderDetails[] = [
                    'orderId' => $order['order_id'],
                    'orderProductId' => $orderProduct['orders_products_id'],
                    'productId' => $orderProduct['products_id'],
                    'productName' => $completeProductDetail['name'],
                    'image' => array_pop($completeProductDetail['image']),
                    'colorId' => ($orderProduct['color_id'] > 0) ? $orderProduct['color_id'] : '',
                    'productRating' => $productRating,
                    'dateTitle' => $this->statusArray[$order['order_status']] . ' On',
                    'orderDate' => date("d F Y", strtotime($order['order_received_date'])),
                    'reviewStatus' => $completeProductDetail['status']
                ];
              }
              $data['data'] = $orderDetails;
              $data['success'] = true;
              $data['message'] = 'Success';
            }
          }
          // echo json_encode($data);die;
        } else {
          $data['data'] = array();
          $data['success'] = true;
          $data['message'] = 'Orders list is empty!';
        }
      } else {
        $data['data'] = array();
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['data'] = array();
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function getOrderedProduct() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['orderId'] != '' && $posteddata['orderProductId'] != '') {
        $status = [];
        $statusCode = '';
        $statusTitle = '';
        $statusDate = '';
        $statusTime = '';
        $dateTitle = '';
        $orderDate = '';
        $orderId = $posteddata['orderId'];
        $productOrderId = $posteddata['productId']; //$posteddata['orderProductId'];
        $productId = $posteddata['productId'];
        $otherProducts = [];
        $product = $this->order_model->get_ordered_product($orderId, $productOrderId);
        $size = "";
        if ($product['size_type'] == 'default') {
          $size = size_name($product['size_id']);
        }
        $color = "";
        if ($product['size_type'] == 'default') {
          $color = color_name($product['color_id']);
        }
        $order = $this->order_model->get_order_master($orderId);

        //Order Details
        $statusCode = $statusTitle = $statusDate = $statusTime = $dateTitle = $orderDate = "";
        $status = array();
        $orderStatusID = (int) $order['order_status'];
        //echo $orderStatusID; exit;
        if ($orderStatusID >= 0) {
          foreach ($this->statusArray as $key => $val) {
            //echo "asas";exit;
            if ($key <= '4') {
              //echo "asas";exit;
              $status[] = array(
                  'statusCode' => $key,
                  'statusTitle' => $this->statusArray[$key],
                  'statusDate' => date("d F Y", strtotime($order[$this->statusDateArray[$key]])),
                  'statusTime' => date("h:i", strtotime($order[$this->statusDateArray[$key]])),
              );
              if ($orderStatusID == $key) {
                $statusCode = $order['order_status'];
                $statusTitle = $this->statusArray[$key];
                $statusDate = date("d F Y", strtotime($order[$this->statusDateArray[$key]]));
                $statusTime = date("h:i", strtotime($order[$this->statusDateArray[$key]]));
                $dateTitle = 'Order Delivered on';
                $orderDate = $statusDate;
                break;
              }
            }
          }
          if ($orderStatusID == 5) {
            $status[] = array(
                'statusCode' => 5,
                'statusTitle' => 'Cancelled',
                'statusDate' => date("d F Y", strtotime($order['order_cancelled_date'])),
                'statusTime' => date("h:i", strtotime($order['order_cancelled_date'])),
            );
            $statusCode = $order['order_status'];
            $statusTitle = 'Cancelled';
            $statusDate = date("d F Y", strtotime($order['order_cancelled_date']));
            $statusTime = date("h:i", strtotime($order['order_cancelled_date']));
            $dateTitle = 'Order cancelled on';
            $orderDate = date("d F Y", strtotime($order['order_cancelled_date']));
          }
          if ($orderStatusID == 6) {
            $status[] = array('statusCode' => 6,
                'statusTitle' => 'Returned',
                'statusDate' => date("d F Y", strtotime($product['return_date'])),
                'statusTime' => date("h:i", strtotime($product['return_date'])),
            );
            $statusCode = $order['order_status'];
            $statusTitle = 'Returned';
            $statusDate = date("d F Y", strtotime($product['return_date']));
            $statusTime = date("h:i", strtotime($product['return_date']));
            $dateTitle = 'Order returned on';
            $orderDate = date("d F Y", strtotime($product['return_date']));
          }
          if ($orderStatusID == 7) {
            $status[] = array('statusCode' => 7,
                'statusTitle' => 'Requested for return',
                'statusDate' => date("d F Y", strtotime($product['request_for_return_date'])),
                'statusTime' => date("h:i", strtotime($product['request_for_return_date'])),
            );
            $statusCode = $order['order_status'];
            $statusTitle = 'Requested for return';
            $statusDate = date("d F Y", strtotime($product['request_for_return_date']));
            $statusTime = date("h:i", strtotime($product['request_for_return_date']));
            $dateTitle = 'Order requested for return on';
            $orderDate = date("d F Y", strtotime($product['request_for_return_date']));
          }
          if ($orderStatusID == 8) {
            $status[] = array(
                'statusCode' => 8,
                'statusTitle' => 'Delivered',
                'statusDate' => date("d F Y", strtotime($order['order_delivery_date'])),
                'statusTime' => date("h:i", strtotime($order['order_delivery_date'])),
            );
            $statusCode = $order['order_status'];
            $statusTitle = 'Delivered';
            $statusDate = date("d F Y", strtotime($order['order_delivery_date']));
            $statusTime = date("h:i", strtotime($order['order_delivery_date']));
            $dateTitle = 'Order Delivered on';
            $orderDate = date("d F Y", strtotime($order['order_delivery_date']));
          }
        }

        $completeProductDetail = get_product_by_id($productId, $order['customers_id']);
        $rating = $this->product_model->get_rating_by_product_user($productId, $order['customers_id']);
        $productRating = (!empty($rating)) ? number_format($rating['rating'], 2) : 0.00;
        //$billing_address = $this->users_model->getAddressById($order['billing_address']);
        //$shipping_address = $this->users_model->getAddressById($order['shipping_address']);
        $orderProducts = $this->order_model->get_order_detail($order['order_id']);

        if (count($orderProducts) == 0) {
          $data['success'] = false;
          $data['message'] = 'No Products for this order!';
          //echo json_encode($data); die;
        } else {
          //print_r($product);
          //echo $product['status'];die;
          foreach ($orderProducts as $orderProduct) {
            if ((int) $orderProduct['products_id'] != $productId) {
              $orderProductDetail = get_product_by_id($orderProduct['products_id']);
              $otherProducts[] = [
                  'productId' => $orderProduct['products_id'],
                  'productName' => $orderProduct['product_name'],
                  'image' => $orderProductDetail['image'],
                  'dateTitle' => $dateTitle,
                  'orderDate' => $orderDate
              ];
            }
          }

          if ($product['size_type'] == 'custom') {
            //print_r($completeProductDetail);
            //$sizeCustom = array();
            $sizeCustom = $product['product_size'];
            ///trace($sizeCustom);
            $orderedProduct = [
                'orderId' => $orderId,
                'invoice' => $order['invoice_number'],
                'productId' => $product['products_id'],
                'orderProductId' => $product['orders_products_id'],
                'productName' => $completeProductDetail['name'],
                'image' => $completeProductDetail['image'],
                "size" => (object) [],
                'customSize' => $sizeCustom,
                "billing_address" => [
                    'name' => $order['billing_name'],
                    'address' => $order['billing_address'],
                    'landmark' => $order['billing_landmark'],
                    'city' => $order['billing_city'],
                    'state' => $order['billing_state'],
                    'pincode' => $order['billing_zipcode'],
                ],
                "shipping_address" => [
                    'name' => $order['shipping_name'],
                    'address' => $order['shipping_address'],
                    'landmark' => $order['shipping_landmark'],
                    'city' => $order['shipping_city'],
                    'state' => $order['shipping_state'],
                    'pincode' => $order['shipping_zipcode'],
                ],
                'quantity' => $product['quantity'],
                'productRating' => $productRating,
                'status' => $status,
                'dateTitle' => $dateTitle,
                'colorId' => $product['color_id'],
                'sizeType' => $product['size_type'],
                'colorName' => $color,
                'orderDate' => $orderDate,
                'otherProducts' => $otherProducts,
                'mrp' => (int)($product['product_price'] * $product['quantity']),
                'product_discount' => (int)(($product['product_price'] - $product['product_discounted_price']) * $product['quantity']),
                'deliveryCharges' => ($order['shipping_amount']) ? $order['shipping_amount'] : '0',
                'originalPrice' => (int)$order['total_amount'],
                'totalDiscountedPrice' => (int)($order['total_amount'] - $order['coupon_discount_amount']),
                'totalDiscount' => (int)$order['coupon_discount_amount'],
                'paymentMethod' => ($order['payment_method']) ? $order['payment_method'] : 'COD',
                'paymentStatus' => $order['payment_status'],
                'review' => $completeProductDetail['review'],
                'reviewStatus' => $completeProductDetail['status']
            ];
          } else {
            $orderedProduct = [
                'orderId' => $orderId,
                'invoice' => $order['invoice_number'],
                'orderProductId' => $product['orders_products_id'],
                'productId' => $product['products_id'],
                'productName' => $completeProductDetail['name'],
                'image' => $completeProductDetail['image'],
                "size" => [
                    'size_id' => $product['size_id'],
                    'size_name' => $size
                ],
                "billing_address" => [
                    'name' => $order['billing_name'],
                    'address' => $order['billing_address'],
                    'landmark' => $order['billing_landmark'],
                    'city' => $order['billing_city'],
                    'state' => $order['billing_state'],
                    'pincode' => $order['billing_zipcode'],
                ],
                "shipping_address" => [
                    'name' => $order['shipping_name'],
                    'address' => $order['shipping_address'],
                    'landmark' => $order['shipping_landmark'],
                    'city' => $order['shipping_city'],
                    'state' => $order['shipping_state'],
                    'pincode' => $order['shipping_zipcode'],
                ],
                'quantity' => $product['quantity'],
                'productRating' => $productRating,
                "customSize" => '',
                'status' => $status,
                'dateTitle' => $dateTitle,
                'sizeType' => $product['size_type'],
                'colorId' => $product['color_id'],
                'colorName' => $color,
                'orderDate' => $orderDate,
                'otherProducts' => $otherProducts,
                'mrp' => (int)($product['product_price'] * $product['quantity']),
                'product_discount' => (int)(($product['product_price'] - $product['product_discounted_price']) * $product['quantity']),
                'deliveryCharges' => (int)($order['shipping_amount']) ? $order['shipping_amount'] : '0',
                'originalPrice' => (int)$order['total_amount'],
                'totalDiscountedPrice' => (int)($order['total_amount'] - $order['coupon_discount_amount']),
                'totalDiscount' => (int)$order['coupon_discount_amount'],
                'paymentMethod' => ($order['payment_method']) ? $order['payment_method'] : 'COD',
                'paymentStatus' => $order['payment_status'],
                'review' => $completeProductDetail['review'],
                'reviewStatus' => $completeProductDetail['status']
            ];
          }
          $data['data'] = $orderedProduct;
          $data['success'] = true;
          $data['message'] = 'Success';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function requestForReturn() {//Status has to changed to 7 for request to return
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if (isset($posteddata['userId']) && $posteddata['userId'] != '' && isset($posteddata['orderProductId']) && $posteddata['orderProductId'] != '' && isset($posteddata['orderId']) && $posteddata['orderId'] != '') {
        $userId = $posteddata['userId'];
        $orderId = $posteddata['orderId'];
        $orderProductId = $posteddata['orderProductId'];
        $comment = $posteddata['comment'];
        $order = $this->order_model->get_order_master($orderId);
        if (count($order) > 0) {
          // if ($order['order_status'] < 2) {
          $orderCode = 7;
          $status = $this->order_model->changeOrderStatus($orderCode, $orderProductId, $comment);
          if ($status == 1) {
            $data['success'] = true;
            $data['message'] = 'Success!';
          } else {
            $data['success'] = false;
            $data['message'] = 'Something went wrong!';
          }
          // }else{
          //   $data['success'] = false;
          //   $data['message'] = 'Order can not cancelled after dispatched!';
          // }
        } else {
          $data['success'] = false;
          $data['message'] = 'No Order Available!';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function cancelOrder() {//Status has to changed to 5 for request to return
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if (isset($posteddata['userId']) && $posteddata['userId'] != '' && isset($posteddata['orderId']) && $posteddata['orderId'] != '') {
        $userId = $posteddata['userId'];
        $orderId = $posteddata['orderId'];
        // $comment = $posteddata['comment'];
        $order = $this->order_model->get_order_master($orderId);
        if (count($order) > 0) {
          if ($order['order_status'] < 2) {
            $orderCode = 5;
            $status = $this->order_model->changeOrderStatus('5', $orderId);
            if ($status == 1) {
              $data['success'] = true;
              $data['message'] = 'Success!';
            } else {
              $data['success'] = false;
              $data['message'] = 'Something went wrong!';
            }
          } else if ($order['order_status'] == '5') {
            $data['success'] = false;
            $data['message'] = 'Order already cancelled!';
          } else {
            $data['success'] = false;
            $data['message'] = 'Order can not cancelled after dispatched!';
          }
        } else {
          $data['success'] = false;
          $data['message'] = 'No Order Available!';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function mailInvoice() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['orderId'] != '') {
        $orderId = $posteddata['orderId'];
        $ordmaster = $this->order_model->get_order_master($orderId);
        $orddetail = $this->order_model->get_order_detail($orderId);
        if (is_array($ordmaster) && !empty($ordmaster)) {
          ob_start();
          $mail_subject = $this->config->item('site_name') . " Order Oerview";
          $from_email = $this->admin_info->admin_email;
          $from_name = $this->config->item('site_name');
          $mail_to = $ordmaster['email'];
          $msg = invoice_content_mail($ordmaster, $orddetail);
          //$msg = ob_get_contents();
          $mail_conf = array(
              'subject' => $this->config->item('site_name') . " Order overview",
              'to_email' => $mail_to,
              'from_email' => $from_email,
              'from_name' => $this->config->item('site_name'),
              'body_part' => $msg
          );
          $this->dmailer->mail_notify($mail_conf);
          //trace($mail_conf); die;
          $data['success'] = true;
          $data['message'] = 'Invoice Sent!';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token!';
    }
    echo json_encode($data);
  }

  public function setBillingShippingAddress() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['orderId'] != '' && $posteddata['shippingAddress'] != '' && $posteddata['billingAddress'] != '') {
        $orderId = $posteddata['orderId'];
        $shippingAddress = $posteddata['shippingAddress'];
        $billingAddress = $posteddata['billingAddress'];
        $isSame = $posteddata['isSame'];
        if ($isSame) {
          $billingAddress = $shippingAddress;
        }
        $billing_address = $this->users_model->getAddressById($billingAddress);
        $shipping_address = $this->users_model->getAddressById($shippingAddress);
        if (!empty($billing_address) && !empty($shipping_address)) {
          $status = $this->order_model->setShippingBillingAddress($orderId, $shippingAddress, $billingAddress);
          if ($status == '0') {
            $data['success'] = false;
            $data['message'] = 'Order Not Available!';
          } else {
            $billing = [
                'id' => $billingAddress,
                'name' => $billing_address['name'],
                'house' => $billing_address['house'],
                'city' => $billing_address['city'],
                'locality' => $billing_address['locality'],
                'street' => $billing_address['street'],
                'pincode' => $billing_address['pincode'],
            ];
            $shipping = [
                'id' => $shippingAddress,
                'name' => $shipping_address['name'],
                'house' => $shipping_address['house'],
                'city' => $shipping_address['city'],
                'locality' => $shipping_address['locality'],
                'street' => $shipping_address['street'],
                'pincode' => $shipping_address['pincode'],
            ];
            $data['billingAddress'] = $billing;
            $data['shippingAddress'] = $shipping;
            $data['success'] = true;
            $data['message'] = 'Success!';
          }
        } else {
          $data['success'] = false;
          $data['message'] = 'Address Not Available!';
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function createOrderOld() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $userId = $posteddata['userId'];
        $cartItems = $this->cart_model->get_cart_items($userId);
        $user = $this->users_model->detail($userId);
        // print_r($user);
        //Get Products from cart
        $totalPrice = 0;
        if (count($cartItems) > 0) {
          foreach ($cartItems as $item) {
            // print_r($item);
            $totalPrice += ($item['product_discounted_price'] == '') ? $item['product_price'] : $item['product_discounted_price'];
          }
          $order = [
              'customers_id' => $userId,
              'first_name' => $user->first_name,
              'email' => $user->user_name,
              'total_amount' => $totalPrice,
              'order_status' => 10
          ];
          $orderId = $this->order_model->safe_insert('wps_order', $order, false);
          // echo $orderId;
          foreach ($cartItems as $item) {
            // print_r($item);
            $product = get_product_by_id($item['product_id']);
            $orderProductData = [
                'color_id' => $item['color_id'],
                'order_id' => $orderId,
                'size_id' => $item['size_id'],
                'products_id' => $item['product_id'],
                'quantity' => $item['quantity'],
                'product_price' => (int)$item['product_price'],
                'product_discounted_price' => (int)$item['product_discounted_price'],
                'custom_size' => $item['custom_size'],
                'size_type' => $item['size_type'],
            ];
//          $this->cart_model->changeCartItemStatus($item['id']);
            $this->order_model->addOrderProduct($orderProductData);
          }
        }
        $data['success'] = true;
        $data['message'] = 'Success';
        $data['orderId'] = $orderId;
        //change the status of cart to 2
        //Add the product details in wps_order_products
        //Create an order.
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
    }
    echo json_encode($data);
  }

  public function createOrder() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    //trace($posteddata);
    if (verifyToken($posteddata['userId'])) {
      if ($posteddata['userId'] != '') {
        $userId = $posteddata['userId'];
        $cartItems = $this->cart_model->get_cart_items($userId);
        //trace($cartItems);
        $costumer_data = $this->users_model->detail($userId);
        //trace($user);
        if (is_array($cartItems) && !empty($cartItems)) {
          $invoice_number = "NBS_" . get_auto_increment('wps_order');
          //create ORDER
          $coupon_id = $posteddata['couponId'];
          $discount_amount = $posteddata['discountAmount'];
          $payment_method = $posteddata['paymentMethod'];
          $customers_id = ( $userId != '') ? $userId : 0;
          $cart_total = $posteddata['total'];
          $tax_cent = 0;
          $ship_method = 'none';
          $ship_amount = 0;
          $cod_amount = 0;
          $tax = ($cart_total * $tax_cent) / 100;
          $shippingData = $posteddata['shippingAddress'];
          $billingData = $posteddata['billingAddress'];
          $data_order = array(
              'customers_id' => $customers_id,
              'invoice_number' => $invoice_number,
              'first_name' => $costumer_data->first_name,
              'last_name' => $costumer_data->last_name,
              'email' => $costumer_data->user_name,
              'billing_title' => $billingData['title'],
              'billing_name' => $billingData['fullName'],
              'billing_phone' => $billingData['mobileNo'],
              'billing_address' => $billingData['address'],
              'billing_landmark' => $billingData['landmark'],
              'billing_zipcode' => $billingData['pincode'],
              'billing_country' => $billingData['country'],
              'billing_city' => $billingData['city'],
              'billing_state' => $billingData['state'],
              'shipping_title' => $shippingData['title'],
              'shipping_name' => $shippingData['fullName'],
              'shipping_phone' => $shippingData['mobileNo'],
              'shipping_address' => $shippingData['address'],
              'shipping_landmark' => $shippingData['landmark'],
              'shipping_zipcode' => $shippingData['pincode'],
              'shipping_country' => $shippingData['country'],
              'shipping_state' => $shippingData['state'],
              'shipping_city' => $shippingData['city'],
              'last_shopping_comment' => '',
              'shipping_method' => $ship_method,
              'discount_coupon_id' => $coupon_id,
              'coupon_discount_amount' => $discount_amount,
              'shipping_amount' => $ship_amount,
              'cod_amount' => $cod_amount,
              'total_amount' => $cart_total,
              'vat_amount' => $tax,
              'vat_applied_cent' => $tax_cent,
              'currency_code' => 'IND',
              'currency_value' => '1.00',
              'order_status' => '0',
              'order_received_date' => $this->config->item('config.date.time'),
              'payment_method' => $payment_method,
              'payment_status' => 'Unpaid'
          );

          if (!$this->cart_model->is_order_no_exits($invoice_number)) {
            $orderId = $this->cart_model->safe_insert('wps_order', $data_order, FALSE);

            foreach ($cartItems as $items) {
              $product = get_product_by_id($items['product_id']);
              $img = $product['image'][0];
              $image_file = $img;
              $file_data = file_get_contents($image_file);
              $dataProduct = array(
                  'order_id' => $orderId,
                  'products_id' => $items['product_id'],
                  'product_name' => $product['name'],
                  'product_code' => $product['productCode'],
                  'product_image' => $file_data,
                  'product_price' => ($items['product_discounted_price'] > 0) ? $items['product_discounted_price'] : $items['product_price'],
                  'quantity' => $items['quantity'],
                  'color_id' => @$items['color_id'],
                  'size_id' => @$items['size_id'],
                  'product_size' => $items['custom_size'],
                  'size_type' => $items['size_type'],
              );
              $this->cart_model->safe_insert('wps_orders_products', $dataProduct, FALSE);
            }
          }

          if ($payment_method == 'Cash') {
            //empty cart
            $this->db->query("DELETE FROM wps_cart WHERE user_id = '" . $userId . "'");
            $data['success'] = true;
            $data['message'] = 'Success';
            $data['orderId'] = $orderId;
          }elseif($payment_method == 'Paytm'){
              $checkSum = "";
              $paramList = array();
              $ORDER_ID = $orderId;
              $CUST_ID = $customers_id;
                $INDUSTRY_TYPE_ID = 'Retail';
                $CHANNEL_ID = 'WAP';
                $TXN_AMOUNT = sprintf('%0.2f', ($cart_total-$discount_amount));
              
              //****Test Mode***//
//              $MID = 'LRiCLb38863804200894';
//              $Merchant_Key = '@D9T99xBgQ9Wqxhi';
//              $WEBSITE = 'APPSTAGING';
//              $CALLBACK_URL = 'https://securegw-stage.paytm.in/theia/paytmCallback?ORDER_ID='.$ORDER_ID;
              //****Test Mode***//
              
              //****Live Mode***//
              $MID = PAYTM_MERCHANT_MID;
              $Merchant_Key = PAYTM_MERCHANT_KEY;
              $WEBSITE = PAYTM_MERCHANT_WEBSITE;
              $CALLBACK_URL = 'https://securegw.paytm.in/theia/paytmCallback?ORDER_ID='.$ORDER_ID;
              //****Live Mode***//
              
              $paramList["MID"] = $MID;
              $paramList["ORDER_ID"] = $ORDER_ID;
              $paramList["CUST_ID"] = $CUST_ID;
              $paramList["INDUSTRY_TYPE_ID"] = $INDUSTRY_TYPE_ID;
              $paramList["CHANNEL_ID"] = $CHANNEL_ID;
              $paramList["TXN_AMOUNT"] = $TXN_AMOUNT;
              $paramList["WEBSITE"] = $WEBSITE;
              $paramList['CALLBACK_URL'] = $CALLBACK_URL;

              $checkSum = getChecksumFromArray($paramList, $Merchant_Key);
              $data['success'] = true;
              $data['message'] = 'Success';
              $data['orderId'] = $orderId;
              $data['checksum'] = $checkSum;
              $data['mid'] = $MID;
              $data['custId'] = $CUST_ID;
              $data['channelId'] = $CHANNEL_ID;
              $data['tnxAmount'] = $TXN_AMOUNT;
              $data['website'] = $WEBSITE;
              $data['industryTypeId'] = $INDUSTRY_TYPE_ID;
              $data['callbackUrl'] = $CALLBACK_URL;
          }
          echo json_encode($data);
        } else {
          $data['success'] = false;
          $data['message'] = 'There are no Item(s) in your cart.';
          echo json_encode($data);
        }
      } else {
        $data['success'] = false;
        $data['message'] = 'Required Parameter Missing!';
        echo json_encode($data);
      }
    } else {
      $data['success'] = false;
      $data['message'] = 'Invalid Token';
      echo json_encode($data);
    }
  }

  public function paymentStatus(){
    $posteddata = json_decode(file_get_contents('php://input'), true);
    $paytmChecksum = "";
    $paramList = array();
    $isValidChecksum = "FALSE";
    $user_id = $posteddata['userId'];
    $paramList = $posteddata['response'];

    $paytmChecksum = isset($paramList["CHECKSUMHASH"]) ? $paramList["CHECKSUMHASH"] : "";
      
    //****Test Mode***// 
    //$isValidChecksum = verifychecksum_e($paramList, '@D9T99xBgQ9Wqxhi', $paytmChecksum);
     //****Test Mode***// 
      
      
    //****Live Mode***//  
    $isValidChecksum = verifychecksum_e($paramList, PAYTM_MERCHANT_KEY, $paytmChecksum);
    //****Live Mode***//
      
    if ($isValidChecksum == "TRUE") {
       if ($paramList["STATUS"] == "TXN_SUCCESS") {
            $this->db->query("DELETE FROM wps_cart WHERE user_id = '" . $user_id . "'");
            $response = json_encode($posteddata['response']);
            $data1 = array('payment_method' => 'Paytm', 'payment_status' => 'Paid', 'paymentResponse' => $response);
            $where = "order_id = '$paramList[ORDERID]'";
            $this->payment_model->safe_update('wps_order', $data1, $where, false);
           
           $res = get_db_field_value('wps_order', 'order_id', array('order_id' => $paramList['ORDERID']));
           $ordmaster = $this->order_model->get_order_master($res);
           $orddetail = $this->order_model->get_order_detail($res);
           if (is_array($ordmaster) && !empty($ordmaster)) {
              ob_start();
              $from_email = $this->admin_info->admin_email;
              $from_name = $this->config->item('site_name');
              $mail_to = $ordmaster['email'];
              $body = invoice_content_mail($ordmaster, $orddetail);
              $msg = ob_get_contents();
              $mail_conf = array(
                  'subject' => $this->config->item('site_name') . " Order Overview",
                  'to_email' => $mail_to,
                  'from_email' => $from_email,
                  'from_name' => $this->config->item('site_name'),
                  'body_part' => $body
              );
              $this->dmailer->mail_notify($mail_conf);
            }
            $data['success'] = true;
            $data['message'] = 'Transaction Successful.';
            $data['orderId'] = $paramList['ORDERID'];
            echo json_encode($data);
       }else{
            $data['success'] = false;
            $data['message'] = 'Transaction Failed.';
            echo json_encode($data);
       }
    }else{
        $data['success'] = false;
        $data['message'] = 'Checksum mismatched';
        echo json_encode($data);
    }
  }

  public function orderDetails() {
    $posteddata = json_decode(file_get_contents('php://input'), true);
    //trace($posteddata);
    //if (verifyToken($posteddata['userId'])) {
    if ($posteddata['userId'] != '') {
      $userId = $posteddata['userId'];
      $orderId = $posteddata['orderId'];
      $ordmaster = $this->order_model->get_order_master($orderId);
      $orddetail = $this->order_model->get_order_detail($orderId);
      $ordDetails = array();
      foreach ($orddetail as $dets) {
        unset($dets['product_image']);
        if ($dets['size_type'] == 'default') {
          $dets['colorName'] = color_name($dets['color_id']);
          $dets['sizeName'] = size_name($dets['size_id']);
        } else {
          $dets['colorName'] = "";
          $dets['sizeName'] = "";
        }
        $ordDetails[] = $dets;
      }
      $data['orderRes'] = $ordmaster;
      $data['orderProducts'] = $ordDetails;
      $data['success'] = true;
      $data['message'] = 'Success';
    } else {
      $data['success'] = false;
      $data['message'] = 'Required Parameter Missing!';
    }
    //} else {
    //$data['success'] = false;
    //$data['message'] = 'Invalid Token';
    //}
    echo json_encode($data);
  }

}
