<?php

class Customization_gallery extends Admin_Controller {

  public function __construct() {
    parent::__construct();

    $this->load->model(array('order/order_model','customization_gallery/customization_gallery_model'));
    $this->load->helper(array('cart/cart', 'file'));
    $this->config->set_item('menu_highlight', 'orders management');
    $this->load->library(array('Dmailer'));
  }
      
    function index(){
        if ($this->input->post('status_action') != '') {
            $act=$this->input->post('status_action');
            $prod_id = $this->input->post('arr_ids');
            $ids="'".implode("','", $prod_id)."'"; 
            $up_where="`id` in ($ids)"; // update_where cond
            if ($act == 'Delete') { 
                foreach ($prod_id as $v) {
                    $where = array('id' => $v);
                    $this->customization_gallery_model->safe_delete('gallery', $where, TRUE);
                }
            }else if($act == 'Activate'){
                $data['status']="1";
                $this->customization_gallery_model->safe_update('gallery',$data,$up_where);
            }else if($act == 'Deactivate'){
                $data['status']="2";
                $this->customization_gallery_model->safe_update('gallery',$data,$up_where);
            }
          $this->session->set_flashdata('success', lang('deleted'));
        }
        $medias=$this->db->query("select * from gallery")->result_array();
        $data['res']=$medias;
        $data['heading_title']='Gallery';
        $data['add_link']='sitepanel/customization_gallery/add_gallery';
        $data['edit_link']='sitepanel/customization_gallery/edit_gallery';
        $this->load->view('customization_gallery/list',$data);
    }
    
   
  
    
    function add_gallery(){
        $data['errs']=array();
        $data['media_type']='gallery';
        $data['req']='required';
        $data['dtl']=array('title'=>'');
        if(is_post()){
            $post=$this->input->post();
            $this->form_validation->set_rules('title','Title','required');
            $this->form_validation->set_rules('media','File','required|file_allowed_type[image]'); 
            try{
                if($this->form_validation->run() == FALSE){
                    throw new Exception('Gallery Not Added Check Form Error');
                }
                if (!empty($_FILES) && $_FILES['media']['name'] != '') {
        			$config['max_size'] = '2048';
        			$this->load->library('upload');
        
        			$uploaded_data = $this->upload->my_upload('media', 'gallery', 1400,550);
        
        			if (!is_array($uploaded_data) or empty($uploaded_data)) {
        				throw new Exception('File Not Uploaded');
        			}
        			$uploaded_file = $uploaded_data['upload_data']['file_name'];
        			$data_ins['title']=$post['title'];
        			$data_ins['type']=$post['type'];
        			$data_ins['path']=$uploaded_file;
        			$this->customization_gallery_model->add_media($data_ins, FALSE);
        			set_success('Gallery Added Successfully');
        			redirect('sitepanel/customization_gallery');
        		}
            }catch(\Exception $e){ 
                $data['errs']=$this->form_validation->error_arr();
                set_err($e->getMessage());
            }
        }
        $data['heading_title']="Add Gallery";
        $this->load->view('customization_gallery/form',$data);
    }
        
    function edit_gallery($id){
        $data['errs']=array();
        $data['req']='';
        $dtl=get_db_single_row('gallery','*',"id='$id'");
        if(!$dtl){
            set_err('Media Not Found');
            redirect('sitepanel/customization_gallery');
        }
        $dtl['img']=get_image('gallery', $dtl['path'], 250, 250, 'AR');
        $data['media_type']='gallery';
        
        $p_name=str_replace('_',' ',$dtl['type']);
        $data['dtl']=$dtl;
        if(is_post()){
            
            $post=$this->input->post();
            $this->form_validation->set_rules('title','Title','required');
            try{
                if($this->form_validation->run() == FALSE){
                    throw new Exception('Print Media Not Added Check Form Error');
                }
                if (!empty($_FILES) && $_FILES['media']['name'] != '') {
        			$config['max_size'] = '2048';
        			$this->load->library('upload');
        
        			$uploaded_data = $this->upload->my_upload('media', 'gallery',1400,550);
        
        			if (!is_array($uploaded_data) or empty($uploaded_data)) {
        				throw new Exception('File Not Uploaded');
        			}
        			$uploaded_file = $uploaded_data['upload_data']['file_name'];
        			$data_ins['path']=$uploaded_file;
        		}
        		$data_ins['title']=$post['title'];
    			$this->customization_gallery_model->update_media($data_ins, $id);
    			set_success('Gallery Updated Successfully');
    			redirect('sitepanel/customization_gallery');
            }catch(\Exception $e){ 
                $data['errs']=$this->form_validation->error_arr();
                set_err($e->getMessage());
            }
        }
        $data['heading_title']="Edit $p_name";
        $this->load->view('customization_gallery/form',$data);
    }

    
}