<?php 
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");
    $meta_rec = $this->meta_info;
    $uri_parts = explode('?', $_SERVER['REQUEST_URI'], 2);
    $actual_link2=(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http")."://$_SERVER[HTTP_HOST]$uri_parts[0]";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" href="<?= theme_url()?>images/favicon.ico" type="image/x-icon">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo $meta_rec['meta_title']; ?></title>
    <meta name="description" content="<?php echo $meta_rec['meta_description']; ?>">
    <meta name="keywords" content="<?php echo $meta_rec['meta_keyword']; ?>" />
    <link rel="canonical" href="<?php echo $actual_link2; ?>">
    <meta name="author" content="<?= $this->config->item('site_name')?>" />
    <meta name="publisher" content="<?= $this->config->item('site_name')?>"/>
    <meta name="robots" content="ALL" /> 
    <link rel="stylesheet" href="<?= theme_url() ?>css/bootstrap.min.css" type="text/css">
    <link rel="stylesheet" href="<?= theme_url() ?>css/bone-chokers-style.css" type="text/css">
    <link href="<?= theme_url() ?>css/font-awesome.css" rel="stylesheet" type="text/css" />
    <link href="<?= theme_url() ?>css/responsive.css" rel="stylesheet" type="text/css" />
    <link href="<?= theme_url() ?>css/owl.carousel.css" rel="stylesheet" type="text/css" />
    <link href="<?= theme_url() ?>css/owl.theme.css" rel="stylesheet" type="text/css" />
    <link href="<?= theme_url() ?>css/sidemenu.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/malihu-custom-scrollbar-plugin/3.1.5/jquery.mCustomScrollbar.min.css">
    <link href="<?= theme_url() ?>magiczoomplus/magiczoomplus.css" rel="stylesheet" type="text/css" />
    <link href="<?= theme_url() ?>magiczoomplus/magiczoomplus-inline.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" > var site_url = '<?php echo site_url(); ?>';</script>
<script type="text/javascript" > var theme_url = '<?php echo theme_url(); ?>';</script>
<script type="text/javascript" > var resource_url = '<?php echo resource_url(); ?>';</script>
    

<!-- Google tag (gtag.js) --> 
<script async src="https://www.googletagmanager.com/gtag/js?id=G-XC98NESHR9"></script> 
<script> window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', 'G-XC98NESHR9'); </script> 
    <meta name="google-site-verification" content="Pe-99dyoc8xl6jTdWIKrJfXxQlKVLLmywXwzvhbpiu8" />
</head>
<body>
    <div class="overlay"></div>
  
    <div class="search-overlay" id="open-search-p">
        <div class="from-close">x</div>
        <div class="search-in-section">
            <form action="<?php echo base_url(); ?>search" method="post" >
                <div class="form-group">
                    <div class="pos-r">
                        <input type="text" name="keyword_search" required="" placeholder="Search Products" class="from-new has-empty" value="Search Products" onfocus="if (this.value == 'Search Products') {this.value = '';}" onblur="if (this.value == '')">
                        <label class="form-label" for="contact" style="color: #fff;"></label>
                        <button><i class="fa fa-search" aria-hidden="true"></i></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <header>
        <div class="tophead">           
                <div class="container text-center thw100">
                    <div class="col-lg-12 col-md-12 col-sm-10 col-xs-10">
                <ul class="top-social">
                    <!-- <li> Free Shipping on Orders Over $75</li>
                    <li>|</li> -->
                    <?php if($this->session->userdata('user_id') > 0){ ?>
                    <li><a href="<?= base_url()?>members/" title="My Account" class="">My Account </a></li> | 
                    <li><a href="<?= base_url()?>users/logout" title="Logout" class="">Logout </a></li>
                    <?php }else{ ?>
                    <li><a href="<?= base_url()?>users/login" title="Sign In" class="">Sign in </a></li>
                    <li>or </li>
                    <li><a href="<?= base_url()?>users/login?q=register" title="Register" class="">Create an account</a></li>
                    <?php }  ?>
                </ul>
            </div>
                      
                    </div>
            
        </div>
        <div class="header">
             <div class="navigation_bar">
            <div class="container">
            <div class="col-lg-3 col-md-3 col-sm-3 col-xs-2 dn-fxds">
                <nav class="nav_menutop">
                    <ul>
                        <li id="search-btn">
                            <button> <i class="fa fa-search" aria-hidden="true"></i><span class="hidden-xs hidden-sm">Search Entire Store Here...</span></button>
                        </li>
                    </ul>
                </nav>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 text-center">
                <a href="<?= base_url() ?>"><img src="<?= theme_url() ?>images/logo.png" class="logo lgw" alt="<?= $this->config->item('site_name')?>" title="<?= $this->config->item('site_name')?>" /></a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-3 col-xs-4 dn-fxds">
                <nav class="nav_menutop pull-right">
                    <ul>
                        
                        <li><a href="<?= base_url()?>members/mywishlist" title="Wishlist"><i class="fa fa-heart"></i><span class="hidden-xs hidden-sm">Wishlist</span></a></li>
                        <li>
                            <a href="<?= base_url()?>cart" title="Cart" class="white tcrel"><i class="fa fa-shopping-bag"></i><span class="hidden-xs">Cart</span><span class="cart-cap-text"><?= count($this->cart->contents())?></span></a>
                            <?php if(count($this->cart->contents()) > 0){?>
                               <ul class="wps-shop-dash">
                                           <li class="hvr-underline-from-left">
                                               <div class="dropdown-menu">
                                                   <div class="scrollpane">
                                                   
                           <?php
                        $cart = $this->cart->contents();
                        $totalAmount = $pprice = 0;
                        foreach ($cart as $items) {
                          // trace($items);die;
                          $pprice = $items['price'] * $items['qty'];
                          $totalAmount += $pprice;
                          $img = get_db_field_value("wps_products_media", "media", "WHERE products_id = '" . $items['pid'] . "' ORDER BY id asc LIMIT 0, 1");
                          $img_link = get_image_with_name($items['origname'],'product_images', $items['img'], '260', '390', 'R');
                  $opt = imagealtTitle('Buy', ucwords(strtolower($items['origname'])), '');
                          ?>
                                    
                                                   <div class="row cart-detail">
                                                       <div class="col-lg-4 col-sm-4 col-4 col-xs-4 cart-detail-img">
                                                           <img src="<?= $img_link ?>" alt="<?= $opt ?>" title="<?= $opt ?>">
                                                       </div>
                                                       <div class="col-lg-8 col-sm-8 col-8 col-xs-8 cart-detail-product">
                                                           <p><?= $items['origname'] ?></p>
                                                           <span class="price text-info"> <?= display_price($items['price']) ?></span> <span class="count"> Quantity:<?= $items['qty'] ?></span>
                                                       </div>
                                                   </div>
                                               <?php } ?>
                                                   <div class="row total-header-section">
                                                       <div class="col-lg-6 col-sm-6 col-6 col-xs-4">
                                                           
                                                       </div>
                                                       <div class="col-lg-6 col-sm-6 col-6 col-xs-8 total-section text-right">
                                                           <p>Total: <span class="text-info"><?= display_price($totalAmount) ?></span></p>
                                                       </div>
                                                   </div>
                                                       </div>
                                                   <div class="row">
                                                       <div class="col-lg-12 col-sm-12 col-12  text-center checkout">
                                                           <a href="<?= site_url() ?>cart"class="btn btn-primary btn-block">Checkout</a>
                                                       </div>
                                                   </div>
                                               </div>

                                           </li>
                                       </ul>
                                   <?php }?>
                                 
                        </li>
                    </ul>
                </nav>
            </div>
        </div>
<?php 
    $cat_res = $this->db->query("SELECT * FROM wps_categories where parent_id = '0' order by sort_order asc")->result_array();
?>
           
                
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="navigation text-center">
                        <div class="navbar"><button><i class="fa fa-bars"></i></button></div>
                        <div class="menu">
                            <ul class="nav">
                                <?php foreach($cat_res as $key => $value){ 
                                  $subcat_res = $this->db->query("SELECT * FROM wps_categories where parent_id = ".$value['category_id']."")->result_array(); 
                                   ?>
                                    <li class="cs-submenu active">
                                        <a href="<?= site_url($value['friendly_url'])?>" title="<?= $value['category_name'] ?>">
                                           <?= $value['category_name'] ?>
                                            <div class="dropdown-expander button"><i class="fa fa-chevron-down"></i></div>
                                        </a>
                                        <?php if(count($subcat_res)>0){ ?>
                                        <ul class="cs-dropdown">
                                           <?php foreach($subcat_res as $key => $subval){  ?>
                                            <li><a href="<?= site_url($subval['friendly_url'])?>" title="<?= $subval['category_name'] ?>"><?= $subval['category_name'] ?></a></li>
                                          <?php } ?>
                                        </ul>
                                      <?php } ?>
                                    </li>
                                <?php } ?>
                                
                                
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>