<?php 
include_once("include/main.inc.php");
$hover = 'Infrastructure Photos';
$page_metatitle = "Infrastructure Photos - " . $admin_res['companyName'];
$page_metakey = "Infrastructure Photos - " . $admin_res['companyName'];
$page_metadesc = "Infrastructure Photos - " . $admin_res['companyName'];
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
  
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>


    <div class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/infrastructure-photos.webp)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Scenic Infrastructure Snapshots - <?=$admin_res['companyName'];?></h1>
                    <div class="clearfix"></div>
                    <div class="cat_title2">Step into a world where elegant design meets nature’s beauty, creating spaces that inspire, relax, and captivate.</div>
                </div>
            </div>
        </div>
    </div>

    <div class="breadcrumbSection hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li><a href="<?=site_url;?>/about-us.htm">About Us</a></li>
                        <li class="active">Infrastructure Photos</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <div class="infrastructurePage">
        <div class="container">
            <h2 class="title_2">Snapshots of Innovation: A Glimpse into Modern Infrastructure</h2>
            <div class="maxWidth">
                <p>Take a visual tour through a collection of stunning photos showcasing the perfect blend of nature and luxury. From expansive event halls to peaceful outdoor spaces, every area is designed with elegance and comfort in mind. These images capture the essence of a venue where memorable moments are crafted in a beautiful setting.</p>
            </div>
            <div class="clearfix"></div>
            <div class="row">
            <?php $gallery_award_sql= mysqli_query($GLOBALS['dbconn'], "select title,image,gallery_id,id from process_tbl order by id ASC"); 
while($gallery_res= mysqli_fetch_assoc($gallery_award_sql)){ 
   $galImg=getImage($gallery_res[image], 374, 250, $gallery_res[title].$gallery_res[id],"/uploaded-files/gallery/photos/");
   $galImg1= getImage($gallery_res[image], 680, 453, $gallery_res[title].$gallery_res[id],"/uploaded-files/gallery/photos/") ;
   ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                    <div class="gallery_item">
                        <a class="hover_effect infrastructure h_yellow" data-fancybox="photo-gallery" href="<?=$galImg1;?>" title="<?=$gallery_res['title'];?>">
                            <img src="<?=$galImg;?>" alt="<?=$gallery_res['title'];?> in <?= $admin_res['targetlocation']; ?>" 
                            title="<?=$gallery_res['title'];?> in <?= $admin_res['targetlocation']; ?>">
                        </a>
                    </div>
                </div>
                <?php } ?>

                

            </div>
        </div>
    </div>
    <?php include "app_testimonials.php"; ?>
    <!-- <?php include "app_clients.php"; ?> -->
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>