<?php 
    include_once("include/main.inc.php"); 
    $page_metatitle = $page_metakey = $page_metadesc= "Video Gallery - ".COMPANY_NAME;
    $videos = mysqli_query($dbconn, "SELECT * FROM video_tbl where id !='10' &&  id !='11' && id !='12' && id !='13' && id !='18' && id !='19' && id !='21'");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?= $page_metatitle; ?></title>
    <meta name="keywords" content="<?= $page_metakey; ?>" />
    <meta name="description" content="<?= $page_metadesc; ?>" />
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>
    <section class="heading_banner" style="background-image: url(designer/images/about-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Video Gallery</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url ?>" title="Home">Home</a></li>
                        <li class="active">Video Gallery</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <section class="gallery_page">
        <div class="container">
            <h2 class="title_2">Video Gallery</h2>
            <div class="clearfix"></div>
            <div class="row g-3">
                <?php 
                    while($video = mysqli_fetch_array($videos)){
                        $imglink  = parse_url($video['slink_url']);
                        parse_str($imglink['query'], $img);
                ?>
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="vd_bx">
                        <img src="https://img.youtube.com/vi/<?= $img['v']; ?>/0.jpg" alt="<?= $video['slink_title']; ?>" title="<?= $video['slink_title']; ?>">
                        <a href="<?= $video['slink_url']; ?>" data-fancybox="" class="video-play-icon" title="<?= $video['slink_title']; ?>">
                            <svg version="1.1" viewBox="0 0 68 48">
                                <path class="ytp-large-play-button-bg" d="M66.52,7.74c-0.78-2.93-2.49-5.41-5.42-6.19C55.79,.13,34,0,34,0S12.21,.13,6.9,1.55 C3.97,2.33,2.27,4.81,1.48,7.74C0.06,13.05,0,24,0,24s0.06,10.95,1.48,16.26c0.78,2.93,2.49,5.41,5.42,6.19 C12.21,47.87,34,48,34,48s21.79-0.13,27.1-1.55c2.93-0.78,4.64-3.26,5.42-6.19C67.94,34.95,68,24,68,24S67.94,13.05,66.52,7.74z" fill="#f00"></path>
                                <path d="M 45,24 27,14 27,34" fill="#fff"></path>
                            </svg>
                        </a>
                        <h3 class="tt"><?= $video['slink_title']; ?></h3>
                    </div>
                </div>
                <?php } ?>

                <!-- <div class="col-lg-4 col-md-6 col-12">
                    <div class="vd_bx">
                        <img src="designer/images/video/video2.jpg" alt="" title="">
                        <a href="https://www.youtube.com/watch?v=gSDgfqAW8LM" data-fancybox="" class="video-play-icon" title="">
                            <svg version="1.1" viewBox="0 0 68 48">
                                <path class="ytp-large-play-button-bg" d="M66.52,7.74c-0.78-2.93-2.49-5.41-5.42-6.19C55.79,.13,34,0,34,0S12.21,.13,6.9,1.55 C3.97,2.33,2.27,4.81,1.48,7.74C0.06,13.05,0,24,0,24s0.06,10.95,1.48,16.26c0.78,2.93,2.49,5.41,5.42,6.19 C12.21,47.87,34,48,34,48s21.79-0.13,27.1-1.55c2.93-0.78,4.64-3.26,5.42-6.19C67.94,34.95,68,24,68,24S67.94,13.05,66.52,7.74z" fill="#f00"></path>
                                <path d="M 45,24 27,14 27,34" fill="#fff"></path>
                            </svg>
                        </a>
                        <div class="tt">Outdoor Furniture | The Courtyard</div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="vd_bx">
                        <img src="designer/images/video/video3.jpg" alt="" title="">
                        <a href="https://www.youtube.com/watch?v=x5kw6XaED7k" data-fancybox="" class="video-play-icon" title="">
                            <svg version="1.1" viewBox="0 0 68 48">
                                <path class="ytp-large-play-button-bg" d="M66.52,7.74c-0.78-2.93-2.49-5.41-5.42-6.19C55.79,.13,34,0,34,0S12.21,.13,6.9,1.55 C3.97,2.33,2.27,4.81,1.48,7.74C0.06,13.05,0,24,0,24s0.06,10.95,1.48,16.26c0.78,2.93,2.49,5.41,5.42,6.19 C12.21,47.87,34,48,34,48s21.79-0.13,27.1-1.55c2.93-0.78,4.64-3.26,5.42-6.19C67.94,34.95,68,24,68,24S67.94,13.05,66.52,7.74z" fill="#f00"></path>
                                <path d="M 45,24 27,14 27,34" fill="#fff"></path>
                            </svg>
                        </a>
                        <div class="tt">Create your dreams outdoor space</div>
                    </div>
                </div> -->
            </div>
        </div>
    </section>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>