<?php 
    include_once("include/main.inc.php"); 
    $page_metatitle = $page_metakey = $page_metadesc= "Photo Gallery - ".COMPANY_NAME;
    $galarys = mysqli_query($dbconn, "SELECT * FROM photo_tbl");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?= $page_metatitle; ?></title>
    <meta name="keywords" content="<?= $page_metakey; ?>" />
    <meta name="description" content="<?= $page_metadesc; ?>" />
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>
    <section class="heading_banner" style="background-image: url(<?= site_url ?>/designer/images/about-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Photo Gallery</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url ?>" title="Home">Home</a></li>
                        <li class="active">Photo Gallery</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <section class="gallery_page">
        <div class="container">
            <h2 class="title_2">Photo Gallery</h2>
            <div class="clearfix"></div>
            <div class="row g-3">
                <?php 
                    while($photo = mysqli_fetch_array($galarys)){
                        $gimg = getImage($photo['image'], 381, 381, $photo['title'], "/uploaded-files/gallery/photos/");
                ?>
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="award-bx">
                        <a href="<?= site_url ?>/uploaded-files/gallery/photos/<?= $photo['image'] ?>" data-fancybox="" class="img" title="<?= $photo['title'] ?>">
                            <img src="<?= $gimg; ?>" alt="<?= $photo['title'] ?>" title="<?= $photo['title'] ?>">
                        </a>
                        <span class="link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                viewBox="0 0 16 16">
                                <path fill-rule="evenodd"
                                    d="M6.5 12a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11zM13 6.5a6.5 6.5 0 1 1-13 0 6.5 6.5 0 0 1 13 0z">
                                </path>
                                <path
                                    d="M10.344 11.742c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1 6.538 6.538 0 0 1-1.398 1.4z">
                                </path>
                                <path fill-rule="evenodd"
                                    d="M6.5 3a.5.5 0 0 1 .5.5V6h2.5a.5.5 0 0 1 0 1H7v2.5a.5.5 0 0 1-1 0V7H3.5a.5.5 0 0 1 0-1H6V3.5a.5.5 0 0 1 .5-.5z">
                                </path>
                            </svg>
                        </span>
                        <div class="tx-bx">
                            <div class="tt"><?= $photo['caption'] ?></div>
                        </div>
                    </div>
                </div>
                <?php } ?>
                <!-- <div class="col-lg-4 col-md-6 col-12">
                    <div class="award-bx">
                        <a href="designer/images/product/-Sunbed.jpg" data-fancybox="" class="img">
                            <img src="designer/images/product/-Sunbed.jpg" alt="">
                        </a>
                        <span class="link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                viewBox="0 0 16 16">
                                <path fill-rule="evenodd"
                                    d="M6.5 12a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11zM13 6.5a6.5 6.5 0 1 1-13 0 6.5 6.5 0 0 1 13 0z">
                                </path>
                                <path
                                    d="M10.344 11.742c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1 6.538 6.538 0 0 1-1.398 1.4z">
                                </path>
                                <path fill-rule="evenodd"
                                    d="M6.5 3a.5.5 0 0 1 .5.5V6h2.5a.5.5 0 0 1 0 1H7v2.5a.5.5 0 0 1-1 0V7H3.5a.5.5 0 0 1 0-1H6V3.5a.5.5 0 0 1 .5-.5z">
                                </path>
                            </svg>
                        </span>
                        <div class="tt">Sunbed</div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="award-bx">
                        <a href="designer/images/product/Outdoor-Bench.jpg" data-fancybox="" class="img">
                            <img src="designer/images/product/Outdoor-Bench.jpg" alt="">
                        </a>
                        <span class="link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                viewBox="0 0 16 16">
                                <path fill-rule="evenodd"
                                    d="M6.5 12a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11zM13 6.5a6.5 6.5 0 1 1-13 0 6.5 6.5 0 0 1 13 0z">
                                </path>
                                <path
                                    d="M10.344 11.742c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1 6.538 6.538 0 0 1-1.398 1.4z">
                                </path>
                                <path fill-rule="evenodd"
                                    d="M6.5 3a.5.5 0 0 1 .5.5V6h2.5a.5.5 0 0 1 0 1H7v2.5a.5.5 0 0 1-1 0V7H3.5a.5.5 0 0 1 0-1H6V3.5a.5.5 0 0 1 .5-.5z">
                                </path>
                            </svg>
                        </span>
                        <div class="tt">Outdoor Bench</div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12">
                    <div class="award-bx">
                        <a href="designer/images/product/Outdoor-Chairs.jpg" data-fancybox="" class="img">
                            <img src="designer/images/product/Outdoor-Chairs.jpg" alt="">
                        </a>
                        <span class="link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                viewBox="0 0 16 16">
                                <path fill-rule="evenodd"
                                    d="M6.5 12a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11zM13 6.5a6.5 6.5 0 1 1-13 0 6.5 6.5 0 0 1 13 0z">
                                </path>
                                <path
                                    d="M10.344 11.742c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1 6.538 6.538 0 0 1-1.398 1.4z">
                                </path>
                                <path fill-rule="evenodd"
                                    d="M6.5 3a.5.5 0 0 1 .5.5V6h2.5a.5.5 0 0 1 0 1H7v2.5a.5.5 0 0 1-1 0V7H3.5a.5.5 0 0 1 0-1H6V3.5a.5.5 0 0 1 .5-.5z">
                                </path>
                            </svg>
                        </span>
                        <div class="tt">Outdoor Chairs</div>
                    </div>
                </div> -->
            </div>
        </div>
    </section>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>