<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.0.2/wow.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/11.0.5/swiper-bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.20/jquery.fancybox.min.js"></script>
<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.9.0/jquery.validate.min.js"></script>
<script src="<?= site_url; ?>/designer/js/themes.js"></script>
<?php include 'app_modal.php'; ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.2.1/build/js/intlTelInput.min.js"></script>
<script>
    $(document).ready(function() {

        // ------------------------------
        // INIT PHONE VALIDATION
        // ------------------------------

        function setupPhoneValidation(formId) {
            const phoneGroups = document.querySelectorAll(formId + " .phone-group");

            phoneGroups.forEach(group => {
                const input = group.querySelector(".phone-input");
                const codeInput = group.querySelector(".country_code");
                const nameInput = group.querySelector(".country_name");
                const isoInput = group.querySelector(".country_iso");
                const errorEl = group.querySelector(".error-message");

                // Init intl-tel-input
                const iti = window.intlTelInput(input, {
                    initialCountry: isoInput.value || "",
                    separateDialCode: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.2.1/build/js/utils.min.js",
                });

                // On country change
                input.addEventListener("countrychange", () => {
                    const c = iti.getSelectedCountryData();
                    codeInput.value = c.dialCode;
                    nameInput.value = c.name;
                    isoInput.value = c.iso2;
                    errorEl.textContent = "";

                    updatePhoneRules(formId, input, c);
                });

                // Sanitize number
                input.addEventListener("input", () => {
                    input.value = input.value
                        .replace(/\s+/g, "")
                        .replace(/\+/g, "")
                        .replace(/^0+/, "");
                    errorEl.textContent = "";
                });

                // Set rules on page load
                updatePhoneRules(formId, input, iti.getSelectedCountryData());
            });
        }

        // ------------------------------
        // UPDATE MOBILE RULES
        // ------------------------------
        function updatePhoneRules(formId, input, country) {
            let validator = $(formId).data("validator");
            if (!validator) return;

            let field = $(input).attr("name");

            // India rules
            if (country.iso2 === "in") {
                $(input).attr("maxlength", 10).attr("minlength", 10);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 10,
                    maxlength: 10,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Please enter your mobile no.",
                    minlength: "Indian number must be 10 digits",
                    maxlength: "Indian number must be 10 digits",
                };
            }

            // Foreign number rules
            else {
                $(input).attr("maxlength", 17).attr("minlength", 4);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 4,
                    maxlength: 17,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Please enter your mobile no.",
                    minlength: "Your Mobile No. must be 4-17 digits long",
                    maxlength: "Your Mobile No. must be 4-17 digits long",
                };
            }

            // $(input).valid();
        }

        // ------------------------------
        // FORM VALIDATION (MAIN)
        // ------------------------------
        $("#contact_form").validate({
            rules: {
                name: "required",
                email: {
                    required: true,
                    email: true
                },
                message: "required",
                location: "required"
                // ❗ mobile rules removed (handled dynamically)
            },
            messages: {
                name: "Please enter your name",
                message: "Please enter your message",
                email: {
                    required: "Please enter your email address",
                    email: "Please enter your email address",
                },
                location: "Please enter your location"
            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $.ajax({
                    url: "<?= site_url; ?>/contact.php",
                    type: "POST",
                    data: $("#contact_form").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $("#pop_up").text(res.message_response).css("color", "green");
                            $("#contact_form")[0].reset();
                            grecaptcha.reset();
                        } else {
                            $("#pop_up").text(res.message_response).css("color", "red");
                        }
                    },
                });
            },
        });

        // ------------------------------
        // INIT PHONE INPUT
        // ------------------------------
        setupPhoneValidation("#contact_form");

    });


    // whatsapp form start

    $(document).ready(function() {

        // ------------------------------
        // INIT PHONE VALIDATION
        // ------------------------------
        function setupPhoneValidation(formId) {
            const phoneGroups = document.querySelectorAll(formId + " .phone-group");

            phoneGroups.forEach(group => {
                const input = group.querySelector(".phone-input");
                const codeInput = group.querySelector(".code");
                const nameInput = group.querySelector(".countryName");
                const isoInput = group.querySelector(".countryIso");
                const errorEl = group.querySelector(".error-message");

                const iti = window.intlTelInput(input, {
                    initialCountry: isoInput.value || "",
                    separateDialCode: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.2.1/build/js/utils.min.js",
                });

                input.addEventListener("countrychange", () => {
                    const c = iti.getSelectedCountryData();
                    codeInput.value = c.dialCode;
                    nameInput.value = c.name;
                    isoInput.value = c.iso2;
                    errorEl.textContent = "";
                    updatePhoneRules(formId, input, c);
                });

                input.addEventListener("input", () => {
                    input.value = input.value
                        .replace(/\s+/g, "")
                        .replace(/\+/g, "")
                        .replace(/^0+/, "");
                    errorEl.textContent = "";
                });

                updatePhoneRules(formId, input, iti.getSelectedCountryData());
            });
        }

        // ------------------------------
        // UPDATE RULES
        // ------------------------------
        function updatePhoneRules(formId, input, country) {
            let validator = $(formId).data("validator");
            if (!validator) return;

            let field = $(input).attr("name");

            if (country.iso2 === "in") {
                $(input).attr("maxlength", 10).attr("minlength", 10);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 10,
                    maxlength: 10,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Enter mobile number",
                    minlength: "Indian number must be 10 digits",
                    maxlength: "Indian number must be 10 digits",
                };
            } else {
                $(input).attr("maxlength", 17).attr("minlength", 4);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 4,
                    maxlength: 17,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Enter mobile number",
                    minlength: "Mobile No. must be 4-17 digits",
                    maxlength: "Mobile No. must be 4-17 digits",
                };
            }
        }

        // ------------------------------
        // FORM VALIDATION
        // ------------------------------
        $("#whatsapp_form").validate({
            rules: {
                name: "required"
                // mobile rules dynamically added
            },
            messages: {
                name: "Please enter your name"
            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $(':input[type="submit"]').prop("disabled", true);

                $.ajax({
                    url: "<?= site_url; ?>/whatsapp_enq.php",
                    type: "POST",
                    data: $("#whatsapp_form").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $(".wht_error_message").text("");
                            $(".wht_success_message").text("Submitted Successfully.");
                            $("#whatsapp_form")[0].reset();
                            window.open(res.message_response, "_blank");
                        } else {
                            $(".wht_success_message").text("");
                            $(".wht_error_message").text(res.message_response);
                        }
                        $(':input[type="submit"]').prop("disabled", false);
                    }
                });
            }
        });

        // ------------------------------
        // INIT PHONE FIELD
        // ------------------------------
        setupPhoneValidation("#whatsapp_form");

    });


    // whatsapp form end

    // Quick Enquiry Form Start

    $(document).ready(function() {

        // ------------------------------
        // INIT PHONE VALIDATION
        // ------------------------------
        function setupPhoneValidation(formId) {
            const phoneGroups = document.querySelectorAll(formId + " .phone-group");

            phoneGroups.forEach(group => {
                const input = group.querySelector(".phone-input");
                const codeInput = group.querySelector(".country_code");
                const nameInput = group.querySelector(".country_name");
                const isoInput = group.querySelector(".country_iso");
                const errorEl = group.querySelector(".error-message");

                // Init intl-tel-input
                const iti = window.intlTelInput(input, {
                    initialCountry: isoInput.value || "",
                    separateDialCode: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.2.1/build/js/utils.min.js",
                });

                // On country change
                input.addEventListener("countrychange", () => {
                    const c = iti.getSelectedCountryData();
                    codeInput.value = c.dialCode;
                    nameInput.value = c.name;
                    isoInput.value = c.iso2;
                    errorEl.textContent = "";

                    updatePhoneRules(formId, input, c);
                });

                // Sanitize number
                input.addEventListener("input", () => {
                    input.value = input.value
                        .replace(/\s+/g, "")
                        .replace(/\+/g, "")
                        .replace(/^0+/, "");
                    errorEl.textContent = "";
                });

                // Set rules on page load
                updatePhoneRules(formId, input, iti.getSelectedCountryData());
            });
        }

        // ------------------------------
        // UPDATE MOBILE RULES
        // ------------------------------
        function updatePhoneRules(formId, input, country) {
            let validator = $(formId).data("validator");
            if (!validator) return;

            let field = $(input).attr("name");

            // India rules
            if (country.iso2 === "in") {
                $(input).attr("maxlength", 10).attr("minlength", 10);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 10,
                    maxlength: 10,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Please enter your mobile no.",
                    minlength: "Indian number must be 10 digits",
                    maxlength: "Indian number must be 10 digits",
                };
            }

            // Foreign number rules
            else {
                $(input).attr("maxlength", 17).attr("minlength", 4);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 4,
                    maxlength: 17,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Please enter your mobile no.",
                    minlength: "Your Mobile No. must be 4-17 digits long",
                    maxlength: "Your Mobile No. must be 4-17 digits long",
                };
            }

            // $(input).valid();
        }

        // ------------------------------
        // FORM VALIDATION (MAIN)
        // ------------------------------
        $("#enq_pop_form1").validate({
            rules: {
                name: "required",
                email: {
                    required: true,
                    email: true
                },
                message: "required",
                location: "required"

                // ❗ mobile rules removed (handled dynamically)
            },
            messages: {
                name: "Please enter your name",
                message: "Please enter your message",
                email: {
                    required: "Please enter your email address",
                    email: "Please enter your email address",
                },
                location: "Please enter your location"
            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $.ajax({
                    url: "<?= site_url; ?>/enquiry_popup.php",
                    type: "POST",
                    data: $("#enq_pop_form1").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $("#enq_pop_up").text(res.message_response).css("color", "green");
                            $("#enq_pop_form1")[0].reset();
                            grecaptcha.reset();
                        } else {
                            $("#enq_pop_up").text(res.message_response).css("color", "red");
                        }
                    },
                });
            },
        });

        // ------------------------------
        // INIT PHONE INPUT
        // ------------------------------
        setupPhoneValidation("#enq_pop_form1");

    });

    // Quick Enquiry Form End

    // Send (Category) Enquiry Form Start

    $(document).ready(function() {

        // ------------------------------
        // INIT PHONE VALIDATION
        // ------------------------------
        function setupPhoneValidation(formId) {
            const phoneGroups = document.querySelectorAll(formId + " .phone-group");

            phoneGroups.forEach(group => {
                const input = group.querySelector(".phone-input");
                const codeInput = group.querySelector(".country_code");
                const nameInput = group.querySelector(".country_name");
                const isoInput = group.querySelector(".country_iso");
                const errorEl = group.querySelector(".error-message");

                // Init intl-tel-input
                const iti = window.intlTelInput(input, {
                    initialCountry: isoInput.value || "",
                    separateDialCode: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.2.1/build/js/utils.min.js",
                });

                // On country change
                input.addEventListener("countrychange", () => {
                    const c = iti.getSelectedCountryData();
                    codeInput.value = c.dialCode;
                    nameInput.value = c.name;
                    isoInput.value = c.iso2;
                    errorEl.textContent = "";

                    updatePhoneRules(formId, input, c);
                });

                // Sanitize number
                input.addEventListener("input", () => {
                    input.value = input.value
                        .replace(/\s+/g, "")
                        .replace(/\+/g, "")
                        .replace(/^0+/, "");
                    errorEl.textContent = "";
                });

                // Set rules on page load
                updatePhoneRules(formId, input, iti.getSelectedCountryData());
            });
        }

        // ------------------------------
        // UPDATE MOBILE RULES
        // ------------------------------
        function updatePhoneRules(formId, input, country) {
            let validator = $(formId).data("validator");
            if (!validator) return;

            let field = $(input).attr("name");

            // India rules
            if (country.iso2 === "in") {
                $(input).attr("maxlength", 10).attr("minlength", 10);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 10,
                    maxlength: 10,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Please enter your mobile no.",
                    minlength: "Indian number must be 10 digits",
                    maxlength: "Indian number must be 10 digits",
                };
            }

            // Foreign number rules
            else {
                $(input).attr("maxlength", 17).attr("minlength", 4);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 4,
                    maxlength: 17,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Please enter your mobile no.",
                    minlength: "Your Mobile No. must be 4-17 digits long",
                    maxlength: "Your Mobile No. must be 4-17 digits long",
                };
            }

            // $(input).valid();
        }

        // ------------------------------
        // FORM VALIDATION (MAIN)
        // ------------------------------
        $("#product_pop_form").validate({
            rules: {
                name: "required",
                email: {
                    required: true,
                    email: true
                },
                message: "required",
                location: "required",
                quantity: "required"
                // ❗ mobile rules removed (handled dynamically)
            },
            messages: {
                name: "Please enter your name",
                message: "Please enter your message",
                email: {
                    required: "Please enter your email address",
                    email: "Please enter your email address",
                },
                location: "Please enter your location",
                quantity: "Please enter your Order Quantity"
            },

            errorPlacement: function(error, element) {
                const group = element.closest(".phone-group");

                if (group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                $.ajax({
                    url: "<?= site_url; ?>/enquirycat_popup.php",
                    type: "POST",
                    data: $("#product_pop_form").serialize(),
                    dataType: "json",
                    success: function(res) {
                        if (res.status === true) {
                            $("#cat_pop_up").text(res.message_response).css("color", "green");
                            $("#product_pop_form")[0].reset();
                            grecaptcha.reset();
                        } else {
                            $("#cat_pop_up").text(res.message_response).css("color", "red");
                        }
                    },
                });
            },
        });

        // ------------------------------
        // INIT PHONE INPUT
        // ------------------------------
        setupPhoneValidation("#product_pop_form");

    });

    // Send (Category) Enquiry Form End


    // Request call back start

    $(document).ready(function() {

        // ------------------------------
        // INIT PHONE VALIDATION
        // ------------------------------
        function setupPhoneValidation(formId) {
            const phoneGroups = document.querySelectorAll(formId + " .phone-group");

            phoneGroups.forEach(group => {
                const input = group.querySelector(".phone-input");
                const codeInput = group.querySelector(".code");
                const nameInput = group.querySelector(".countryName");
                const isoInput = group.querySelector(".countryIso");
                const errorEl = group.querySelector(".error-message");

                const iti = window.intlTelInput(input, {
                    initialCountry: isoInput.value || "",
                    separateDialCode: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.2.1/build/js/utils.min.js",
                });

                // when country changes - update hidden fields and clear errors
                input.addEventListener("countrychange", () => {
                    const c = iti.getSelectedCountryData() || {};
                    codeInput.value = c.dialCode || "";
                    nameInput.value = c.name || "";
                    isoInput.value = c.iso2 || "";
                    if (errorEl) errorEl.textContent = "";
                    // clear global popup if any
                    $("#cpop_up").text("");
                    // update validator rules for this input
                    updatePhoneRules(formId, input, c);
                });

                // sanitize typing and clear error message for phone field
                input.addEventListener("input", () => {
                    input.value = input.value
                        .replace(/\s+/g, "")
                        .replace(/\+/g, "")
                        .replace(/^0+/, "");
                    if (errorEl) errorEl.textContent = "";
                    $("#cpop_up").text("");
                });

                // run once initially
                updatePhoneRules(formId, input, iti.getSelectedCountryData() || {});
            });
        }

        // ------------------------------
        // UPDATE RULES
        // ------------------------------
        function updatePhoneRules(formId, input, country) {
            let validator = $(formId).data("validator");
            if (!validator) return;

            let field = $(input).attr("name");

            // default - foreign style
            let isIndia = (country && (country.iso2 || "").toLowerCase() === "in");

            if (isIndia) {
                $(input).attr("maxlength", 10).attr("minlength", 10);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 10,
                    maxlength: 10,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Enter mobile number",
                    minlength: "Indian number must be 10 digits",
                    maxlength: "Indian number must be 10 digits",
                };
            } else {
                $(input).attr("maxlength", 17).attr("minlength", 4);

                validator.settings.rules[field] = {
                    required: true,
                    minlength: 4,
                    maxlength: 17,
                    number: true
                };

                validator.settings.messages[field] = {
                    required: "Enter mobile number",
                    minlength: "Mobile No. must be 4-17 digits",
                    maxlength: "Mobile No. must be 4-17 digits",
                };
            }
        }

        // ------------------------------
        // FORM VALIDATION
        // ------------------------------
        $("#callback_form").validate({
            rules: {
                name: "required"
                // mobile rules dynamically added
            },
            messages: {
                name: "Please enter your name"
            },

            errorPlacement: function(error, element) {
                // element is jQuery object
                const group = element.closest(".phone-group");

                if (group && group.length) {
                    group.find(".error-message")
                        .html(error.text())
                        .css("color", "red");
                } else {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                // ensure hidden code is present before sending
                const formEl = $("#callback_form");
                const codeVal = formEl.find("input.code").val() || "";
                const nameVal = formEl.find("input.countryName").val() || "";
                // if code missing, show message and stop
                if ($.trim(codeVal) === "") {
                    $("#cpop_up").text("Please select a valid country code!").css("color", "red");
                    return false;
                }

                // disable button to prevent double submits
                const $submitBtn = $(':input[type="submit"]', formEl);
                $submitBtn.prop("disabled", true);

                // send submit_callback so PHP recognizes AJAX submit
                const payload = formEl.serialize() + "&submit_callback=1";

                $.ajax({
                    url: "<?= site_url; ?>/ajax_enq_action.php",
                    type: "POST",
                    data: payload,
                    dataType: "json",
                    success: function(res) {
                        if (res && res.status === true) {
                            $("#cpop_up").text(res.message_response).css("color", "green");
                            $("#callback_form")[0].reset();
                            // reset intlTelInput UI values too (if grecaptcha not used remove next line)
                            if (typeof grecaptcha !== "undefined" && grecaptcha.reset) {
                                grecaptcha.reset();
                            }
                        } else {
                            const msg = (res && res.message_response) ? res.message_response : "Something went wrong";
                            $("#cpop_up").text(msg).css("color", "red");
                        }
                    },
                    error: function(xhr, status, err) {
                        $("#cpop_up").text("Server error. Please try again.").css("color", "red");
                    },
                    complete: function() {
                        // always re-enable submit button
                        $submitBtn.prop("disabled", false);
                    }
                });
            },
        });

        // ------------------------------
        // INIT PHONE FIELD
        // ------------------------------
        setupPhoneValidation("#callback_form");

        // additionally: if user manually changes hidden code (edge cases), clear popup
        $(document).on("change", "#callback_form input.code, #callback_form input.countryName", function() {
            $("#cpop_up").text("");
        });
    });



    // Request Call back end


    function ValidateAlpha(evt) {
        var keyCode = (evt.which) ? evt.which : evt.keyCode
        if ((keyCode < 65 || keyCode > 90) && (keyCode < 97 || keyCode > 123) && keyCode != 32)
            return false;
        return true;
    }

    function isNumberKey(evt) {
        //var e = evt || window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode != 46 && charCode > 31 &&
            (charCode < 48 || charCode > 57))
            return false;
        return true;
    }

    function validateOnlyTextField(element) {
        var str = element.value;
        if (str == ' ') {
            element.value = "";
        }
        if (!(/^[a-zA-Z\s]+$/.test(str))) {
            // console.log('String contain number characters');
            str = str.substr(0, str.length - 1);
            element.value = "";
        }
    }

    $('.iti__country-list li').click(function() {

        $("#code").val($(this).data('dial-code'));

        $(".mobile").val($(this).data('country-code-code'));

        $('#countryName').val($(".iti__country-name", this).text());

        $(".code").val($(this).data('dial-code'));

        $('.countryName').val($(".iti__country-name", this).text());

    })
</script>


<!-- <script>
    $(document).ready(function() {
        setupPhoneValidation("#contact_form");
        $("#contact_form").validate({
            rules: {
                name: "required",
                message: {
                    required: true,
                },
                location: {
                    required: true,
                },
                email: {
                    required: true,
                },
                mobile: {
                    required: true,
                    number: true,
                    minlength: 10,
                    maxlength: 10,
                }
            },
            messages: {
                name: "Please enter your name",
                message: {
                    required: "Please enter your message",
                },
                email: {
                    required: "Please enter your email address"
                },
                location: {
                    required: "Please enter your location",
                },
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                    minlength: "Your Mobile No. must be 10 digits long",
                    maxlength: "Your Mobile No. must be 10 digits long",
                }
            },
            submitHandler: function(form) {
                $.ajax({
                    url: '<?= site_url; ?>/contact.php',
                    type: 'POST',
                    data: $('#contact_form').serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status == true) {
                            $('#pop_up').text(response.message_response).css('color',
                                'green');
                            $('#contact_form')[0].reset();
                            grecaptcha.reset();
                        } else {
                            $('#pop_up').text(response.message_response).css('color',
                                'red');
                        }
                    }
                });
            }
        });
    });
    $(document).ready(function() {
        setupPhoneValidation("#enq_pop_form1");
        $("#enq_pop_form1").validate({
            rules: {
                name: "required",
                message: {
                    required: true,
                },
                location: {
                    required: true,
                },
                email: {
                    required: true,
                },
                mobile: {
                    required: true,
                    number: true,
                    minlength: 10,
                    maxlength: 10,
                }
            },
            messages: {
                name: "Please enter your name",
                message: {
                    required: "Please enter your message",
                },
                email: {
                    required: "Please enter your email address"
                },
                location: {
                    required: "Please enter Your location",
                },
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                    minlength: "Your Mobile No. must be 10 digits long",
                    maxlength: "Your Mobile No. must be 10 digits long",
                }
            },
            submitHandler: function(form) {
                $.ajax({
                    url: '<?= site_url; ?>/enquiry_popup.php',
                    type: 'POST',
                    data: $('#enq_pop_form1').serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status == true) {
                            $('#enq_pop_up').text(response.message_response).css('color',
                                'green');
                            $('#enq_pop_form1')[0].reset();
                            grecaptcha.reset();
                        } else {
                            $('#enq_pop_up').text(response.message_response).css('color',
                                'red');
                        }
                    }
                });
            }
        });
    });


    $(document).ready(function() {
        setupPhoneValidation("#product_pop_form");
        $("#product_pop_form").validate({
            rules: {
                name: "required",
                message: {
                    required: true,
                },
                location: {
                    required: true,
                },
                quantity: {
                    required: true,
                },
                email: {
                    required: true,
                },
                mobile: {
                    required: true,
                    number: true,
                    minlength: 10,
                    maxlength: 10,
                }
            },
            messages: {
                name: "Please enter your name",
                message: {
                    required: "Please enter your message",
                },
                email: {
                    required: "Please enter your email address"
                },
                location: {
                    required: "Please enter Your Location",
                },
                quantity: {
                    required: "Please enter Your Minimum Order Quantity",
                },
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                    minlength: "Your Mobile No. must be 10 digits long",
                    maxlength: "Your Mobile No. must be 10 digits long",
                }
            },
            submitHandler: function(form) {
                $.ajax({
                    url: '<?= site_url; ?>/enquirycat_popup.php',
                    type: 'POST',
                    data: $('#product_pop_form').serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status == true) {
                            $('#cat_pop_up').text(response.message_response).css('color',
                                'green');
                            $('#product_pop_form')[0].reset();
                            grecaptcha.reset();
                        } else {
                            $('#cat_pop_up').text(response.message_response).css('color',
                                'red');
                        }
                    }
                });
            }
        });
    });


    $(document).ready(function() {

        setupPhoneValidation("#whatsapp_form");

        $("#whatsapp_form").validate({

            rules: {

                name: "required",

                mobile: {

                    required: true,

                    number: true,

                    minlength: 10,

                    maxlength: 10,

                }

            },

            messages: {

                name: "Please Enter Your Name",

                mobile: {

                    required: "Please Enter Your Mobile Number",

                    number: "Mobile Number Must be Number",

                    minlength: "Mobile Number must have 10 digits",

                    maxlength: "Mobile Number must have 10 difits",

                }

            },

        });

    });

    $('#whatsapp_form').submit(function(e) {
        e.preventDefault();

        if (!$('#whatsapp_form').valid()) return;

        $(':input[type="submit"]').prop('disabled', true);

        $.ajax({

            'url': '<?= site_url; ?>/whatsapp_enq.php',

            'type': 'POST',

            'dataType': 'json',

            'data': $(this).serialize(),

            'success': function(result) {

                if (result.status == false) {

                    $('.wht_success_message').text('');

                    $('.wht_error_message').text(result.message_response)

                    $(':input[type="submit"]').prop('disabled', false);

                } else {

                    $('.wht_error_message').text('');

                    $('.wht_success_message').text("You Have Successfully Submitted enquiry. We will contact you soon.");

                    $('#whatsapp_form').trigger("reset");

                    window.open(result.message_response, '_blank');

                    $(':input[type="submit"]').prop('disabled', false);

                }

            }

        });

    });




    $(document).ready(function() {
        setupPhoneValidation("#callback_form");

        $("#callback_form").validate({

            rules: {

                name: "required",

                mobile: {

                    required: true,

                    number: true,

                    minlength: 10,

                    maxlength: 10,

                }

            },

            messages: {

                name: "Please enter your name",

                mobile: {

                    required: "Please enter your mobile no.",

                    number: "Mobile No. contains only numbers",

                    minlength: "Your Mobile No. must be 10 digits long",

                    maxlength: "Your Mobile No. must be 10 digits long",

                }

            },

            submitHandler: function(form) {
                $(':input[type="submit"]').prop('disabled', true);

                $.ajax({

                    url: '<?= site_url; ?>/ajax_enq_action.php',

                    type: 'POST',

                    data: $('#callback_form').serialize(),

                    dataType: 'json',

                    success: function(response) {

                        if (response.status == true) {

                            $('#cpop_up').text(response.message_response).css('color',

                                'green');

                            $('#callback_form')[0].reset();

                            grecaptcha.reset();

                        } else {

                            $('#cpop_up').text(response.message_response).css('color',

                                'red');

                        }

                    }

                });

            }

        });

    });

    // code for form validation 
    function ValidateAlpha(evt) {
        var keyCode = (evt.which) ? evt.which : evt.keyCode
        if ((keyCode < 65 || keyCode > 90) && (keyCode < 97 || keyCode > 123) && keyCode != 32)
            return false;
        return true;
    }

    function isNumberKey(evt) {
        //var e = evt || window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode != 46 && charCode > 31 &&
            (charCode < 48 || charCode > 57))
            return false;
        return true;
    }

    function validateOnlyTextField(element) {
        var str = element.value;
        if (str == ' ') {
            element.value = "";
        }
        if (!(/^[a-zA-Z\s]+$/.test(str))) {
            // console.log('String contain number characters');
            str = str.substr(0, str.length - 1);
            element.value = "";
        }
    }

    //disabling context menu
    document.onkeydown = function(e) {
        if (e.ctrlKey &&
            (e.keyCode === 67 ||
                e.keyCode === 86 ||
                e.keyCode === 85 ||
                e.keyCode === 117)) {
            return false;
        } else {
            return true;
        }
    };
    $(document).keypress("u", function(e) {
        if (e.ctrlKey) {
            return false;
        } else {
            return true;
        }
    });
    document.addEventListener("contextmenu", function(e) {
        e.preventDefault();
    }, false);
</script> -->


<!-- <script>
    function setupPhoneValidation(formSelector) {
        var $form = $(formSelector);
        if (!$form.length) return;

        // find mobile input(s) inside the form
        var $mobile = $form.find('input[name="mobile"], input[id="mobile"], input[class*="mobile"]');

        if ($mobile.length) {
            // force digits only and maxlength
            $mobile.attr('maxlength', 10).on('input', function() {
                // remove non digits and cut to 10 chars
                this.value = this.value.replace(/\D/g, '').slice(0, 10);
            });

            // optional: trim spaces on blur
            $mobile.on('blur', function() {
                this.value = this.value.trim();
            });
        }

        // Add (or re-add) custom validator method only once
        if (!$.validator.methods.phoneDigits) {
            $.validator.addMethod('phoneDigits', function(value, element) {
                // allow empty if optional(), otherwise require exactly 10 digits
                value = (value || '').replace(/\s+/g, '');
                return this.optional(element) || /^\d{10}$/.test(value);
            }, 'Please enter a valid 10 digit mobile number');
        }
    }

    /* --- compact initializer for many forms --- */
    $(document).ready(function() {

        // list all forms you want to apply phone validation + jQuery Validate
        var forms = [
            '#contact_form',
            '#enq_pop_form1',
            '#product_pop_form',
            '#whatsapp_form',
            '#callback_form'
            // add other form selectors here
        ];

        // call setupPhoneValidation for each form BEFORE calling .validate
        forms.forEach(function(selector) {
            setupPhoneValidation(selector);
        });

        // Example: initialize validation for contact_form (your existing config)
        $('#contact_form').validate({
            rules: {
                name: 'required',
                message: {
                    required: true
                },
                location: {
                    required: true
                },
                email: {
                    required: true,
                    email: true
                },
                // use custom phoneDigits rule here
                mobile: {
                    required: true,
                    phoneDigits: true
                }
            },
            messages: {
                name: 'Please enter your name',
                message: {
                    required: 'Please enter your message'
                },
                email: {
                    required: 'Please enter your email address'
                },
                location: {
                    required: 'Please enter your location'
                },
                mobile: {
                    required: 'Please enter your mobile no.',
                    phoneDigits: 'Mobile number must be exactly 10 digits'
                }
            },
            submitHandler: function(form) {
                // keep your existing AJAX call (example)
                $.ajax({
                    url: '<?= site_url; ?>/contact.php',
                    type: 'POST',
                    data: $('#contact_form').serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status == true) {
                            $('#pop_up').text(response.message_response).css('color', 'green');
                            $('#contact_form')[0].reset();
                            if (typeof grecaptcha !== 'undefined') grecaptcha.reset();
                        } else {
                            $('#pop_up').text(response.message_response).css('color', 'red');
                        }
                    },
                    error: function(xhr, status, err) {
                        console.error('Contact form AJAX error', status, err);
                    }
                });
            }
        });

        // Initialize other forms re-using the same rules (you can tweak per form)
        $('#enq_pop_form1').validate({
            rules: {
                name: 'required',
                message: {
                    required: true
                },
                location: {
                    required: true
                },
                email: {
                    required: true,
                    email: true
                },
                mobile: {
                    required: true,
                    phoneDigits: true
                }
            },
            messages: {
                name: 'Please enter your name',
                message: {
                    required: 'Please enter your message'
                },
                email: {
                    required: 'Please enter your email address'
                },
                location: {
                    required: 'Please enter Your location'
                },
                mobile: {
                    required: 'Please enter your mobile no.',
                    phoneDigits: 'Your Mobile No. must be 10 digits long'
                }
            },
            submitHandler: function(form) {
                // your AJAX for enq_pop_form1
                $.ajax({
                    url: '<?= site_url; ?>/enquiry_popup.php',
                    type: 'POST',
                    data: $('#enq_pop_form1').serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status == true) {
                            $('#enq_pop_up').text(response.message_response).css('color', 'green');
                            $('#enq_pop_form1')[0].reset();
                            if (typeof grecaptcha !== 'undefined') grecaptcha.reset();
                        } else {
                            $('#enq_pop_up').text(response.message_response).css('color', 'red');
                        }
                    }
                });
            }
        });

        // Example for whatsapp_form (no ajax here in example)
        $('#whatsapp_form').validate({
            rules: {
                name: 'required',
                mobile: {
                    required: true,
                    phoneDigits: true
                }
            },
            messages: {
                name: 'Please Enter Your Name',
                mobile: {
                    required: 'Please Enter Your Mobile Number',
                    phoneDigits: 'Mobile number must have 10 digits'
                }
            }
        });

        // Similarly initialize #product_pop_form, #callback_form etc...
        // You can copy the pattern above and adjust 'rules', 'messages', and submitHandler as needed.
          $("#product_pop_form").validate({
            rules: {
                name: "required",
                message: {
                    required: true,
                },
                location: {
                    required: true,
                },
                quantity: {
                    required: true,
                },
                email: {
                    required: true,
                },
                mobile: {
                    required: true,
                    number: true,
                    minlength: 10,
                    maxlength: 10,
                }
            },
            messages: {
                name: "Please enter your name",
                message: {
                    required: "Please enter your message",
                },
                email: {
                    required: "Please enter your email address"
                },
                location: {
                    required: "Please enter Your Location",
                },
                quantity: {
                    required: "Please enter Your Minimum Order Quantity",
                },
                mobile: {
                    required: "Please enter your mobile no.",
                    number: "Mobile No. contains only numbers",
                    minlength: "Your Mobile No. must be 10 digits long",
                    maxlength: "Your Mobile No. must be 10 digits long",
                }
            },
            submitHandler: function(form) {
                $.ajax({
                    url: '<?= site_url; ?>/enquirycat_popup.php',
                    type: 'POST',
                    data: $('#product_pop_form').serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status == true) {
                            $('#cat_pop_up').text(response.message_response).css('color',
                                'green');
                            $('#product_pop_form')[0].reset();
                            grecaptcha.reset();
                        } else {
                            $('#cat_pop_up').text(response.message_response).css('color',
                                'red');
                        }
                    }
                });
            }
        });
 $("#callback_form").validate({

            rules: {

                name: "required",

                mobile: {

                    required: true,

                    number: true,

                    minlength: 10,

                    maxlength: 10,

                }

            },

            messages: {

                name: "Please enter your name",

                mobile: {

                    required: "Please enter your mobile no.",

                    number: "Mobile No. contains only numbers",

                    minlength: "Your Mobile No. must be 10 digits long",

                    maxlength: "Your Mobile No. must be 10 digits long",

                }

            },

            submitHandler: function(form) {
                $(':input[type="submit"]').prop('disabled', true);

                $.ajax({

                    url: '<?= site_url; ?>/ajax_enq_action.php',

                    type: 'POST',

                    data: $('#callback_form').serialize(),

                    dataType: 'json',

                    success: function(response) {

                        if (response.status == true) {

                            $('#cpop_up').text(response.message_response).css('color',

                                'green');

                            $('#callback_form')[0].reset();

                            grecaptcha.reset();

                        } else {

                            $('#cpop_up').text(response.message_response).css('color',

                                'red');

                        }

                    }

                });

            }

        });

    });
</script> -->