<?php

class Products extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('category/category_model', 'products/product_model', 'color/color_model', 'size/size_model', 'testimonials/testimonial_model'));
    $this->load->helper(array('products/product', 'category/category'));
    $this->lang->load('portuguese', 'portuguese');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $this->page_section_ct = 'product';
    $this->load->library(array('Dmailer', 'safe_encrypt'));
  }

  public function index() {
    //Product Price Sort Query
    //SELECT product_price, (case when (product_discounted_price > 0) THEN product_discounted_price ELSE product_price END) as price from wps_products order by price
    $this->page_section_ct = 'product';
    $condtion = array();
    $cat_res = '';
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $this->uri->segment(3);
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "products/index/$category_id/pg/" : "products/index/pg/";
    $condtion['status'] = '1';

    if ($this->input->post('keywordSearch')) {
      $page_title = "Search Result - (" . strtoupper($this->input->post('keywordSearch')) . ")";
    } else {
      $page_title = "Product Lists";
    }

    //Sorting
    $sort = $this->input->get_post('sort');
    if ($sort > 0) {
      if ($sort == 1) {//Popular Products
        $condtion['orderby'] = 'wlp.products_viewed DESC';
      }
      if ($sort == 2) {//Price Low to High
        $condtion['orderby'] = 'wlp.product_price ASC';
      }
      if ($sort == 3) {//Price High to Low
        $condtion['orderby'] = 'wlp.product_price DESC';
      }
    } else {
      $condtion['orderby'] = 'wlp.product_code asc';
    }

    //Filter
    $type = $this->uri->segment(1);
    if ($type != "") {
      if ($type == 'latest') {
        $condtion['latest_product'] = '1';
        $page_title = "Latest Products";
      }
      if ($type == 'best-seller') {
        $condtion['bestseller'] = '1';
        $page_title = "Best Seller Products";
      }
      if ($type == 'popular') {
        $condtion['popular'] = '1';
        $page_title = "Popular Products";
      }
      if ($type == 'new-arrival') {
        $condtion['newarrival'] = '1';
        $page_title = "New Arrival Products";
      }
    }

    $color = $this->input->post('color');
    $size = $this->input->post('size');
    $price = $this->input->post('price');

    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    if (!empty($price)) {
      $condtion['price'] = $price;
    }

    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$category_id'");
      $page_title = $cat_res['category_name'];
    }
    $data['catid'] = '';
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);

    $data['total_rows'] = $data['total_list_rows'] = $config['total_rows'] = get_found_rows();
    $data['heading_title'] = $page_title;
    $data['products'] = $res_array;
    $data['cat_res'] = $cat_res;

    $this->load->view('products/view_product_listing', $data);
  }

  public function getDiscountedprice() {
    $id = $this->input->post('id');
    $id1 = explode("^", $id);
    $product_id = $id1[0];
    $DiscountId = $id1[1];
    $productDetail = get_db_single_row('wps_products', '*', " products_id='$product_id'");
    if ($DiscountId == 'd1') {
      echo '<span class="highlighted-orange">' . display_price($productDetail['discounted_price1']) . '</span> (Per Unit Price <span class="highlighted-orange">' . display_price($productDetail['discounted_price1'] / $productDetail['no_of_products1']) . '</span>)';
      echo '<input type="hidden" name="Discount" value="discounted_price1" />';
    } elseif ($DiscountId == 'd2') {
      echo '<span class="highlighted-orange">' . display_price($productDetail['discounted_price2']) . '</span> (Per Unit Price <span class="highlighted-orange">' . display_price($productDetail['discounted_price2'] / $productDetail['no_of_products2']) . '</span>)';
      echo '<input type="hidden" name="Discount" value="discounted_price2" />';
    } elseif ($DiscountId == 'd3') {
      echo '<span class="highlighted-orange">' . display_price($productDetail['discounted_price3']) . '</span> (Per Unit Price <span class="highlighted-orange">' . display_price($productDetail['discounted_price3'] / $productDetail['no_of_products3']) . '</span>)';
      echo '<input type="hidden" name="Discount" value="discounted_price3" />';
    } elseif ($DiscountId == 'd4') {
      echo '<span class="highlighted-orange">' . display_price($productDetail['discounted_price4']) . '</span> (Per Unit Price <span class="highlighted-orange">' . display_price($productDetail['discounted_price4'] / $productDetail['no_of_products4']) . '</span>)';
      echo '<input type="hidden" name="Discount" value="discounted_price4" />';
    } elseif ($DiscountId == 'none') {
      echo '<input type="hidden" name="Discount" value="none" />';
    }
  }

  public function special_offer() {
    //Product Price Sort Query
    //SELECT product_price, (case when (product_discounted_price > 0) THEN product_discounted_price ELSE product_price END) as price from wps_products order by price
    $this->page_section_ct = 'product';
    $condtion = array();
    $cat_res = '';
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $this->uri->segment(3);
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "products/index/$category_id/pg/" : "products/index/pg/";
    $condtion['status'] = '1';
    $condtion['newarrival'] = '1';

    if ($this->input->post('keywordSearch')) {
      $page_title = "Search Result - (" . strtoupper($this->input->post('keywordSearch')) . ")";
    } else {
      $page_title = "Special Offer Products";
    }

    //Sorting
    $sort = $this->input->get_post('sort');
    if ($sort > 0) {
      if ($sort == 1) {//Popular Products
        $condtion['orderby'] = 'wlp.products_viewed DESC';
      }
      if ($sort == 2) {//Price Low to High
        $condtion['orderby'] = 'wlp.product_price ASC';
      }
      if ($sort == 3) {//Price High to Low
        $condtion['orderby'] = 'wlp.product_price DESC';
      }
    } else {
      $condtion['orderby'] = 'wlp.product_name asc';
    }


    //Filter
    $type = $this->uri->segment(1);
    if ($type != "") {
      if ($type == 'latest') {
        $condtion['latest_product'] = '1';
        $page_title = "Latest Products";
      }
      if ($type == 'best-seller') {
        $condtion['bestseller'] = '1';
        $page_title = "Best Seller Products";
      }
      if ($type == 'popular') {
        $condtion['popular'] = '1';
        $page_title = "Popular Products";
      }
      if ($type == 'new-arrival') {
        $condtion['newarrival'] = '1';
        $page_title = "New Arrival Products";
      }
    }

    $color = $this->input->post('color');
    $size = $this->input->post('size');
    $price = $this->input->post('price');

    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    if (!empty($price)) {
      $condtion['price'] = $price;
    }

    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$category_id'");
      $page_title = $cat_res['category_name'];
    }
    $data['catid'] = '';
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    $data['total_rows'] = $data['total_list_rows'] = $config['total_rows'] = get_found_rows();
    $data['heading_title'] = $page_title;
    $data['products'] = $res_array;
    $data['cat_res'] = $cat_res;

    $this->load->view('products/view_product_listing', $data);
  }

  public function top_seller() {
    //Product Price Sort Query
    //SELECT product_price, (case when (product_discounted_price > 0) THEN product_discounted_price ELSE product_price END) as price from wps_products order by price
    $this->page_section_ct = 'product';
    $condtion = array();
    $cat_res = '';
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $this->uri->segment(3);
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "products/index/$category_id/pg/" : "products/index/pg/";
    $condtion['status'] = '1';
    $condtion['popular'] = '1';

    if ($this->input->post('keywordSearch')) {
      $page_title = "Search Result - (" . strtoupper($this->input->post('keywordSearch')) . ")";
    } else {
      $page_title = "Top Seller Products";
    }

    //Sorting
    $sort = $this->input->get_post('sort');
    if ($sort > 0) {
      if ($sort == 1) {//Popular Products
        $condtion['orderby'] = 'wlp.products_viewed DESC';
      }
      if ($sort == 2) {//Price Low to High
        $condtion['orderby'] = 'wlp.product_price ASC';
      }
      if ($sort == 3) {//Price High to Low
        $condtion['orderby'] = 'wlp.product_price DESC';
      }
    } else {
      $condtion['orderby'] = 'wlp.product_name asc';
    }


    //Filter
    $type = $this->uri->segment(1);
    if ($type != "") {
      if ($type == 'latest') {
        $condtion['latest_product'] = '1';
        $page_title = "Latest Products";
      }
      if ($type == 'best-seller') {
        $condtion['bestseller'] = '1';
        $page_title = "Best Seller Products";
      }
      if ($type == 'popular') {
        $condtion['popular'] = '1';
        $page_title = "Popular Products";
      }
      if ($type == 'new-arrival') {
        $condtion['newarrival'] = '1';
        $page_title = "New Arrival Products";
      }
    }

    $color = $this->input->post('color');
    $size = $this->input->post('size');
    $price = $this->input->post('price');

    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    if (!empty($price)) {
      $condtion['price'] = $price;
    }

    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$category_id'");
      $page_title = $cat_res['category_name'];
    }
    $data['catid'] = '';
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    $data['total_rows'] = $data['total_list_rows'] = $config['total_rows'] = get_found_rows();
    $data['heading_title'] = $page_title;
    $data['products'] = $res_array;
    $data['cat_res'] = $cat_res;

    $this->load->view('products/view_product_listing', $data);
  }

  public function ajax_load_product_view() {

    $data['title'] = 'Ajax Load Products';
    $config['per_page'] = $this->config->item('per_page');
    $offset = $this->input->get_post('stOffSet');

    if ($this->input->get_post('category_id')) {
      $parent_segment = (int) $this->input->get_post('category_id');
    } else {
      $parent_segment = (int) $this->input->get_post('category_id');
    }
    $page_segment = find_paging_segment();
    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';

    $condtion['status'] = '1';
    $page_title = "Product Lists";
    if ($parent_id > 0) {
      $condtion['category_id'] = $parent_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$parent_id'");
      $page_title = $cat_res['category_name'];
      $data['catid'] = $parent_id;
    }

    //Sorting
    $sort = $this->input->get_post('sort');
    if ($sort > 0) {
      if ($sort == 1) {//Popular Products
        $condtion['orderby'] = 'wlp.products_viewed DESC';
      }
      if ($sort == 2) {//Price Low to High
        $condtion['orderby'] = 'wlp.product_price ASC';
      }
      if ($sort == 3) {//Price High to Low
        $condtion['orderby'] = 'wlp.product_price DESC';
      }
    } else {
      $condtion['orderby'] = 'wlp.products_id asc';
    }

    $type = $this->input->get_post('type');
    if ($type != "") {
      if ($type == 'latest') {
        $condtion['latest_product'] = '1';
      }
      if ($type == 'best-seller') {
        $condtion['bestseller'] = '1';
      }
      if ($type == 'popular') {
        $condtion['popular'] = '1';
      }
      if ($type == 'new-arrival') {
        $condtion['newarrival'] = '1';
      }
    }

    if ($this->input->get_post('keyword') != '') {
      $condtion['keyword'] = $this->input->get_post('keyword');
    }

    $color = $this->input->post('color');
    $size = $this->input->post('size');
    $price = $this->input->post('price');

    if (!empty($color)) {
      //$colors = implode(',', $color);
      $condtion['color'] = $color;
    }
    if (!empty($size)) {
      //$sizes = implode(',', $size);
      $condtion['size'] = $size;
    }
    if (!empty($price)) {
      $condtion['price'] = $price;
    }

    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    $data['listRes'] = $res_array;
    $this->load->view('products/ajax_load_products', $data);
  }

  public function detail() {
    $this->page_section_ct = 'product';
    $data['unq_section'] = "Product";
    $productId = (int) $this->meta_info['entity_id'];
    $where = "wlp.products_id = '" . $productId . "'";
    $option = array(
        'fields' => "SQL_CALC_FOUND_ROWS wlp.*,wlc.first_name,wlc.user_name,wlc.mobile_number,wlcat.category_id",
        'where' => $where
    );
    $res = $this->product_model->get_products('1', '', $option);
    // print_r($res);  exit();
    if (is_array($res) && !empty($res)) {
      $res = $res[0];
      //trace($res);
      // Recent View
      $id = $res['products_id'];
      $ee = $this->session->userdata('recent_view');
      if (is_array($ee)) {
        if (!@in_array($id, $ee)) {
          @array_push($ee, $id);
          $this->session->set_userdata('recent_view', $ee);
        }
      } else {
        $this->session->set_userdata('recent_view', array($id));
      }
      // End Here

      $this->load->model('comments/comments_model');
      $data['error_validate'] = TRUE;

      $data['title'] = "Product";
      $data['res'] = $res;
      $this->product_model->update_viewed($res['products_id'], $res['products_viewed']);
      $media_res = $this->product_model->get_product_media(6, 0, array('productid' => $res['products_id']));
      $data['media_res'] = $media_res;

      //Reviews
      $qry_options = array('limit' => 200, 'offset' => 0, 'condition' => " AND product_id ='" . $res['products_id'] . "' AND entity_type='product' AND a.status='1'");
      $review_res = $this->comments_model->get_comments($qry_options);
      $data['review_count'] = get_found_rows();
      $data['review_res'] = $review_res;

      //Related Products
      $related_products = $this->get_product_related_list($res['category_id'], $productId);
      $data['related'] = $related_products;
      //End

      $data['REMARKSS'] = $this->config->item('REMARKS');
      $data['product_discount'] = $this->db->query("select * from wps_products_discounts where category_id = '" . $res['category_id'] . "'  order by sort_order")->result_array();
      $this->load->view('products/view_product_details', $data);
    } else {
      redirect('products', '');
    }
  }

  public function enquireNow() {

    $this->form_validation->set_rules('name', 'Name', 'trim|required|alpha');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Mobile Number', 'trim|required|max_length[15]|min_length[10]');
    $this->form_validation->set_rules('message', 'Message', 'trim|xss_clean|required|max_length[500]|alpha_numeric_spaces');
    $this->form_validation->set_rules('captcha', 'Captcha', 'trim|required');
    $this->form_validation->set_rules('product_id', 'Product Id', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
      $posted_data = array(
          'type' => '4',
          'first_name' => $this->input->post('name'),
          'products_id' => $this->input->post('product_id'),
          'post_url' => $_SERVER['HTTP_REFERER'],
          'last_name' => '',
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('phone'),
          'message' => $this->input->post('message'),
          'receive_date' => $this->config->item('config.date.time'),
      );
      $result = $this->product_model->safe_insert('wps_enquiry', $posted_data, false);

      $subject = "Webpulseindia.com - Enquiry From www.magnetichub.com";
      $body = '<html><head></head><body>
              <table border="0" width="100%">
              <tbody>
              <tr>
              <td colspan="2">
              <strong>Dear Admin</strong></td>
              </tr>
              <tr>
              <td colspan="2">
              Enquiry&nbsp; has been submitted with following info :</td>
              </tr>
              <tr>
              <td colspan="2">
              &nbsp;</td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Name : </strong></td>
              <td>
              <span style="margin-top:15px">' . $this->input->post('name') . '</span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Email : </strong></td>
              <td>
              <span style="margin-top:15px"><a href="mailto:' . $this->input->post('email') . '" target="_blank">' . $this->input->post('email') . '</a></span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Mobile : </strong></td>
              <td>
              <span style="margin-top:15px">' . $this->input->post('phone') . '</span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Message : </strong></td>
              <td>
              <span style="margin-top:15px">' . $this->input->post('message') . '</span></td>
              </tr>
               <tr>
              <td width="26%">
              <strong>URL : </strong></td>
              <td>
              <span style="margin-top:15px">' . $_SERVER['HTTP_REFERER'] . '</span></td>
              </tr>
              <tr>
              <td colspan="2">
              &nbsp;</td>
              </tr>
              </tbody>
              </table><br/>
              <span style="margin-top:15px">
               Thank you.<br>
               ' . $this->config->item('site_name') . ' Customer Service<br>
               Email: <a href="mailto:' . $this->admin_info->admin_email . '" target="_blank">' . $this->admin_info->admin_email . '</a><div class="yj6qo"></div><div class="adL"> 
              </div></span></body</html>';
      if ($this->admin_info->website_mode == 'Live') {
        $mail_conf = array(
            'subject' => $subject,
            'to_email' => $this->admin_info->admin_email, //
            'from_email' => $this->input->post('email'),
            'from_name' => $this->input->post('name'),
            'reply_to' => $this->input->post('email'),
            'body_part' => $body,
        );
        $this->dmailer->mail_notify($mail_conf);

        $mail_conf2 = array(
            'subject' => "Webpulseindia.com - Enquiry From www.magnetichub.com",
            'to_email' => 'webpulseindia@gmail.com', //
            'from_email' => $this->input->post('email'),
            'from_name' => $this->input->post('name'),
            'reply_to' => $this->input->post('email'),
            'body_part' => $body,
        );
        $this->dmailer->mail_notify($mail_conf2);

        $mail_conf3 = array(
            'subject' => "Webpulseindia.com - Enquiry From www.magnetichub.com",
            'to_email' => 'shelleyent@aol.com', //
            'from_email' => $this->input->post('email'),
            'from_name' => $this->input->post('name'),
            'reply_to' => $this->input->post('email'),
            'body_part' => $body,
        );
        $this->dmailer->mail_notify($mail_conf3);
      } else {
        $mail_conf4 = array(
            'subject' => "Webpulseindia.com - Enquiry From www.magnetichub.com",
            'to_email' => 'test.webpulse@gmail.com', //
            'from_email' => $this->input->post('email'),
            'from_name' => $this->input->post('name'),
            'reply_to' => $this->input->post('email'),
            'body_part' => $body,
        );
        $this->dmailer->mail_notify($mail_conf4);
      }
      $res = 'success';
    } else {
      $res = '<div class="alert alert-danger">
                      <strong>' . validation_errors() . '
                  </div>';
    }

    echo $res;
    exit;
  }

  public function customized() {

    $this->page_section_ct = 'product';
    $data['unq_section'] = "Product";
    $productId = (int) $this->uri->segment(3);

    $where = "wlp.products_id = '" . $productId . "'";
    $option = array('fields' => "SQL_CALC_FOUND_ROWS wlp.*,wlc.first_name,wlc.user_name,wlc.mobile_number,wlcat.category_id", 'where' => $where);
    $res = $this->product_model->get_products('1', '', $option);

    if (is_array($res) && !empty($res)) {
      $res = $res[0];
      $data['error_validate'] = TRUE;
      $data['title'] = "Product";
      $data['res'] = $res;

      $qry_options = array('limit' => 200, 'offset' => 0, 'condition' => " AND entity_id ='" . $res['products_id'] . "' AND entity_type='product' AND b.status='1'");
      $media_res = $this->product_model->get_product_media(5, 0, array('productid' => $res['products_id']));
      $data['media_res'] = $media_res;


      $this->load->view('products/view_product_customized', $data);
    } else {
      redirect('products', '');
    }
  }

  public function setSizeColorSession() {
    $color_id = $this->input->post('color_id');
    $size_id = $this->input->post('size_id');

    $this->session->set_userdata(array(
        'color_id' => $color_id,
        'size_id' => $size_id
    ));
  }

  public function get_product_related_list($catId = "", $productId) {
    $condtion['status'] = '1';
    $condtion['where'] = "wlp.category_id = '" . $catId . "' AND wlp.products_id != '" . $productId . "'";
    $condtion['orderby'] = 'products_id DESC';
    $product_list = $this->product_model->get_products('10', '0', $condtion);
    return $product_list;
  }

  public function get_product_price() {
    $sid = (int) $this->input->post('sid');
    $cid = (int) $this->input->post('cid');
    $pid = (int) $this->input->post('pid');

    if ($cid > 0 && $sid > 0) {
      $res = $this->db->select('quantity,quantity,product_price,product_discounted_price')->get_where('wps_product_attributes', array('color_id' => $cid, 'size_id' => $sid, 'product_id' => $pid))->row();
      //echo_sql();
      if (is_object($res)) {
        echo $res->quantity . '-' . $res->product_price . '-' . $res->product_discounted_price;
      }
    }
  }

  public function get_product_stock() {
    $sid = (int) $this->input->post('sid');
    $pid = (int) $this->input->post('pid');
    if ($sid > 0) {
      $res = $this->db->select('quantity')->get_where('wps_product_attributes', array('store_id' => $sid, 'product_id' => $pid))->row();
      if (is_object($res)) {
        echo $res->quantity;
      } else {
        echo '0';
      }
    }
  }

  public function check_zipcode() {
    //$zipcode=$this->input->post("zipcode");
    $this->form_validation->set_rules('zip_code', 'Zipcode', 'trim|required|is_numeric|max_length[6]|callback_is_zipcode_exist');

    if ($this->form_validation->run() === TRUE) {
      $this->session->set_userdata("zip_code", $this->input->post("zip_code"));
      print json_encode(array("success" => ''));
    } else {
      print json_encode(array("error" => form_error("zip_code", '<span>', '</span>')));
    }
  }

  public function is_zipcode_exist() {
    $zipcode = $this->input->post("zip_code");

    $zc = $this->db->query("select zip_code, cod from tbl_zip_location where zip_code='" . $this->input->post("zip_code") . "' AND status='1'")->row_array();

    if (empty($zc)) {
      $this->form_validation->set_message('is_zipcode_exist', 'COD not available at your location and not servicable.');
      return FALSE;
    } elseif ($zc['cod'] == 'N') {
      $this->form_validation->set_message('is_zipcode_exist', 'COD not available at your location.');
      return FALSE;
    }
  }

  public function post_review() {
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[70]');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|max_length[80]|valid_email');
    $this->form_validation->set_rules('rating', 'Rating', 'trim|required|max_length[1]');
    $this->form_validation->set_rules('reviews', 'Review', 'trim|required|max_length[450]');
    if ($this->form_validation->run() === TRUE) {
      $mem_id = $this->session->userdata('user_id');
      $posted_data = array(
          'entity_id' => $this->input->get_post('products_id'),
          'entity_type' => 'product',
          'customer_id' => $mem_id,
          'ads_rating' => $this->input->post('rating'),
          'author' => $this->input->post('name'),
          'author_email' => $this->input->post('email'),
          'text' => $this->input->post('reviews'),
          'status' => '1',
          'review_date' => $this->config->item('config.date.time')
      );
      $this->product_model->safe_insert('wps_review', $posted_data, FALSE);

      $data['success'] = true;
      $data['message'] = 'Thank you. Your review has been submitted successfully';
      echo json_encode($data);
    } else {
      $data['success'] = false;
      $data['error'] = validation_errors();
      echo json_encode($data);
    }
  }

  public function check_product_exits_into_cart($pres) {
    $cart_array = $this->cart->contents();
    $insert_flag = 0;
    if (is_array($cart_array) && !empty($cart_array)) {
      foreach ($this->cart->contents() as $item) {
        if (array_key_exists('pid', $item)) {
          if ($item['pid'] == $pres['products_id']) {
            $insert_flag = 1;
          }
        }
      }
    }
    return $insert_flag;
  }

}

?>