<?php
$this->load->view('top_application');
?>
<div class="page_breadcrumbs">
  <div class="container">
    <ul>
      <li><a href="<?php echo site_url(); ?>">Home</a></li>
      <li>Order Status</li>
    </ul>
  </div>
</div>
<section class="cart_page">
  <div class="container">

    <div class="row">
      <div class="col-md-12 col-sm-12 col-lg-12 col-xs-12 ">
        <div class="cart_left">
          <h1>Payment Successfull</h1>

          <div class="text">
            <b>Hello <?php echo ucwords($ordmaster['first_name']); ?>,</b><br /><br />
            <?php
            if ($ordmaster['payment_status'] == 'Paid' || $ordmaster['payment_method'] == 'Cash') {
              ?>
              <span class="textBig" style='text-align: left;text-transform: capitalize; font-size: 24px;'>Thank you for choosing Magnetic Hub.</span><br />
              <span class="textBig" style="text-align: left;"><b>Order Confirmation Number/Tracking Number</b>: <?php echo $ordmaster['order_id']; ?> is Confirmed!</span><br />
              <!--span class="textBig">
              <?php //echo str_replace('|', '<br />', $ordmaster['paymentResponse']);         ?>
              </span><br /><br /-->
              You will be notified with Tracking No. once your order is shipped.<br /><br />
              <?php
            } else {
              ?>
              <span class="textBig"><b>Your Order</b> #<?php echo $ordmaster['order_id']; ?> has been canceled/declined!</span><br /><br />
              <?php
            }
            ?>
          </div>
          <table class="table table-bordered table-hover">
            <thead>
              <tr>
                <th>Product</th>
                <th>Quantity</th>
                <th>Size</th>
                <th>Color</th>
                <th>Price</th>
              </tr>
            </thead>
            <tbody>
              <?php
              //trace($ordmaster);
              $gTotal = 0;
              $sizeName = $this->config->item('sizeName');
              foreach ($orddetail as $key => $val) {
                $gTotal += $val['product_price'] * $val['quantity'];
                //trace($val);
                if ($val['size_type'] == 'custom') {
                  $size_name = 'Custom';
                  $color_name = 'As Shown';
                } else {
                  $color_name = get_db_field_value("wps_colors", "color_name", "WHERE color_id = '" . $val['color_id'] . "'");
                  $size_name = get_db_field_value("wps_sizes", "size_name", "WHERE size_id = '" . $val['size_id'] . "'");
                }
                ?>
                <tr>
                  <td>
                    <b><?php echo $val['product_name']; ?></b>
                  </td>
                  <td><?php echo $val['quantity']; ?></td>
                  <td>
                    <span class="custom_size"><strong>Size</strong>: <span class="custom"><?php echo $size_name; ?></span>
                      <?php
                      if ($val['size_type'] == 'custom') {
                        ?>
                        <div class="custom-hover">
                          <?php
                          $productSize = explode(',', $val['product_size']);
                          foreach ($sizeName as $key => $vals) {
                            ?>
                            <p><strong><?php echo $vals; ?>: </strong><?php echo $productSize[$key]; ?> CM</p>
                            <?php
                          }
                          ?>
                        </div>
                        <?php
                      }
                      ?>
                    </span>
                  </td>
                  <td><?php echo $color_name; ?></td>
                  <td align="right"> <?php echo display_price($val['product_price'] * $val['quantity']); ?></td>
                </tr>
                <?php
              }
              ?>
            </tbody>
            <tfoot>
              <tr>
                <td colspan="4"><strong>Payment Method:</strong></td>
                <td align="right"><?php echo $ordmaster['payment_method']; ?></td>
              </tr>
              <?php
              if ($ordmaster['payment_method'] == 'Cash') {
                ?>
                <tr>
                  <td colspan="4"><strong>Subtotal:</strong></td>
                  <td align="right"> <?php echo display_price($gTotal); ?></td>
                </tr>
                <!--<tr>
                  <td colspan="2"><strong>COD Changes:</strong></td>
                  <td align="right"> <?php echo display_price('0'); ?></td>
                </tr>-->
                <tr>
                  <td colspan="4"><strong>Total:</strong></td>
                  <td align="right"> <?php echo display_price($gTotal + 0); ?></td>
                </tr>
                <?php
              } else {
                ?>
                <tr>
                  <td colspan="4"><strong>Total:</strong></td>
                  <td align="right"> <?php echo display_price($gTotal); ?></td>
                </tr>
                <?php
              }
              ?>
            </tfoot>
          </table>
          <div class="table-footer">
            <div class="p-details-cart"> <a type="submit" href="<?php echo site_url(); ?>products" title="Continue Shopping" class="order_btn">Continue Shopping</a> </div>           
            <div style="margin-bottom: 20px;">&nbsp;</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- ======footer========= -->
<?php $this->load->view('bottom_application'); ?>