<?php
if (is_array($orders) && !empty($orders)) {
  foreach ($orders as $key => $val) {
    $orderDets = $this->order_model->get_order_detail($val['order_id']);
    //trace($orderDets);
    //trace($val);
    ?>
    <div class="order_item listpager">
      <div class="order_top">
        <div class="row">
          <div class="col-lg-5">
            <a class="orderID" rel="noopener noreferrer" href="<?php echo site_url(); ?>members/order_details/<?php echo $val['order_id']; ?>"><?php echo $val['invoice_number']; ?></a>
          </div>
          <div class="col-lg-3 pull-right text-right">
            <a class="need_btn" href="<?php echo site_url(); ?>members/order_details/<?php echo $val['order_id']; ?>" title="Track"><i class="fa fa-map-marker"></i> Track</a>
          </div>
        </div>
      </div>
      <div class="order_body">
        <?php
        if (is_array($orderDets) && !empty($orderDets)) {
          foreach ($orderDets as $o => $pageVal) {
            $furl = get_db_field_value("wps_products", "friendly_url", "WHERE products_id = '" . $pageVal['products_id'] . "'");
            $img = get_db_field_value("wps_products_media", "media", "WHERE products_id = '" . $pageVal['products_id'] . "'");
            $productName = get_db_field_value("wps_products", "product_name", "WHERE products_id = '" . $pageVal['products_id'] . "'");
            ?>
            <div class="row">
              <div class="col-lg-5 col-md-5 col-sm-5">
                <div class="row">
                  <div class="col-lg-4 col-md-4 col-sm-4">
                    <a href="<?php echo site_url() . $furl; ?>"><img src="<?php echo get_image('product_images', $img, '80', '80', 'R'); ?>" alt = "<?php echo $productName; ?>"></a>
                  </div>
                  <div class="col-lg-8 col-md-8 col-sm-8">
                    <div class="order_info">
                      <a href="<?php echo site_url() . $furl; ?>"><?php echo $productName; ?></a>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-7 col-md-7 col-sm-7">
                <div class="row">
                  <div class="col-lg-3 col-md-3 col-sm-3">
                    <div class="order_price">
                      <?php echo display_price($pageVal['product_price']); ?>
                    </div>
                  </div>
                  <?php
                  if ($val['order_status'] == 'Delivered') {
                    ?>
                    <div class="col-lg-5 col-md-5 col-sm-5">
                      <div class="delivered">
                        <p>Delivered on <?php echo getDateFormat($val['order_delivery_date'], 3); ?></p>
                        <small>Your item has been delivered</small>
                      </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-5">
                      <a class="review_product" href="review.html" title="Rate & Review Product"><i class="fa fa-star"></i> Rate & Review</a>
                    </div>
                    <?php
                  } elseif ($val['order_status'] == 'Canceled') {
                    ?>
                    <div class="col-lg-5 col-md-5 col-sm-5">
                      <div class="delivered">
                        <?php echo ucwords(($this->session->userdata('lang') == 'p') ? $this->lang->line('order_canceled') : 'Order Canceled'); ?>

                      </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-5">

                    </div>
                    <?php
                  }
                  ?>
                </div>
              </div>
            </div>
            <?php
          }
        }
        ?>
      </div>
      <div class="order_foot">
        <div class="row">
          <div class="col-lg-6 col-md-6 col-sm-6">
            <p>Ordered On <?php echo getDateFormat($val['order_received_date'], 3); ?></p>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-6">
            <p class="text-right">Order Total <strong><?php echo display_price($val['total_amount']); ?></strong></p>
          </div>
        </div>
      </div>
    </div>
    <?php
  }
}