<?php
$this->load->view("top_application");
$popular = $this->db->query("SELECT * FROM wps_blog WHERE article_id ORDER BY rand() LIMIT 20")->result_array();
?>
<div class="page_breadcrumbs">
  <div class="container">
    <ul>
      <li><a href="<?php echo site_url(); ?>">Home</a></li>
      <li><a href="<?php echo site_url(); ?>blog">Blog</a></li>
      <li><?php echo $res['article_title']; ?></li>
    </ul>
  </div>
</div>

<section class="about_area">
  <div class="container">
    <div class="row">
      <div class="col-lg-9 col-md-9">
        <div class="blog_wrapper blog_details">
          <article class="single_blog">
            <figure>
              <div class="post_header">
                <h3 class="post_title"><?php echo $res['article_title']; ?></h3>
                <div class="blog_meta">                                        
                  <span class="author">Posted by : <a href="#"><?php echo $res['blog_author']; ?></a> / </span>
                  <span class="meta_date">On : <a href="#"><?php echo getDateFormat($res['post_date'], 3); ?></a> /</span>
                </div>
              </div>
              <div class="blog_thumb">
                <img src="<?php echo get_image('blog', $res['article_image'], '', '', 'R'); ?>" alt="">
              </div>
              <figcaption class="blog_content">
                <div class="post_content"><?php echo $res['article_desc']; ?></div>
                <div class="entry_content">
                  <div class="social_sharing">
                    <p>share this post:</p>
                    <ul>
                      <li><a href="#" title="facebook"><i class="fa fa-facebook"></i></a></li>
                      <li><a href="#" title="twitter"><i class="fa fa-twitter"></i></a></li>
                      <li><a href="#" title="pinterest"><i class="fa fa-pinterest"></i></a></li>
                      <li><a href="#" title="google+"><i class="fa fa-google-plus"></i></a></li>
                      <li><a href="#" title="linkedin"><i class="fa fa-linkedin"></i></a></li>
                    </ul>
                  </div>
                </div>
              </figcaption>
            </figure>
          </article>
          <?php
          if (is_array($comm) && !empty($comm)) {
            ?>
            <div class="comments_box">
              <h3><?php echo count($comm); ?> Comment(s)	</h3>
              <?php
              $sl = 1;
              foreach ($comm as $bval) {
                ?>
                <div class="comment_list <?php //echo ($sl % 2 == 0) ? 'list_two' : ''; ?>">
                  <div class="comment_thumb">
                    <img src="<?php echo theme_url(); ?>images/blog/comment3.png.jpg" alt="">
                  </div>
                  <div class="comment_content">
                    <div class="comment_meta">
                      <h5><a href="#"><?php echo $bval['mem_name']; ?></a></h5>
                      <span><?php echo getDateFormat($bval['post_date'], 6); ?></span> 
                    </div>
                    <p><?php echo $bval['comment']; ?></p>
                  </div>
                </div>
                <?php
                $sl++;
              }
              ?>
            </div>
            <?php
          }
          ?>
          <div class="comments_form">
            <a name="post_comment"></a>
            <h3>Leave a Reply </h3>
            <p>Your email address will not be published. Required fields are marked *</p>
            <form class="sending-form"action="<?php echo current_url(); ?>#post_comment" method="post">
              <?php echo validation_message(); ?>
              <?php echo error_message(); ?>
              <div class="row">
                <div class="col-lg-12 col-md-12">
                  <label for="review_comment">Comment </label>
                  <textarea name="comment" placeholder="Comment"><?php echo set_value('comment'); ?></textarea>
                </div> 
                <div class="col-lg-4 col-md-4">
                  <label for="author">Name</label>
                  <input placeholder="Name" value="<?php echo set_value('name'); ?>" name="name" type="text">
                </div> 
                <div class="col-lg-4 col-md-4">
                  <label for="email">Email </label>
                  <input placeholder="Email" value="<?php echo set_value('email'); ?>" type="text">
                </div>
              </div>
              <input type="hidden" name="action" value="post_comment" />
              <button class="button" type="submit">Post Comment</button>
            </form>    
          </div>
        </div>
        <!--blog grid area start-->
      </div>
      <div class="col-lg-3 col-md-3">
        <div class="left_title">Recent Post</div>
        <div class="category_list post">
          <?php
          if (is_array($popular) && !empty($popular)) {
            ?>
            <ul>
              <?php
              foreach ($popular as $popular) {
                ?>
                <li>
                  <div class="pro-media">
                    <a href="<?php echo site_url($popular['friendly_url']); ?>" title="<?php echo $popular['article_title']; ?>"><img alt="<?php echo $popular['article_title']; ?>" title="<?php echo $popular['article_title']; ?>" src="<?php echo get_image('blog', $popular['article_image'], '75', '75', 'R'); ?>"></a></div>
                  <div class="pro-detail-info"> <a title="<?php echo $popular['article_title']; ?>" href="<?php echo site_url($popular['friendly_url']); ?>"><?php echo $popular['article_title']; ?></a>
                    <div class="post-info"><?php echo getDateFormat($popular['post_date'], 3); ?></div>
                  </div>
                </li>
                <?php
              }
              ?>
            </ul>
            <?php
          }
          ?>
        </div>
      </div>
    </div>
  </div>
</section>
<?php $this->load->view("bottom_application"); ?>