<?php
$this->load->view('includes/header');
$ref_id = $this->input->get_post('ref_id');
?>
<div class="page-title">                    
  <h2><span ></span><?php echo $heading_title; ?></h2>
  <?php
  if ($ref_id > 0) {
    ?>
    <div class="buttons">
      <a href="<?php echo base_url(); ?>sitepanel/product_discounts/add/<?php echo $this->input->get('ref_id'); ?>" class="btn btn-primary pull-right">Add Discount</a>
    </div>
    <?php
  }
  ?>
</div>
<!-- END PAGE TITLE -->                
<!-- PAGE CONTENT WRAPPER -->
<div class="page-content-wrap">
  <div class="fix"></div>
  <div class="row">
    <div class="col-md-12">
      <?php
      if ($this->session->flashdata('success')) {
        ?>
        <div class="alert alert-info">
          <?php echo $this->session->flashdata('success'); ?>
        </div>
        <?php
      }
      ?>
      <!-- START DEFAULT DATATABLE -->
      <div class="panel panel-default">
        <div class="panel-body">
          <div class="table-responsive">
            <?php
            if (is_array($res) && !empty($res)) {
              echo form_open(current_url_query_string(), 'id="data_form"');
              ?>
              <table class="table datatable" width="100%" id="my_data">
                <thead>
                  <tr>
                    <td><input type="checkbox" onclick="$('input[name*=\'arr_ids\']').attr('checked', this.checked);" /></td>
                    <td><strong>Discount Text</strong></td>
                    <td><strong>No Of Products</strong></td>
                    <td><strong>Image</strong></td>
                    <td><strong>Display Order</strong></td>
                    <td><strong>Status</strong></td>
                    <td><strong>Action</strong></td>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  foreach ($res as $catKey => $val) {
                    $displayorder = ($val['sort_order'] != '') ? $val['sort_order'] : "0";
                    ?> 
                    <tr>
                      <td><input type="checkbox" name="arr_ids[]" value="<?php echo $val['discount_id']; ?>" /></td>
                      <td><?php echo $val['discount_text']; ?></td>
                      <td><?php echo $val['no_of_products']; ?></td>
                      <td>
                        <img src="<?php echo get_image_with_name($val['products_id'], 'product_images', $val['discount_image'], 50, 50, 'AR'); ?>" />
                      </td>
                      <td>
                        <input type="text" name="ord[<?php echo $val['discount_id']; ?>]" value="<?php echo $displayorder; ?>" size="5" />
                      </td>
                      <td><?php echo $val['status'] == '1' ? 'Active' : 'Inactive'; ?>
                      </td>
                      <td>
                        <p>                    
                          <?php echo anchor("sitepanel/product_discounts/edit/$val[discount_id]/", "<span>Edit</span>", 'class="btn btn-info" '); ?> 
                        </p>
                        <p>
                          <?php echo anchor("sitepanel/special_offers?ref_id=$val[discount_id]", 'Special Offer', 'target="_blank"'); ?>
                        </p>
                      </td>
                    </tr>
                    <?php
                  }
                  ?> 
                </tbody>
              </table>
              <table class="list" width="100%">
                <tr>
                  <td align="left" colspan="11" style="padding:2px" height="35">
                    <input name="status_action" type="submit"  value="Activate" class="button2" id="Activate" onClick="return validcheckstatus('arr_ids[]', 'Activate', 'Record', 'u_status_arr[]');"/>

                    <input name="status_action" type="submit" class="button2" value="Deactivate" id="Deactivate"  onClick="return validcheckstatus('arr_ids[]', 'Deactivate', 'Record', 'u_status_arr[]');"/>

                    <input name="status_action" type="submit" class="button2" id="Delete" value="Delete"  onClick="return validcheckstatus('arr_ids[]', 'delete', 'Record');"/> 

                    <input name="update_order" type="submit"  value="Update Order" class="button2" />
                  </td>
                </tr>
              </table>
              <?php
              echo form_close();
            } else {
              echo "<center><strong> No record(s) found !</strong></center>";
            }
            ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script type="text/javascript">
  function onclickgroup() {
    if (validcheckstatus('arr_ids[]', 'set', 'record', 'u_status_arr[]')) {
      $('#data_form').submit();
    }
  }
</script>
<?php $this->load->view('includes/footer'); ?>