<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Banner_model extends MY_Model {

  public function __construct() {
    parent::__construct();
  }

  public function get_banner($offset = FALSE, $per_page = FALSE) {
    $keyword = $this->db->escape_str(trim($this->input->get_post('keyword', TRUE)));
    $condtion = ($keyword != '') ? "status !='2' AND ( banner_position LIKE '%" . $keyword . "%') " : "status !='2'";
    $fetch_config = array(
        'condition' => $condtion,
        'order' => "banner_id DESC",
        'limit' => $per_page,
        'start' => $offset,
        'debug' => FALSE,
        'return_type' => "array"
    );
    $result = $this->findAll('wps_banners', $fetch_config);
    return $result;
  }

  public function get_banner_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);
    if ($id > 0) {
      $condtion = "status !='2' AND banner_id=$id";
      $fetch_config = array(
          'condition' => $condtion,
          'debug' => FALSE,
          'return_type' => "object"
      );
      $result = $this->find('wps_banners', $fetch_config);
      return $result;
    }
  }

  public function get_company_banner($limit = '10', $offset = '0', $param = array()) {
    $status = @$param['status'];
    $banner_id = @$param['banner_id'];
    $customers_id = @$param['customers_id'];
    $orderby = @$param['orderby'];
    $where = @$param['where'];
    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);

    if ($customers_id > 0) {
      $this->db->where("companyId ", "$customers_id");
    }
    if ($banner_id != '') {
      $this->db->where("banner_id  ", "$banner_id");
    }
    if ($status != '') {
      $this->db->where("status", "$status");
    }
    if ($where != '') {
      $this->db->where($where);
    }
    if ($keyword != '') {
      $this->db->where("(career_title LIKE '%" . $keyword . "%' OR description LIKE '%" . $keyword . "%' )");
    }
    if ($orderby != '') {
      $this->db->order_by($orderby);
    } else {
      $this->db->order_by('banner_id ', 'desc');
    }

    $this->db->limit($limit, $offset);
    $this->db->select('SQL_CALC_FOUND_ROWS*', FALSE);
    $this->db->from('wps_company_banners');
    $this->db->where('status !=', '2');
    $q = $this->db->get();
    //echo_sql();
    $result = $q->result_array();
    $result = ($limit == '1') ? $result[0] : $result;
    return $result;
  }

  public function get_company_banner_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);
    if ($id > 0) {
      $condtion = "status !='2' AND banner_id=$id";
      $fetch_config = array(
          'condition' => $condtion,
          'debug' => FALSE,
          'return_type' => "object"
      );
      $result = $this->find('wps_company_banners', $fetch_config);
      return $result;
    }
  }

  public function get_company_photo($limit = '10', $offset = '0', $param = array()) {
    $status = @$param['status'];
    $photo_id = @$param['photo_id'];
    $customers_id = @$param['customers_id'];
    $orderby = @$param['orderby'];
    $where = @$param['where'];
    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);

    if ($customers_id > 0) {
      $this->db->where("companyId ", "$customers_id");
    }
    if ($photo_id != '') {
      $this->db->where("photo_id  ", "$photo_id");
    }
    if ($status != '') {
      $this->db->where("status", "$status");
    }
    if ($where != '') {
      $this->db->where($where);
    }
    if ($keyword != '') {
      $this->db->where("(photo_text LIKE '%" . $keyword . "%')");
    }
    if ($orderby != '') {
      $this->db->order_by($orderby);
    } else {
      $this->db->order_by('photo_id ', 'desc');
    }

    $this->db->limit($limit, $offset);
    $this->db->select('SQL_CALC_FOUND_ROWS*', FALSE);
    $this->db->from('wps_company_photos');
    $this->db->where('status !=', '2');
    $q = $this->db->get();
    //echo_sql();
    $result = $q->result_array();
    $result = ($limit == '1') ? $result[0] : $result;
    return $result;
  }

  public function get_company_photo_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);
    if ($id > 0) {
      $condtion = "status !='2' AND photo_id=$id";
      $fetch_config = array(
          'condition' => $condtion,
          'debug' => FALSE,
          'return_type' => "object"
      );
      $result = $this->find('wps_company_photos', $fetch_config);
      return $result;
    }
  }
  
  
  public function get_company_video($limit = '10', $offset = '0', $param = array()) {
    $status = @$param['status'];
    $video_id = @$param['video_id'];
    $customers_id = @$param['customers_id'];
    $orderby = @$param['orderby'];
    $where = @$param['where'];
    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);

    if ($customers_id > 0) {
      $this->db->where("companyId ", "$customers_id");
    }
    if ($video_id != '') {
      $this->db->where("video_id  ", "$video_id");
    }
    if ($status != '') {
      $this->db->where("status", "$status");
    }
    if ($where != '') {
      $this->db->where($where);
    }
    if ($keyword != '') {
      $this->db->where("(video_text LIKE '%" . $keyword . "%')");
    }
    if ($orderby != '') {
      $this->db->order_by($orderby);
    } else {
      $this->db->order_by('video_id ', 'desc');
    }

    $this->db->limit($limit, $offset);
    $this->db->select('SQL_CALC_FOUND_ROWS*', FALSE);
    $this->db->from('wps_company_videos');
    $this->db->where('status !=', '2');
    $q = $this->db->get();
    //echo_sql();
    $result = $q->result_array();
    $result = ($limit == '1') ? $result[0] : $result;
    return $result;
  }

  public function get_company_video_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);
    if ($id > 0) {
      $condtion = "status !='2' AND video_id=$id";
      $fetch_config = array(
          'condition' => $condtion,
          'debug' => FALSE,
          'return_type' => "object"
      );
      $result = $this->find('wps_company_videos', $fetch_config);
      return $result;
    }
  }

}

// model end here