<?php

class Special_offers extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('comments/comments_model', 'products/product_model'));
    $this->load->helper(array('products/product'));
    $this->config->set_item('menu_highlight', 'product management');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
  }

  public function index($page = NULL) {

    $keyword = trim($this->input->get_post('keyword2', TRUE));
    $keyword = $this->db->escape_str($keyword);

    $pagesize = (int) $this->input->get_post('pagesize');

    $ref_id = (int) $this->input->get_post('ref_id');

    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');

    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;

    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $condition = " AND c.status!='2' ";

    if ($ref_id > 0) {
      $condition .= " AND product_id ='" . $ref_id . "' ";
    }

    $status = $this->input->get_post('status');

    if ($status != '') {
      //$condition .= " AND .status = '" . $status . "'";
    }

    $qry_options = array(
        'limit' => $config['limit'],
        'offset' => $offset,
        'condition' => $condition,
        'exjoin' => " INNER JOIN wps_products as c ON c.products_id=a.product_id",
        'exselect' => " ,c.product_name"
    );


    //$res_array = $this->comments_model->get_comments($qry_options);
    $res_array = $this->db->query("select * from wps_product_discount_special_offer where discount_id = '" . $ref_id . "' ")->result_array();


    $config['total_rows'] = get_found_rows();

    $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['res'] = $res_array;


    //update status
    //trace($this->input->post());
    if ($this->input->post('status_action') != '') {
      $this->session->set_flashdata('success', lang('deleted'));
      $this->update_status('wps_product_discount_special_offer', 'special_id');
    }


    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found ";
    $data['heading_title'] = "View Special Offer";
    $this->load->view('catalog/view_special_offer_list', $data);
  }

  /* Add Product Comments */

  public function add() {

    $Id = (int) $this->uri->segment(4);
    $catId = get_db_field_value("wps_products_discounts", "category_id", "where discount_id='" . $Id . "'");
    $pres = $this->db->query("SELECT category_id, category_name FROM wps_categories WHERE category_id = '" . $catId . "'")->row_array();

    if (is_array($pres) && !empty($pres)) {
      $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
      
      $this->form_validation->set_rules('perBox', 'Per Box/Title Text', 'trim|max_length[20]');
      $this->form_validation->set_rules('discount_text', 'Discount Text', 'trim');
      $this->form_validation->set_rules('discount_percentage', 'Discount Percentage', 'trim|max_length[3]|required|numeric');
      $this->form_validation->set_rules('no_of_products', 'No Of Products', 'trim|max_length[3]|required|numeric');
      if ($this->form_validation->run() == TRUE) {
        $quantity = (int) $this->input->post('no_of_products');

        $regular_price = 0;
        $discounted_price = 0;
        $final_carding_cost = 0;

        $posted_data = array(
            'discount_id' => $Id,
            'perBox' => $this->input->post('perBox'),
            'discount_text' => $this->input->post('discount_text'),
            'regular_price' => $regular_price,
            'no_of_products' => $this->input->post('no_of_products'),
            'status' => '1',
        );
        // trace($posted_data);
        // exit();
        $this->comments_model->safe_insert('wps_product_discount_special_offer', $posted_data, FALSE);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('success'));
        redirect('sitepanel/special_offers?ref_id=' . $Id, '');
      }

      $data['pres'] = $pres;
      $data['heading_title'] = "Add Special Offer";
      $this->load->view('catalog/view_post_special_offer', $data);
    } else {
      $this->session->set_userdata(array('msg_type' => 'error'));
      $this->session->set_flashdata('success', 'Category not exists');
      redirect('sitepanel/special_offers/', '');
    }
  }

  /* Edit School Feedback */

  public function edit() {

    $id = (int) $this->uri->segment(4);
    $res = $this->db->query("select * from wps_product_discount_special_offer where special_id = '" . $id . "' ")->row_array();
    //print_r($res);
    if (is_array($res) && !empty($res)) {
      $catId = get_db_field_value("wps_products_discounts", "category_id", "where discount_id='" . $res['discount_id'] . "'");
      $pres = $this->db->query("SELECT category_id, category_name FROM wps_categories WHERE category_id = '" . $catId . "'")->row_array();


      $this->form_validation->set_rules('perBox', 'Per Box/Title Text', 'trim|max_length[20]');
      $this->form_validation->set_rules('discount_text', 'Discount Text', 'trim');
      $this->form_validation->set_rules('discount_percentage', 'Discount Percentage', 'trim|max_length[3]|required|numeric');
      $this->form_validation->set_rules('no_of_products', 'No Of Products', 'trim|max_length[3]|required|numeric');
      if ($this->form_validation->run() == TRUE) {
        $posted_data = array(
            'perBox' => $this->input->post('perBox'),
            'discount_text' => $this->input->post('discount_text'),
            'discount_percentage' => $this->input->post('discount_percentage'),
            'no_of_products' => $this->input->post('no_of_products'),
            'status' => '1',
        );
        $where = "special_id = '" . $id . "'";
        $this->comments_model->safe_update('wps_product_discount_special_offer', $posted_data, $where, FALSE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect('sitepanel/special_offers?ref_id=' . $res['discount_id'], '');
      }
      $data['res'] = $res;
      $data['heading_title'] = "Edit Special Offer";
      $this->load->view('catalog/view_edit_special_offer', $data);
    } else {
      $this->session->set_userdata(array('msg_type' => 'error'));
      $this->session->set_flashdata('success', 'Special Offer not exists');
      redirect('sitepanel/special_offers' . query_string(), '');
    }
  }

}

// End of controller