<?php

class Product_discounts extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('comments/comments_model', 'products/product_model'));
    $this->load->helper(array('products/product'));
    $this->config->set_item('menu_highlight', 'product management');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
  }

  public function index($page = NULL) {
    if ($this->input->post('status_action') != '') {

      $this->update_status('wps_products_discounts', 'discount_id');
    }
 if ($this->input->post('update_order') != '') {
      $this->update_displayOrder('wps_products_discounts', 'sort_order', 'discount_id');
    }


    $keyword = trim($this->input->get_post('keyword2', TRUE));
    $keyword = $this->db->escape_str($keyword);

    $pagesize = (int) $this->input->get_post('pagesize');

    $ref_id = (int) $this->input->get_post('ref_id');

    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');

    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;

    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $condition = " AND c.status!='2' ";

    if ($ref_id > 0) {
      $condition .= " AND product_id ='" . $ref_id . "' ";
    }

    $status = $this->input->get_post('status');

    if ($status != '') {
      //$condition .= " AND .status = '" . $status . "'";
    }

    $qry_options = array(
        'limit' => $config['limit'],
        'offset' => $offset,
        'condition' => $condition,
        'exjoin' => " INNER JOIN wps_products as c ON c.products_id=a.product_id",
        'exselect' => " ,c.product_name"
    );


    //$res_array = $this->comments_model->get_comments($qry_options);
    $res_array = $this->db->query("select * from wps_products_discounts where products_id = '" . $ref_id . "' ")->result_array();


    $config['total_rows'] = get_found_rows();

    $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['res'] = $res_array;
    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found ";
    $data['heading_title'] = "View Discounts";
    $this->load->view('catalog/view_discount_list', $data);
  }

  /* Add Product Comments */

  public function add() {
    $Id = (int) $this->uri->segment(4);
    $condition = array(
        'fields' => "wlp.product_name,wlp.products_id,wlp.product_price,wlp.product_discounted_price",
        'where' => "wlp.products_id ='" . $Id . "'"
    );
    $pres = $this->product_model->get_products('1', '', $condition);


    if (is_array($pres) && !empty($pres)) {
      $pres = $pres[0];

      $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");

      $this->form_validation->set_rules('discount_text', 'Discount Text', 'trim');
      //$this->form_validation->set_rules('regular_price', 'Regular Price', 'trim|required|valid_amount');
      //$this->form_validation->set_rules('discounted_price', 'Discounted Price', 'trim|required|valid_amount');
      //$this->form_validation->set_rules('carding_cost', 'Carding Cost', 'trim|max_length[5]|valid_amount');
      //$this->form_validation->set_rules('shipping_cost', 'Shipping Cost', 'trim|max_length[3]|valid_amount');
      $this->form_validation->set_rules('discount_percentage', 'Discount Percentage', 'trim|max_length[3]|required|numeric');
      $this->form_validation->set_rules('no_of_products', 'No Of Products', 'trim|max_length[3]|required|numeric');
      $this->form_validation->set_rules('discount_image', 'Discount Image', "required|file_allowed_type[image]");
      //$this->form_validation->set_rules('mandatory', 'Mandatory', "trim");

      if ($this->form_validation->run() == TRUE) {
         $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['discount_image']['name'] != '') {
        $config['max_size'] = '2048';
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('discount_image', 'product_images', round(microtime(true)));
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }

      $quantity= (int) $this->input->post('no_of_products');
      if($pres['product_price']>0){
        $dis_price=($pres['product_price']*$this->input->post('discount_percentage')/100);
        $after_discount_price=($pres['product_price']-$dis_price);
        $regular_price=$pres['product_price']*$quantity;
        $discounted_price=$after_discount_price*$quantity;
        $final_carding_cost=($this->input->post('carding_cost')*$quantity);
      }else{
        $regular_price=0;
        $discounted_price=0;
        $final_carding_cost=0;
    }
      
       
        $posted_data = array(
            'products_id' => $pres['products_id'],
            'discount_text' => $this->input->post('discount_text'),
            'regular_price' => $regular_price,
            'discounted_price' => $discounted_price,
            'discount_percentage' => $this->input->post('discount_percentage'),
            'carding_cost' => $this->input->post('carding_cost'),
            'final_carding_cost' => $final_carding_cost,
            'shipping_cost' => $this->input->post('shipping_cost'),
            'no_of_products' => $this->input->post('no_of_products'),
            'discount_image' => $uploaded_file,
            'status' => '1',
            'mandatory' => $this->input->post('mandatory')
        );
        // trace($posted_data);
        // exit();
        $this->comments_model->safe_insert('wps_products_discounts', $posted_data, FALSE);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('success'));
        redirect('sitepanel/product_discounts?ref_id=' . $pres['products_id'], '');
      }

      $data['pres'] = $pres;
      $data['heading_title'] = "Add Discount";
      $this->load->view('catalog/view_post_discount', $data);
    } else {
      $this->session->set_userdata(array('msg_type' => 'error'));
      $this->session->set_flashdata('success', 'Product not exists');
      redirect('sitepanel/product_discounts/', '');
    }
  }

  /* Edit School Feedback */

  public function edit() {

    $id = (int) $this->uri->segment(4);

    $qry_options = array(
        'limit' => 1,
        'offset' => 0,
        'condition' => " AND discount_id ='$id'"
    );

    $res = $this->db->query("select * from wps_products_discounts where discount_id = '" . $id . "' ")->result_array();
//print_r($res);

    if (is_array($res) && !empty($res)) {

      $res = $res[0];
       
      $condition = array(
          'fields' => "wlp.product_name,wlp.products_id,wlp.product_price,wlp.product_discounted_price",
          'where' => "wlp.products_id ='" . $res['products_id'] . "'"
      );

      $pres = $this->product_model->get_products('1', '', $condition);
      
     
      $pres2 = $pres[0];

       $this->form_validation->set_rules('discount_text', 'Discount Text', 'trim');
      //$this->form_validation->set_rules('regular_price', 'Regular Price', 'trim|required|valid_amount');
      //$this->form_validation->set_rules('discounted_price', 'Discounted Price', 'trim|required|valid_amount');
      //$this->form_validation->set_rules('carding_cost', 'Carding Cost', 'trim|max_length[5]|valid_amount');
      //$this->form_validation->set_rules('shipping_cost', 'Shipping Cost', 'trim|max_length[3]|valid_amount');
      $this->form_validation->set_rules('no_of_products', 'No Of Products', 'trim|max_length[3]|required|numeric');
       $this->form_validation->set_rules('discount_percentage', 'Discount Percentage', 'trim|max_length[3]|required|numeric');
      $this->form_validation->set_rules('discount_image', 'Discount Image', "file_allowed_type[image]");
      //$this->form_validation->set_rules('mandatory', 'Mandatory', "trim");
      if ($this->form_validation->run() == TRUE) {
         $uploaded_file = $res['discount_image'];
        $unlink_image = array('source_dir' => "product_images", 'source_file' => $res['discount_image']);
        if (!empty($_FILES) && $_FILES['discount_image']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('discount_image', 'product_images', round(microtime(true)));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }

        $quantity= (int) $this->input->post('no_of_products');
        if($pres2['product_price']>0){
          $dis_price=($pres2['product_price']*$this->input->post('discount_percentage')/100);
          $after_discount_price=($pres2['product_price']-$dis_price);
          $regular_price=$pres2['product_price']*$quantity;
          $discounted_price=$after_discount_price*$quantity;
          $final_carding_cost=($this->input->post('carding_cost')*$quantity);
        }else{
          $regular_price=0;
          $discounted_price=0;
          $final_carding_cost=0;
        }
          

       $posted_data = array(
            'products_id' => $pres2['products_id'],
            'discount_text' => $this->input->post('discount_text'),
            'regular_price' => $regular_price,
            'discounted_price' => $discounted_price,
            'discount_percentage' => $this->input->post('discount_percentage'),
            'carding_cost' => $this->input->post('carding_cost'),
            'final_carding_cost' => $final_carding_cost,
            'shipping_cost' => $this->input->post('shipping_cost'),
            'no_of_products' => $this->input->post('no_of_products'),
            'discount_image' => $uploaded_file,
            'status' => '1',
            'mandatory' => $this->input->post('mandatory')
        );
       // trace($posted_data);
       // exit();
       

        $where = "discount_id = '" . $res['discount_id'] . "'";

        $this->comments_model->safe_update('wps_products_discounts', $posted_data, $where, FALSE);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect('sitepanel/product_discounts?ref_id=' . $pres2['products_id'], '');
      }

      $data['res'] = $res;
      $data['pres'] = $pres;
      $data['heading_title'] = "Edit Discount";
      $this->load->view('catalog/view_edit_discount', $data);
    } else {
      $this->session->set_userdata(array('msg_type' => 'error'));
      $this->session->set_flashdata('success', 'Discount not exists');
      redirect('sitepanel/product_discounts' . query_string(), '');
    }
  }

}

// End of controller