<?php



class Payment extends Public_Controller {



  public function __construct() {

    parent::__construct();

    $this->load->helper(array('payment/paytm', 'payment/encdec_paytm', 'payment/paypal', 'payment/payu', 'payment/razorpay', 'payment/ccavenue', 'cart/cart', 'file'));

    $this->load->model(array('order/order_model', 'payment/payment_model'));

    $this->load->library(array('Dmailer', 'safe_encrypt'));

    $this->lang->load('portuguese', 'portuguese');

    $this->page_section_ct = 'common';

  }



  public function index() {

    $payMode = str_replace('.html', '', $this->input->get_post('pay_method'));

    if ($payMode == "payu") {

      $working_order_id = $this->session->userdata('working_order_id');

      $order_res = $this->order_model->get_order_master($working_order_id);

      //trace($_POST);

      payuForm($order_res);

    } elseif ($payMode == "COD") {

      $this->pay_by_check();

    } elseif ($payMode == "CCAvenue") {

      $data = array('payment_method' => $payMode, 'payment_status' => 'Unpaid');

      $ordId = $this->session->userdata('working_order_id');

      $where = "order_id = '" . $ordId . "' ";

      $order_res = $this->order_model->get_order_master($ordId);

      ccavenueForm($order_res);

    } elseif ($payMode == "RazorPay") {

      $data = array('payment_method' => $payMode, 'payment_status' => 'Unpaid');

      $ordId = $this->session->userdata('working_order_id');

      $where = "order_id = '" . $ordId . "' ";

      $order_res = $this->order_model->get_order_master($ordId);

      razorpayForm($order_res);

    } elseif ($payMode == "paytm") {

      $data = array('payment_method' => $payMode, 'payment_status' => 'Unpaid');

      $ordId = $this->session->userdata('working_order_id');

      $where = "order_id = '" . $ordId . "' ";

      $order_res = $this->order_model->get_order_master($ordId);

      //print_r($order_res); die;

      paytmForm($order_res);

    } elseif ($payMode == "paypal") {

      $data = array('payment_method' => $payMode, 'payment_status' => 'Unpaid');

      $ordId = $this->session->userdata('working_order_id');

      $where = "order_id = '" . $ordId . "' ";

      $order_res = $this->order_model->get_order_master($ordId);

      //echo '<pre>'; print_r($order_res); die;

      paypalForm($order_res);

    } else {

      $data = array('payment_method' => $payMode, 'payment_status' => 'Unpaid');

      $ordId = $this->session->userdata('working_order_id');

      $where = "order_id = '" . $ordId . "' ";

      $order_res = $this->order_model->get_order_master($ordId);
      //echo '<pre>'; print_r($order_res); die;

      paypalForm($order_res);

    }

  }



  function getStatus($order_id) {

    /* initialize an array */

    $paytmParams = array();

    /* Find your MID in your Paytm Dashboard at https://dashboard.paytm.com/next/apikeys */

    $paytmParams["MID"] = PAYTM_MERCHANT_MID;

    /* Enter your order id which needs to be check status for */

    $paytmParams["ORDERID"] = $order_id;

    $checksum = getChecksumFromArray($paytmParams, PAYTM_MERCHANT_KEY);

    /* put generated checksum value here */

    $paytmParams["CHECKSUMHASH"] = $checksum;



    /* prepare JSON string for request */

    $post_data = json_encode($paytmParams, JSON_UNESCAPED_SLASHES);



    /* for Staging */

    // $url = "https://securegw-stage.paytm.in/order/status";



    /* for Production */

    $url = "https://securegw.paytm.in/order/status";



    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_POST, 1);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

    $response = curl_exec($ch);

    print_r($response);

  }



  public function payment_status() {

    //dd($this->input->post());

    $paytmChecksum = "";

    $paramList = array();

    $isValidChecksum = "FALSE";

    $paramList = $_POST;



    $paytmChecksum = isset($_POST["CHECKSUMHASH"]) ? $_POST["CHECKSUMHASH"] : "";

    //Sent by Paytm pg//Verify all parameters received from Paytm pg to your application. Like MID received from paytm pg is same as your applicationÃ¢â‚¬â„¢s MID, TXN_AMOUNT and ORDER_ID are same as what was sent by you to Paytm PG for initiating transaction etc.

    $isValidChecksum = verifychecksum_e($paramList, PAYTM_MERCHANT_KEY, $paytmChecksum);



    //get Status

    $this->getStatus($_POST['ORDERID']);

    // echo "<br/><br/>";

    //  print_r($_POST);

    // // echo "<br/><br/>";

    // // print_r($isValidChecksum);

    //  exit();

    //will return TRUE or FALSE string.

    if ($isValidChecksum == "TRUE") {

      //echo "<b>Checksum matched and following are the transaction details:</b>" . "<br/>";

      if ($_POST["STATUS"] == "TXN_SUCCESS") {

        //echo "<b>Transaction status is success</b>" . "<br/>";

        //Process your transaction here as success transaction.

        //Verify amount & order id received from Payment gateway with your application's order id and amount.

        if (isset($_POST) && count($_POST) > 0) {

          foreach ($_POST as $paramName => $paramValue) {

            //echo "<br/>" . $paramName . " = " . $paramValue;

          }

        }

        $ordId = $_POST['ORDERID'];

        $response = json_encode($_POST);

        $this->session->unset_userdata('posted_data');

        $this->cart->destroy();

        //update payment status

        $data = array('payment_method' => 'Online Payment (PayTm)', 'payment_status' => 'Paid', 'paymentResponse' => $response);

        $where = "order_id = '$ordId' ";

        $this->payment_model->safe_update('wps_order', $data, $where, false);

        redirect('payment/order_success/' . md5($ordId), '');

        // redirect('payment/order_success/' . $ordId, '');

        /* echo_sql();        //exit;    */

      } else {

        $ordId = $_POST['ORDERID'];

        $this->session->unset_userdata('posted_data');

        $this->cart->destroy();

        redirect('payment/order_cancle/' . md5($ordId), '');

        //redirect('payment/order_cancle/' . $ordId, '');

        //echo "<b>Transaction status is failure</b>" . "<br/>";

      }

    } else {

      $ordId = $_POST['ORDERID'];

      $this->session->unset_userdata('posted_data');

      $this->cart->destroy();

      redirect('payment/order_cancle/' . md5($ordId), '');

      //echo "<b>Checksum mismatched.</b>";      //Process transaction as suspicious.

    }

  }



  public function payment_status_custom() {

    //dd($this->input->post());

    $paytmChecksum = "";

    $paramList = array();

    $isValidChecksum = "FALSE";

    $paramList = $_POST;



    $paytmChecksum = isset($_POST["CHECKSUMHASH"]) ? $_POST["CHECKSUMHASH"] : "";

    $isValidChecksum = verifychecksum_e($paramList, PAYTM_MERCHANT_KEY, $paytmChecksum);



    //  print_r($_POST);

    // // echo "<br/><br/>";

    // // print_r($isValidChecksum);

    //  exit();

    //will return TRUE or FALSE string.

    if ($isValidChecksum == "TRUE") {

      //echo "<b>Checksum matched and following are the transaction details:</b>" . "<br/>";

      if ($_POST["STATUS"] == "TXN_SUCCESS") {

        //echo "<b>Transaction status is success</b>" . "<br/>";

        if (isset($_POST) && count($_POST) > 0) {

          foreach ($_POST as $paramName => $paramValue) {

            //echo "<br/>" . $paramName . " = " . $paramValue;

          }

        }

        $ordId = $_POST['ORDERID'];

        $response = json_encode($_POST);

        //update payment status

        $data = array('payment_status' => 'Paid', 'payment_response' => $response);

        $where = "order_id = '$ordId' ";

        $this->payment_model->safe_update('wps_payment', $data, $where, false);

        redirect('payment/payment_success/' . $ordId, '');

      } else {

        $ordId = $_POST['ORDERID'];

        $this->session->unset_userdata('posted_data');

        $this->cart->destroy();

        redirect('payment/payment_cancel/' . $ordId, '');

      }

    } else {

      $ordId = $_POST['ORDERID'];

      $this->session->unset_userdata('posted_data');

      $this->cart->destroy();

      redirect('payment/payment_cancel/' . $ordId, '');

      //echo "<b>Checksum mismatched.</b>";      //Process transaction as suspicious.

    }

  }



  public function payment_success() {

    $ordId = $this->uri->segment(3);

    $data = array('payment_status' => 'Paid');

    // $where = "MD5(order_id) = '$ordId' ";

    $where = "order_id = '$ordId' ";

    $this->payment_model->safe_update('wps_payment', $data, $where, FALSE);

    //echo_sql();

    //exit;

    //$res = get_db_field_value('wps_payment', 'order_id', array('MD5(order_id)' => $ordId));

    $res = get_db_field_value('wps_payment', 'order_id', array('order_id' => $ordId));



    $mail_subject = $this->config->item('site_name') . " Payment Successfull!";

    $from_email = $this->admin_info->admin_email;

    $from_name = $this->config->item('site_name');

    $mail_to = $res['email'];

    $body = 'Your payment is successfull!';



    $mail_conf = array(

        'subject' => $this->config->item('site_name') . " Order overview",

        'to_email' => $mail_to,

        'from_email' => $from_email,

        'from_name' => $this->config->item('site_name'),

        'body_part' => $body

    );

    //trace($mail_conf); die;

    $this->dmailer->mail_notify($mail_conf);

    $mail_conf2 = array(

        'subject' => $this->config->item('site_name') . " Order overview",

        'to_email' => "shelleyincusa@gmail.com",

        'from_email' => $from_email,

        'from_name' => $this->config->item('site_name'),

        'body_part' => $body

    );

    //trace($mail_conf); die;

    //$this->dmailer->mail_notify($mail_conf2);

    $mail_conf3 = array(

        'subject' => $this->config->item('site_name') . " Order overview",

        'to_email' => "shelleyent@aol.com",

        'from_email' => $from_email,

        'from_name' => $this->config->item('site_name'),

        'body_part' => $body

    );

    $this->dmailer->mail_notify($mail_conf3);

    $mail_conf4 = array(

        'subject' => $this->config->item('site_name') . " Order overview",

        'to_email' => "webpulseindia@gmail.com",

        'from_email' => $from_email,

        'from_name' => $this->config->item('site_name'),

        'body_part' => $body

    );

    $this->dmailer->mail_notify($mail_conf4);







    $this->session->set_flashdata('msg', $this->config->item('payment_success'));

    redirect('payment/thanks_custom/' . $ordId, '');

  }



  public function thanks_custom() {

    $order_id = str_replace('.html', '', $this->uri->segment(3));

    $res = $this->db->query("SELECT * FROM wps_payment WHERE order_id = '$order_id'")->row_array();

    $data['res'] = $res;

    $this->load->view('payment/pay_thanks_custom', $data);

  }



  public function payment_cancel() {

    $ordId = $this->uri->segment(3);

    $data = array('payment_status' => 'Canceled');

    $where = "order_id = '$ordId' ";

    $this->payment_model->safe_update('wps_payment', $data, $where, FALSE);

    $this->session->set_flashdata('msg', $this->config->item('payment_failed'));

    redirect('payment/thanks_custom/' . $ordId, '');

  }



  public function pay_by_check() {

    $data = array('payment_method' => 'Cash', 'payment_status' => 'Unpaid');

    $ordId = $this->session->userdata('working_order_id');

    $where = "order_id = '" . $ordId . "' ";

    $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

    $condition = "&& order_id='" . $ordId . "'";

    $cupn = $this->order_model->get_orders(0, 1, $condition);

    $cupn = $cupn[0];

    $ordId = md5($ordId);

    $res = get_db_field_value('wps_order', 'order_id', array('MD5(order_id)' => $ordId));

    $ordmaster = $this->order_model->get_order_master($res);

    $orddetail = $this->order_model->get_order_detail($res);

    if (is_array($ordmaster) && !empty($ordmaster)) {

      ob_start();

      $mail_subject = $this->config->item('site_name') . " Order Oerview";

      $from_email = $this->admin_info->admin_email;

      $from_name = $this->config->item('site_name');

      $mail_to = $ordmaster['email'];

      $body = invoice_content_print($ordmaster, $orddetail);

      $msg = ob_get_contents();

      $mail_conf = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => $mail_to,

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $msg

      );

      //trace($mail_conf); die;

      $this->dmailer->mail_notify($mail_conf);



      $mail_conf2 = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => "shelleyincusa@gmail.com",

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $body

      );

      //trace($mail_conf); die;

      //$this->dmailer->mail_notify($mail_conf2);

      $mail_conf3 = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => "shelleyent@aol.com",

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $body

      );

      $this->dmailer->mail_notify($mail_conf3);

      $mail_conf4 = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => "webpulseindia@gmail.com",

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $body

      );

      $this->dmailer->mail_notify($mail_conf4);

    }

    redirect('payment/thanks/' . $ordId, '');

  }



  public function order_success() {

    $ordId = $this->uri->segment(3);

    $this->session->unset_userdata(array('discount_amount' => 0));

    $this->session->unset_userdata(array('discount_amount2' => 0));

    //update payment status

    $data = array('payment_method' => 'PayTm', 'payment_status' => 'Paid');

    $where = "MD5(order_id) = '$ordId' ";

    //$where = "order_id = '$ordId' ";

    $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

    //echo_sql();

    //exit;

    // $res = get_db_field_value('wps_order', 'order_id', array('MD5(order_id)' => $ordId));

    $res = get_db_field_value('wps_order', 'order_id', array('order_id' => $ordId));

    $ordmaster = $this->order_model->get_order_master($res);

    $orddetail = $this->order_model->get_order_detail($res);

    if (is_array($ordmaster) && !empty($ordmaster)) {

      ob_start();

      $mail_subject = $this->config->item('site_name') . " Order Oerview";

      $from_email = $this->admin_info->admin_email;

      $from_name = $this->config->item('site_name');

      $mail_to = $ordmaster['email'];

      $body = invoice_content_print($ordmaster, $orddetail);

      $msg = ob_get_contents();



      $mail_conf = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => $mail_to,

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $msg

      );

      //trace($mail_conf); die;

      $this->dmailer->mail_notify($mail_conf);

      $mail_conf2 = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => "shelleyincusa@gmail.com",

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $body

      );

      //trace($mail_conf); die;

      //$this->dmailer->mail_notify($mail_conf2);

      $mail_conf3 = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => "shelleyent@aol.com",

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $body

      );

      $this->dmailer->mail_notify($mail_conf3);

      $mail_conf4 = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => "webpulseindia@gmail.com",

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $body

      );

      $this->dmailer->mail_notify($mail_conf4);

    }



    $this->session->set_flashdata('msg', $this->config->item('payment_success'));

    redirect('payment/thanks/' . $ordId, '');

  }



  public function order_success_paypal() {

    //trace($_POST);

    //trace($_GET);

    //exit;

    $paymentResponse = json_encode($_POST);



    $ordId = $this->uri->segment(3);

    $this->session->unset_userdata(array('discount_amount' => 0));

    if ($_POST['payment_status'] == 'Completed') {



      //update payment status

      $data = array('payment_method' => 'Paypal', 'payment_status' => 'Paid', 'paymentResponse' => $paymentResponse);

      $where = "MD5(order_id) = '$ordId' ";

      //$where = "order_id = '$ordId' ";

      $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

      $res = get_db_field_value('wps_order', 'order_id', array('MD5(order_id)' => $ordId));

      //$res = get_db_field_value('wps_order', 'order_id', array('order_id' => $ordId));

      $ordmaster = $this->order_model->get_order_master($res);

      $orddetail = $this->order_model->get_order_detail($res);

      if (is_array($ordmaster) && !empty($ordmaster)) {

        ob_start();

        $mail_subject = $this->config->item('site_name') . " Order Oerview";

        $from_email = $this->admin_info->admin_email;

        $from_name = $this->config->item('site_name');

        $mail_to = $ordmaster['email'];

        $body = invoice_content_print($ordmaster, $orddetail);

        $msg = ob_get_contents();



        $mail_conf = array(

            'subject' => $this->config->item('site_name') . " Order overview",

            'to_email' => $mail_to,

            'from_email' => $from_email,

            'from_name' => $this->config->item('site_name'),

            'body_part' => $msg

        );

        $this->dmailer->mail_notify($mail_conf);



 if($this->admin_info->website_mode=='Live'){

        $mail_conf2 = array(

            'subject' => $this->config->item('site_name') . " Order overview",

            'to_email' => "shelleyincusa@gmail.com",

            'from_email' => $from_email,

            'from_name' => $this->config->item('site_name'),

            'body_part' => $msg

        );

        //$this->dmailer->mail_notify($mail_conf2);

        $mail_conf3 = array(

            'subject' => $this->config->item('site_name') . " Order overview",

            'to_email' => "shelleyent@aol.com",

            'from_email' => $from_email,

            'from_name' => $this->config->item('site_name'),

            'body_part' => $msg

        );

        $this->dmailer->mail_notify($mail_conf3);

        $mail_conf4 = array(

            'subject' => $this->config->item('site_name') . " Order overview",

            'to_email' => "webpulseindia@gmail.com",

            'from_email' => $from_email,

            'from_name' => $this->config->item('site_name'),

            'body_part' => $msg

        );

        $this->dmailer->mail_notify($mail_conf4);

      }else{

           $mail_conf5 = array(

            'subject' => $this->config->item('site_name') . " Order overview",

            'to_email' => "test.webpulse@gmail.com",

            'from_email' => $from_email,

            'from_name' => $this->config->item('site_name'),

            'body_part' => $msg

           );

          $this->dmailer->mail_notify($mail_conf5);

      }

      }



      $this->session->set_flashdata('msg', $this->config->item('payment_success'));

      redirect('payment/thanks/' . $ordId, '');

    } else {

      //update payment status

      $data = array('payment_method' => 'Paypal', 'payment_status' => 'Pending', 'paymentResponse' => $paymentResponse);

      $where = "MD5(order_id) = '$ordId' ";

      //$where = "order_id = '$ordId' ";

      $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

      // echo_sql();

      // exit;

      //Mailer Start

       $subject = "www.magnetichub.com - Payment not captured";

         $body='<html><head></head><body>

              <table border="0" width="100%">

              <tbody>

              <tr>

              <td colspan="2">

              Payment not captured : '.$ordId.'</td>

              </tr>

              <tr>

              <td colspan="2">

              &nbsp;</td>

              </tr>

             <tr>

              <td colspan="2">

              &nbsp;</td>

              </tr>

              </tbody>

              </table><br/>

              <span style="margin-top:15px">

               Thank you.<br>

               '.$this->config->item('site_name').' Customer Service<br>

               Email: <a href="mailto:'.$this->admin_info->admin_email.'" target="_blank">'.$this->admin_info->admin_email.'</a><div class="yj6qo"></div><div class="adL"> 

              </div></span></body</html>';

        $mail_conf = array(

            'subject' => $subject,

            'to_email' => $mail_to, 

            'from_email' => $from_email,

            'from_name' => $this->config->item('site_name'),

            'body_part' => $body,

        );

        $this->dmailer->mail_notify($mail_conf);

      //Mailer End



      $this->session->set_flashdata('msg', 'Payment Not Captured');

      redirect('payment/thanks/' . $ordId, '');

    }

  }



  public function order_success_old() {

    $ordId = $this->uri->segment(3);

    $workingKey = '2130A8AF3A5EC388D6F3E018E1C523FF';  //Working Key should be provided here.

    if (!isset($_POST["encResp"])) {

      redirect(site_url(), 'refresh');

      exit;

    }

    $encResponse = $_POST["encResp"];   //This is the response sent by the CCAvenue Server

    $rcvdString = decrypt($encResponse, $workingKey);  //Crypto Decryption used as per the specified working key.

    $order_status = "";

    $decryptValues = explode('&', $rcvdString);

    $dataSize = sizeof($decryptValues);



    for ($i = 0; $i < $dataSize; $i++) {

      $information = explode('=', $decryptValues[$i]);

      if ($i == 3)

        $order_status = $information[1];

    }



    if ($order_status === "Success") {

      //update payment status

      $data = array('payment_method' => 'CCAvenue', 'payment_status' => 'Paid');

      $where = "MD5(order_id) = '$ordId' ";

      $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

      //echo_sql();

      //exit;



      $res = get_db_field_value('wps_order', 'order_id', array('MD5(order_id)' => $ordId));

      $ordmaster = $this->order_model->get_order_master($res);

      $orddetail = $this->order_model->get_order_detail($res);

      if (is_array($ordmaster) && !empty($ordmaster)) {

        ob_start();

        $mail_subject = $this->config->item('site_name') . " Order Oerview";

        $from_email = $this->admin_info->admin_email;

        $from_name = $this->config->item('site_name');

        $mail_to = $ordmaster['email'];

        $body = invoice_content_print($ordmaster, $orddetail);

        $msg = ob_get_contents();



        $mail_conf = array(

            'subject' => $this->config->item('site_name') . " Order overview",

            'to_email' => $mail_to,

            'from_email' => $from_email,

            'from_name' => $this->config->item('site_name'),

            'body_part' => $msg

        );

        //trace($mail_conf); die;

        $this->dmailer->mail_notify($mail_conf);

      }



      $this->session->set_flashdata('msg', $this->config->item('payment_success'));

      redirect('payment/thanks/' . $ordId, '');



      //echo "<br>Thank you for shopping with us. Your credit card has been charged and your transaction is successful. We will be shipping your order to you soon.";

    } else {

      if ($order_status === "Aborted") {

        $msg = "<br>Thank you for shopping with us.We will keep you posted regarding the status of your order through e-mail";

      } else if ($order_status === "Failure") {

        $msg = "<br>Thank you for shopping with us.However,the transaction has been declined.";

      } else {

        $msg = "<br>Security Error. Illegal access detected";

      }

      //update payment status

      $data = array('payment_method' => 'CCAvenue', 'payment_status' => 'Unpaid');

      $where = "MD5(order_id) = '$ordId' ";

      $this->payment_model->safe_update('wps_order', $data, $where, FALSE);



      $this->session->set_userdata('order_status', $order_status);

      $this->session->set_userdata('ermsg', $msg);

      redirect('payment/failed/' . $ordId, '');

    }

  }



  public function order_cancle() {



    //trace($_POST);

    //exit;



    $ordId = $this->uri->segment(3);

    //$data = array('order_status' => 'Canceled');
    $data = array('order_status' => '5','order_cancelled_date'=>date('Y-m-d H:i:s')); //Canceled    Cancelled
    $where = "MD5(order_id) = '$ordId' ";

    $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

    $this->session->unset_userdata(array('working_order_id' => 0));

    $this->session->set_flashdata('msg', $this->config->item('payment_failed'));

    redirect('payment/thanks/' . $ordId, '');

  }



  public function thanks() {



    $order_id = str_replace('.html', '', $this->uri->segment(3));

    $res = get_db_field_value('wps_order', 'order_id', array('md5(order_id)' => $order_id));



    if ($res > 0) {

      $data['title'] = "Invoice Print";

      $order_res = $this->order_model->get_order_master($res);

      //trace($order_res);

      $order_details_res = $this->order_model->get_order_detail($res);

      $data['orddetail'] = $order_details_res;

      $data['ordmaster'] = $order_res;

      $this->load->view('payment/pay_thanks', $data);

    }

  }



  public function failed_old() {

    $order_id = str_replace('.html', '', $this->uri->segment(3));

    $res = get_db_field_value('wps_order', 'order_id', array('MD5(order_id)' => $order_id));

    //trace($res);exit;

    if ($res > 0) {

      $data['title'] = "Invoice Print";

      $order_res = $this->order_model->get_order_master($res);

      //trace($order_res);

      $order_details_res = $this->order_model->get_order_detail($res);

      $data['orddetail'] = $order_details_res;

      $data['ordmaster'] = $order_res;

      $this->load->view('payment/pay_fail', $data);

    }

  }



  //RAZORPAY INTEGRATION STARTS HERE

  private function get_curl_handle($payment_id, $amount) {

    $amount = ($amount > 0) ? $amount : 100;

    $headers = array();

    $url = 'https://api.razorpay.com/v1/payments/' . $payment_id . '/capture';

    $key_id = RAZOR_KEY_ID;

    $key_secret = RAZOR_KEY_SECRET;

    $headers[] = "Content-Type: application/json";

    $headers[] = 'Authorization:Basic ' . base64_encode($key_id . ':' . $key_secret);



    $post_data = json_encode(array(

        "amount" => $amount,

    ));

    $timeout = 100; // set to zero for no timeout

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_HEADER, 0);

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);

    $result = curl_exec($ch);

    //$curl_error = curl_errno($ch);

    //trace($result);

    return $result;

  }



  // callback method

  public function callback() {

    //trace($_POST);

    if (!empty($this->input->post('razorpay_payment_id'))) {

      $razorpay_payment_id = $this->input->post('razorpay_payment_id');

      //trace($this->session->userdata);

      $merchant_order_id = $this->uri->segment(3); //$this->session->userdata('working_order_id');



      $where = "order_id = '" . $merchant_order_id . "' ";

      $order_res = $this->order_model->get_order_master($merchant_order_id);

      $amount = (($order_res['total_amount'] + $order_res['shipping_amount']) * 100);



      $success = false;

      $error = '';

      try {

        $result = $this->get_curl_handle($razorpay_payment_id, $amount);

        //trace($result);

        //execute post

        if ($result === false) {

          $success = false;

          $data = array('payment_method' => 'RazorPay', 'paymentResponse' => $result);

          $where = "order_id = '$merchant_order_id' ";

          $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

          redirect(site_url() . 'payment/failed/' . $merchant_order_id);

          //$error = 'Curl error: ' . curl_error($ch);

        } else {

          $response_array = json_decode($result, true);

          if (isset($response_array['status']) && $response_array['status'] == 'captured') {

            $this->success($merchant_order_id, $result);

          } elseif ($response_array['error']['field']['status'] == 'captured') {

            $this->success($merchant_order_id, $result);

          } else {

            $data = array('payment_method' => 'RazorPay', 'paymentResponse' => $result);

            $where = "order_id = '$merchant_order_id' ";

            $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

            redirect(site_url() . 'payment/failed/' . $merchant_order_id);

          }

        }

      } catch (Exception $e) {

        $success = false;

        $data = array('payment_method' => 'RazorPay', 'paymentResponse' => $result);

        $where = "order_id = '$merchant_order_id' ";

        $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

        redirect(site_url() . 'payment/failed/' . $merchant_order_id);

      }

    } else {

      $data = array('payment_method' => 'RazorPay', 'paymentResponse' => $result);

      $where = "order_id = '$merchant_order_id' ";

      $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

      redirect(site_url() . 'payment/failed/' . $merchant_order_id);

      //echo 'An error occured. Contact site administrator, please!';

    }

  }



  public function success($ordId, $response) {

    $data = array('payment_method' => 'RazorPay', 'payment_status' => 'Paid', 'paymentResponse' => $response);

    $where = "order_id = '$ordId' ";

    $this->payment_model->safe_update('wps_order', $data, $where, FALSE);

    //echo_sql();

    //exit;



    $res = get_db_field_value('wps_order', 'order_id', array('order_id' => $ordId));

    $ordmaster = $this->order_model->get_order_master($res);

    $orddetail = $this->order_model->get_order_detail($res);

    $order_res = $orddetail;

    if (is_array($ordmaster) && !empty($ordmaster)) {

      ob_start();

      $mail_subject = $this->config->item('site_name') . " Order Oerview";

      $from_email = $this->admin_info->admin_email;

      $from_name = $this->config->item('site_name');

      $mail_to = $ordmaster['email'];

      $body = invoice_content_print($ordmaster, $orddetail);

      $msg = ob_get_contents();

      $ord_data['orddetail'] = $orddetail;

      $ord_data['ordmaster'] = $ordmaster;

      //$msg = $this->load->view('mailers/order_success', $ord_data, true);

      //mail to user

      $mail_conf = array(

          'subject' => $this->config->item('site_name') . " Order overview",

          'to_email' => $mail_to,

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $msg

      );

      //trace($mail_conf); die;

      $this->dmailer->mail_notify($mail_conf);

      //end

      //Mail to Admin

      $mail_conf = array(

          'subject' => "New Order Received",

          'to_email' => $from_email,

          'from_email' => $from_email,

          'from_name' => $this->config->item('site_name'),

          'body_part' => $msg

      );

      //trace($mail_conf); die;

      //$this->dmailer->mail_notify($mail_conf);

      //End here

      //Inventory Updation

      foreach ($order_res as $res1) {

        $qty1 = $res1['quantity'];

        //$this->db->query("UPDATE wps_products SET product_qty = product_qty-$qty1 WHERE products_id='" . $res['products_id'] . "'");

      }

    }



    $this->session->set_flashdata('msg', $this->config->item('payment_success'));

    redirect('payment/thanks/' . md5($ordId), '');

    //$this->load->view('razorpay/success', $data);

  }



  public function failed() {

    $ordId = $this->uri->segment(3);

    //trace($this->session->userdata);

    //trace($_POST);

    //echo $ordId; die;

    $data = array('order_status' => 'Canceled');

    $where = "order_id = '$ordId' ";

    $this->payment_model->safe_update('wps_order', $data, $where, FALSE);



    $res = get_db_field_value('wps_order', 'order_id', array('order_id' => $ordId));

    $this->session->unset_userdata(array('working_order_id' => 0));

    $this->session->set_flashdata('msg', $this->config->item('payment_failed'));



    $ordmaster = $this->order_model->get_order_master($res);

    //trace($ordmaster);

    $orddetail = $this->order_model->get_order_detail($res);

    $data['orddetail'] = $orddetail;

    $data['ordmaster'] = $ordmaster;



    $this->load->view('payment/pay_thanks', $data);

    //$this->load->view('razorpay/failed', $data);

  }



}



/* End of file member.php */



/* Location: .application/modules/products/controllers/cart.php */