<?php
$this->load->view('top_application');
$adminRes = get_site_email();
?>
<div class="container">
        <div class="breadcrumb-banner row">
            <div class="text-container">
                <ul class="breadcrumb-listing">
                    <li><a href="<?=site_url();?>" title="Home">Home</a></li>
                    <li><?php echo $content['page_name']; ?></li>
                </ul>
            </div>
        </div>
<div class="contact_area">
  <div class="container">
    <div class="row">
      <div class="col-lg-6">
        <div class="contact-message">
          <h1 class="contact-title">Contact Form</h1>
          <?php if($this->session->flashdata('success')) echo '
          <div class="alert alert-success success" style="padding: 8px 8px 8px 40px;">'.$this->session->flashdata('success').'</div>
          <br/>'; ?>
          <?php if($this->session->flashdata('error')) echo '
          <div class="alert alert-warning error" style="padding: 8px 8px 8px 40px;">'.$this->session->flashdata('error').'</div>
          <br/>'; ?>
          <form id="contact-form" name="contactform" method="post" class="contact-form">
            <div class="row">
              <div class="col-lg-6 col-md-6 col-sm-6">
                <input name="first_name" value="<?php echo set_value('first_name'); ?>" placeholder="First Name *" type="text" required="" onKeyPress="return isAlpha(event)" pattern="[a-z A-Z]+" />
              </div>
              <div class="col-lg-6 col-md-6 col-sm-6">
                <input name="last_name" value="<?php echo set_value('last_name'); ?>" placeholder="Last Name *" type="text" required="" onKeyPress="return isAlpha(event)" pattern="[a-z A-Z]+" />
              </div>
              <div class="col-lg-6 col-md-6 col-sm-6">
                <input name="phone" value="<?php echo set_value('phone'); ?>" placeholder="Phone *" type="text" maxlength="10" minlength="10" onKeyPress="return isNumberKey(event)" required="" />
              </div>
              <div class="col-lg-6 col-md-6 col-sm-6">
                <input name="email" placeholder="Email *" type="email" value="<?php echo set_value('email'); ?>" required="" />
              </div>
              <div class="col-lg-12 col-md-12">
                <div class="contact2-textarea text-center">
                  <textarea placeholder="Message *" name="message" class="form-control2" onKeyPress="return isAlphaNumeric(event)" size="500" ondrop="return false;" onpaste="return false;" onkeyup="isURL(this);" required="">
                    <?php echo set_value( 'message'); ?>
                  </textarea>
                </div>
                <div class="form-selector">
                  <div class="g-recaptcha" data-sitekey="<?php echo CAPTCHA_SITEKEY; ?>" style="transform:scale(0.80);-webkit-transform:scale(0.70);transform-origin:0 0;-webkit-transform-origin:0 0;outline:0"></div>
                  <?php echo form_error( 'g-recaptcha-response'); ?>
                </div>
                <div class="contact-btn">
                  <button class="contact_btn" type="submit">Submit</button>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="contact-info">
          <h2 class="contact-title">contact us</h2>
          <div>
            <?php echo $content[ 'page_description']; ?>
          </div>
          <ul>
            <li><i class="fa fa-map-marker"></i> Address :
              <?php echo $adminRes->address; ?></li>
            <!--  <li><i class="fa fa-envelope-o"></i> <?php echo $adminRes->admin_email; ?></li> -->
            <li><i class="fa fa-phone"></i> 
              <?php echo $adminRes->phone; ?></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>
<iframe class="contact_map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3314.7724250271754!2d-118.3090677847911!3d33.81818548067022!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80dd4a9b6cdba0c5%3A0x599b2f8b68dbba5c!2sShelley%20Enterprises!5e0!3m2!1sen!2sin!4v1576221499879!5m2!1sen!2sin" frameborder="0" style="border:0;" allowfullscreen=""></iframe>

</div>
<?php $this->load->view('bottom_application'); ?>
   <script src="https://www.google.com/recaptcha/api.js"></script>
<script type="text/javascript">
  
function isAlphaNumeric(key) {
   var regex = new RegExp("^[A-Za-z0-9? ,_-]+$");
        var key = String.fromCharCode(event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
}
function isAlpha(key) {
   var regex = new RegExp("^[a-zA-Z]+$");
        var key = String.fromCharCode(event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
}
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : event.keyCode;
    if ((charCode < 48 || charCode > 57))
        return false;

    return true;
}
function isURL(emailField){
    var reg = /(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;

    if (reg.test(emailField.value) == true) 
    {
        $('#enmessage').val('');
        return false;
    }
    var reg2 =/<(.|\n),*?>/g; 
    if (reg2.test(emailField.value) == true) {
        $('#enmessage').val('');
        return false;
    }
}
</script>
