<?php

class Pages extends Public_Controller {

  public function __construct() {

    parent::__construct();
    $this->load->helper(array('file', 'currency', 'payment/paytmCustom','payment/encdec_paytm'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->load->model(array('pages/pages_model', 'members/members_model'));
    $this->lang->load('portuguese', 'portuguese');
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
    $this->page_section_ct = 'static';
  }

  public function index() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/cms_page_view', $data);
  }

  public function aboutus() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['banner'] = get_db_field_value("wps_banners", "banner_image", "WHERE banner_page='about' ORDER BY RAND()");
    $this->load->view('pages/about', $data);
  }
 public function testimonials() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['testimonials'] = $this->db->query("SELECT * FROM wps_testimonial WHERE status='1'")->result_array();
    $this->load->view('pages/testimonials', $data);
  }

 

  public function contactus() {

    //trace($_SERVER['HTTP_REFERER']);
    $this->form_validation->set_rules('first_name', 'First Name', 'trim|required|alpha');
    $this->form_validation->set_rules('last_name', 'Last Name', 'trim|required|alpha');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[10]');
    $this->form_validation->set_rules('message', 'Comment', 'trim|required|alpha_extra');
     $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');
    
    if ($this->form_validation->run() == TRUE) {
       $post_data = http_build_query(
             array(
                 'secret' => CAPTCHA_SECRET,
                 'response' => $_POST['g-recaptcha-response'],
                 'remoteip' => $_SERVER['REMOTE_ADDR'],
             )
       );
       $opts = array('http' => array(
               'method' => 'POST',
               'header' => 'Content-type: application/x-www-form-urlencoded',
               'content' => $post_data,
           ),
       );
       $context = stream_context_create($opts);
       $response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
       $capcha_result = json_decode($response);
       if (!$capcha_result->success) {
         //throw new Exception('Gah! CAPTCHA verification failed. Please try again', 1);
          $msg = "CAPTCHA verification failed!";
          $this->session->set_userdata(array('msg_type' => 'error'));
          $this->session->set_flashdata('error', $msg);
          $friendly_url = $this->uri->uri_string;
          $condition = array('friendly_url' => $friendly_url, 'status' => '1');
          $content = $this->pages_model->get_cms_page($condition);
          $data['content'] = $content;
          $data['title'] = "Contact Us";
          $this->load->view('contactus', $data);
       } else {

      $posted_data = array(
          'first_name' => $this->input->post('first_name'),
          'last_name' => $this->input->post('last_name'),
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('phone'),
          'message' => $this->input->post('message'),
          'receive_date' => $this->config->item('config.date.time')
      );
      $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
      //Mail
      $content = get_content('wps_auto_respond_mails', '5');
      $name = $this->input->post('first_name') . ' ' . $this->input->post('last_name');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', $name, $body);
      $body = str_replace('{email}', $this->input->post('email'), $body);
      $body = str_replace('{phone}', $this->input->post('phone'), $body);
      $body = str_replace('{comments}', $this->input->post('message'), $body);
      $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
      $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
        if($this->admin_info->website_mode=='Live'){
                  $mail_conf = array(
                      'subject' => $subject,
                      'to_email' => $this->admin_info->admin_email, //
                      'from_email' => $this->input->post('email'),
                      'from_name' => $name,
                      'reply_to' => $this->input->post('email'),
                      'body_part' => $body,
                  );
                  $this->dmailer->mail_notify($mail_conf);
                  
                  $mail_conf2 = array(
                      'subject' => "Webpulseindia.com - Enquiry From www.magnetichub.com",
                      'to_email' => 'webpulseindia@gmail.com', //
                      'from_email' => $this->input->post('email'),
                      'from_name' => $name,
                      'reply_to' => $this->input->post('email'),
                      'body_part' => $body,
                  );
                  $this->dmailer->mail_notify($mail_conf2);

                   $mail_conf3 = array(
                      'subject' => "Webpulseindia.com - Enquiry From www.magnetichub.com",
                      'to_email' => 'shelleyent@aol.com', //
                      'from_email' => $this->input->post('email'),
                      'from_name' => $name,
                      'reply_to' => $this->input->post('email'),
                      'body_part' => $body,
                  );
                  $this->dmailer->mail_notify($mail_conf3);
            }else{
               $mail_conf4 = array(
                  'subject' => "Webpulseindia.com - Enquiry From www.magnetichub.com",
                  'to_email' => 'test.webpulse@gmail.com', //
                  'from_email' => $this->input->post('email'),
                  'from_name' => $name,
                  'reply_to' => $this->input->post('email'),
                  'body_part' => $body,
              );
              $this->dmailer->mail_notify($mail_conf4);
            }

      $msg = "Your request has been sent successfully ! We will get back to you shortly !";
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $msg);
      redirect(base_url('contact-us'));
    }
    }
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['title'] = "Contact Us";
    $this->load->view('contactus', $data);
  }

  public function sitemap() {
    $data['title'] = "Site Map";
    $this->load->view('sitemap', $data);
  }

  public function thanks() {
    $data['heading_title'] = "Thanks";
    $this->load->view('pages/thanks', $data);
  }

  public function page_not_found() {
    $this->meta_info['meta_title'] = '404 page not found';
    $this->load->view('pages/view_404'); //loading in my template 
  }

  private function subscribe_newsletter($posted_data) {
    $query = $this->db->query("SELECT subscriber_email,status FROM  wps_newsletters WHERE subscriber_email='$posted_data[subscriber_email]'");
    $subscribe_me = $posted_data['subscribe_me'];

    if ($query->num_rows() > 0) {
      $row = $query->row_array();
      if ($row['status'] == '0' && ($subscribe_me == 'Y')) {
        $where = "subscriber_email = '" . $row['subscriber_email'] . "'";
        $this->pages_model->safe_update('wps_newsletters', array('status' => '1'), $where, FALSE);
        $msg = $this->config->item('newsletter_subscribed');
        return $msg;
      } else if ($row['status'] == '0' && ($subscribe_me == 'N')) {
        $msg = $this->config->item('newsletter_not_subscribe');
        return $msg;
      } else if ($row['status'] == '1' && ($subscribe_me == 'Y')) {
        $msg = $this->config->item('newsletter_already_subscribed');
        return $msg;
      } else if ($row['status'] == '1' && ($subscribe_me == 'N')) {
        $where = "subscriber_email = '" . $row['subscriber_email'] . "'";
        $this->pages_model->safe_update('wps_newsletters', array('status' => '0'), $where, FALSE);
        $msg = $this->config->item('newsletter_unsubscribed');
        return $msg;
      }
    } else {
      if ($subscribe_me == 'N') {
        $msg = $this->config->item('newsletter_not_subscribe');
        return $msg;
      } else {
        $data = array('status' => '1', 'subscriber_name' => $posted_data['subscriber_name'], 'subscriber_email' => $posted_data['subscriber_email']);
        $this->pages_model->safe_insert('wps_newsletters', $data);
        $msg = $this->config->item('newsletter_subscribed');
        return $msg;
      }
    }
  }

  public function sendEnquiry()
  {
    $this->form_validation->set_rules('name', 'Name', 'trim|required|alpha');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Mobile Number', 'trim|required|numeric|max_length[10]|min_length[10]');
    $this->form_validation->set_rules('location', 'Location', 'trim|required|alpha_extra');
    $this->form_validation->set_rules('message', 'Message', 'trim|required|alpha_extra');
    $this->form_validation->set_rules('captcha', 'Captcha', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
        $posted_data = array(
            'type' => '4',
            'first_name' => $this->input->post('name'),
            'last_name' => '',
            'email' => $this->input->post('email'),
            'mobile_number' => $this->input->post('phone'),
            'location' => $this->input->post('location'),
            'message' => $this->input->post('message'),
            'receive_date' => $this->config->item('config.date.time'),
        );
        $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

        $subject = "WebpulseIndia.com - Enquiry from www.magnetichub.com";
         $body='<html><head></head><body>
              <table border="0" width="100%">
              <tbody>
              <tr>
              <td colspan="2">
              <strong>Dear Admin</strong></td>
              </tr>
              <tr>
              <td colspan="2">
              Enquiry&nbsp; has been submitted with following info :</td>
              </tr>
              <tr>
              <td colspan="2">
              &nbsp;</td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Name : </strong></td>
              <td>
              <span style="margin-top:15px">'.$this->input->post('name').'</span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Email : </strong></td>
              <td>
              <span style="margin-top:15px"><a href="mailto:'.$this->input->post('email').'" target="_blank">'.$this->input->post('email').'</a></span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Mobile : </strong></td>
              <td>
              <span style="margin-top:15px">'.$this->input->post('phone').'</span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Address : </strong></td>
              <td>
              <span style="margin-top:15px">'.$this->input->post('location').'</span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Message : </strong></td>
              <td>
              <span style="margin-top:15px">'.$this->input->post('message').'</span></td>
              </tr>
              <tr>
              <td colspan="2">
              &nbsp;</td>
              </tr>
              </tbody>
              </table><br/>
              <span style="margin-top:15px">
               Thank you.<br>
               '.$this->config->item('site_name').' Customer Service<br>
               Email: <a href="mailto:'.$this->admin_info->admin_email.'" target="_blank">'.$this->admin_info->admin_email.'</a><div class="yj6qo"></div><div class="adL"> 
              </div></span></body</html>';
        $mail_conf = array(
            'subject' => $subject,
            'to_email' => $this->admin_info->admin_email, //$this->admin_info->admin_email
            'from_email' => $this->input->post('email'),
            'from_name' => $this->input->post('name'),
            'body_part' => $body,
        );
        //Send the Mail to Client
        $this->dmailer->mail_notify($mail_conf);
        
        $mail_conf = array(
            'subject' => "WebpulseIndia.com - Enquiry from www.magnetichub.com",
            'to_email' => 'webpulseindia@gmail.com', //
            'from_email' => $this->input->post('email'),
            'from_name' => $this->input->post('name'),
            'body_part' => $body,
        );
        //Send the Mail To webpulse
        //$this->dmailer->mail_notify($mail_conf);
        $res = '<div class="alert alert-success">
                      <strong>Success!</strong>
                      Your request has been sent successfully ! We will get back to you shortly !
                  </div>';
    } else {
      $res = '<div class="alert alert-danger">
                      <strong>'.validation_errors().'
                  </div>';
    }

    echo $res;
    exit;
  }


  public function newsletter() {
    $data['default_email_text'] = "Email Id";
    $this->form_validation->set_rules('subscriber_name', 'Name', 'trim|required|max_length[225]');
    $this->form_validation->set_rules('subscriber_email', 'Email', 'trim|required|valid_email|max_length[255]');
    $this->form_validation->set_rules('subscribe_me', 'Status', 'trim|required');
    $this->form_validation->set_rules('verification_code', 'Verification Code', 'trim|required|valid_captcha_code');
    if ($this->form_validation->run() == TRUE) {
      $res = $this->pages_model->add_newsletter_member();
      $this->session->set_userdata('msg_type', $res['error_type']);
      $this->session->set_flashdata($res['error_type'], $res['error_msg']);
      redirect('pages/newsletter', '');
    }
    $this->load->view('view_subscribe_newsletter', $data);
  }

  public function join_newsletter() {
    $subscriber_name = $this->input->post('newsletter_name', TRUE);
    $subscriber_email = $this->input->post('newsletter_email', TRUE);

    $this->form_validation->set_rules('newsletter_name', 'Name', "trim|required|alpha|max_lenght[200]");
    $this->form_validation->set_rules('newsletter_email', 'Email ID', "trim|required|valid_email|max_lenght[80]");
    $this->form_validation->set_rules('newsletter_captcha', 'Verification code', 'trim|required|valid_captcha_code');

    if ($this->form_validation->run() == TRUE) {
      $subscribe_me = $this->input->post('subscribe_me', TRUE);

      $posted_data = array('subscriber_name' => $subscriber_name, 'subscriber_email' => $subscriber_email, 'subscribe_me' => $subscribe_me);
      $result = $this->subscribe_newsletter($posted_data);
      if ($result) {
        //echo '<div style="color:#009900">'.$result.'</div>';
        $res = array('error_type' => 'sucess', 'error_msg' => '<div style="color:#009900">' . $result . '</div>');
      }
    } else {
      //echo '<p style="color:#009900">'.validation_errors().'</p>';
      $res = array('error_type' => 'error', 'error_msg' => validation_errors());
    }

    echo json_encode($res);
    exit;
  }

  public function get_country() {
    $country = $this->db->query("SELECT id, country_name, status FROM wps_country WHERE status ='1'")->result_array();
    //trace($country);
    $selVal = $this->input->get_post('selVal');
    $option = '<option value="">Select Country</option>';
    if (is_array($country) && !empty($country)) {
      foreach ($country as $key => $val) {
        $sel = ($selVal == $val['id']) ? 'selected="selected"' : '';
        $option .= '<option value="' . $val["id"] . '" ' . $sel . '>' . $val["country_name"] . '</option>';
      }
    }
    echo $option;
  }

  public function get_state() {
    $count_id = (int) $this->input->get_post('country_id');
    $selVal = $this->input->get_post('selVal');
    $strQry = ($count_id > 0) ? " AND country_id ='" . $count_id . "'" : '';
    $state = $this->db->query("SELECT id, country_id, title, status FROM wps_states WHERE status ='1' $strQry")->result_array();
    $option = '<option value="">Choose State</option>';

    if (is_array($state) && !empty($state)) {
      $result = array();
      foreach ($state as $key => $val) {
        $sel = ($selVal == $val['id']) ? 'selected="selected"' : '';
        $option .= '<option value="' . $val["id"] . '" ' . $sel . '>' . $val["title"] . '</option>';
      }
    }
    echo $option;
  }

  public function get_city() {
    $selVal = $this->input->get_post('selVal');
    $state_id = (int) $this->input->get_post('state_id');
    $strQry = ($state_id > 0) ? " AND state_id  ='" . $state_id . "'" : '';
    $city = $this->db->query("SELECT id, state_id, country_id, title, status FROM wps_city WHERE status ='1' $strQry")->result_array();
    $option = '<option value="">Choose City</option>';

    if (is_array($city) && !empty($city)) {
      $result = array();
      foreach ($city as $key => $val) {
        $sel = ($selVal == $val['id']) ? 'selected="selected"' : '';
        $option .= '<option value="' . $val["id"] . '" ' . $sel . '>' . $val["title"] . '</option>';
      }
    }
    echo $option;
  }

  public function verify_otp() {
    $sent_otp_id = $this->input->post('sent_otp_id');
    $user_otp = $this->input->post('user_otp');

    if (($user_otp != "") && ($sent_otp_id != "")) {
      $match_otp = $this->db->get_where('wps_sent_otp', array('otp_id' => $sent_otp_id, 'otp' => $user_otp))->row_array();
      if (count($match_otp) > 0) {
        echo 'success';
      } else {
        echo 'failed';
      }
    } else {
      echo "wrong";
    }
  }

  public function marketarea() {
    $data = array();

    $data['country'] = $this->db->query("SELECT id, name, country_temp_name, status FROM wps_countries_list WHERE status ='1'")->result_array();

    $data['state'] = $this->db->query("SELECT id, name, country_id, temp_title, status FROM wps_states_list WHERE status ='1'")->result_array();

    $this->load->view('marketarea', $data);
  }

  public function custom_design() {
    $this->page_section_ct = 'product';
    $data['unq_section'] = "Custome Design";

    if ($this->input->post()) {
      if($this->input->get_post('user_id')!=''){
         $user_id=$this->input->get_post('user_id');
         $customDesign = $this->db->query("SELECT * FROM wps_custom_design WHERE user_id =$user_id")->result_array();
         $custom_data=array(
           'user_id' => $user_id,
           'email' => $this->input->post('email'),
           'upper_chest' => $this->input->post('upper_chest'),
           'chest' => $this->input->post('chest'),
           'upper_waist' => $this->input->post('uwaist'),
           'tummy' => $this->input->post('tummy'),
           'hips' => $this->input->post('uhips'),
           'shoulder' => $this->input->post('shoulder'),
           'armhole' => $this->input->post('armhole'),
           'highpoint_shoulder_waist' => $this->input->post('shoulder_waist'),
           'highpoint_shoulder_knee' => $this->input->post('shoulder_knee'),
           'sleeve_length' => $this->input->post('length_sleeve'),
           'bicep' => $this->input->post('bicep'),
           'height' => $this->input->post('height'),
           'length' => $this->input->post('length'),
           'lower_waist' => $this->input->post('lower_waist'),
           'lower_hips' => $this->input->post('lhips'),
           'thigh' => $this->input->post('thigh'),
           'knee' => $this->input->post('knee'),
           'ankle' => $this->input->post('ankle'),
           'calf' => $this->input->post('calf'),
           'full_length' => $this->input->post('full_length'),
           'organization' => $this->input->post('organization'),
           'location' => $this->input->post('location'),
         );
         if(count($customDesign)>0){
             $where = "user_id = '".$user_id."'";
             $this->pages_model->safe_update('wps_custom_design', $custom_data, $where, FALSE);
         }else{
             $this->pages_model->safe_insert('wps_custom_design', $custom_data, FALSE);
         }
      }


      $sizeArr = array();
      $sizeArr[] = $this->input->get_post('upper_chest');
      $sizeArr[] = $this->input->get_post('chest');
      $sizeArr[] = $this->input->get_post('uwaist');
      $sizeArr[] = $this->input->get_post('tummy');
      $sizeArr[] = $this->input->get_post('uhips');
      $sizeArr[] = $this->input->get_post('shoulder');
      $sizeArr[] = $this->input->get_post('armhole');
      $sizeArr[] = $this->input->get_post('shoulder_waist');
      $sizeArr[] = $this->input->get_post('shoulder_knee');
      $sizeArr[] = $this->input->get_post('length_sleeve');
      $sizeArr[] = $this->input->get_post('bicep');
      $sizeArr[] = $this->input->get_post('height');
      $sizeArr[] = $this->input->get_post('length');
      $sizeArr[] = $this->input->get_post('lower_waist');
      $sizeArr[] = $this->input->get_post('lhips');
      $sizeArr[] = $this->input->get_post('thigh');
      $sizeArr[] = $this->input->get_post('knee');
      $sizeArr[] = $this->input->get_post('ankle');
      $sizeArr[] = $this->input->get_post('calf');
      $sizeArr[] = $this->input->get_post('full_length');
      $sizeArr[] = $this->input->get_post('quantity');
      $sizeArr[] = $this->input->get_post('fabric');

      $uploaded_file =  array();
      for($i=0;$i<count($_FILES["pic"]["name"]);$i++){
          $_FILES['pics']['name']     = $_FILES['pic']['name'][$i];
          $_FILES['pics']['type']     = $_FILES['pic']['type'][$i];
          $_FILES['pics']['tmp_name'] = $_FILES['pic']['tmp_name'][$i];
          $_FILES['pics']['error']     = $_FILES['pic']['error'][$i];
          $_FILES['pics']['size']     = $_FILES['pic']['size'][$i];
           // File upload configuration
            $uploadPath = UPLOAD_DIR.'/custom_design/';
            $config['upload_path'] = $uploadPath;
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
            
            // Load and initialize upload library
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            
            // Upload file to server
            if($this->upload->do_upload('pics')){
                // Uploaded file data
                $fileData = $this->upload->data();
                $uploaded_file[] = $fileData['file_name'];              
            }
          // $config['max_size'] = '2048';
          // $this->load->library('upload');
          // $uploaded_data = $this->upload->my_upload('pic', 'custom_design', $this->input->post('name') . $i);
          // if (is_array($uploaded_data) && !empty($uploaded_data)) {
          //   $uploaded_file = $uploaded_data['upload_data']['file_name'];
          // }
      }

      
      $posted_data = array(
          'type'=>'2',
          'first_name' => $this->input->post('name'),
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('mobile'),
           'organization' => $this->input->post('organization'),
          'location' => $this->input->post('location'),
          'message' => "",//$this->input->post('comments'),
          'product_size'=>implode(',',$sizeArr),
          'custom_image'=> implode(',', $uploaded_file),
          'receive_date' => $this->config->item('config.date.time')
      );
      $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
      //Mail
      $subject = 'New Custom Product Design query have been posted on NoorBySakshi';
      $content = get_content('wps_auto_respond_mails', '5');
      $name = $this->input->post('name');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', $name, $body);
      $body = str_replace('{email}', ($this->input->post('email'))?$this->input->post('email'):'N.A', $body);
      $body = str_replace('{phone}', $this->input->post('mobile'), $body);
      $body = str_replace('{comments}', ($this->input->post('comments'))?$this->input->post('comments'):'N.A', $body);
      $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
      $body = str_replace('{admin_email}', $this->config->item('site_name'), $body);
      $mail_conf = array(
          'subject' => $subject,
          'to_email' => "test.webpulse@gmail.com",
          'from_email' => $this->input->post('email'),
          'from_name' => $name,
          'body_part' => $body
      );
      //trace($mail_conf);
      //exit;
      $this->dmailer->mail_notify($mail_conf);

      $msg = "Your request has been sent successfully ! We will get back to you shortly !";
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $msg);
      
      redirect(site_url('send-custom-design'), '');
      
    }


    $this->load->view('pages/view_custom_design', $data);
  }

}

/* End of file pages.php */