<?php

class Home extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('home/home_model', 'users/users_model', 'category/category_model', 'products/product_model'));
    $this->load->model(array('sitepanel/setting_model'));
    $this->load->helper(array('category/category'));
    $this->load->library(array('safe_encrypt', 'securimage_library', 'Auth', 'Dmailer', 'cart'));
  }

  public function index() {
    $data['page_title'] = "";
    $data['page_keyword'] = "";
    $data['page_description'] = "";

    //home category
    $home_cat = array('field' => "*", 'condition' => "AND status='1' AND home_menu = '1'", 'debug' => FALSE);
    $category_result = $this->category_model->getcategory($home_cat);
    $data['home_cat'] = $category_result;
    
    //Middle Banner
    $data['midBanner'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Middle 1' AND status = '1'")->row_array();
    //echo_sql();
    
    //Middle Banner
    $data['midBanner1'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Middle 2' AND status = '1'")->row_array();
    //echo_sql();

     //Middle Banner
    $data['midBanner2'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Middle 3' AND status = '1'")->row_array();
    
    //latest products
    $data['featured_products'] = $this->get_latest_product();
    
    //Bestseller products
    $data['best_products'] = $this->get_best_product();
    
    //Popular products
    $data['popular_products'] = $this->get_popular_product();
    
    //New Arrival products
    $data['new_products'] = $this->get_new_product();
    

    $content = "";
    $homeHeading='';
    //Check if it is subdomain
    $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $uri_segments = explode('/', $uri_path);
    $st = $uri_segments[1];
    if (strstr($st, '.html')) {
      $st = substr($st, 0, -5);
    }

    $stArray = $this->db->query("SELECT meta_id, page_url FROM wps_meta_tags WHERE is_fixed='L' AND page_url='" . $st . "'")->row_array();
    if (is_array($stArray) & !empty($stArray)) {
      $locId = $stArray['meta_id'];
      $resprosub = $this->db->query("SELECT * FROM wps_subloccontent WHERE status = '1' AND FIND_IN_SET($locId,location_id)")->row();
      if (is_object($resprosub) && !empty($resprosub)) {
        $key1 = $resprosub->meta_key1;
        $key2 = $resprosub->meta_key2;
        $key3 = $resprosub->meta_key3;
        $content = str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosub->description))));  
        $homeHeading = 'Welcome to Magnetic Hub - '.ucwords(locationName($st));     
      }
    }
    else
    {
      $content = get_db_field_value('wps_cms_pages', 'page_description', "WHERE page_id = '12'");
      $homeHeading = 'Welcome to Magnetic Hub';  
    }
    $data['title1']= get_db_field_value('wps_cms_pages', 'title1', "WHERE page_id = '12'");
    $data['description1']= get_db_field_value('wps_cms_pages', 'description1', "WHERE page_id = '12'");
    $data['homeHeading'] = $homeHeading;
    $data['home'] = $content;

     //banners
    $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND banner_position = 'Index Slider' order by banner_id desc")->result_array();

    //$data['home'] = get_db_field_value('wps_cms_pages', 'page_description', "WHERE page_id = '12'");
    $data['testimonials'] = $this->db->query("SELECT * FROM wps_testimonial WHERE status='1'")->result_array();
    $this->load->view('home', $data);
  }
  
  public function get_latest_product() {
    $condtion['status'] = '1';
    $condtion['where'] = "latest_product = '1'";
    $condtion['orderby'] = 'products_id ASC';
    $product_list = $this->product_model->get_products('5', '0', $condtion);
    return $product_list;
  }
  
  public function get_best_product() {
    $condtion['status'] = '1';
    $condtion['where'] = "bestseller_product = '1'";
    $condtion['orderby'] = 'products_id DESC';
    $product_list = $this->product_model->get_products('5', '0', $condtion);
    return $product_list;
  }
  
  public function get_popular_product() {
    $condtion['status'] = '1';
    $condtion['where'] = "popular_product = '1'";
    $condtion['orderby'] = 'products_id DESC';
    $product_list = $this->product_model->get_products('5', '0', $condtion);
    return $product_list;
  }
  
  public function get_new_product() {
    $condtion['status'] = '1';
    $condtion['where'] = "newarrival_product = '1'";
    $condtion['orderby'] = 'products_id DESC';
    $product_list = $this->product_model->get_products('5', '0', $condtion);
    return $product_list;
  }


  public function set_currency() {
    $currId = (int) $this->uri->segment(3);
    $this->session->set_userdata('currency_id', $currId);
    redirect($_SERVER['HTTP_REFERER'], 'refresh');
  }

  public function set_location() {
    $locId = (int) $this->uri->segment(3);
    $this->session->set_userdata('location_id', $locId);
    redirect($_SERVER['HTTP_REFERER'], 'refresh');
  }

  public function set_language() {
    $locId = $this->uri->segment(3);
    $this->session->unset_userdata('lang', '0');
    $this->session->unset_userdata('field_type', '');
    $this->session->set_userdata('lang', $locId);
    if ($locId == 'p') {
      $this->session->set_userdata('field_type', '_p');
    }
    redirect($_SERVER['HTTP_REFERER'], 'refresh');
  }

  public function set_sessions() {
    $ref = $this->input->get_post('ref');
    $p1 = $this->input->get_post('p1');
    $p2 = $this->input->get_post('p2');
    $p3 = $this->input->get_post('p3');

    $this->session->set_userdata('ref', $ref);
    if ($ref == 'buckets') {
      $this->session->set_userdata('destination', $p1);
      $this->session->set_userdata('start', $p2);
    }
    if ($ref == 'tripSearch') {
      $this->session->set_userdata('theme', $p1);
      $this->session->set_userdata('start', $p2);
      $this->session->set_userdata('zone', $p3);
    }
    echo $this->session->userdata('ref');
  }

  public function post_enquiry() {
    $this->form_validation->set_rules('name', 'Your Name', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('mobile', 'Mobile Number', 'trim|required');
    $this->form_validation->set_rules('message', 'Message', 'trim|required');
    $this->form_validation->set_rules('location', 'Location', 'trim|required');
    if ($this->form_validation->run() == TRUE) {
      $posted_data = array(
          'first_name' => $this->input->post('name'),
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('mobile'),
          'message' => $this->input->post('message'),
          'post_url' => $this->input->post('curl'),
          'location' => $this->input->post('location'),
          'receive_date' => $this->config->item('config.date.time')
      );
      $this->home_model->safe_insert('wps_enquiry', $posted_data, FALSE);
      //Mail
      $subject = 'New Enquiry has been Posted on BrandEmpower.in';
      $content = get_content('wps_auto_respond_mails', '5');
      $body = $content->email_content;
      $body = str_replace('{purpose}', ($this->input->post('purpose')) ? $this->input->post('purpose') : 'N.A.', $body);
      $body = str_replace('{name}', $this->input->post('name'), $body);
      $body = str_replace('{email}', $this->input->post('email'), $body);
      $body = str_replace('{mobile}', $this->input->post('mobile'), $body);
      $body = str_replace('{comments}', ($this->input->post('message')) ? $this->input->post('message') : 'N.A.', $body);
      $body = str_replace('{url}', $this->input->post('curl'), $body);
      $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
      $body = str_replace('{admin_email}', 'info@brandempower.in', $body);
      $mail_conf = array(
          'subject' => $subject,
          'to_email' => "info@brandempower.in",
          //'to_email' => "kirpanand@webpulseindia.com",
          'from_email' => $this->input->post('email'),
          'from_name' => ucwords($this->input->post('name')),
          'body_part' => $body
      );
      //trace($mail_conf);
      //exit;
      $this->dmailer->mail_notify($mail_conf);
      echo "Thanks for enquiry, we will get back shortly!";
    }else{
      echo strip_tags(validation_errors());
    }
  }

  public function textToPdf(){
    $data = array();
    $this->load->view('texttopdf', $data);
  }
}