<?php

require_once(dirname(__FILE__) . '/dompdf/autoload.inc.php');

use Dompdf\Dompdf;
use Dompdf\Options;

class Pdf {

  public function create($html, $filename) {
    //Initialization
    $dompdf = new Dompdf();
    $dompdf->setPaper('Letter', 'portrait');
    $dompdf->loadHtml(utf8_decode($html));
    //render
    $dompdf->render();
    
    //header and Footer
    $canvas = $dompdf->get_canvas();
    $footer = $canvas->open_object();
    $w = $canvas->get_width();
    $h = $canvas->get_height();
    $canvas->page_text($w - 60, $h - 28, "Page {PAGE_NUM} of {PAGE_COUNT}", '', 6);
    $canvas->page_text($w - 590, $h - 28, "Shelley Enterprises, 22833 Lockness Ave. Torrance CA, 90501, USA | Contact: 1-800-544-5537", '', 6);
    $canvas->close_object();
    $canvas->add_object($footer, "all");
    //Hedaer & footer end Here
    
    //Auto Download
    $dompdf->stream($filename . '.pdf');
    
    //Open File in Browser
    //$dompdf->stream($filename . '.pdf',array("Attachment"=>0));
    
    //save the file to the server
    //$output = $dompdf->output();
    //file_put_contents(UPLOAD_DIR . "/pdf/" . $filename . ".pdf", $output);
  }

}

?>