<?php
include_once("../include/main.inc.php");
check_session('MyCpanel','index.php');

/* ================= CONFIG ================= */
@extract($_REQUEST);
$heading     = "Manage Sizes";
$record_type = "Size";
$script_name = "manage_size.php";
$table_name  = "size_tbl";

/* ================= PAGINATION ================= */
$start    = (intval($start)<0 || $start=="") ? 0 : $start;
$pagesize = intval($pagesize)==0 ? 20 : $pagesize;

/* ================= ADD ================= */
if($id=="add_record"){
	if(trim($size_name)==""){
		$form_check_alert .= "<li>Please enter size</li>";
	}
	if(!strlen($form_check_alert)>0){
		db_query("INSERT INTO $table_name SET
			size_name='".addslashes($size_name)."',
			sort_order='".intval($sort_order)."',
			status='1',
			date_added=NOW()
		");
		$_SESSION['session_message']="Size added successfully";
		header("Location: $script_name?start=$start&pagesize=$pagesize");
		exit;
	}
}

/* ================= UPDATE ================= */
if($id=="update_record"){
	if(trim($size_name)==""){
		$form_check_alert .= "<li>Please enter size</li>";
	}
	if(!strlen($form_check_alert)>0){
		db_query("UPDATE $table_name SET
			size_name='".addslashes($size_name)."',
			sort_order='".intval($sort_order)."',
			status='".intval($status)."',
			date_updated=NOW()
			WHERE size_id='$recordID'
		");
		$_SESSION['session_message']="Size updated successfully";
		header("Location: $script_name?start=$start&pagesize=$pagesize");
		exit;
	}
}

/* ================= DELETE ================= */
if($id=="delete_record"){
	db_query("DELETE FROM $table_name WHERE size_id='$recordID'");
	$_SESSION['session_message']="Size deleted successfully";
	header("Location: $script_name?start=$start&pagesize=$pagesize");
	exit;
}

admin_header("");
?>

<!-- ================= HEADING + PAGESIZE ================= -->
<table width="99%" align="center">
<tr>
	<td class="myTitle"><?=$heading;?></td>
	<td align="right">
	<form method="post">
	Records Per Page:
	<select name="pagesize" onChange="this.form.submit();">
	<?php foreach($_GLOBALS['pgsize_arr'] as $val){ ?>
	<option value="<?=$val;?>" <?=$pagesize==$val?'selected':''?>><?=$val;?></option>
	<?php } ?>
	</select>
	</form>
	</td>
</tr>
</table>

<hr>

<?php
$qry_cnt = db_query("SELECT * FROM $table_name");
$reccnt  = NumRows($qry_cnt);

$qry = db_query("SELECT * FROM $table_name ORDER BY sort_order ASC LIMIT $start,$pagesize");

echo pageNavigation($reccnt,$pagesize,$start);
print_message();
?>

<!-- ================= LISTING ================= -->
<table width="99%" class="table table-bordered table-hover">
<tr bgcolor="#EAEAEA">
	<td width="5%" align="center"><b>#</b></td>
	<td width="30%" align="center"><b>Size</b></td>
	<!-- <td width="15%" align="center"><b>Order</b></td> -->
	<td width="15%" align="center"><b>Status</b></td>
	<td width="20%" align="center"><b>Action</b></td>
</tr>

<?php
$sl = $start+1;
while($row=mysqli_fetch_assoc($qry)){
?>
<tr>
	<td align="center"><?=$sl;?></td>
	<td align="center"><?=$row['size_name'];?></td>
	<!-- <td align="center"><?=$row['sort_order'];?></td> -->
	<td align="center">
		<?=($row['status']=='1')?'Active':'Deactive';?>
	</td>
	<td align="center">
		<a class="btn btn-primary" href="<?=$script_name;?>?id=edit_record&recordID=<?=$row['size_id'];?>&start=<?=$start;?>&pagesize=<?=$pagesize;?>">Edit</a>
		<a class="btn btn-danger" href="<?=$script_name;?>?id=delete_record&recordID=<?=$row['size_id'];?>&start=<?=$start;?>&pagesize=<?=$pagesize;?>" onclick="return confirm('Delete this size?');">Delete</a>
	</td>
</tr>
<?php $sl++; } ?>
</table>

<!-- ================= ADD / EDIT FORM ================= -->
<?php
$res = getResult($table_name,"WHERE size_id='$recordID'");
?>

<form method="post">
<table width="99%" class="table table-bordered">
<tr bgcolor="#EAEAEA">
	<td colspan="2"><b><?=($recordID)?"Edit":"Add New";?> Size</b></td>
</tr>

<tr>
	<td width="30%"><b>Size *</b></td>
	<td>
		<input type="text" name="size_name" class="form-control"
		value="<?=$res['size_name'];?>"
		placeholder="28 / 30 / 32 / XL" required>
	</td>
</tr>

<!-- <tr>
	<td><b>Sort Order</b></td>
	<td>
		<input type="number" name="sort_order" class="form-control"
		value="<?=($res['sort_order']!='')?$res['sort_order']:0;?>">
	</td>
</tr> -->

<?php if($recordID){ ?>
<tr>
	<td><b>Status</b></td>
	<td>
		<select name="status" class="form-control">
			<option value="1" <?=$res['status']=='1'?'selected':'';?>>Active</option>
			<option value="0" <?=$res['status']=='0'?'selected':'';?>>Deactive</option>
		</select>
	</td>
</tr>
<?php } ?>

<tr>
	<td></td>
	<td>
	<?php if($recordID){ ?>
		<input type="submit" value="Update Size" class="btn btn-primary">
		<input type="hidden" name="id" value="update_record">
		<input type="hidden" name="recordID" value="<?=$recordID;?>">
	<?php } else { ?>
		<input type="submit" value="Add Size" class="btn btn-success">
		<input type="hidden" name="id" value="add_record">
	<?php } ?>
	<input type="hidden" name="start" value="<?=$start;?>">
	<input type="hidden" name="pagesize" value="<?=$pagesize;?>">
	</td>
</tr>
</table>
</form>

<?php admin_footer(); ?>
