<?php
include_once("../include/main.inc.php");
check_session('MyCpanel','index.php');

@extract($_REQUEST);

/* ================= CONFIG ================= */
$heading     = "Manage Discount Coupons";
$record_type = "Coupon";
$script_name = "manage_discount_coupans.php";
$table_name  = "wl_discount_coupans";

/* ================= PAGINATION ================= */
$start    = (intval($start)<0 || $start=="") ? 0 : $start;
$pagesize = intval($pagesize)==0 ? 20 : $pagesize;

/* ================= ADD ================= */
if($id=="add_record"){

	if(trim($cpn_code)=="" || trim($cpn_name)==""){
		$form_check_alert .= "<li>Please enter coupon code and name</li>";
	}

	if(!strlen($form_check_alert)>0){
		db_query("INSERT INTO $table_name SET
			cpn_type='".intval($cpn_type)."',
			cpn_code='".addslashes($cpn_code)."',
			cpn_name='".addslashes($cpn_name)."',
			cpn_rate='".intval($cpn_rate)."',
			minimum_amount_for_coupan_apply='$minimum_amount_for_coupan_apply',
			cpn_start_date='$cpn_start_date',
			cpn_end_date='$cpn_end_date',
			status='1'
		");

		$_SESSION['session_message']="Coupon added successfully";
		header("Location: $script_name?start=$start&pagesize=$pagesize");
		exit;
	}
}

/* ================= UPDATE ================= */
if($id=="update_record"){

	if(trim($cpn_code)=="" || trim($cpn_name)==""){
		$form_check_alert .= "<li>Please enter coupon code and name</li>";
	}

	if(!strlen($form_check_alert)>0){
		db_query("UPDATE $table_name SET
			cpn_type='".intval($cpn_type)."',
			cpn_code='".addslashes($cpn_code)."',
			cpn_name='".addslashes($cpn_name)."',
			cpn_rate='".intval($cpn_rate)."',
			minimum_amount_for_coupan_apply='$minimum_amount_for_coupan_apply',
			cpn_start_date='$cpn_start_date',
			cpn_end_date='$cpn_end_date',
			status='".intval($status)."'
			WHERE cpn_id='$recordID'
		");

		$_SESSION['session_message']="Coupon updated successfully";
		header("Location: $script_name?start=$start&pagesize=$pagesize");
		exit;
	}
}

/* ================= DELETE ================= */
if($id=="delete_record"){
	db_query("UPDATE $table_name SET status='2' WHERE cpn_id='$recordID'");
	$_SESSION['session_message']="Coupon deleted successfully";
	header("Location: $script_name?start=$start&pagesize=$pagesize");
	exit;
}

admin_header("");
?>

<!-- ================= HEADING & PAGESIZE ================= -->
<table width="99%">
<tr>
	<td class="myTitle"><?=$heading;?></td>
	<td align="right">
	<form method="post">
	Records Per Page:
	<select name="pagesize" onChange="this.form.submit();">
	<?php foreach($_GLOBALS['pgsize_arr'] as $val){ ?>
	<option value="<?=$val;?>" <?=$pagesize==$val?'selected':''?>><?=$val;?></option>
	<?php } ?>
	</select>
	</form>
	</td>
</tr>
</table>

<hr>

<?php
$qry_cnt = db_query("SELECT * FROM $table_name WHERE status!='2'");
$reccnt  = NumRows($qry_cnt);

$qry = db_query("SELECT * FROM $table_name 
	WHERE status!='2' 
	ORDER BY cpn_id DESC 
	LIMIT $start,$pagesize");

echo pageNavigation($reccnt,$pagesize,$start);
print_message();
?>

<!-- ================= LISTING ================= -->
<table width="99%" class="table table-bordered table-hover">
    <a href="<?=SITE_ADMIN_URL;?>/add_edit_discount_coupon.php" class="btn btn-success">+ Add New Coupon</a>
<tr bgcolor="#EAEAEA">
	<td align="center"><b>#</b></td>
	<td align="center"><b>Coupon Code</b></td>
	<td align="center"><b>Type</b></td>
	<td align="center"><b>Rate</b></td>
	<td align="center"><b>Min Amount</b></td>
	<td align="center"><b>Start Date</b></td>
    <td align="center"><b>End Date</b></td>
	<td align="center"><b>Status</b></td>
	<td align="center"><b>Action</b></td>
</tr>

<?php
$sl=$start+1;
while($row=mysqli_fetch_assoc($qry)){
?>
<tr>
	<td align="center"><?=$sl;?></td>
	<td align="center"><?=$row['cpn_code'];?></td>
	<td align="center">
		<?=($row['cpn_type']==1)?'Percentage (%)':'Fixed (₹)';?>
	</td>
	<td align="center"><?=$row['cpn_rate'];?></td>
	<td align="center"><?=$row['minimum_amount_for_coupan_apply'];?></td>
	<td align="center"><?=$row['cpn_start_date'];?></td>
    <td align="center"><?=$row['cpn_end_date'];?></td>
	<td align="center">
		<?=($row['status']==1)?'Active':'Deactive';?>
	</td>
	<td align="center">
		<a class="btn btn-primary" style="color:#fff;" href="<?=SITE_ADMIN_URL;?>/add_edit_discount_coupon.php?id=edit_record&recordID=<?=$row['cpn_id'];?>&start=<?=$start;?>&pagesize=<?=$pagesize;?>">Edit</a>
		<a class="btn btn-danger" href="<?=$script_name;?>?id=delete_record&recordID=<?=$row['cpn_id'];?>&start=<?=$start;?>&pagesize=<?=$pagesize;?>" onclick="return confirm('Delete this coupon?');">Delete</a>
	</td>
</tr>
<?php $sl++; } ?>
</table>

<!-- ================= ADD / EDIT FORM ================= -->
<!-- <?php
$res = getResult($table_name,"WHERE cpn_id='$recordID'");
?>

<form method="post">
<table width="99%" class="table table-bordered">
<tr bgcolor="#EAEAEA">
	<td colspan="2"><b><?=($recordID)?"Edit":"Add New";?> Coupon</b></td>
</tr>

<tr>
	<td><b>Coupon Type</b></td>
	<td>
	<select name="cpn_type" class="form-control">
		<option value="0" <?=$res['cpn_type']=='0'?'selected':'';?>>Fixed Amount</option>
		<option value="1" <?=$res['cpn_type']=='1'?'selected':'';?>>Percentage</option>
	</select>
	</td>
</tr>

<tr>
	<td><b>Coupon Code</b></td>
	<td><input type="text" name="cpn_code" class="form-control" value="<?=$res['cpn_code'];?>" required></td>
</tr>

<tr>
	<td><b>Coupon Name</b></td>
	<td><input type="text" name="cpn_name" class="form-control" value="<?=$res['cpn_name'];?>" required></td>
</tr>

<tr>
	<td><b>Discount Rate</b></td>
	<td><input type="number" name="cpn_rate" class="form-control" value="<?=$res['cpn_rate'];?>" required></td>
</tr>

<tr>
	<td><b>Minimum Amount</b></td>
	<td><input type="text" name="minimum_amount_for_coupan_apply" class="form-control" value="<?=$res['minimum_amount_for_coupan_apply'];?>"></td>
</tr>

<tr>
	<td><b>Start Date</b></td>
	<td><input type="date" name="cpn_start_date" class="form-control" value="<?=$res['cpn_start_date'];?>"></td>
</tr>

<tr>
	<td><b>End Date</b></td>
	<td><input type="date" name="cpn_end_date" class="form-control" value="<?=$res['cpn_end_date'];?>"></td>
</tr>

<?php if($recordID){ ?>
<tr>
	<td><b>Status</b></td>
	<td>
	<select name="status" class="form-control">
		<option value="1" <?=$res['status']==1?'selected':'';?>>Active</option>
		<option value="0" <?=$res['status']==0?'selected':'';?>>Deactive</option>
	</select>
	</td>
</tr>
<?php } ?>

<tr>
	<td></td>
	<td>
	<?php if($recordID){ ?>
	<input type="submit" value="Update Coupon" class="btn btn-primary">
	<input type="hidden" name="id" value="update_record">
	<input type="hidden" name="recordID" value="<?=$recordID;?>">
	<?php } else { ?>
	<input type="submit" value="Add Coupon" class="btn btn-success">
	<input type="hidden" name="id" value="add_record">
	<?php } ?>
	<input type="hidden" name="start" value="<?=$start;?>">
	<input type="hidden" name="pagesize" value="<?=$pagesize;?>">
	</td>
</tr>
</table>
</form> -->

<?php admin_footer(); ?>
