<?php
include_once("../include/main.inc.php");
check_session('MyCpanel','index.php');

@extract($_REQUEST);

/* ================= CONFIG ================= */
$heading     = "Manage Colors";
$script_name = "manage_color.php";
$table_name  = "color_tbl";

/* ================= PAGING ================= */
$start = (intval($start) < 0 || $start == "") ? 0 : $start;
$pagesize = intval($pagesize) == 0 ? 20 : $pagesize;

/* ================= BULK ACTION ================= */
if(isset($_POST['bulk_action']) && !empty($_POST['color_ids'])) {

    $ids = implode(",", array_map('intval', $_POST['color_ids']));

    if($_POST['bulk_action']=="delete"){
        db_query("DELETE FROM $table_name WHERE color_id IN ($ids)");
        $_SESSION['session_message']="Selected colors deleted successfully";
    }

    if($_POST['bulk_action']=="activate"){
        db_query("UPDATE $table_name SET status='1' WHERE color_id IN ($ids)");
        $_SESSION['session_message']="Selected colors activated";
    }

    if($_POST['bulk_action']=="deactivate"){
        db_query("UPDATE $table_name SET status='0' WHERE color_id IN ($ids)");
        $_SESSION['session_message']="Selected colors deactivated";
    }

    header("Location: ".SITE_ADMIN_URL."/$script_name?start=$start&pagesize=$pagesize");
    exit;
}

/* ================= UPDATE SORT ORDER ================= */
if (isset($_POST['update_order']) && isset($_POST['sort_order']) && is_array($_POST['sort_order'])) {

    foreach ($_POST['sort_order'] as $cid => $order) {
        if ($order !== '' && is_numeric($order)) {
            db_query("
                UPDATE color_tbl 
                SET sort_order = '".intval($order)."'
                WHERE color_id = '".intval($cid)."'
            ");
        }
    }

    $_SESSION['session_message'] = "Order updated successfully";
    header("Location: ".SITE_ADMIN_URL."/manage_color.php");
    exit;
}

/* ================= ADD ================= */
if($id=="add_record"){

    if($_FILES['themes_image']['name']!=""){
        $ext=strtolower(getExtension($_FILES['themes_image']['name']));
        if(!in_array($ext,['jpg','jpeg','png','gif'])){
            $form_check_alert.="<li>Invalid image format</li>";
        }
    }

    if(!strlen($form_check_alert)>0){

        if($_FILES['themes_image']['name']!=""){
            $themes_image=upload_file("color_".time(),"themes_image","uploaded-files/gallery/photos");
        }
        $status = (isset($status) && $status !== '') ? intval($status) : 1;

        db_query("INSERT INTO $table_name SET
            color_name='$color_name',
            color_code='$color_code',
            themes_image='$themes_image',
            sort_order='".intval($sort_order)."',
            status='".intval($status)."',
            color_date_added=NOW()
        ");

        $_SESSION['session_message']="Color added successfully";
        header("Location: ".SITE_ADMIN_URL."/$script_name?start=$start&pagesize=$pagesize");
        exit;
    }
}

/* ================= UPDATE ================= */
if($id=="update_record"){

    if($_FILES['themes_image']['name']!=""){
        $ext=strtolower(getExtension($_FILES['themes_image']['name']));
        if(!in_array($ext,['jpg','jpeg','png','gif'])){
            $form_check_alert.="<li>Invalid image format</li>";
        }
    }

    if(!strlen($form_check_alert)>0){

        if($_FILES['themes_image']['name']!=""){
            $old=getResult($table_name,"WHERE color_id='$recordID'");
            @unlink(SITE_DIR_PATH."uploaded-files/gallery/photos/".$old['themes_image']);
            $themes_image=upload_file("color_".time(),"themes_image","uploaded-files/colors");
            updateTable($table_name,"themes_image='$themes_image' WHERE color_id='$recordID'");
        }

        updateTable($table_name,"
            color_name='$color_name',
            color_code='$color_code',
            sort_order='".intval($sort_order)."',
            status='".intval($status)."',
            color_date_updated=NOW()
            WHERE color_id='$recordID'
        ");

        $_SESSION['session_message']="Color updated successfully";
        header("Location: ".SITE_ADMIN_URL."/$script_name?start=$start&pagesize=$pagesize");
        exit;
    }
}

/* ================= DELETE SINGLE ================= */
if($id=="delete_record"){
    db_query("DELETE FROM $table_name WHERE color_id='$recordID'");
    $_SESSION['session_message']="Color deleted";
    header("Location: ".SITE_ADMIN_URL."/$script_name?start=$start&pagesize=$pagesize");
    exit;
}

admin_header("");
?>
<!-- ================= LISTING ================= -->
<table width="99%" align="center">
<tr>
<td class="myTitle"><?=$heading;?></td>
<td align="right">
<form method="post" style="margin:0;">
Records Per Page:
<select name="pagesize" onchange="this.form.submit()">
<?php foreach($_GLOBALS['pgsize_arr'] as $val){ ?>
<option value="<?=$val?>" <?=$pagesize==$val?'selected':''?>><?=$val?></option>
<?php } ?>
</select>
</form>
</td>
</tr>
</table>

<hr>
<?php
$qry1=db_query("select * from $table_name ");
$reccnt=NumRows($qry1);
// $qry=db_query("select * from $table_name where image!='' order by id desc limit $start,$pagesize");
$qry=db_query("SELECT * FROM $table_name ORDER BY sort_order ASC LIMIT $start,$pagesize");
echo pageNavigation($reccnt,$pagesize,$start);
print_message();
?>

<form method="post" id="bulkForm">

<table width="99%" class="table table-bordered table-hover">
<tr bgcolor="#EAEAEA">
<th width="4%"><input type="checkbox" id="select_all"></th>
<th>S.No</th>
<th>Color Name</th>
<th>Preview</th>
<th>Status</th>
<th width="6%">Order</th>
<th>Action</th>
</tr>

<?php

$sl=$start+1;

while($row=mysqli_fetch_array($qry)){
?>
<tr>
<td align="center">
<input type="checkbox" class="rowCheck" name="color_ids[]" value="<?=$row['color_id']?>">
</td>

<td align="center"><?=$sl?></td>
<td align="center"><?=$row['color_name']?></td>

<td align="center">
<?php
$img=SITE_DIR_PATH."/uploaded-files/colors/".$row['themes_image'];
if($row['themes_image']!="" && file_exists($img)){
?>
<img src="<?=SITE_URL_PATH?>/uploaded-files/colors/<?=$row['themes_image']?>" width="40">
<?php } else { ?>
<div style="width:40px;height:40px;background:<?=$row['color_code']?>;border:1px solid #000"></div>
<?php } ?>
</td>

<td align="center">
<?=($row['status']=='1')?'<span style="color:green">Active</span>':'<span style="color:red">Inactive</span>'?>
</td>

<td align="center">
<input type="number" name="sort_order[<?=$row['color_id']?>]" value="<?=$row['sort_order']?>" class="form-control" style="width:70px;text-align:center;">
</td>

<td align="center">
<a class="btn btn-primary" href="<?=$script_name?>?id=edit_record&recordID=<?=$row['color_id']?>">Edit</a>
<a class="btn btn-danger" href="<?=$script_name?>?id=delete_record&recordID=<?=$row['color_id']?>" onclick="return confirm('Delete?')">Delete</a>
</td>
</tr>
<?php $sl++; } ?>
</table>

<div style="margin:10px 0;">
<input type="submit" name="update_order" value="Update Order" class="btn btn-success" onclick="return confirm('Update order?')">
</div>

<div id="bulkActions" style="display:none;margin:10px 0;">
<select name="bulk_action" class="form-control" style="width:220px;display:inline-block">
<option value="delete">Delete Selected</option>
<option value="activate">Activate Selected</option>
<option value="deactivate">Deactivate Selected</option>
</select>
<input type="submit" value="Apply" class="btn btn-danger" onclick="return confirm('Apply bulk action?')">
</div>

</form>

<hr>

<?php $res=getResult($table_name,"WHERE color_id='$_GET[recordID]'"); ?>

<form method="post" enctype="multipart/form-data">
<table width="99%" class="table table-bordered">

<tr bgcolor="#EAEAEA">
<td colspan="2"><b><?=($id=="edit_record")?"Edit":"Add New"?> Color</b></td>
</tr>

<tr>
<td><b>Color Name *</b></td>
<td><input type="text" name="color_name" class="form-control" value="<?=$res['color_name']?>" required></td>
</tr>

<tr>
<td><b>Color *</b></td>
<td style="text-align:left;">
<input type="text" id="colorCode" name="color_code" value="<?=($res['color_code'])?$res['color_code']:'#000000'?>" class="form-control" style="width:120px;display:inline-block;">
<input type="color" id="colorPicker" value="<?=($res['color_code'])?$res['color_code']:'#000000'?>" style="margin-left:10px;">
<!-- <span id="colorPreview" style="display:inline-block;width:30px;height:30px;margin-left:10px;border:1px solid #333;background:<?=($res['color_code'])?$res['color_code']:'#000000'?>"></span> -->
</td>
</tr>

<tr>
<td><b>Theme Image</b></td>
<td>
<input type="file" name="themes_image">
<?php if($res['themes_image']){ ?>
<br><img src="<?=SITE_URL_PATH?>/uploaded-files/gallery/photos/<?=$res['themes_image']?>" width="50">
<?php } ?>
</td>
</tr>
<!-- 
<tr>
<td><b>Sort Order</b></td>
<td><input type="number" name="sort_order" value="<?=$res['sort_order']?>" class="form-control"></td>
</tr> -->

<!-- <tr>
<td><b>Status</b></td>
<td>
<select name="status" class="form-control">
<option value="1" <?=($res['status']=='1')?'selected':''?>>Active</option>
<option value="0" <?=($res['status']=='0')?'selected':''?>>Inactive</option>
</select>
</td>
</tr> -->

<tr>
<td></td>
<td>
<?php if($id=="edit_record"){ ?>
<input type="hidden" name="recordID" value="<?=$res['color_id']?>">
<input type="hidden" name="id" value="update_record">
<input type="submit" value="Update Color" class="btn btn-success">
<?php } else { ?>
<input type="hidden" name="id" value="add_record">
<input type="submit" value="Add Color" class="btn btn-primary">
<?php } ?>
</td>
</tr>

</table>
</form>

<script>
const selectAll=document.getElementById('select_all');
const checks=document.querySelectorAll('.rowCheck');
const bulkBox=document.getElementById('bulkActions');

function toggleBulk(){
    let any=false;
    checks.forEach(c=>{ if(c.checked) any=true; });
    bulkBox.style.display=any?'block':'none';
}

selectAll.addEventListener('change',()=>{
    checks.forEach(c=>c.checked=selectAll.checked);
    toggleBulk();
});
checks.forEach(c=>c.addEventListener('change',toggleBulk));

const picker=document.getElementById('colorPicker');
const code=document.getElementById('colorCode');
const prev=document.getElementById('colorPreview');

picker.addEventListener('input',()=>{
    code.value=picker.value;
    prev.style.background=picker.value;
});

code.addEventListener('input',()=>{
    if(/^#[0-9A-Fa-f]{6}$/.test(code.value)){
        picker.value=code.value;
        prev.style.background=code.value;
    }
});
</script>

<?php admin_footer(); ?>
