<?php
include_once("../include/main.inc.php");
check_session('MyCpanel', 'index.php');

require_once '../dompdf/autoload.inc.php';

use Dompdf\Dompdf;
use Dompdf\Options;

// Error reporting (enable only if needed)
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

$order_id = isset($_GET['order_id']) ? (int)$_GET['order_id'] : 0;
if (!$order_id) {
    die("Invalid Order ID");
}

$html = invoicehtmlprint($order_id, "admin");

$options = new Options();
$options->set('isRemoteEnabled', true);   // allow images
$options->set('defaultPaperSize', 'A4');  // force A4
$options->set('dpi', 96);                 // correct scaling
$options->set('isHtml5ParserEnabled', true);


$dompdf = new Dompdf($options);

$dompdf->setPaper('A4', 'portrait');

$dompdf->loadHtml($html, 'UTF-8');


$dompdf->render();

$dompdf->stream(
    "Invoice_" . $order_id . ".pdf",
    [
        "Attachment" => true   // true = download | false = preview
    ]
);

exit;
?>
