<?php
include_once("../include/main.inc.php");
check_session('MyCpanel','index.php');

$product_id = intval($_GET['product_id']);
$heading = "Manage Product Stock";

/* =========================
   UPDATE STOCK (EDIT MODE)
========================= */
if (isset($_POST['save_stock']) && !empty($_POST['stock'])) {

    foreach ($_POST['stock'] as $color_id => $sizes) {
        foreach ($sizes as $size_id => $data) {

            $stock_id = intval($data['stock_id']);
            $qty      = intval($data['qty']);
            $price    = floatval($data['price']);
            $mrp      = floatval($data['mrp_price']);

            // calculate discount price
            $discount_price = $mrp - $price;
            if ($discount_price < 0) {
                $discount_price = 0;
            }

            if ($stock_id > 0) {
                mysqli_query($dbconn, "
                    UPDATE product_stock SET
                        quantity = '$qty',
                        price = '$price',
                        mrp_price = '$mrp'
                    WHERE id = '$stock_id'
                    AND product_id = '$product_id'
                ");
            }
        }
    }

    $_SESSION['session_message'] =
        '<div class="btn btn-success">Stock updated successfully</div>';

    header("Location: ajax_manage_stock.php?product_id=".$product_id);
    exit;
}

/* =========================
   PRODUCT INFO
========================= */
$prod = mysqli_fetch_assoc(mysqli_query($dbconn,"
    SELECT product_title, color_ids, size_ids, selling_price, mrp_price
    FROM product_tbl
    WHERE product_id = '$product_id'
"));

$color_ids = array_filter(explode(',', $prod['color_ids']));
$size_ids  = array_filter(explode(',', $prod['size_ids']));

$colors = [];
$sizes  = [];

/* =========================
   COLORS
========================= */
if (!empty($color_ids)) {
    $cq = mysqli_query($dbconn,"
        SELECT color_id, color_name
        FROM color_tbl
        WHERE color_id IN(".implode(',', $color_ids).")
    ");
    while ($c = mysqli_fetch_assoc($cq)) {
        $colors[$c['color_id']] = $c['color_name'];
    }
}

/* =========================
   SIZES
========================= */
if (!empty($size_ids)) {
    $sq = mysqli_query($dbconn,"
        SELECT size_id, size_name
        FROM size_tbl
        WHERE size_id IN(".implode(',', $size_ids).")
    ");
    while ($s = mysqli_fetch_assoc($sq)) {
        $sizes[$s['size_id']] = $s['size_name'];
    }
}

admin_header();
?>

<h3 class="myTitle"><?= $heading; ?></h3>
<hr>

<p><strong>Product:</strong> <?= $prod['product_title']; ?></p>

<form method="post">
<input type="hidden" name="save_stock" value="1">

<table class="table table-bordered">
<thead>
<tr style="background:#f5f5f5;">
    <th>Color</th>
    <th>Size</th>
    <th>Quantity</th>
    <th>Selling Price (₹)</th>
    <th>MRP Price (₹)</th>
</tr>
</thead>
<tbody>

<?php
foreach ($colors as $cid => $cname) {
    foreach ($sizes as $sid => $sname) {

        $stk = mysqli_fetch_assoc(mysqli_query($dbconn,"
            SELECT id, quantity, price, mrp_price
            FROM product_stock
            WHERE product_id = '$product_id'
            AND color_id = '$cid'
            AND size_id = '$sid'
        "));
?>
<tr>
    <td><?= $cname; ?></td>
    <td><?= $sname; ?></td>

    <td>
        <input type="number" class="form-control"
               name="stock[<?= $cid; ?>][<?= $sid; ?>][qty]"
               value="<?= $stk['quantity'] ?? 0 ?>"
               min="0">
    </td>

    <td>
        <input type="text" class="form-control"
               name="stock[<?= $cid; ?>][<?= $sid; ?>][price]"
               value="<?= $stk['price'] ?? $prod['selling_price']; ?>">
    </td>

    <td>
        <input type="text" class="form-control"
               name="stock[<?= $cid; ?>][<?= $sid; ?>][mrp_price]"
               value="<?= $stk['mrp_price'] ?? $prod['mrp_price']; ?>">
    </td>

    <!-- STOCK ID -->
    <input type="hidden"
           name="stock[<?= $cid; ?>][<?= $sid; ?>][stock_id]"
           value="<?= $stk['id'] ?? 0 ?>">
</tr>
<?php }} ?>

</tbody>
</table>

<div class="text-right">
    <button type="submit" class="btn btn-success">
        Save Stock
    </button>

    <a href="<?= SITE_ADMIN_URL ?>/manage_products.php"
       class="btn btn-secondary">
        Back
    </a>
</div>

</form>

<?php admin_footer(); ?>
