<?php
include_once("include/main.inc.php");
$encoded = $_GET['oid'] ?? '';

if ($encoded == '') {
    die('Invalid request');
}

$order_id = decodeOrderId($encoded);


// /* ---------- Validate Order ---------- */
// if (!isset($_GET['order_id']) || $_GET['order_id'] == '') {
//     die("Invalid Order");
// }

// $order_id = intval($_GET['order_id']);

/* ---------- Order ---------- */
$order = mysqli_fetch_assoc(mysqli_query(
    $dbconn,
    "SELECT * FROM orders_tbl WHERE order_id = '$order_id'"
));

/* ---------- Order Items ---------- */
$order_items = mysqli_query($dbconn, "
    SELECT 
        od.*,
        p.product_code,
        p.product_title,
        p.product_image,
        p.mrp_price,
        s.size_name,
        c.color_name
    FROM order_details od
    LEFT JOIN product_tbl p ON p.product_id = od.product_id
    LEFT JOIN size_tbl s ON s.size_id = od.size
    LEFT JOIN color_tbl c ON c.color_id = od.color
    WHERE od.order_id = '$order_id'
");


$status_q = mysqli_query($dbconn, "
    SELECT 
        os.stage_name,
        osh.remark,
        osh.updated_at
    FROM order_status_history osh
    JOIN order_stages os ON os.id = osh.stage_id
    WHERE osh.order_id = '$order_id'
    ORDER BY osh.updated_at ASC
");


$completedStages = [];
$lastRemark = '';
$lastDate = '';

while ($row = mysqli_fetch_assoc($status_q)) {
    $completedStages[] = $row['stage_name'];
    $lastRemark = $row['remark'];
    $lastDate = date('D, jS M h:i a', strtotime($row['updated_at']));
}

$currentStage = !empty($completedStages) ? end($completedStages) : 'Pending';

$encoded = encodeOrderId($order_id);

?>

<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="utf-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">



    <?php include "app_top2.php"; ?>
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<style>
    .track_page {
    float: left;
    width: 100%;
    margin: 0;
    padding: 30px 0 40px;
    background: #eee;
    position: relative;
}
.track_info {
    padding: 0;
    box-shadow: 0 2px 4px 0 rgba(0, 0, 0, .08);
    margin-bottom: 20px;
    background: #fff;
}
.delivery_address_track {
    padding: 20px 15px;
    border-right: 1px solid #ccc;
}
.delivery_address_track h1 {
      font-size: 20px;
    font-weight: 700;
    line-height: 24px;
    margin: 0;
    padding: 0 0 10px;
    text-transform: capitalize;
    background: transparent;
    color:#226cd8;
}
.delivery_address_track h2 {
    font-size: 16px;
    font-weight: 600;
    line-height: 24px;
    margin: 0;
    padding: 0;
    background: transparent;
    color: #333;
}
.more_track {
    padding: 20px 15px;
}
.more_track h2 {
    font-size: 18px;
    font-weight: 600;
    line-height: 24px;
    margin: 0;
    padding: 0 0 10px;
    background: transparent;
    color: #333;
}
.more_track p i {
    color: #226cd8;
}
.request_invoice {
    padding: 5px 10px;
    border: 1px solid #226cd8;
    border-radius: 4px;
    line-height: normal;
    background: #226cd8;
    color: #fff;
    font-size: 13px;
    text-decoration: none;
    margin-left: 10px;
}
.process {
    padding: 15px;
    float: left;
    width: 100%;
    background: #fff;
    border: 1px solid #ccc;
}
.process_left {
    float: left;
    width: 100%;
    margin: 0;
    padding: 0;
}
.process_left {
    float: left;
    width: 100%;
    margin: 0;
    padding: 0;
}

.process_left a {
    color: #333;
    text-decoration: none;
    font-size: 16px;
    font-weight: 600;
}

.process_left p {
    font-size: 13px;
    color: #333;
    line-height: 20px;
    margin: 0 0 10px;
    padding: 0;
    text-align: left;
}

.process_left .details_price {
    margin-bottom: 0;
}

.process_left .product-price {
    text-align: left;
}

.process_left .product-price ins {
    text-decoration: none;
    font-size: 16px;
    font-weight: 600;
    margin-right: 5px;
}

.deliver_process {
    float: left;
    width: 100%;
    margin: 25px 0 10px;
    padding: 0;
}

.progressbar {
    float: left;
    width: 100%;
    margin: 0;
    padding: 0;
    counter-reset: step;
}

.progressbar li {
    list-style-type: none;
    width: 25%;
    float: left;
    font-size: 12px;
    position: relative;
    text-align: center;
    text-transform: capitalize;
    color: #7d7d7d;
}

.progressbar li:before {
    width: 20px;
    height: 20px;
    content: counter(step);
    counter-increment: step;
    line-height: 15px;
    border: 2px solid #7d7d7d;
    display: block;
    text-align: center;
    margin: 0 auto 10px auto;
    border-radius: 50%;
    background: white;
    position: relative;
    z-index: 5;
}

.progressbar li:after {
    width: 100%;
    height: 2px;
    content: '';
    position: absolute;
    background-color: #7d7d7d;
    top: 10px;
    left: -50%;
    z-index: 0;
}

.progressbar li:first-child:after {
    content: none;
}

.progressbar li.active {
    color: #226cd8;
}

.progressbar li.active:before {
    border-color: #226cd8;
}

.progressbar li.active+li:after {
    background: #226cd8;
}

.progressbar li .process_dec {
    display: none;
    width: 200px;
    position: absolute;
    z-index: 999;
    top: 110%;
    left: 0;
    background: #eee;
    padding: 10px;
    box-shadow: 0 2px 4px 0 rgba(0, 0, 0, .08);
}

.progressbar li:hover .process_dec {
    display: block;
    border-top: 0;
}

.progressbar li:hover .process_dec:after {
    content: "\f0d8";
    font-family: 'FontAwesome';
    position: absolute;
    top: -22px;
    font-size: 31px;
    left: 50px;
    color: #eee;
}

.progressbar li .process_dec p {
    font-size: 14px;
    line-height: 18px;
    text-align: left;
}

.progressbar li .process_dec p span {
    font-size: 12px;
    color: #333;
}



.price .offerPrice {
    font-size: 24px;
    color: #226cd8;
    font-weight: 600;
    margin-bottom: 10px;
    position: relative;
    width: 100%;
}

.price .offPercentage {
    display: inline-block;
    text-align: center;
    position: relative;
    background: #388e3c;
    color: #fff;
    padding: 3px 10px;
    font-size: 14px;
    border-radius: 3px;
    margin-left: 10px;
}

.price .mrpPrice {
    font-size: 18px;
    color: #666;
    text-decoration: line-through;
    font-weight: normal;
    margin-left: 5px;
}
.deliver_righ_info h4 {
    font-size: 16px;
}
.track_footer {
    float: left;
    width: 100%;
    border: 1px solid #ccc;
    border-top: 0;
    padding: 10px 15px;
    background: #fff;
    box-shadow: 0 2px 4px 0 rgba(0, 0, 0, .08);
    margin-bottom: 20px;
    font-weight: 600;
    font-size: 16px;
}
.track_footer .checkout_btn {
    padding: 5px 15px;
    float: right;
    margin: 0;
}
</style>

</head>



<body>



    <?php include "app_header2.php"; ?>




<section class="track_page">
        <div class="container">
            <div class="row">
                <div class="col-md-12">

                    <div class="wps_right track_info">
                        <div class="row">
                            
                            <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8 col-sm-8 col-12">
                                <div class="delivery_address_track">
                                    <h1>Delivery Address</h1>
                                    <h2><?= $order['bill_fname'].' '.$order['bill_lname']; ?></h2>
                                     <p>
                                        <?= $order['bill_address1']; ?>,
                                        <?= $order['bill_city']; ?>,
                                        <?= $order['bill_state']; ?> - <?= $order['bill_zipcode']; ?><br>
                                        <strong>Phone</strong>: <?= $order['bill_mobile']; ?>
                                    </p>
                                </div>
                            </div>
                            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <div class="more_track">
                                    <h2>More actions</h2>
                                    <p><i class="fa fa-file-text"></i> Invoice <a class="request_invoice" href="<?= site_url;?>/download-invoice.htm?oid=<?= urlencode($encoded); ?>">Download</a></p>

                                </div>
                            </div>
                        </div>

                    </div>

                    <div class=" process">
                         <?php while ($item = mysqli_fetch_assoc($order_items)) {

                                    $images = explode(',', $item['image']);
                                    $img = !empty($images[0]) ? $images[0] : 'noimage.jpg';
                                    $product_img = getImage($img, 80, 80, $item['product_id'], '/uploaded-files/product-images/');
                                     $mrp = (float)$item['mrp_price'];
                                    $sell = (float)$item['item_price'];

                                    // Discount %
                                    $discount = ($mrp > 0 && $sell > 0) ? round((($mrp - $sell) / $mrp) * 100) : 0;
                                ?>
                        <div class="row">
                            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <div class="process_left">
                                    <div class="row">
                                        <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-4 col-12">
                                            <a href="javascript:void(0);"><img src="<?= $product_img; ?>"></a>
                                        </div>
                                        <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-8 col-12">
                                            <div class="order_info">
                                                <a href="javascript:void(0);"><?= $item['product_name']; ?></a>
                                                      <p><small>SKU : <?= $item['product_code'] ?></small><br>
                                                        <small>Size : <?= $item['size_name'] ?></small><br>
                                                        <small>Color : <?= $item['color_name'] ?></small><br>
                                                        <small>Qty : <strong><?= $item['qty'] ?></strong></small></p>
                                                      
                                                <div class="price">
                                                    <span class="offerPrice">₹<?= number_format($sell, 2); ?></span>
                                                     <?php if($mrp > $sell){ ?>
                                                    <span class="mrpPrice">₹<?= number_format($mrp, 2); ?></span>
                                                    <?php } ?>
                                                    <?php if($discount > 0){ ?>
                                                    <span class="offPercentage"><?= $discount; ?>% off</span>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                               
                            </div>
                            <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                <div class="deliver_process">
                                    <!-- <ul class="progressbar">
                                        <li class="active">Ordered
                                            <div class="process_dec">
                                                <p><span>Sun, 11th Jan 10:43 pm</span><br> Seller has processed your order.</p>
                                            </div>
                                        </li>
                                        <li class="active">Packed
                                            <div class="process_dec">
                                                <p><span>Sun, 11th Jan 11:07 pm</span> Your item has been dispatched from the seller warehouse</p>
                                            </div>
                                        </li>
                                        <li class="active">Shipped
                                            <div class="process_dec">
                                                <p><span>Mon, 12th Jan 11:07 pm</span><br>Your item is out for delivery Ecom Express - 799774259</p>
                                            </div>
                                        </li>
                                        <li class="active">Delivered
                                            <div class="process_dec">
                                                <p><span>Tue, 13th Jan 04:07 pm</span><br>
                                                    Your item has been delivered</p>
                                            </div>
                                        </li>
                                    </ul> -->
                                   
                                        <ul class="progressbar">

                                            <li class="<?= ($currentStage == 'Order Placed') ? 'active' : '' ?>">
                                                Ordered
                                                <div class="process_dec">
                                                    <p>
                                                        <?php if ($currentStage == 'Order Placed'): ?>
                                                            <span><?= $lastDate ?></span><br>
                                                            <?= htmlspecialchars($lastRemark) ?>
                                                        <?php elseif (in_array($currentStage, ['Packed','Shipped','Delivered'])): ?>
                                                            Order placed successfully.
                                                        <?php else: ?>
                                                            Pending
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </li>

                                            <li class="<?= ($currentStage == 'Packed') ? 'active' : '' ?>">
                                                Packed
                                                <div class="process_dec">
                                                    <p>
                                                        <?php if ($currentStage == 'Packed'): ?>
                                                            <span><?= $lastDate ?></span><br>
                                                            <?= htmlspecialchars($lastRemark) ?>
                                                        <?php elseif (in_array($currentStage, ['Shipped','Delivered'])): ?>
                                                            Item packed successfully.
                                                        <?php else: ?>
                                                            Pending
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </li>

                                            <li class="<?= ($currentStage == 'Shipped') ? 'active' : '' ?>">
                                                Shipped
                                                <div class="process_dec">
                                                    <p>
                                                        <?php if ($currentStage == 'Shipped'): ?>
                                                            <span><?= $lastDate ?></span><br>
                                                            <?= htmlspecialchars($lastRemark) ?>
                                                        <?php elseif ($currentStage == 'Delivered'): ?>
                                                            Item shipped successfully.
                                                        <?php else: ?>
                                                            Pending
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </li>

                                            <li class="<?= ($currentStage == 'Delivered') ? 'active' : '' ?>">
                                                Delivered
                                                <div class="process_dec">
                                                    <p>
                                                        <?php if ($currentStage == 'Delivered'): ?>
                                                            <span><?= $lastDate ?></span><br>
                                                            <?= htmlspecialchars($lastRemark) ?>
                                                        <?php else: ?>
                                                            Pending status
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </li>

                                        </ul>


                                </div>
                            </div>
                            <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12">
                                <div class="deliver_righ_info">
                                    <!-- <h4>Delivered On Tue, January 13th '2026</h4> -->
                                 <h4><?= $currentStage; ?></h4>
                                        <?php if ($lastRemark): ?>
                                            <?= htmlspecialchars($lastRemark) ?><br>
                                            <small><?= $lastDate ?></small>
                                        <?php endif; ?>

                                    <a class="review_product" href="review.php?order_id=<?= $order_id; ?>" title="Rate &amp; Review Product"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                                        </svg> Rate &amp; Review</a>
                                      
                                </div>
                            </div>
                        </div>
                        <hr>
                         <?php } ?>

                    </div>
                    <div class="track_footer">
                        Total ₹<?= $order['total_amount']; ?> <button onclick="goBack();" class="checkout_btn" name="Back">Back</button>
                    </div>
                </div>
            </div>


        </div>

    </section>





    <?php include "app_footer.php"; ?>

    <?php include "app_bottom2.php"; ?>
    <script src="designer/js/magic-zoom2.js"></script>
    <script src="designer/js/swiper.min.js"></script>
<script>
function goBack() {
    window.history.back();
}
</script>

    <script>
    $(document).ready(function() {
        $('.check-pincode-js').click(function() {
            const pincode = $('#pincode').val().trim();
            const pincodeRegex = /^[1-9][0-9]{5}$/;

            // Hide all messages initially
            $('.pincodeInfo').addClass('d-none');

            if (!pincodeRegex.test(pincode)) {
                // Invalid format
                $('.pincodeInvalid').removeClass('d-none');
            } else {
                // Simulate success / failure
                if (["110001", "400001", "560001"].includes(pincode)) {
                    // Success: show fake delivery date
                    const deliveryDate = new Date();
                    deliveryDate.setDate(deliveryDate.getDate() + 5); // +5 days
                    const options = {
                        day: 'numeric',
                        month: 'long',
                        year: 'numeric'
                    };

                    $('.deliveryDate').text(deliveryDate.toLocaleDateString('en-IN', options));
                    $('.pincodeSuccess').removeClass('d-none');
                } else {
                    // Not deliverable
                    $('.pincodeUndeliverable').removeClass('d-none');
                }
            }
        });
    });
    </script>
    <script>
    var swiper = new Swiper(".mySwiper", {

        loop: false,

        spaceBetween: 5,

        mousewheel: true,

        slidesPerView: 5,

        freeMode: true,

        watchSlidesProgress: true,

        breakpoints: {

            992: {

                direction: "horizontal",

            },

        },

    });



    var swiper2 = new Swiper(".mySwiper2", {

        loop: true,

        spaceBetween: 10,

        navigation: {

            nextEl: ".swiper-next",

            prevEl: ".swiper-prev",

        },

        thumbs: {

            swiper: swiper,

        },

    });
    </script>
    <script>
    // PLUS
    $(document).on('click', '.button-plus', function() {
        let qtyInput = $(this).siblings('.quantity');
        let qty = parseInt(qtyInput.val());
        qtyInput.val(qty + 1);
        updateTotals();
    });

    // MINUS (quantity never below 1)
    $(document).on('click', '.button-minus', function() {
        let qtyInput = $(this).siblings('.quantity');
        let qty = parseInt(qtyInput.val());

        if (qty > 1) {
            qtyInput.val(qty - 1);
            updateTotals();
        }
    });
    </script>

</body>



</html>