<?php 
include_once("include/main.inc.php"); 
session_start();

// --- Security & Data Handling ---
$keyword = isset($_REQUEST['keyword']) ? mysqli_real_escape_string($GLOBALS['dbconn'], $_REQUEST['keyword']) : '';
$chunk = substr($keyword, 0, 5);

// Count initial results for Categories and Products
if (!empty($keyword)) {
    $query_cat = "SELECT * FROM category_tbl 
                  WHERE catName LIKE '%$keyword%' 
                  OR catName LIKE '%$chunk%' 
                  OR displayName LIKE '%$keyword%'";

    $query_prod = "SELECT * FROM product_tbl 
                   WHERE (product_name LIKE '%$keyword%' 
                   OR product_title LIKE '%$keyword%'
                   OR product_code LIKE '%$keyword%'
                   OR product_specfi LIKE '%$keyword%')
                   AND product_status != '2'";
} else {
    $query_cat = "SELECT * FROM category_tbl ORDER BY catID DESC LIMIT 10";
    $query_prod = "SELECT * FROM product_tbl WHERE product_status !='2' ORDER BY product_id DESC";
}

$sql_cat = mysqli_query($GLOBALS['dbconn'], $query_cat);
$sql_prod = mysqli_query($GLOBALS['dbconn'], $query_prod);
$wnum = mysqli_num_rows($sql_cat) + mysqli_num_rows($sql_prod);

$page_metatitle = "Search - ".$admin_res['companyName'];
$page_metakey = "Search - ".$admin_res['companyName'];
$page_metadesc = "Search - ".$admin_res['companyName'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include "app_top2.php"; ?>
    
    <style>
        :root { --primary-dark: #212529; --accent: #ff6b6b; --bg-light: #f8f9fa; }
        body { background-color: #fff; font-family: 'Inter', sans-serif; }
        
        /* Sidebar Styling */
        .filter-sidebar { position: sticky; top: 20px; background: #fff; border: 1px solid #eee; border-radius: 12px; padding: 20px; }
        .filter-section { border-bottom: 1px solid #f0f0f0; margin-bottom: 15px; padding-bottom: 15px; }
        .filter-title { font-size: 0.85rem; font-weight: 700; text-transform: uppercase; letter-spacing: 1px; color: var(--primary-dark); cursor: pointer; display: flex; justify-content: space-between; }
        
        /* Color Swatches */
        .color-wrapper { display: flex; flex-wrap: wrap; gap: 10px; margin-top: 10px; }
        .color-item { cursor: pointer; position: relative; }
        .color-item input { display: none; }
        .color-dot { width: 25px; height: 25px; border-radius: 50%; border: 1px solid #ddd; display: block; transition: transform 0.2s; }
        .color-item input:checked + .color-dot { transform: scale(1.2); border: 2px solid var(--primary-dark); }
        
        /* Product List */
        #product-list { min-height: 400px; transition: opacity 0.3s; }
        .search-header { background: var(--bg-light); padding: 40px 0; margin-bottom: 30px; border-radius: 0 0 30px 30px; }
        .breadcrumb { font-size: 0.9rem; }
        .view-more-btn { color: #007bff; font-size: 0.8rem; cursor: pointer; font-weight: 600; margin-top: 5px; }
    </style>
</head>
<body>

<?php include "app_header2.php"; ?>

<header class="search-header">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= site_url; ?>">Home</a></li>
                <li class="breadcrumb-item active">Search</li>
            </ol>
        </nav>
        <h1 class="display-6 fw-bold">Results for "<?= htmlspecialchars($keyword) ?>"</h1>
        <p class="text-muted" id="item-total-display"><?= $wnum ?> items found</p>
    </div>
</header>

<section class="mb-5">
    <div class="container">
        <div class="row">
            
            <aside class="col-lg-3 col-md-4">
                <div class="filter-sidebar shadow-sm">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h2 class="m-0 fw-bold">Filters</h2>
                        <a href="search.php?keyword=<?=urlencode($keyword)?>" class="text-danger small text-decoration-none">Reset</a>
                    </div>

                    <div class="filter-section">
                        <div class="filter-title" onclick="$('#cat-content').slideToggle()">Category <span>+</span></div>
                        <div id="cat-content" class="mt-3">
                            <?php 
                            $cat_filter_q = mysqli_query($GLOBALS['dbconn'], "SELECT catID, displayName FROM category_tbl WHERE parentID = '1' AND status = 'Y' ORDER BY catOrder");
                            $i = 0;
                            while($row = mysqli_fetch_assoc($cat_filter_q)){
                                $i++;
                                $hide = ($i > 5) ? 'style="display:none"' : '';
                                 $extraClass = ($i > 5) ? ' extra-cat' : '';
                                echo "<div class='form-check mb-2{$extraClass}' $hide>
                                        <input class='form-check-input' type='checkbox' name='category[]' value='{$row['catID']}' id='c{$row['catID']}'>
                                        <label class='form-check-label small' for='c{$row['catID']}'>{$row['displayName']}</label>
                                      </div>";
                            }
                            if($i > 5) echo '<div class="view-more-btn" id="load-more-cats">Show More</div>';
                            ?>
                        </div>
                    </div>

                    <div class="filter-section">
                        <div class="filter-title" onclick="$('#color-content').slideToggle()">Available Colors <span>+</span></div>
                        <div id="color-content" class="color-wrapper mt-3">
                            <?php 
                            $clr_q = mysqli_query($GLOBALS['dbconn'], "SELECT color_id, color_code, color_name FROM color_tbl WHERE status = '1'");
                            while($clr = mysqli_fetch_assoc($clr_q)){
                                echo "<label class='color-item' title='{$clr['color_name']}'>
                                        <input type='checkbox' name='color[]' value='{$clr['color_id']}'>
                                        <span class='color-dot' style='background:{$clr['color_code']}'></span>
                                      </label>";
                            }
                            ?>
                        </div>
                    </div>

                    <div class="filter-section">
                        <div class="filter-title">Price Range</div>
                        <div class="mt-3">
                            <div class="form-check"><input class="form-check-input" type="checkbox" name="price[]" value="1" id="p1"><label class="form-check-label small" for="p1">Under ₹1,000</label></div>
                            <div class="form-check"><input class="form-check-input" type="checkbox" name="price[]" value="2" id="p2"><label class="form-check-label small" for="p2">₹1,000 - ₹5,000</label></div>
                            <div class="form-check"><input class="form-check-input" type="checkbox" name="price[]" value="3" id="p3"><label class="form-check-label small" for="p3">Above ₹5,000</label></div>
                        </div>
                    </div>
                </div>
            </aside>

            <main class="col-lg-9 col-md-8">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <?php 
                            if(mysqli_num_rows($sql_cat) > 0) {
                                while($c = mysqli_fetch_assoc($sql_cat)) {
                                    // Create the SEO URL like your products do
                                    $cat_url = site_url . '/' . getValidFileName($c['displayName']).'.htm';
                                    
                                    echo "<a href='$cat_url' class='badge rounded-pill bg-light text-dark border me-1 text-decoration-none'>
                                            {$c['displayName']}
                                        </a>";
                                }
                            } 
                            ?>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-dark dropdown-toggle" type="button" id="sortDropdown" data-bs-toggle="dropdown">
                            Sort By: New Arrivals
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="plpSorClick('Price Low to High')">Price Low to High</a></li>
                            <li><a class="dropdown-item" href="#" onclick="plpSorClick('Price High to Low')">Price High to Low</a></li>
                            <li><a class="dropdown-item active" href="#" onclick="plpSorClick('New Arrivals')">New Arrivals</a></li>
                        </ul>
                    </div>
                </div>

                <div id="product-list" class="row g-4">
                    </div>

                <div id="pagination-container" class="mt-5 d-flex justify-content-center"></div>
            </main>
        </div>
    </div>
</section>

<?php include 'app_footer.php'; ?>
<?php include 'app_bottom2.php'; ?>

<script>
let isFirstLoad = true;

function plpSorClick(val) {
    $('#sortDropdown').text('Sort By: ' + val);
    loadProducts(1);
}

function loadProducts(page = 1) {
    let categories = [];
    $('input[name="category[]"]:checked').each(function() { categories.push($(this).val()); });

    let colors = [];
    $('input[name="color[]"]:checked').each(function() { colors.push($(this).val()); });

    let prices = [];
    $('input[name="price[]"]:checked').each(function() { prices.push($(this).val()); });

    let sortVal = $('#sortDropdown').text().replace('Sort By: ', '').trim();

    if (!isFirstLoad) $('#product-list').css('opacity', '0.5');

    $.ajax({
        url: 'ajax_product_filter.php',
        type: 'POST',
        data: {
            keyword: '<?= $keyword ?>',
            categories: categories,
            colors: colors,
            price: prices,
            sort: sortVal,
            page: page
        },
        dataType: 'json',
        success: function(data) {
            if(data.count == 0) {
                $('#product-list').html('<div class="col-12 text-center py-5"><style="width:150px"><p class="mt-3 text-danger">No products found matching your filters.</p></div>');
            } else {
                $('#product-list').html(data.products);
            }
            $('#product-list').css('opacity', '1');
            $('#pagination-container').html(data.pagination);
            $('#item-total-display').text(data.count + ' Items found');
            isFirstLoad = false;
        }
    });
}

$(document).ready(function() {
    loadProducts(1);

    $(document).on('click', '.page-link', function(e) {
        e.preventDefault(); // Stop the page from jumping
        let page = $(this).data('page');
        
        // Only trigger if it's a valid page number and not disabled
        if (page && !$(this).parent().hasClass('disabled')) {
            loadProducts(page);
            // Scroll to top of product list so user sees new results
            $('html, body').animate({
                scrollTop: $("#product-list").offset().top - 100
            }, 500);
        }
    });

    // Filter Change Event
    $('input').on('change', function() { loadProducts(1); });

    // UI Toggle View More
        $(document).on('click', '#load-more-cats', function() {
            $('.extra-cat').slideToggle();
            $(this).text($(this).text() === 'Show More' ? 'Show Less' : 'Show More');
        });
});
</script>

</body>
</html>