<?php
include_once("include/main.inc.php");

if (!isset($_GET['order'])) {
    die('Invalid order');
}

$orderId = $_GET['order'];

// 🔒 Fetch order securely
$stmt = $GLOBALS["dbconn"]->prepare("
    SELECT order_id,invoice_no,payment_status,received_amount,payment_method,order_received_dt,user_id,payment_mode
    FROM orders_tbl WHERE razorpay_order_id = ? LIMIT 1
");
$stmt->bind_param("s", $orderId);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die('Order not found');
}

$order = $result->fetch_assoc();
$orderId=$order['order_id'];
$check = mysqli_query($GLOBALS['dbconn'],"SELECT * FROM email_log WHERE order_id='$orderId' AND type='order_confirmation' AND status='sent'");


if(mysqli_num_rows($check)==0){
    // EMAIL ALREADY SENT – STOP


    $product_sql=mysqli_query($GLOBALS['dbconn'],"Select * from order_details Where order_id='".$orderId."'");
    $invoiceName=$order['invoice_no'];
    $userID=$order['user_id'];
    $customer_res= mysqli_fetch_assoc(mysqli_query($GLOBALS["dbconn"],"Select user_id,user_name,user_email,user_mobile from user_tbl where user_id='$userID'"));
    $itemRows = '';
    $grandTotal = 0;

       while($item = mysqli_fetch_assoc($product_sql)) {
        $sizeRes= mysqli_fetch_assoc(mysqli_query($dbconn,"SELECT size_name from size_tbl Where size_id='".$item['size']."'"));
        $colorRes= mysqli_fetch_assoc(mysqli_query($dbconn,"SELECT color_name from color_tbl Where color_id='".$item['color']."'"));
    $itemName = htmlspecialchars($item['product_name']);
    $qty      = (int)$item['qty'];
    $price    = (float)$item['item_price'];
    $total    = $qty * $price;
    $grandTotal += $total;

    // Extra options
    $extras = '';

    if($item['embroidery'] == '1'){
        $extras .= '<small style="color:#666;">+ Name Embroidery (₹150)</small><br>';
    }
    if($item['symbol1'] == '1'){
        $extras .= '<small style="color:#666;">+ Stethoscope Symbol (₹100)</small><br>';
    }
    if($item['symbol2'] == '1'){
        $extras .= '<small style="color:#666;">+ Medical Symbol (₹100)</small><br>';
    }

    // Size & Color
    $extras .= '<small style="color:#888;">Size : '.$sizeRes['size_name'].'</small><br>';
    $extras .= '<small style="color:#888;">Color : '.$colorRes['color_name'].'</small>';

    $itemRows .= '
    <tr>
        <td>
            <strong>'.$itemName.'</strong><br>
            '.$extras.'
        </td>
        <td>'.$qty.'</td>
        <td>₹'.number_format($total,2).'</td>
    </tr>';
}
       
      $to = $admin_res['email'];

        $to2 = $admin_res['cc'];

       $to3 = 'webpulseindia@gmail.com'; 

    //  $to3 = 'vicky.wpsranchi@gmail.com'; 
      $subject="Your Loyal Needs order confirmation $invoiceName";
      $htmlContent = '<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{
    margin:0;
    padding:0;
    background:#f5f7fa;
    font-family:Arial, sans-serif;
}
.container{
    max-width:600px;
    margin:30px auto;
    background:#ffffff;
    border-radius:12px;
    overflow:hidden;
    box-shadow:0 4px 10px rgba(0,0,0,0.05);
}
.header{
    text-align:center;
    padding:25px;
    border-bottom:1px solid #eaeaea;
}
.logo{max-width:160px;}
.content{
    padding:30px;
    color:#444;
}
h2{
    color:#00AEEF;
    margin-bottom:10px;
}
.order-box{
    background:#f8fbff;
    padding:20px;
    border-radius:8px;
    border:1px solid #e6f2ff;
    margin:20px 0;
}
.badge{
    background:#ffe5e5;
    color:#d60000;
    padding:4px 10px;
    border-radius:20px;
    font-size:12px;
}
.table{
    width:100%;
    border-collapse:collapse;
}
.table th{
    text-align:left;
    padding:10px 0;
    border-bottom:2px solid #eee;
}
.table td{
    padding:10px 0;
    border-bottom:1px solid #f1f1f1;
}
.total-row td{
    padding-top:15px;
    font-weight:bold;
}
.footer{
    background:#fafafa;
    text-align:center;
    padding:20px;
    font-size:12px;
    color:#888;
}
.footer a{
    color:#00AEEF;
    text-decoration:none;
}
</style>
</head>

<body>
<div class="container">

<div class="header">
    <img src="https://www.lnuniform.com/designer/images/logo.png" class="logo">
</div>

<div class="content">
    <h2>🎉 Order Confirmed!</h2>

    <p>Hi <strong>'.$customer_res['user_name'].'</strong>,</p>
    <p>Thank you for shopping with us. Your order has been successfully placed and is currently being processed.</p>

    <div class="order-box">
        <p><strong>Order ID:</strong> '.$invoiceName.'</p>
        <p><strong>Date:</strong> '.date('F d, Y').'</p>
        <p><strong>Status:</strong> <span class="badge">Processing</span></p>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>Item</th>
                <th>Qty</th>
                <th> Price</th>
            </tr>
        </thead>
        <tbody>
            '.$itemRows.'
        </tbody>
        <tfoot>
      
            <tr class="total-row">
                <td colspan="2" align="right">Order Total:</td>
                <td>₹'.number_format($grandTotal,2).'</td>
            </tr>
        </tfoot>
    </table>

</div>

<div class="footer">
    <p><strong>Loyal Needs</strong></p>
    <p>Visit us: <a href="https://www.lnuniform.com">www.lnuniform.com</a></p>
    <p>&copy; '.date('Y').' Loyal Needs. All rights reserved.</p>
</div>

</div>
</body>
</html>';
$mailStatus = 'failed';
  if($to!='')

         {

        if(smtp_mailer($to, $email, $name, $subject, $htmlContent)){
             $mailStatus = 'sent';
        }

         }

         if($to2!='')

         {

        if(smtp_mailer($to2, $email, $name, $subject, $htmlContent)){
             $mailStatus = 'sent';
        }

         }

     if(smtp_mailer($to3, $email, $name, $subject, $htmlContent)){
        $mailStatus = 'sent';
     }
if(smtp_mailer($customer_res['user_email'], $email, $name, $subject, $htmlContent)){
     $mailStatus = 'sent';
}
mysqli_query($GLOBALS['dbconn'],
"INSERT INTO email_log 
(order_id,email,type,status) VALUES 
('$orderId','".$customer_res['user_email']."','order_confirmation','$mailStatus')");
}
// Helper values
$amount = number_format($order['received_amount'], 2);
$status = ucfirst($order['payment_status']=='captured'?'Success':'Pending');
$delivery = "3–5 Business Days";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmed | Loyal Needs</title>
    <style>
    :root {
        --primary-blue: #00AEEF;
        /* Matches the 'SEL' blue */
        --accent-red: #ED1C24;
        /* Matches the red dot */
        --text-dark: #1A1A1A;
        --bg-light: #f9f9f9;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: var(--bg-light);
        color: var(--text-dark);
        margin: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
    }

    .thank-you-card {
        background: #ffffff;
        padding: 40px;
        border-radius: 12px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        max-width: 600px;
        width: 90%;
        text-align: center;
    }

    .logo {
        max-width: 200px;
        margin-bottom: 20px;
    }

    .success-icon {
        width: 80px;
        height: 80px;
        background: #e6f7ff;
        color: var(--primary-blue);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 40px;
        margin: 0 auto 20px;
    }

    h1 {
        color: var(--text-dark);
        margin-bottom: 10px;
        font-size: 28px;
    }

    p {
        color: #666;
        line-height: 1.6;
    }

    .order-box {
        background: #fdfdfd;
        border: 1px dashed #ddd;
        padding: 20px;
        border-radius: 8px;
        margin: 25px 0;
        text-align: left;
    }

    .order-id {
        color: var(--primary-blue);
        font-weight: bold;
    }

    .btn-container {
        display: flex;
        gap: 15px;
        justify-content: center;
        margin-top: 30px;
    }

    .btn {
        text-decoration: none;
        padding: 12px 25px;
        border-radius: 6px;
        font-weight: 600;
        transition: 0.3s;
    }

    .btn-primary {
        background-color: var(--primary-blue);
        color: white;
    }

    .btn-primary:hover {
        background-color: #008cc0;
    }

    .btn-outline {
        border: 2px solid #ddd;
        color: #555;
    }

    .btn-outline:hover {
        border-color: var(--primary-blue);
        color: var(--primary-blue);
    }

    .footer-note {
        font-size: 14px;
        margin-top: 30px;
        border-top: 1px solid #eee;
        padding-top: 20px;
    }

    .red-dot {
        color: var(--accent-red);
    }
    </style>
</head>

<body>

    <div class="thank-you-card">
        <img src="<?=site_url;?>/designer/images/logo.png" alt="Loyal Needs" class="logo">

        <div class="success-icon">✓</div>

        <h1>Order Placed Successfully<span class="red-dot">!</span></h1>
        <p>Thank you for choosing <strong>Loyal Needs</strong>. We have sent a
            confirmation email to your registered email address.</p>

        <div class="order-box">
            <strong>Order ID:</strong>
            <span class="order-id"><?= htmlspecialchars($order['invoice_no']) ?></span><br>

            <strong>Amount Paid:</strong>
            ₹<?= $amount ?><br>

            <strong>Payment Method:</strong>
            <?= strtoupper($order['payment_method']) ?><br>

            <strong>Status:</strong>
            <span class="status"><?= $status ?></span><br>

            <strong>Estimated Delivery:</strong>
            <?= $delivery ?><br>

            <strong>Order Date:</strong>
            <?= date("d M Y, h:i A", strtotime($order['order_received_dt'])) ?>
        </div>

        <div class="btn-container">
            <a href="<?=site_url;?>" class="btn btn-primary">Continue Shopping</a>
            <a href="<?=site_url;?>/my-account.htm" class="btn btn-outline">My Account</a>
        </div>

        <div class="footer-note">
          
            <p><small>&copy; <?=date(Y);?> Loyal Needs | www.lnuniform.com</small></p>
        </div>
    </div>

</body>

</html>