<?php 

include_once("include/main.inc.php"); 

$user_id = isset($_SESSION['USER_ID']) ? intval($_SESSION['USER_ID']) : 0;


// Fetch wishlist items for this user
$wishlist_qry = mysqli_query($dbconn, "
    SELECT 
        w.*, 
        p.product_id,
        p.product_title,
        p.product_name, 
        p.selling_price, 
        p.mrp_price, 
        p.product_specfi, 
        p.product_image
    FROM wps_wishlists w
    JOIN product_tbl p ON p.product_id = w.products_Id
    WHERE w.customer_id = '$user_id'
    ORDER BY w.wishlists_date_added DESC
");

// --- Handle Wishlist Remove AJAX Request ---
if(isset($_POST['remove']) && isset($_POST['wish_id'])){
    $user_id = isset($_SESSION['USER_ID']) ? intval($_SESSION['USER_ID']) : 0;
    if($user_id <= 0){
        echo "login";
        exit;
    }

    $wish_id = intval($_POST['wish_id']);
    $del = mysqli_query($dbconn, "DELETE FROM wps_wishlists WHERE id='$wish_id' AND customer_id='$user_id'");
    echo ($del) ? "removed" : "error";
    exit;
}

$wishlist_count = mysqli_num_rows($wishlist_qry);
?>                  
                    <div class="tab-pane fade" id="wishlist" role="tabpanel">
                            <div class="mb-3 text-pink fs-5 fw-bold">Wishlist (<?php echo $wishlist_count; ?>)</div>
                            <div class="row row-cols-1 row-cols-md-3 g-4" id="wishlist-container">
                                  <?php if($wishlist_count > 0): ?>
                               <?php while($item = mysqli_fetch_assoc($wishlist_qry)): 
                                $images = explode(',', $item['product_image']);
                                $main_img = !empty($images[0]) ? $images[0] : 'noimage.jpg';
                                $product_img = getImage($main_img,310,470,$item['product_title'],'/uploaded-files/product-images/');
                                 $product_url = site_url.'/'.getValidFileName($item['product_name']).'-'.$item['product_id'].'.htm';

                              $mrp  = (float)$item['mrp_price'];
                              $sell = (float)$item['selling_price'];
                             $discount_percent = ($mrp > 0 && $sell > 0) ? round((($mrp - $sell) / $mrp) * 100) : 0;
                            ?>
                                <div class="col wishlist-item">
                                    <div class="card h-100 shadow-sm">
                                        <a href="<?= $product_url; ?>">
                                        <img class="card-img-top"
                                            src="<?= $product_img; ?>"
                                            title="<?= htmlspecialchars($item['product_title']); ?>" alt="<?= htmlspecialchars($item['product_title']); ?>">
                                            </a>

                                        <div class="card-body pt-2">
                                            <div class="card-title title4"><?php echo $item['product_title']; ?>  </div>
                                            <!-- <p class="card-text">Beautiful traditional Wishlist with Wishlist border.
                                            </p> -->
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="fw-bold text-purple fs-6">₹<?= number_format($sell, 2); ?></span>
                                                  
                                                <button type="button" class="btn btn-sm btn-outline-danger remove-wishlist removeWish" 
                                                  data-id="<?= $item['id']; ?>">
                                                    <i class="bi bi-heart-fill "></i> Remove
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <p>Your wishlist is empty.</p>
                            <?php endif; ?>
                                <!-- <div class="col wishlist-item">
                                    <div class="card h-100 shadow-sm">
                                        <img class="card-img-top"
                                            src="https://www.lnuniform.com/uploaded-files/product-images/thumbs/Sterile-High-Performance-SMS-Surgical-Gown---Blue,-XL-Size,-Minimum-Order-100-thumbs-800X800.jpg"
                                            title="abc" alt="abc">

                                        <div class="card-body pt-2">
                                            <div class="card-title title4">Wishlist2</div>
                                            <p class="card-text">Cotton Wishlist perfect for summer wear.</p>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="fw-bold text-purple fs-6">₹749</span>
                                                <button class="btn btn-sm btn-outline-danger remove-wishlist">
                                                    <i class="bi bi-heart-fill"></i> Remove
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div> -->
                            </div>
                        </div>

                        <!-- <script>
$(".removeWish").click(function(){
    let wid = $(this).data("id");
    let row = $(this).closest(".wishlist-item");

    $.ajax({
        type: "POST",
        url: "",
        data: { remove: 1, wish_id: wid },
        success: function(res){
            console.log("Response:", res);
            if(res.trim() === "removed"){
                row.fadeOut(300, function(){
                    $(this).remove();
                    
                });
            }
        }
    });
});

</script> -->