<?php

class Cart
{
    private $dbconn;
    private $userId;
    private $taxRate = 0; 
    public function __construct($dbconn, $userId = null)
    {
        $this->db     = $dbconn;
        $this->userId = $userId;
        if (!isset($_SESSION['cart'])) {
            $_SESSION['cart'] = [];
        }
         $_SESSION['coupon'] ?? null;
    }
public function add($product)
{
    global $dbconn;
    $cart = $this->getCart();
    $product_id = $product['product_id'];
    $color_id   = $product['color'];
    $size_id    = $product['size'];
    $qty        = $product['qty'];
    $type       = $product['type'];
    $image       = $product['image'];
    $product_code  = $product['product_code'];
    $embroidery  = $product['embroidery'] ?? 0;
    $symbol1     = $product['symbol1'] ?? 0;
    $symbol2     = $product['symbol2'] ?? 0;
    $line1       = $product['line1'] ?? '';
    $line2       = $product['line2'] ?? '';
    $extraprice=0;
    if($embroidery=='1'){
    $extraprice+=150;
    }
    if($symbol1=='1'){
      $extraprice+=100;
    }
    if($symbol2=='1'){
   $extraprice+=100;
    }
    /* ===== CART KEY (IMPORTANT) ===== */
    $key = $product_id.'|'.$color_id.'|'.$size_id;
    /* ===== GET STOCK & PRICE FROM DB ===== */
    $q = mysqli_query($dbconn,"
        SELECT ps.quantity, ps.price, ps.mrp_price, p.product_title
        FROM product_stock ps
        JOIN product_tbl p ON p.product_id = ps.product_id
        WHERE ps.product_id='$product_id'
        AND ps.color_id='$color_id'
        AND ps.size_id='$size_id'
        LIMIT 1
    ");
    if (mysqli_num_rows($q) == 0) {
        return ['error' => 'Product variation not available'];
    }
    $stock = mysqli_fetch_assoc($q);
    /* ===== STOCK CHECK ===== */
    // if ($stock['quantity'] < $qty) {
    //     return ['error' => 'Out of stock'];
    // }
    /* ===== ADD / UPDATE CART ===== */
    if (isset($cart[$key])) {
        $newQty = $cart[$key]['qty'] + $qty;
        if ($newQty > $stock['quantity']) {
            return ['error' => 'Stock limit exceeded'];
        }
        $cart[$key]['qty'] = $newQty;
    } else {
        $cart[$key] = [
            'product_id'   => $product_id,
            'name' => $stock['product_title'],
            'color'     => $color_id,
            'size'      => $size_id,
            'qty'       => $qty,
            'price'     => $stock['price']+$extraprice,
            'mrp_price' => $stock['mrp_price']+$extraprice,
            'image'     => $image,
            'product_code'=>$product_code,
            'type'=>$type,
            'embroidery'=>$embroidery,
            'symbol1'=>$symbol1,
            'symbol2'=>$symbol2,
            'line1'=>$line1,
            'line2'=>$line2
        ];
    }
    /* ===== SUBTOTAL ===== */
    $cart[$key]['subtotal'] =$cart[$key]['qty'] * $cart[$key]['price'];
    $this->saveCart($cart);
    // return $this->summary();
}
    // public function add($product)
    // {
    //     $cart = $this->getCart();
    //     $id   = $product['product_id'];
    //     if (isset($cart[$id])) {
    //         $cart[$id]['qty'] += $product['qty'];
    //          $cart[$id]['size'] += $product['size'];
    //           $cart[$id]['color'] += $product['color'];
    //             $cart[$id]['type'] += $product['type'];
    //     } else {
    //         $cart[$id] = $product;
    //     }
    //     $cart[$id]['subtotal'] = $cart[$id]['qty'] * $cart[$id]['price'];
    //     $this->saveCart($cart);
    //     return $this->summary();
    // }
    // public function update($productId, $qty)
    // {
    //     $cart = $this->getCart();
    //     if (isset($cart[$productId])) {
    //         $cart[$productId]['qty'] = $qty;
    //         $cart[$productId]['subtotal'] =
    //             $qty * $cart[$productId]['price'];
    //     }
    //     $this->saveCart($cart);
    //     return $this->summary();
    // }
   public function update($key, $qty)
{
    $cart = $this->getCart();
    if (!isset($cart[$key])) {
        return ['error' => 'Cart item not found'];
    }
    // OPTIONAL: Re-fetch price from DB if size-based
    $price = $cart[$key]['price'];
    $cart[$key]['qty'] = $qty;
    $cart[$key]['subtotal'] = $qty * $price;
    $this->saveCart($cart);
    return [
        'key' => $key,
        'price' => $price,
        'subtotal' => $cart[$key]['subtotal'],
        'grand_total' => $this->summary()['subtotal'],
        'total' => $this->summary()['total']
    ];
}

public function remove($product_id, $color_id, $size_id)
{
     global $dbconn;
    $cart = $this->getCart();
    $key = $product_id.'|'.$color_id.'|'.$size_id;
    if (isset($cart[$key])) {
        unset($cart[$key]);
        $this->saveCart($cart);
    }
     if($this->userId){
        mysqli_query($dbconn,"
            DELETE FROM carts
            WHERE user_id = '{$this->userId}'
            AND product_id = '$product_id'
            AND color = '$color_id'
            AND size = '$size_id'
        ");
      }
    return $this->summary();
}
    // public function remove($productId)
    // {
    //     $cart = $this->getCart();
    //     unset($cart[$productId]);
    //     $this->saveCart($cart);
    //     return $this->summary();
    // }
    /* =======================
       COUPON
    ======================= */
    public function applyCoupon($code)
    {
        $stmt = $this->db->prepare("
            SELECT * FROM coupons
            WHERE code = ? AND is_active = 1
              AND (expiry_date IS NULL OR expiry_date >= CURDATE())
        ");
        $stmt->execute([$code]);
        $coupon = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$coupon) {
            throw new Exception("Invalid coupon code");
        }
        if ($this->subtotal() < $coupon['min_cart_amount']) {
            throw new Exception("Minimum cart value not met");
        }
        $_SESSION['coupon'] = $coupon;
        return $this->summary();
    }
    public function removeCoupon()
    {
        $_SESSION['coupon'] = null;
        return $this->summary();
    }
    /* =======================
       CALCULATIONS
    ======================= */
    private function subtotal()
    {
        return array_sum(
            array_column($this->getCart(), 'subtotal')
        );
    }
        private function discount()
        {
            $sub = $this->subtotal();
            if ($sub >= 10000) {
                return $sub * 0.10;
            }
            if ($sub >= 2500) {
                return $sub * 0.05;
            }
            return 0;
        }
    // private function discount()
    // {
    //     if (!$_SESSION['coupon']) return 0;
    //     $coupon = $_SESSION['coupon'];
    //     $sub    = $this->subtotal();
    //     return $coupon['type'] === 'percent'
    //         ? ($sub * $coupon['value'] / 100)
    //         : $coupon['value'];
    // }
    private function taxAmount($afterDiscount)
    {
        return ($afterDiscount * $this->taxRate) / 100;
    }
    public function summary()
    {
        $sub       = $this->subtotal();
        $discount  = $this->discount();
        $afterDisc = max(0, $sub - $discount);
        $tax       = $this->taxAmount($afterDisc);
        $total     = $afterDisc + $tax;
        return [
            'items'      => $this->getCart(),
            'subtotal'   => round($sub),
            'discount'   => round($discount),
            'tax'        => round($tax),
            'total'      => round($total),
            'coupon'     => $_SESSION['coupon']['code'] ?? null
        ];
    }
    /* =======================
       STORAGE
    ======================= */
    private function getCart()
    {
        if ($this->userId) {
            return $this->getCartFromDb();
        }
        return $_SESSION['cart'];
    }
    private function saveCart($cart)
    {
        if ($this->userId) {
            $this->saveCartToDb($cart);
        } else {
            $_SESSION['cart'] = $cart;
        }
    }
   private function getCartFromDb()
{
    $stmt = $this->db->prepare(
        "SELECT * FROM carts WHERE user_id = ?"
    );
    $stmt->bind_param("i", $this->userId);
    $stmt->execute();
    $result = $stmt->get_result();
    $cart = [];
    while ($item = $result->fetch_assoc()) {
        $cart[$item['cart_key']] = [
            'product_id' => $item['product_id'],
            'name'       => $item['name'],
            'price'      => $item['price'],
             'mrp_price' => $item['mrp_price'],
             'image' => $item['product_image'],
            'product_code' => $item['product_code'],
            'qty'        => $item['qty'],
            'color'        => $item['color'],
            'size'        => $item['size'],
              'type'        => $item['type'],
                'embroidery'        => $item['embroidery'],
                 'symbol1'        => $item['symbol1'],
                  'symbol2'        => $item['symbol2'],
                   'line1'        => $item['line1'],
                    'line2'        => $item['line2'],
            'subtotal'   => $item['qty'] * $item['price']
        ];
    }
    $stmt->close();
    return $cart;
}
private function saveCartToDb($cart)
{
    // 1️⃣ Delete old cart
   

    // 2️⃣ Prepare insert
    $stmt = $this->db->prepare("
        INSERT INTO carts
        (user_id, cart_key, product_id, name, price, mrp_price, qty, size, color, type,
         product_image, product_code, embroidery, symbol1, symbol2, line1, line2)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    foreach ($cart as $key => $item) {
 $stmtD = $this->db->prepare(
        "DELETE FROM carts WHERE cart_key = ?"
    );
    $stmtD->bind_param("s", $key);
    $stmtD->execute();
    $stmtD->close();
        // cart_key is array key (163|8|6)
        $cartKey = $key;

        $stmt->bind_param(
            "isisddissssssssss",
            $this->userId,
            $cartKey,
            $item['product_id'],
            $item['name'],
            $item['price'],
            $item['mrp_price'],
            $item['qty'],
            $item['size'],
            $item['color'],
            $item['type'],
            $item['image'],
            $item['product_code'],
            $item['embroidery'],
            $item['symbol1'],
            $item['symbol2'],
            $item['line1'],
            $item['line2']
        );
        $stmt->execute();
    }

    $stmt->close();
}
}
        $userId = $_SESSION['USER_ID'] ?? null;
        $cartObj = new Cart($dbconn, $userId);
        $cartData = $cartObj->summary();
        $totalQty = 0;
        $totalprice=0;
        $totalmrpprice=0;
        foreach ($cartData['items'] as $item) {
            $totalQty += $item['qty'];
            $totalprice+=($item['price']*$item['qty']);
            $totalmrpprice+=($item['mrp_price']*$item['qty']);
        }
        function getCheckoutAddress($dbconn) {
    // LOGGED-IN USER
    if (!empty($_SESSION['USER_ID'])) {
        $user_id = (int)$_SESSION['USER_ID'];
        $sql = "SELECT bill_fname, bill_mobile, bill_address1, bill_address2, bill_city, bill_zipcode, bill_state, bill_country,
                    ship_fname, ship_mobile, ship_address1, ship_address2, ship_city, ship_zipcode, ship_state, ship_country
                FROM wps_customer_address
                WHERE user_id = ?";
        $stmt = mysqli_prepare($dbconn, $sql);
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        if ($row = mysqli_fetch_assoc($result)) {
            return [
                'billing' => [
                    'name'     => $row['bill_fname'],
                    'mobile'   => $row['bill_mobile'],
                    'addr1'    => $row['bill_address1'],
                    'addr2'    => $row['bill_address2'],
                    'city'     => $row['bill_city'],
                    'zipcode'  => $row['bill_zipcode'],
                    'state'    => $row['bill_state'],
                    'country'  => $row['bill_country'],
                ],
                'shipping' => [
                    'name'     => $row['ship_fname'],
                    'mobile'   => $row['ship_mobile'],
                    'addr1'    => $row['ship_address1'],
                    'addr2'    => $row['ship_address2'],
                    'city'     => $row['ship_city'],
                    'zipcode'  => $row['ship_zipcode'],
                    'state'    => $row['ship_state'],
                    'country'  => $row['ship_country'],
                ]
            ];
        }
    }
    // GUEST USER (fallback)
    return [
        'billing'  => $_SESSION['checkout_address']  ?? [],
        'shipping' => $_SESSION['checkout_shipping'] ?? []
    ];
}
    