<?php
include_once("include/main.inc.php");
$page_metatitle = "Forgot Password - " . $admin_res['companyName'];
$page_metakey = "Forgot Password - " . $admin_res['companyName'];
$page_metadesc = "Forgot Password - " . $admin_res['companyName'];
date_default_timezone_set('Asia/Kolkata');

// AJAX HANDLERS
if(isset($_POST['otp_submit'])){
    $email = mysqli_real_escape_string($dbconn, $_POST['email']); 
    if($email != ''){
        $check_sql = mysqli_query($dbconn,"SELECT user_id FROM user_tbl WHERE user_email='$email'");
        if(mysqli_num_rows($check_sql) > 0){
            $otp = rand(1000,9999);
            $expiry = date("Y-m-d H:i:s", strtotime('+10 minutes'));
            mysqli_query($dbconn,"UPDATE user_tbl SET otp='$otp', otp_expiry='$expiry' WHERE user_email='$email'");
            $subject = 'Your OTP for Password Reset - '.site_url;
            $message = "<p>Your OTP for password reset is: <strong>$otp</strong>. It is valid for 10 minutes.</p>";
            $status = smtp_mailer($email, $email, $admin_res['companyName'], $subject, $message);
            $resp = $status ? ['status'=>true,'message_response'=>'OTP sent successfully. Please verify below.','show_otp'=>true,'email'=>$email] : ['status'=>false,'message_response'=>'Failed to send OTP.'];
        } else { $resp = ['status'=>false,'message_response'=>'Email not found.']; }
    } else { $resp = ['status'=>false,'message_response'=>'Email field is mandatory.']; }
    echo json_encode($resp); exit;
}

if(isset($_POST['verify_otp'])){
    $email = $_POST['verify_email'];
    $otp_val = $_POST['otp_box'];
    $check = mysqli_query($dbconn,"SELECT otp,otp_expiry FROM user_tbl WHERE user_email='$email'");
    $res = mysqli_fetch_assoc($check);
    $resp = ($res && $res['otp']==$otp_val && $res['otp_expiry'] >= date("Y-m-d H:i:s")) 
        ? ['status'=>true,'message_response'=>'OTP Verified. Reset Password below.','show_reset'=>true,'email'=>$email]
        : ['status'=>false,'message_response'=>'Invalid or expired OTP.'];
    echo json_encode($resp); exit;
}

if(isset($_POST['reset_pass'])){
    $email = $_POST['reset_email'];
    $new = $_POST['new_password'];
    mysqli_query($dbconn,"UPDATE user_tbl SET password='$new',cpassword='$new', otp=NULL, otp_expiry=NULL WHERE user_email='$email'");
    echo json_encode(['status'=>true,'message_response'=>'Password Reset Successfully! Please login.','redirect_url'=>site_url.'/login.htm']); exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<?php include "app_top2.php"; ?>
</head>
<body>

<?php include "app_header2.php"; ?>

<section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/sitemap-banner.jpg)">
    <div class="container text-center">
        <h1 class="cat_title">Forgot Password?</h1>
    </div>
</section>

<div class="inner_breadcrumb hidden_xs">
    <div class="container">
        <ul class="breadcrumb">
            <li><a href="<?= site_url; ?>">Home</a></li>
            <li class="active">Forgot Password?</li>
        </ul>
    </div>
</div>

<!-- Home About Section -->
<div class="w-100 float-start pb-0" style="background-image:url(designer/images/dot-shape1.webp);background-repeat:no-repeat">
    <section class="contact-form-area py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-8 mx-auto">
                    <div class="default-form-area p-4 rounded-3 text-center border-bottom border-3 border-light bg-white">

                        <div class="base-header2 mb-3">
                            <div class="aboutTitle fs-4 mb-1">Email <span>Address</span></div> 
                        </div>

                        <!-- EMAIL FORM -->
                        <form id="forget_form">
                            <div id="forget_response"></div>
                            <div class="form-group mb-2">
                                <input type="email" name="email" class="form-control" placeholder="Enter Your Registered Email" required>
                            </div>
                            <div class="text-center">
                            <button type="submit" name="otp_submit" class="modal_btn moreBtn mb-2" style="padding:6px 12px; font-size:14px; display:inline-flex; align-items:center; gap:5px;">
                                <svg width="15" height="15" viewBox="0 0 64 64" fill="currentColor">
                                    <path d="M52,24h-4v-8c0-8.836-7.164-16-16-16S16,7.164,16,16v8h-4c-2.211,0-4,1.789-4,4v32c0,2.211,1.789,4,4,4h40
                                    c2.211,0,4-1.789,4-4V28C56,25.789,54.211,24,52,24z M32,48c-2.211,0-4-1.789-4-4s1.789-4,4-4s4,1.789,4,4S34.211,48,32,48z M40,24
                                    H24v-8c0-4.418,3.582-8,8-8s8,3.582,8,8V24z"/>
                                </svg>
                                Send OTP
                            </button>
                        </div>

                        </form>

                        <!-- OTP FORM -->
                        <div id="otp_section" style="display:none;">
                            <form id="otp_form">
                                <input type="hidden" name="verify_email" id="verify_email">
                                <div class="form-group mb-2">
                                    <input type="text" name="otp_box" class="form-control" maxlength="4" placeholder="Enter OTP" required>
                                </div>
                                <button type="submit" name="verify_otp" class="modal_btn mb-2">Verify OTP</button>
                                <button type="button" id="resend_btn" class="modal_btn mb-2" style="background:#ff9800;">Resend OTP</button>
                            </form>
                        </div>

                        <!-- RESET PASSWORD FORM -->
                        <div id="reset_section" style="display:none;">
                            <form id="reset_form">
                                <input type="hidden" name="reset_email" id="reset_email">
                                <div class="form-group mb-2">
                                    <input type="password" name="new_password" class="form-control" placeholder="New Password" required>
                                </div>
                                <button type="submit" name="reset_pass" class="modal_btn w-100">Reset Password</button>
                            </form>
                        </div>

                    </div>
                    <p class="shift mt-3">Don't have an account? <a href="<?= site_url; ?>/register.htm">Register</a></p>
                </div>
            </div>
        </div>
    </section>
</div>

<?php include "app_footer.php"; ?>
<?php include "app_bottom2.php"; ?>

<script>
$(document).ready(function(){

    // SEND OTP
    $("#forget_form").submit(function(e){
        e.preventDefault();
        $.ajax({
            url:'forget_passwords.php',
            type:'POST',
            data:$(this).serialize()+"&otp_submit=1",
            dataType:'json',
            success:function(result){
                $(".alert").remove();
                if(result.status){
                    $("#verify_email").val(result.email);
                    $("#forget_form").hide();
                    $("#otp_section").show();
                    $("#otp_section").prepend('<div class="alert alert-success text-center">'+result.message_response+'</div>');
                } else {
                    $("#forget_response").html('<div class="alert alert-danger text-center">'+result.message_response+'</div>');
                }
            }
        });
    });

    // VERIFY OTP
    $("#otp_form").submit(function(e){
        e.preventDefault();
        $.ajax({
            url:'forget_passwords.php',
            type:'POST',
            data:$(this).serialize()+"&verify_otp=1",
            dataType:'json',
            success:function(result){
                $(".alert").remove();
                if(result.status){
                    $("#reset_email").val(result.email);
                    $("#otp_section").hide();
                    $("#reset_section").show();
                    $("#reset_section").prepend('<div class="alert alert-success text-center">'+result.message_response+'</div>');
                } else {
                    $("#otp_section").prepend('<div class="alert alert-danger text-center">'+result.message_response+'</div>');
                }
            }
        });
    });

    // RESEND OTP
    $("#resend_btn").click(function(){
        let email = $("#verify_email").val();
        $.ajax({
            url:'forget_passwords.php',
            type:'POST',
            data:{ email: email, otp_submit:1 },
            dataType:'json',
            success:function(result){
                $(".alert").remove();
                $("#otp_section").prepend('<div class="alert alert-'+(result.status?'warning':'danger')+' text-center">'+result.message_response+'</div>');
            }
        });
    });

    // RESET PASSWORD
    $("#reset_form").submit(function(e){
        e.preventDefault();
        $.ajax({
            url:'forget_passwords.php',
            type:'POST',
            data:$(this).serialize()+"&reset_pass=1",
            dataType:'json',
            success:function(result){
                $(".alert").remove();
                $("#forget_response").html('<div class="alert alert-success text-center">'+result.message_response+'</div>');
                $("#otp_section, #reset_section").hide();
                $("#forget_form").show();
                if(result.redirect_url){
                    setTimeout(()=>{ window.location.href=result.redirect_url; },2000);
                }
            }
        });
    });

});
</script>

</body>
</html>
