<?php
include_once("include/main.inc.php");
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
date_default_timezone_set('Asia/Kolkata');

header("Content-Type: application/json");

if(empty($cartData['items'])){
    echo json_encode(['error'=>'Cart empty']);
    exit;
}
date_default_timezone_set('Asia/Kolkata');
$currentDate = date('Y-m-d H:i:s');
require 'razorpay/vendor/autoload.php';
use Razorpay\Api\Api;

$user_id = $_SESSION['USER_ID'];
$enq_date = date('Y-m-d H:i:s');

$payType = $_POST['payType']; // ONLINE | COD

/* ================= TOTAL ================= */
// $totalprice = 0;
// foreach($_SESSION['cart'] as $item){
//     $totalprice += ($item['price'] * $item['qty']);
// }

/* ================= AMOUNT ================= */
if($payType == 'COD'){
    $amount = $cartData['total'] + 50; // COD extra charge
}else{
    $amount = $cartData['total']; // ONLINE
}

/* ================= ADDRESS ================= */
$address = getCheckoutAddress($GLOBALS['dbconn']);
$billing  = $address['billing'];
$shipping = $address['shipping'];

$checkout_login = $_SESSION['checkout_login'];

if($checkout_login['type']=='guest'){
    $customer_email = $checkout_login['email'];
}else{
    $customer_res = mysqli_fetch_assoc(mysqli_query($GLOBALS["dbconn"],"SELECT user_email FROM user_tbl WHERE user_id='$user_id'")
    );
    $customer_email = $customer_res['user_email'];
}

/* ================= INSERT ORDER ================= */
$data = [
    'invoice_no'=>'',
    'user_id'=>$user_id,
    'user_type'=>$checkout_login['type'],
    'bill_fname'=>$billing['name'],
    'bill_country'=>$billing['country'],
    'bill_address1'=>$billing['addr1'],
    'bill_address2'=>$billing['addr2'],
    'bill_city'=>$billing['city'],
    'bill_state'=>$billing['state'],
    'bill_zipcode'=>$billing['zipcode'],
    'bill_mobile'=>$billing['mobile'],
    'bill_email'=>$customer_email,
    'ship_fname'=>$shipping['name'],
    'ship_country'=>$shipping['country'],
    'ship_address1'=>$shipping['addr1'],
    'ship_address2'=>$shipping['addr2'],
    'ship_city'=>$shipping['city'],
    'ship_state'=>$shipping['state'],
    'ship_zipcode'=>$shipping['zipcode'],
    'ship_mobile'=>$shipping['mobile'],
    'ship_email'=>$customer_email,
    'total_amount'=>$cartData['total'],
    'payable_amount'=>$amount,
    'payment_mode'=>$payType,
    'order_status'=>'9',
    'order_received_dt'=>$enq_date
];

      if (!isset($_SESSION['local_order_id'])) {
         $result = insertdata('orders_tbl',$data);
        $order_id= mysqli_insert_id($GLOBALS['dbconn']);
         $_SESSION['local_order_id'] = $order_id;
        }else{
            $order_id = $_SESSION['local_order_id'];
         }
$invoice = "#Loyal_Needs_".$order_id;
mysqli_query($GLOBALS["dbconn"],"UPDATE orders_tbl SET invoice_no='$invoice' WHERE order_id=$order_id");

/* ================= ORDER DETAILS ================= */
foreach($cartData['items'] as $item){
 $data1 = ['order_id'=>$order_id,
        'product_id'=>$item['product_id'],
        'product_name'=>$item['name'],
        'qty'=>$item['qty'],
        'item_price'=>$item['price'],
        'product_specify'=>'',
        'image'=>$item['image'],
        'mrp_price'=>$item['mrp_price'],
        'size'=>$item['size'],
        'color'=>$item['color'],
        'type'=>$item['type'],
        'embroidery'=>$item['embroidery'],
        'symbol1'=>$item['symbol1'],
        'symbol2'=>$item['symbol2'],
        'line1'=>$item['line1'],
        'line2'=>$item['line2'],
        'cart_key'=>''
    ];

    insertdata('order_details',$data1);
}

/* =====================================================
   COD FLOW (NO RAZORPAY)
===================================================== */
if($payType == 'COD'){
      foreach($cartData['items'] as $key => $item){
      $cart_key = $key;
      mysqli_query($dbconn,"DELETE FROM carts WHERE cart_key='$cart_key'");
      }
    unset($_SESSION['cart']);
    unset($_SESSION['local_order_id']);
    unset($_SESSION['razorpay_order_id']);
    unset($_SESSION['order_amount']);
     $encoded = encodeOrderId($order_id);
     // get stage id
        $stage = mysqli_fetch_assoc(mysqli_query($dbconn,
        "SELECT id FROM order_stages WHERE stage_name='Order Placed'"
        ));

        $stageId = $stage['id'];
        mysqli_query($dbconn," INSERT INTO order_status_history (order_id, stage_id, remark, updated_at) 
        VALUES ('$order_id','$stageId','Order successfully placed','$currentDate')");
        mysqli_query($dbconn," UPDATE orders_tbl SET current_stage_id='$stageId' WHERE order_id='$order_id'");
        echo json_encode([
            'status'=>'success',
            'type'=>'COD',
            'order_id'=>$encoded
        ]);
        exit;
}
if($payType == 'ONLINE'){

   $stage = mysqli_fetch_assoc(mysqli_query($dbconn,"SELECT id FROM order_stages WHERE stage_name='Order Placed'"));
   $stageId = $stage['id'];

   mysqli_query($dbconn,"INSERT INTO order_status_history 
   (order_id, stage_id, remark, updated_at) 
   VALUES ('$order_id','$stageId','Order placed, waiting for payment','$currentDate')");

   mysqli_query($dbconn,"UPDATE orders_tbl SET current_stage_id='$stageId' WHERE order_id='$order_id'");

/* =====================================================
   ONLINE FLOW (RAZORPAY)
===================================================== */
 $q = mysqli_query($GLOBALS['dbconn'],"SELECT razorpay_order_id, last_amount, last_payment_method FROM orders_tbl WHERE order_id = $order_id");

        $row = mysqli_fetch_assoc($q);
        if ($row['razorpay_order_id'] && $row['last_amount'] == $amount * 100 && $row['last_payment_method'] == $payType) {
            // ✅ SAFE TO REUSE
            echo json_encode([
                'order_id' => $row['razorpay_order_id'],
                'amount'   => $amount * 100,
                'payType' => $payType
            ]);
            exit;
        }
$api = new Api(RZP_KEY_ID, RZP_SECRET_ID);

$rzpOrder = $api->order->create([
    'receipt' => $invoice,
    'amount' => $amount * 100,
    'currency' => 'INR',
    'payment_capture' => 1
]);

// mysqli_query($GLOBALS['dbconn'],"UPDATE orders_tbl SET razorpay_order_id='{$rzpOrder['id']}'
//  WHERE order_id=$order_id");
        $sql = "UPDATE orders_tbl SET  razorpay_order_id   = '{$rzpOrder['id']}',last_amount = " . ($amount * 100) . ",last_payment_method = '$payType',total_amount = '$totalprice',payable_amount= '$amount',payment_mode = '$payType'WHERE order_id = $order_id";
        mysqli_query($GLOBALS['dbconn'], $sql);

                $_SESSION['razorpay_order_id'] = $rzpOrder['id'];
                $_SESSION['local_order_id']    = $order_id;
                $_SESSION['order_amount']      = $amount * 100;
                echo json_encode([
                    'order_id' => $rzpOrder['id'],
                    'amount' => $rzpOrder['amount'],
                    'payType' => $payType
                ]);

}
?>