<?php 
include_once("include/main.inc.php"); 
header("Content-Type: application/json");
function json_response($status, $message, $redirect = null) {
     ob_clean();
    echo json_encode([
        "status"   => $status,
        "message"  => $message,
        "redirect" => $redirect
    ]);
    exit;
}
error_reporting(0);
function clean($str) {
    return htmlspecialchars(trim($str), ENT_QUOTES, 'UTF-8');
}
$user_id=$_SESSION['USER_ID']!=''?$_SESSION['USER_ID']:'0';
$checkout_login=$_SESSION['checkout_login'];
$billing = [
    "name"     => clean($_POST["bill_fname"] ?? ""),
    "mobile"   => clean($_POST["bill_mobile"] ?? ""),
    "addr1"    => clean($_POST["bill_address1"] ?? ""),
    "addr2"    => clean($_POST["bill_address2"] ?? ""),
    "city"     => clean($_POST["bill_city"] ?? ""),
    "zipcode"  => clean($_POST["bill_zipcode"] ?? ""),
    "state"    => clean($_POST["bill_state"] ?? ""),
    "country"  => clean($_POST["bill_country"] ?? "")
];

$shipping = [
    "name"     => clean($_POST["ship_fname"] ?? ""),
    "mobile"   => clean($_POST["ship_mobile"] ?? ""),
    "addr1"    => clean($_POST["ship_address1"] ?? ""),
    "addr2"    => clean($_POST["ship_address2"] ?? ""),
    "city"     => clean($_POST["ship_city"] ?? ""),
    "zipcode"  => clean($_POST["ship_zipcode"] ?? ""),
    "state"    => clean($_POST["ship_state"] ?? ""),
    "country"  => clean($_POST["ship_country"] ?? "")
];

// foreach ($billing as $key => $value) {
//     if ($value === "" || $value === null) {
//         json_response("error", "Billing: " . ucfirst(str_replace('_', ' ', $key)) . " is required.");
//     }
// }
// foreach ($shipping as $key => $value) {
//     if ($value === "" || $value === null) {
//         json_response("error", "Shipping: " . ucfirst(str_replace('_', ' ', $key)) . " is required.");
//     }
// }

// Phone validation
if (!preg_match("/^[0-9]{10}$/", $billing["mobile"])) {
    json_response("error", "Billing mobile must be 10 digits.");
}
if (!preg_match("/^[0-9]{10}$/", $shipping["mobile"])) {
    json_response("error", "Shipping mobile must be 10 digits.");
}

// Pincode validation
if (!preg_match("/^[0-9]{6}$/", $billing["zipcode"])) {
    json_response("error", "Billing pincode must be 6 digits.");
}
if (!preg_match("/^[0-9]{6}$/", $shipping["zipcode"])) {
    json_response("error", "Shipping pincode must be 6 digits.");
}



$chk = mysqli_query($GLOBALS['dbconn'], "SELECT * FROM wps_customer_address WHERE user_id='$user_id'");
if($checkout_login['type']!='guest'){ 
if(mysqli_num_rows($chk) > 0){
    // Address exists → UPDATE
    $sql = "UPDATE wps_customer_address SET 
        bill_fname=?, bill_mobile=?, bill_address1=?, bill_address2=?, bill_city=?, bill_zipcode=?, bill_state=?, bill_country=?,
        ship_fname=?, ship_mobile=?, ship_address1=?, ship_address2=?, ship_city=?, ship_zipcode=?, ship_state=?, ship_country=?
        WHERE user_id=?";
    $stmt = mysqli_prepare($GLOBALS['dbconn'], $sql);
    mysqli_stmt_bind_param(
        $stmt,"ssssssssssssssssi",
        $billing["name"], $billing["mobile"], $billing["addr1"], $billing["addr2"], $billing["city"], $billing["zipcode"], $billing["state"], $billing["country"],
        $shipping["name"], $shipping["mobile"], $shipping["addr1"], $shipping["addr2"], $shipping["city"], $shipping["zipcode"], $shipping["state"], $shipping["country"],
        $user_id
    );
} else {
    // Address does not exist → INSERT
    $sql = "INSERT INTO wps_customer_address 
    ( user_id,bill_fname, bill_mobile, bill_address1, bill_address2, bill_city, bill_zipcode, bill_state, bill_country,
      ship_fname, ship_mobile, ship_address1, ship_address2, ship_city, ship_zipcode, ship_state, ship_country) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($GLOBALS['dbconn'], $sql);
    mysqli_stmt_bind_param(
        // $stmt,"issssssssssssssss",
         $stmt,"issssssssssssssss", 
        $user_id,$billing["name"],$billing["mobile"],$billing["addr1"],$billing["addr2"],$billing["city"],
        $billing["zipcode"],$billing["state"],$billing["country"],$shipping["name"],$shipping["mobile"],$shipping["addr1"],$shipping["addr2"],$shipping["city"],$shipping["zipcode"],$shipping["state"],$shipping["country"]
    );
}
}else{
$_SESSION['checkout_address'] = $billing;
$_SESSION['checkout_shipping'] = $shipping;
$_SESSION['checkout_step_2'] = true;
json_response("success", "", "payment.htm");
}
if (mysqli_stmt_execute($stmt)) {
    $_SESSION['checkout_address'] = $billing;
$_SESSION['checkout_shipping'] = $shipping;
    $_SESSION['checkout_step_2'] = true;
      json_response("success", "Address saved successfully", "confirm-address.htm");
} else {
   json_response("error", mysqli_stmt_error($stmt));
}

mysqli_stmt_close($stmt);
// -------------------------
// SAVE TO DATABASE (Example)
// -------------------------

// Replace this with your DB connection
// $db = new mysqli("localhost", "user", "pass", "dbname");


// Example sample insert code (commented)
// $stmt = $db->prepare("INSERT INTO orders (bill_name, bill_mobile) VALUES (?, ?)");
// $stmt->bind_param("ss", $billing["name"], $billing["mobile"]);
// $stmt->execute();

// -------------------------
// SUCCESS
// -------------------------
// json_response("success", "Address saved successfully!", site_url . "/checkout_payment.php");
